/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.util.async;

import java.util.concurrent.ExecutorService;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.sit.sitbp.common.api.MultiThreadTask;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.async.enums.MultiThreadCase;

public class MultiThreadTaskExecutor {
    private static final ThreadPool PREPARE_POOL = ThreadPools.newFixedThreadPool((String)"MultiThreadTaskExecutorPrepare", (int)6);
    private static final ThreadPool HANDLE_POOL = ThreadPools.newFixedThreadPool((String)"MultiThreadTaskExecutorHandle", (int)3);

    private MultiThreadTaskExecutor() {
    }

    public static <T> BatchResult<T> execute(MultiThreadTask<T> task) {
        return MultiThreadTaskExecutor.execute(task, MultiThreadCase.BY_ACTION, true, PREPARE_POOL, HANDLE_POOL);
    }

    public static <T> BatchResult<T> execute(MultiThreadTask<T> task, boolean async) {
        return MultiThreadTaskExecutor.execute(task, MultiThreadCase.BY_ACTION, async, PREPARE_POOL, HANDLE_POOL);
    }

    public static <T> BatchResult<T> execute(MultiThreadTask<T> task, ThreadPool preparePool, ThreadPool handlePool) {
        return MultiThreadTaskExecutor.execute(task, MultiThreadCase.BY_ACTION, true, preparePool, handlePool);
    }

    public static <T> BatchResult<T> execute(MultiThreadTask<T> task, boolean async, ThreadPool preparePool, ThreadPool handlePool) {
        return MultiThreadTaskExecutor.execute(task, MultiThreadCase.BY_ACTION, async, preparePool, handlePool);
    }

    public static <T> BatchResult<T> execute(MultiThreadTask<T> task, boolean async, ExecutorService preparePool, ExecutorService handlePool) {
        return MultiThreadTaskExecutor.execute(task, MultiThreadCase.BY_ACTION, async, preparePool, handlePool);
    }

    public static <T> BatchResult<T> execute(MultiThreadTask<T> task, MultiThreadCase handleCase, boolean async, ThreadPool preparePool, ThreadPool handlePool) {
        task.setHandleCase(handleCase);
        task.updateProgress();
        if (preparePool == null) {
            task.prepareDataBatch(PREPARE_POOL);
        } else {
            task.prepareDataBatch(preparePool);
        }
        if (handlePool == null) {
            return task.handleDataBatch(HANDLE_POOL, async);
        }
        return task.handleDataBatch(handlePool, async);
    }

    public static <T> BatchResult<T> execute(MultiThreadTask<T> task, MultiThreadCase handleCase, boolean async, ExecutorService preparePool, ExecutorService handlePool) {
        task.setHandleCase(handleCase);
        task.updateProgress();
        if (preparePool == null) {
            task.prepareDataBatch(PREPARE_POOL);
        } else {
            task.prepareDataBatch(preparePool);
        }
        if (handlePool == null) {
            return task.handleDataBatch(HANDLE_POOL, async);
        }
        return task.handleDataBatch(handlePool, async);
    }
}

