/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.util.async.model;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.sit.sitbp.common.api.DataBatch;
import kd.sit.sitbp.common.api.DataItem;

public abstract class BaseDataItem<T>
implements DataItem<T> {
    protected int weight;
    protected int batchSize;
    protected final AtomicInteger prepareNum = new AtomicInteger();
    protected final AtomicInteger handleNum = new AtomicInteger();
    protected ArrayBlockingQueue<DataBatch<T>> dataBatches;
    protected AtomicInteger unCompleteBatchNum;

    public BaseDataItem(int batchSize, int weight) {
        this.batchSize = batchSize;
        this.weight = weight;
    }

    @Override
    public void addDataBatch(DataBatch<T> dataBatch) {
        try {
            this.dataBatches.put(dataBatch);
            if (dataBatch.getDataList() != null) {
                this.prepareNum.addAndGet(dataBatch.getDataList().size());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public int leftBatchNum() {
        return this.unCompleteBatchNum.intValue();
    }

    @Override
    public void completeBatch(DataBatch<T> dataBatch) {
        if (dataBatch.getDataList() != null) {
            this.handleNum.addAndGet(dataBatch.getDataList().size());
        }
        this.unCompleteBatchNum.decrementAndGet();
    }

    @Override
    public boolean notCompleted() {
        return this.unCompleteBatchNum.intValue() > 0;
    }

    @Override
    public DataBatch<T> nextBatch() {
        if (this.notCompleted()) {
            try {
                return this.dataBatches.poll(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return null;
    }

    @Override
    public long dealWeight(int prepareWeight, int handleWeight) {
        return (long)(this.prepareNum.intValue() * prepareWeight + this.handleNum.intValue() * handleWeight) * (long)this.weight;
    }

    @Override
    public long prepareNum() {
        return this.prepareNum.longValue();
    }

    @Override
    public long handleNum() {
        return this.handleNum.longValue();
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }
}

