/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.util.async.model;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.sit.sitbp.common.api.CommonResource;
import kd.sit.sitbp.common.api.DataBatch;
import kd.sit.sitbp.common.api.DataItem;
import kd.sit.sitbp.common.api.MultiThreadTask;
import kd.sit.sitbp.common.api.ProcessHandler;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.async.enums.MultiThreadCase;

public abstract class BaseMultiThreadTask<T>
implements MultiThreadTask<T> {
    private static final Log LOGGER = LogFactory.getLog(BaseMultiThreadTask.class);
    protected final LongAdder totalWight = new LongAdder();
    private String key;
    protected int prepareWeight = 5;
    protected int handleWeight = 5;
    protected static final String DEFAULT_DATA_KEY = "defaultData";
    protected ConcurrentHashMap<String, DataItem<T>> dataItemMap = new ConcurrentHashMap(4);
    protected BatchResult<T> finalResult = new BatchResult(new CopyOnWriteArrayList(), new CopyOnWriteArrayList());
    protected CommonResource commonResource;
    protected ProcessHandler processHandler;
    private long startTimeMill;
    private long timeout = 1200000L;
    private final AtomicBoolean completed = new AtomicBoolean(false);
    private MultiThreadCase handleCase = MultiThreadCase.BY_ACTION;

    protected void adjustWeight(int diff) {
        this.totalWight.add(diff * (this.prepareWeight + this.handleWeight));
    }

    @Override
    public BatchResult<T> handleDataBatch(ThreadPool handlePool, boolean async) {
        BaseResult<T> res = this.beforeHandleDataBatch();
        if (!res.isSuccess()) {
            return BatchResult.fromBaseResult(res);
        }
        RequestContext context = RequestContext.getOrCreate();
        AtomicLong count = new AtomicLong();
        AtomicLong missCount = new AtomicLong();
        switch (this.handleCase) {
            case BY_PROVIDER: {
                for (Map.Entry<String, DataItem<T>> entry : this.dataItemMap.entrySet()) {
                    handlePool.execute(() -> {
                        GlobalParam.remove();
                        try {
                            RequestContext.copyAndSet((RequestContext)context);
                            this.doHandleItem((DataItem)entry.getValue(), count, missCount);
                        }
                        finally {
                            GlobalParam.remove();
                        }
                    });
                }
                break;
            }
            default: {
                handlePool.execute(() -> {
                    GlobalParam.remove();
                    try {
                        RequestContext.copyAndSet((RequestContext)context);
                        for (Map.Entry<String, DataItem<T>> entry : this.dataItemMap.entrySet()) {
                            this.doHandleItem(entry.getValue(), count, missCount);
                        }
                    }
                    finally {
                        GlobalParam.remove();
                    }
                });
            }
        }
        if (async) {
            return new BatchResult(true, null);
        }
        while (!this.isCompleted()) {
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return this.finalResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHandleItem(DataItem<T> dataItem, AtomicLong count, AtomicLong missCount) {
        while (dataItem.notCompleted()) {
            LOGGER.info("MultiThread Task is running {} - {} - {} times, miss {}", new Object[]{this.getClass().getSimpleName(), this.key, count.incrementAndGet(), missCount.longValue()});
            DataBatch<T> dataBatch = dataItem.nextBatch();
            if (dataBatch == null) {
                try {
                    TimeUnit.MILLISECONDS.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                missCount.incrementAndGet();
                continue;
            }
            try {
                BatchResult<T> result = this.handleData(dataBatch);
                this.appendLog("batch " + dataBatch.getBatchIndex() + " handled, left " + dataItem.leftBatchNum());
                this.finalResult.merge(result);
            }
            catch (Exception e) {
                this.finalResult.addFailResult(dataBatch.getDataList(), e.getMessage(), ResultStatusEnum.ERROR.getCode());
            }
            finally {
                dataItem.completeBatch(dataBatch);
                this.updateProgress();
            }
        }
        this.updateProgress();
    }

    @Override
    public BatchResult<T> handleDataBatch(ExecutorService handlePool, boolean async) {
        BaseResult<T> res = this.beforeHandleDataBatch();
        if (!res.isSuccess()) {
            return BatchResult.fromBaseResult(res);
        }
        RequestContext context = RequestContext.getOrCreate();
        AtomicLong count = new AtomicLong();
        AtomicLong missCount = new AtomicLong();
        switch (this.handleCase) {
            case BY_PROVIDER: {
                for (Map.Entry<String, DataItem<T>> entry : this.dataItemMap.entrySet()) {
                    handlePool.execute(() -> {
                        GlobalParam.remove();
                        try {
                            RequestContext.copyAndSet((RequestContext)context);
                            this.doHandleItem((DataItem)entry.getValue(), count, missCount);
                        }
                        finally {
                            GlobalParam.remove();
                        }
                    });
                }
                break;
            }
            default: {
                handlePool.execute(() -> {
                    GlobalParam.remove();
                    try {
                        RequestContext.copyAndSet((RequestContext)context);
                        for (Map.Entry<String, DataItem<T>> entry : this.dataItemMap.entrySet()) {
                            this.doHandleItem(entry.getValue(), count, missCount);
                        }
                    }
                    finally {
                        GlobalParam.remove();
                    }
                });
            }
        }
        if (async) {
            return this.finalResult;
        }
        while (!this.isCompleted()) {
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return this.finalResult;
    }

    @Override
    public void updateProgress() {
        Thread.currentThread().setUncaughtExceptionHandler((thread, exception) -> LOGGER.warn("BaseMultiThreadTask Error occurs at updateProgress", exception));
        if (this.processHandler == null) {
            this.processHandler = this.openProcessHandler();
        }
        long dealWeight = 0L;
        for (DataItem<T> dataItem : this.dataItemMap.values()) {
            dealWeight += dataItem.dealWeight(this.prepareWeight, this.handleWeight);
        }
        long totalWeightLong = this.totalWight.longValue();
        long dealNum = this.dealNum();
        long totalNum = this.getTotalSize();
        if (totalWeightLong == 0L) {
            ++totalWeightLong;
            ++dealWeight;
        }
        this.processHandler.update(totalWeightLong, dealWeight, totalNum, dealNum, this.finalResult.failResult().size(), this.finalResult.messageFromRight(120));
        if (this.isCompleted() && this.completed.compareAndSet(false, true)) {
            this.appendLog("BaseMultiThreadTask completed");
            this.afterHandleDataBatch(0);
        }
    }

    @Override
    public boolean isCompleted() {
        if (this.startTimeMill == 0L) {
            this.startTimeMill = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.startTimeMill > this.timeout) {
            if (this.completed.compareAndSet(false, true)) {
                this.afterHandleDataBatch(-1);
            }
            return true;
        }
        for (DataItem<T> dataItem : this.dataItemMap.values()) {
            if (!dataItem.notCompleted()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String taskKey() {
        return this.key;
    }

    public BaseMultiThreadTask<T> ofKey(String key) {
        this.key = key;
        return this;
    }

    public BaseMultiThreadTask<T> ofTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    protected long dealNum() {
        long dealNum = 0L;
        for (DataItem<T> dataItem : this.dataItemMap.values()) {
            dealNum += dataItem.handleNum();
        }
        return dealNum;
    }

    protected BaseResult<?> beforePrepareDataBatch() {
        return BaseResult.success(null);
    }

    protected BaseResult<T> beforeHandleDataBatch() {
        return BaseResult.success(null);
    }

    protected void appendLog(String msg) {
    }

    protected abstract BatchResult<T> handleData(DataBatch<T> var1);

    protected BaseResult<T> afterHandleDataBatch(int status) {
        this.processHandler.close(this.closeParams(status));
        return BaseResult.success(null);
    }

    protected Map<String, Object> closeParams(int status) {
        return new HashMap<String, Object>(0);
    }

    protected abstract ProcessHandler openProcessHandler();

    public abstract int getTotalSize();

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public MultiThreadCase getHandleCase() {
        return this.handleCase;
    }

    @Override
    public void setHandleCase(MultiThreadCase handleCase) {
        if (handleCase != null) {
            this.handleCase = handleCase;
        }
    }
}

