/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.util.async.model.assign;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import kd.sit.sitbp.common.api.DataBatch;
import kd.sit.sitbp.common.util.async.model.BaseDataItem;

public class AssignDataItem<T>
extends BaseDataItem<T> {
    protected List<List<?>> idsList;
    private final AtomicInteger startIndex = new AtomicInteger();

    public AssignDataItem(int batchSize, int weight, List<?> ids) {
        super(batchSize, weight);
        int startIndex = 0;
        int endIndex = batchSize;
        int batchNum = ids.size() / batchSize;
        if (ids.size() % batchSize != 0) {
            ++batchNum;
        }
        this.idsList = new ArrayList(batchNum);
        while (endIndex < ids.size()) {
            this.idsList.add(ids.subList(startIndex, endIndex));
            startIndex = endIndex;
            endIndex += batchSize;
        }
        this.idsList.add(ids.subList(startIndex, ids.size()));
        this.dataBatches = new ArrayBlockingQueue(10);
        this.unCompleteBatchNum = new AtomicInteger(batchNum);
    }

    public List<List<?>> getIdsList() {
        return this.idsList;
    }

    @Override
    public void addDataBatch(DataBatch<T> dataBatch) {
        int startInd = this.startIndex.getAndAdd(dataBatch.getDataList().size());
        dataBatch.setStartIndex(startInd);
        super.addDataBatch(dataBatch);
    }
}

