/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.util.async.model.assign;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.async.enums.MultiThreadCase;
import kd.sit.sitbp.common.util.async.model.BaseMultiThreadTask;
import kd.sit.sitbp.common.util.async.model.assign.AssignDataBatch;
import kd.sit.sitbp.common.util.async.model.assign.AssignDataItem;

public abstract class AssignMultiThreadTask<T>
extends BaseMultiThreadTask<T> {
    private static final Log LOGGER = LogFactory.getLog(AssignMultiThreadTask.class);
    private final AtomicInteger totalSize = new AtomicInteger();

    @Override
    public BaseResult<T> prepareDataBatch(ThreadPool preparePool) {
        BaseResult<?> res = this.beforePrepareDataBatch();
        if (!res.isSuccess()) {
            this.afterHandleDataBatch(-2);
            return BaseResult.fromPrev(res);
        }
        MultiThreadCase handleCase = this.getHandleCase();
        RequestContext context = RequestContext.getOrCreate();
        switch (handleCase) {
            case BY_PROVIDER: {
                for (Map.Entry entry : this.dataItemMap.entrySet()) {
                    String key = (String)entry.getKey();
                    AssignDataItem dataItem = (AssignDataItem)entry.getValue();
                    List<List<?>> idsList = dataItem.getIdsList();
                    preparePool.execute(() -> {
                        RequestContext.copyAndSet((RequestContext)context);
                        for (int i = 0; i < idsList.size(); ++i) {
                            List ids = (List)idsList.get(i);
                            int batchIndex = i + 1;
                            LOGGER.info("AssignMultiThreadTask Task is running: {} - key:{} - current index:{} - total batch:{}", new Object[]{this.getClass().getSimpleName(), key, i, idsList.size()});
                            this.doPrepare(key, dataItem, ids, batchIndex);
                        }
                    });
                }
                break;
            }
            default: {
                preparePool.execute(() -> {
                    RequestContext.copyAndSet((RequestContext)context);
                    for (Map.Entry entry : this.dataItemMap.entrySet()) {
                        String key = (String)entry.getKey();
                        AssignDataItem dataItem = (AssignDataItem)entry.getValue();
                        List<List<?>> idsList = dataItem.getIdsList();
                        for (int i = 0; i < idsList.size(); ++i) {
                            List<?> ids = idsList.get(i);
                            int batchIndex = i + 1;
                            LOGGER.info("AssignMultiThreadTask Task is running: {} - key:{} - current index:{} - total batch:{}", new Object[]{this.getClass().getSimpleName(), key, i, idsList.size()});
                            this.doPrepare(key, dataItem, ids, batchIndex);
                        }
                    }
                });
            }
        }
        return BaseResult.success(null);
    }

    @Override
    public BaseResult<T> prepareDataBatch(ExecutorService preparePool) {
        BaseResult<?> res = this.beforePrepareDataBatch();
        if (!res.isSuccess()) {
            this.afterHandleDataBatch(-2);
            return BaseResult.fromPrev(res);
        }
        MultiThreadCase handleCase = this.getHandleCase();
        RequestContext context = RequestContext.getOrCreate();
        switch (handleCase) {
            case BY_PROVIDER: {
                for (Map.Entry entry : this.dataItemMap.entrySet()) {
                    String key = (String)entry.getKey();
                    AssignDataItem dataItem = (AssignDataItem)entry.getValue();
                    List<List<?>> idsList = dataItem.getIdsList();
                    preparePool.execute(() -> {
                        RequestContext.copyAndSet((RequestContext)context);
                        for (int i = 0; i < idsList.size(); ++i) {
                            List ids = (List)idsList.get(i);
                            int batchIndex = i + 1;
                            LOGGER.info("AssignMultiThreadTask Task is running: {} - key:{} - current index:{} - total batch:{}", new Object[]{this.getClass().getSimpleName(), key, i, idsList.size()});
                            this.doPrepare(key, dataItem, ids, batchIndex);
                        }
                    });
                }
                break;
            }
            default: {
                preparePool.execute(() -> {
                    RequestContext.copyAndSet((RequestContext)context);
                    for (Map.Entry entry : this.dataItemMap.entrySet()) {
                        String key = (String)entry.getKey();
                        AssignDataItem dataItem = (AssignDataItem)entry.getValue();
                        List<List<?>> idsList = dataItem.getIdsList();
                        for (int i = 0; i < idsList.size(); ++i) {
                            List<?> ids = idsList.get(i);
                            int batchIndex = i + 1;
                            LOGGER.info("AssignMultiThreadTask Task is running: {} - key:{} - current index:{} - total batch:{}", new Object[]{this.getClass().getSimpleName(), key, i, idsList.size()});
                            this.doPrepare(key, dataItem, ids, batchIndex);
                        }
                    }
                });
            }
        }
        return BaseResult.success(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPrepare(String key, AssignDataItem<T> dataItem, List<?> ids, int batchIndex) {
        AssignDataBatch<T> dataBatch = new AssignDataBatch<T>(key, batchIndex, 0);
        try {
            List<T> data = this.queryData(key, ids);
            dataBatch.setIds(ids);
            dataBatch.setDataList(data);
            this.totalSize.addAndGet(data.size());
            this.adjustWeight(data.size() - ids.size());
            dataItem.addDataBatch(dataBatch);
            this.appendLog("AssignMultiThreadTask batch " + dataBatch.getBatchIndex() + " prepared");
        }
        catch (Exception e) {
            LOGGER.error("AssignMultiThreadTask Error occurs when query data ", (Throwable)e);
            List dataList = dataBatch.getDataList();
            if (CollectionUtils.isEmpty(dataList)) {
                dataList = this.keysAdapterToData(ids);
            }
            this.finalResult.addFailResult(dataList, e.getMessage(), ResultStatusEnum.ERROR.getCode());
            dataItem.completeBatch(dataBatch);
        }
        finally {
            GlobalParam.remove();
        }
    }

    protected List<T> keysAdapterToData(List<?> ids) {
        return new ArrayList();
    }

    public AssignMultiThreadTask<T> addData(int batchSize, List<?> ids) {
        return this.addData("defaultData", batchSize, ids, 1);
    }

    public AssignMultiThreadTask<T> addData(String dataKey, int batchSize, List<?> ids, int weight) {
        if (this.dataItemMap.containsKey(dataKey)) {
            throw new KDBizException("Data repeat added");
        }
        AssignDataItem item = new AssignDataItem(batchSize, weight, ids);
        this.dataItemMap.put(dataKey, item);
        this.totalWight.add(ids.size() * weight * (this.prepareWeight + this.handleWeight));
        return this;
    }

    @Override
    public int getTotalSize() {
        return this.totalSize.intValue();
    }

    protected abstract List<T> queryData(String var1, List<?> var2);
}

