/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.util.async.model.page;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.sit.sitbp.common.api.DataItem;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.async.enums.MultiThreadCase;
import kd.sit.sitbp.common.util.async.model.BaseMultiThreadTask;
import kd.sit.sitbp.common.util.async.model.page.PageDataBatch;
import kd.sit.sitbp.common.util.async.model.page.PageDataItem;

public abstract class PageMultiThreadTask<T>
extends BaseMultiThreadTask<T> {
    private static final Log LOGGER = LogFactory.getLog(PageMultiThreadTask.class);
    private final AtomicInteger totalSize = new AtomicInteger();

    @Override
    public BaseResult<T> prepareDataBatch(ThreadPool preparePool) {
        BaseResult<?> res = this.beforePrepareDataBatch();
        if (!res.isSuccess()) {
            return BaseResult.fromPrev(res);
        }
        MultiThreadCase handleCase = this.getHandleCase();
        RequestContext context = RequestContext.getOrCreate();
        switch (handleCase) {
            case BY_PROVIDER: {
                for (Map.Entry entry : this.dataItemMap.entrySet()) {
                    String key = (String)entry.getKey();
                    DataItem dataItem = (DataItem)entry.getValue();
                    int page = dataItem.leftBatchNum();
                    int pageSize = dataItem.getBatchSize();
                    preparePool.execute(() -> {
                        RequestContext.copyAndSet((RequestContext)context);
                        for (int i = 0; i < page; ++i) {
                            int pageIndex = i;
                            int startIndex = i * pageSize;
                            LOGGER.info("PageMultiThreadTask Task is running: {} - key:{} - current index:{} - pageIndex:{}", new Object[]{this.getClass().getSimpleName(), key, i, pageIndex});
                            this.doPrepareData(key, dataItem, pageSize, pageIndex, startIndex);
                        }
                    });
                }
                break;
            }
            default: {
                preparePool.execute(() -> {
                    RequestContext.copyAndSet((RequestContext)context);
                    for (Map.Entry entry : this.dataItemMap.entrySet()) {
                        String key = (String)entry.getKey();
                        DataItem dataItem = (DataItem)entry.getValue();
                        int page = dataItem.leftBatchNum();
                        int pageSize = dataItem.getBatchSize();
                        for (int i = 0; i < page; ++i) {
                            int pageIndex = i;
                            int startIndex = i * pageSize;
                            LOGGER.info("PageMultiThreadTask Task is running: {} - key:{} - current index:{} - pageIndex:{}", new Object[]{this.getClass().getSimpleName(), key, i, pageIndex});
                            this.doPrepareData(key, dataItem, pageSize, pageIndex, startIndex);
                        }
                    }
                });
            }
        }
        return BaseResult.success(null);
    }

    @Override
    public BaseResult<T> prepareDataBatch(ExecutorService preparePool) {
        BaseResult<?> res = this.beforePrepareDataBatch();
        if (!res.isSuccess()) {
            return BaseResult.fromPrev(res);
        }
        MultiThreadCase handleCase = this.getHandleCase();
        RequestContext context = RequestContext.getOrCreate();
        switch (handleCase) {
            case BY_PROVIDER: {
                for (Map.Entry entry : this.dataItemMap.entrySet()) {
                    String key = (String)entry.getKey();
                    DataItem dataItem = (DataItem)entry.getValue();
                    int page = dataItem.leftBatchNum();
                    int pageSize = dataItem.getBatchSize();
                    preparePool.execute(() -> {
                        RequestContext.copyAndSet((RequestContext)context);
                        for (int i = 0; i < page; ++i) {
                            int pageIndex = i;
                            int startIndex = i * pageSize;
                            LOGGER.info("PageMultiThreadTask Task is running: {} - key:{} - current index:{} - pageIndex:{}", new Object[]{this.getClass().getSimpleName(), key, i, pageIndex});
                            this.doPrepareData(key, dataItem, pageSize, pageIndex, startIndex);
                        }
                    });
                }
                break;
            }
            default: {
                preparePool.execute(() -> {
                    RequestContext.copyAndSet((RequestContext)context);
                    for (Map.Entry entry : this.dataItemMap.entrySet()) {
                        String key = (String)entry.getKey();
                        DataItem dataItem = (DataItem)entry.getValue();
                        int page = dataItem.leftBatchNum();
                        int pageSize = dataItem.getBatchSize();
                        for (int i = 0; i < page; ++i) {
                            int pageIndex = i;
                            int startIndex = i * pageSize;
                            LOGGER.info("PageMultiThreadTask Task is running: {} - key:{} - current index:{} - pageIndex:{}", new Object[]{this.getClass().getSimpleName(), key, i, pageIndex});
                            this.doPrepareData(key, dataItem, pageSize, pageIndex, startIndex);
                        }
                    }
                });
            }
        }
        return BaseResult.success(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPrepareData(String key, DataItem<T> dataItem, int pageSize, int pageIndex, int startIndex) {
        PageDataBatch<T> dataBatch = new PageDataBatch<T>(key, pageIndex, startIndex);
        try {
            List<T> data = this.queryData(key, pageIndex, pageSize);
            dataBatch.setDataList(data);
            this.adjustWeight(data.size() - pageSize);
            dataItem.addDataBatch(dataBatch);
            this.totalSize.addAndGet(data.size());
            this.appendLog("batch " + dataBatch.getBatchIndex() + " prepared");
        }
        catch (Exception e) {
            LOGGER.error("Error occurs when query data ", (Throwable)e);
            List dataList = dataBatch.getDataList();
            if (CollectionUtils.isEmpty(dataList)) {
                dataList = this.keysAdapterToData(pageIndex, pageSize);
            }
            this.finalResult.addFailResult(dataList, e.getMessage(), ResultStatusEnum.ERROR.getCode());
            dataItem.completeBatch(dataBatch);
        }
        finally {
            GlobalParam.remove();
        }
    }

    protected List<T> keysAdapterToData(int pageIndex, int pageSize) {
        return new ArrayList();
    }

    public PageMultiThreadTask<T> addData(int totalSize, int pageSize) {
        return this.addData("defaultData", totalSize, pageSize, 1);
    }

    public PageMultiThreadTask<T> addData(String dataKey, int totalSize, int pageSize, int weight) {
        if (this.dataItemMap.containsKey(dataKey)) {
            throw new KDBizException("Data repeat added");
        }
        PageDataItem item = new PageDataItem(totalSize, pageSize, weight);
        this.totalWight.add(item.leftBatchNum() * pageSize * weight * (this.prepareWeight + this.handleWeight));
        this.dataItemMap.put(dataKey, item);
        return this;
    }

    @Override
    public int getTotalSize() {
        return this.totalSize.intValue();
    }

    protected abstract List<T> queryData(String var1, int var2, int var3);
}

