/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.util.datatype;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.sit.sitbp.common.api.DataConverter;
import kd.sit.sitbp.common.util.datatype.DataTypeEnum;
import kd.sit.sitbp.common.util.datatype.DefaultFixValuePropEnum;

public abstract class BaseDataConverter<T>
implements DataConverter<T> {
    private static final Map<String, DataConverter> DATA_CONVERTER_MAP_NAME = new ConcurrentHashMap<String, DataConverter>();
    private static final Map<Class, DataConverter> DATA_CONVERTER_MAP_CLASS = new ConcurrentHashMap<Class, DataConverter>();
    private static final Map<String, Class> DATA_TYPE_MAIN_CLASS = new ConcurrentHashMap<String, Class>();

    public static boolean canApplyFor(String clazz) {
        return DATA_CONVERTER_MAP_NAME.containsKey(clazz);
    }

    public static boolean canApplyFor(Class clazz) {
        return DATA_CONVERTER_MAP_CLASS.containsKey(clazz);
    }

    public static String toString(Object object) {
        if (object == null || object instanceof String) {
            return (String)object;
        }
        Class<?> clazz = object.getClass();
        DataConverter dataConverter = DATA_CONVERTER_MAP_CLASS.get(clazz);
        if (dataConverter == null) {
            for (Map.Entry<Class, DataConverter> entry : DATA_CONVERTER_MAP_CLASS.entrySet()) {
                if (!entry.getKey().isAssignableFrom(clazz)) continue;
                dataConverter = entry.getValue();
            }
        }
        if (dataConverter == null) {
            return object.toString();
        }
        return dataConverter.toStr(object);
    }

    public static <T> T convert(Object object, String clazz) {
        DataConverter dataConverter = DATA_CONVERTER_MAP_NAME.get(clazz);
        if (dataConverter == null) {
            return null;
        }
        return dataConverter.convert(object);
    }

    public static <T> T convert(Object object, Class<T> clazz) {
        if (object == null || clazz.isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        DataConverter dataConverter = DATA_CONVERTER_MAP_CLASS.get(clazz);
        if (dataConverter == null) {
            return null;
        }
        return dataConverter.convert(object);
    }

    public static <T> T convert(Object object, Class<T> clazz, T defValue) {
        if (object == null) {
            return defValue;
        }
        if (clazz.isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        DataConverter dataConverter = DATA_CONVERTER_MAP_CLASS.get(clazz);
        if (dataConverter == null) {
            return defValue;
        }
        Object convert = dataConverter.convert(object);
        if (convert == null) {
            return defValue;
        }
        return convert;
    }

    public static <T> T defaultValue(Class<T> clazz) {
        DataConverter dataConverter = DATA_CONVERTER_MAP_CLASS.get(clazz);
        if (dataConverter == null) {
            return null;
        }
        return dataConverter.defaultValue();
    }

    public static Object getValueByProp(Object object, String valueProp) {
        Object result = null;
        if (DefaultFixValuePropEnum.NULL.getValueProp().equals(valueProp)) {
            return null;
        }
        if (object instanceof DynamicObject) {
            try {
                result = ((DynamicObject)object).get(valueProp);
            }
            catch (Exception e) {
                return null;
            }
        } else if (object instanceof Map) {
            result = ((Map)object).get(valueProp);
        }
        if (result instanceof ILocaleString) {
            result = ((ILocaleString)result).getLocaleValue();
        }
        return result;
    }

    public static Object getValueByProp(Object object, String ... valueProps) {
        Object result = object;
        for (String valueProp : valueProps) {
            result = BaseDataConverter.getValueByProp(result, valueProp);
        }
        return result;
    }

    public static Object getValueFormFront(Object object, String valueProp, Class clazz, String format) {
        Object result = BaseDataConverter.getValueByProp(object, valueProp);
        if (StringUtils.isEmpty((CharSequence)format)) {
            return result;
        }
        return new Object[]{BaseDataConverter.formats(result, clazz, format), result == null ? BaseDataConverter.defaultValue(clazz) : result};
    }

    public static String formats(Object value, String format) {
        DataConverter dataConverter;
        if (value == null || (dataConverter = DATA_CONVERTER_MAP_CLASS.get(value.getClass())) == null) {
            return BaseDataConverter.toString(value);
        }
        return dataConverter.format(value, format);
    }

    public static String formats(Object value, String clazz, String format) {
        DataConverter dataConverter = DATA_CONVERTER_MAP_NAME.get(clazz);
        if (dataConverter == null) {
            return BaseDataConverter.toString(value);
        }
        return dataConverter.format(value, format);
    }

    public static String formats(Object value, Class clazz, String format) {
        DataConverter dataConverter = DATA_CONVERTER_MAP_CLASS.get(clazz);
        if (dataConverter == null) {
            return BaseDataConverter.toString(value);
        }
        return dataConverter.format(BaseDataConverter.convert(value, clazz), format);
    }

    public static Class<?> mainClassOf(String dataType) {
        Class result;
        if (StringUtils.isEmpty((CharSequence)dataType) || (result = DATA_TYPE_MAIN_CLASS.get(dataType)) == null) {
            return String.class;
        }
        return result;
    }

    public static String dataTypeOf(Class<?> clazz) {
        DataConverter dataConverter = DATA_CONVERTER_MAP_CLASS.get(clazz);
        if (dataConverter == null) {
            return DataTypeEnum.STRING.name();
        }
        return dataConverter.applyFor().name();
    }

    public static <T> DataConverter<T> getInstance(Class<T> clazz) {
        return DATA_CONVERTER_MAP_CLASS.get(clazz);
    }

    public static <T> DataConverter<T> getInstance(String clazz) {
        return DATA_CONVERTER_MAP_NAME.get(clazz);
    }

    static {
        ServiceLoader<DataConverter> load = ServiceLoader.load(DataConverter.class);
        for (DataConverter next : load) {
            ParameterizedType type = (ParameterizedType)next.getClass().getGenericSuperclass();
            Type actualTypeArgument = type.getActualTypeArguments()[0];
            Class clazz = (Class)actualTypeArgument;
            DataTypeEnum dataTypeEnum = next.applyFor();
            DATA_CONVERTER_MAP_NAME.put(dataTypeEnum.name(), next);
            DataConverter dataConverter = DATA_CONVERTER_MAP_CLASS.get(clazz);
            if (dataConverter == null || dataConverter.priority() < next.priority()) {
                DATA_CONVERTER_MAP_CLASS.put(clazz, next);
            }
            DATA_TYPE_MAIN_CLASS.put(dataTypeEnum.name(), clazz);
            Class[] clazzArr = dataTypeEnum.getClazz();
            if (clazzArr == null) continue;
            for (Class clz : clazzArr) {
                DATA_CONVERTER_MAP_CLASS.put(clz, next);
            }
        }
    }
}

