/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.util.datatype;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.sit.sitbp.common.util.NumberUtil;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import kd.sit.sitbp.common.util.datatype.DataTypeEnum;

public class BigDecimalConverter
extends BaseDataConverter<BigDecimal> {
    @Override
    public BigDecimal convert(Object obj) {
        if (obj instanceof String) {
            obj = ((String)obj).trim();
        }
        if (obj == null || "".equals(obj)) {
            return null;
        }
        return (BigDecimal)ObjectConverter.convert((Object)obj, BigDecimal.class, (boolean)true);
    }

    @Override
    public String toStr(BigDecimal data) {
        if (data == null) {
            return null;
        }
        return data.toString();
    }

    @Override
    public DataTypeEnum applyFor() {
        return DataTypeEnum.BIG_DECIMAL;
    }

    @Override
    public BigDecimal defaultValue() {
        return new BigDecimal(0);
    }

    @Override
    public String format(BigDecimal data, String format) {
        if (data == null) {
            return null;
        }
        return new DecimalFormat(format).format(data);
    }

    @Override
    public boolean styleMatch(Object value) {
        return NumberUtil.isBigDecimal(value);
    }
}

