/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.util.datatype;

import kd.bos.dataentity.entity.ObjectConverter;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import kd.sit.sitbp.common.util.datatype.DataTypeEnum;

public class BooleanConverter
extends BaseDataConverter<Boolean> {
    @Override
    public Boolean convert(Object obj) {
        if (obj instanceof String) {
            obj = ((String)obj).trim();
        }
        if (obj == null || "".equals(obj)) {
            return null;
        }
        Boolean res = YesOrNoEnum.toBoolean(obj);
        if (res != null) {
            return res;
        }
        return (Boolean)ObjectConverter.convert((Object)obj, Boolean.class, (boolean)true);
    }

    @Override
    public String toStr(Boolean data) {
        if (data == null) {
            return null;
        }
        return data.toString();
    }

    @Override
    public DataTypeEnum applyFor() {
        return DataTypeEnum.BOOLEAN;
    }

    @Override
    public Boolean defaultValue() {
        return Boolean.FALSE;
    }

    @Override
    public String format(Boolean data, String format) {
        if (data == null) {
            return null;
        }
        return data.toString();
    }

    @Override
    public boolean styleMatch(Object value) {
        return false;
    }
}

