/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.util.datatype;

import java.text.DecimalFormat;
import kd.sit.sitbp.common.util.NumberUtil;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import kd.sit.sitbp.common.util.datatype.DataTypeEnum;

public class ByteConverter
extends BaseDataConverter<Byte> {
    @Override
    public Byte convert(Object obj) {
        if (obj instanceof String) {
            obj = ((String)obj).trim();
        }
        if (obj == null || "".equals(obj)) {
            return null;
        }
        if (obj instanceof Byte) {
            return (Byte)obj;
        }
        if (obj instanceof Number) {
            Number number = (Number)obj;
            return number.byteValue();
        }
        if (obj instanceof String) {
            return Byte.parseByte((String)obj);
        }
        return null;
    }

    @Override
    public String toStr(Byte data) {
        if (data == null) {
            return null;
        }
        return data.toString();
    }

    @Override
    public DataTypeEnum applyFor() {
        return DataTypeEnum.BYTE;
    }

    @Override
    public Byte defaultValue() {
        return (byte)0;
    }

    @Override
    public String format(Byte data, String format) {
        if (data == null) {
            return null;
        }
        return new DecimalFormat(format).format(data);
    }

    @Override
    public boolean styleMatch(Object value) {
        return NumberUtil.isByte(value);
    }
}

