/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.util.datatype;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.service.KDDateFormatUtils;
import kd.sit.sitbp.common.util.SitDateUtil;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import kd.sit.sitbp.common.util.datatype.DataTypeEnum;

public class DateConverter
extends BaseDataConverter<Date> {
    @Override
    public Date convert(Object obj) {
        if (obj instanceof String) {
            obj = ((String)obj).trim();
        }
        if (obj == null || "".equals(obj)) {
            return null;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj instanceof Long) {
            return new Date((Long)obj);
        }
        if (obj instanceof LocalDate) {
            ZonedDateTime zonedDateTime = ((LocalDate)obj).atStartOfDay(ZoneId.systemDefault());
            return Date.from(zonedDateTime.toInstant());
        }
        if (obj instanceof LocalDateTime) {
            ZonedDateTime zonedDateTime = ((LocalDateTime)obj).toLocalDate().atStartOfDay(ZoneId.systemDefault());
            return Date.from(zonedDateTime.toInstant());
        }
        if (obj instanceof String) {
            String str = (String)obj;
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            int index = str.indexOf(32);
            if (index > 0) {
                str = str.substring(0, index);
            }
            if (str.indexOf(47) > 0) {
                str = str.replace('/', '-');
            }
            try {
                return df.parse(str);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String toStr(Date data) {
        if (data == null) {
            return null;
        }
        return KDDateFormatUtils.getDateFormat().format(data);
    }

    @Override
    public DataTypeEnum applyFor() {
        return DataTypeEnum.DATE;
    }

    @Override
    public Date defaultValue() {
        return null;
    }

    @Override
    public String format(Date data, String format) {
        if (data == null) {
            return "";
        }
        if (StringUtils.isEmpty((CharSequence)format)) {
            format = "yyyy-MM-dd";
        }
        return new SimpleDateFormat(format).format(data);
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public boolean styleMatch(Object value) {
        return SitDateUtil.isDate(value);
    }
}

