/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.util.datatype;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import kd.bos.dataentity.utils.StringUtils;
import kd.sit.sitbp.common.util.SitDateUtil;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import kd.sit.sitbp.common.util.datatype.DataTypeEnum;

public class LocalDateConverter
extends BaseDataConverter<LocalDate> {
    @Override
    public LocalDate convert(Object obj) {
        if (obj instanceof String) {
            obj = ((String)obj).trim();
        }
        if (obj == null || "".equals(obj)) {
            return null;
        }
        if (obj instanceof LocalDate) {
            return (LocalDate)obj;
        }
        if (obj instanceof Date) {
            return ((Date)obj).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }
        if (obj instanceof LocalDateTime) {
            return ((LocalDateTime)obj).toLocalDate();
        }
        if (obj instanceof Long) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli((Long)obj), ZoneId.systemDefault()).toLocalDate();
        }
        if (obj instanceof String) {
            String str = (String)obj;
            int index = str.indexOf(32);
            if (index > 0) {
                str = str.substring(0, index);
            }
            if (str.indexOf(47) > 0) {
                str = str.replace('/', '-');
            }
            return LocalDate.parse(str);
        }
        return null;
    }

    @Override
    public String toStr(LocalDate data) {
        if (data == null) {
            return null;
        }
        return DateTimeFormatter.ofPattern("yyyy-MM-dd").format(data);
    }

    @Override
    public DataTypeEnum applyFor() {
        return DataTypeEnum.LOCAL_DATE;
    }

    @Override
    public LocalDate defaultValue() {
        return null;
    }

    @Override
    public String format(LocalDate data, String format) {
        if (data == null) {
            return "";
        }
        if (StringUtils.isEmpty((CharSequence)format)) {
            format = "yyyy-MM-dd";
        }
        return DateTimeFormatter.ofPattern(format).format(data);
    }

    @Override
    public boolean styleMatch(Object value) {
        return SitDateUtil.isDate(value);
    }
}

