/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbp.common.util.datatype;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import kd.bos.dataentity.utils.StringUtils;
import kd.sit.sitbp.common.util.SitDateUtil;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import kd.sit.sitbp.common.util.datatype.DataTypeEnum;

public class LocalDateTimeConverter
extends BaseDataConverter<LocalDateTime> {
    @Override
    public LocalDateTime convert(Object obj) {
        if (obj instanceof String) {
            obj = ((String)obj).trim();
        }
        if (obj == null || "".equals(obj)) {
            return null;
        }
        if (obj instanceof LocalDateTime) {
            return (LocalDateTime)obj;
        }
        if (obj instanceof Date) {
            return ((Date)obj).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        if (obj instanceof LocalDate) {
            return ((LocalDate)obj).atStartOfDay();
        }
        if (obj instanceof Long) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli((Long)obj), ZoneId.systemDefault());
        }
        if (obj instanceof String) {
            String str = (String)obj;
            int index = str.indexOf(32);
            if (index < 0) {
                str = str.indexOf(58) > 0 ? "1970-01-01 " + str : str + ' ' + "00:00:00";
            }
            if (str.indexOf(47) > 0) {
                str = str.replace('/', '-');
            }
            return LocalDateTime.parse(str, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        return null;
    }

    @Override
    public String toStr(LocalDateTime data) {
        if (data == null) {
            return null;
        }
        return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(data);
    }

    @Override
    public DataTypeEnum applyFor() {
        return DataTypeEnum.LOCAL_DATE_TIME;
    }

    @Override
    public LocalDateTime defaultValue() {
        return null;
    }

    @Override
    public String format(LocalDateTime data, String format) {
        if (data == null) {
            return "";
        }
        if (StringUtils.isEmpty((CharSequence)format)) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        return DateTimeFormatter.ofPattern(format).format(data);
    }

    @Override
    public boolean styleMatch(Object value) {
        return SitDateUtil.isDate(value);
    }
}

