/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.common.utils;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class StringCheckUtils {
    private static final List<String> specialCharList = Arrays.asList("+", "-", "/", "*", "\"", "(", ")", "!=", "=", "<", ">", "<=", ">=", " ", ".", ",", "@", "[", "]");
    private static final char[] JAVANAME_NOTCONTAIN_CHAR_ARRAY = new char[]{'+', '-', '/', '*', '(', ')', '=', '<', '>', ' ', '.', ',', '@', '!', '#', '$', '%', '^', '&', '-', '`', '\"', '\'', '[', ']', '{', '}'};
    private static final String[] JAVAVARIABLEFORBIDCHAR_ARRAY = new String[]{"+", "-", "/", "*", "(", ")", "=", "<", ">", " ", ".", ",", "@", "!", "#", "$", "%", "^", "&", "-", "`", "\"", "'", "[", "]", "{", "}", "\\"};
    private static final char REPLACE_CHAR = '_';
    private static final List<String> NAME_SPECIAL_CHAR_LIST = Arrays.asList("[", "]");
    private static final Pattern pattern = Pattern.compile("[0-9]*");

    public static boolean isContainSpecialChar(String name) {
        return StringCheckUtils.isContainSpecialChar(name, specialCharList);
    }

    public static boolean checkNameIsContainSpecialChar(String name) {
        return StringCheckUtils.isContainSpecialChar(name, NAME_SPECIAL_CHAR_LIST);
    }

    public static boolean isContainSpecialChar(String name, List<String> specialCharList) {
        if (name == null || CollectionUtils.isEmpty(specialCharList)) {
            return false;
        }
        name = name.trim();
        boolean flag = false;
        for (String specialChar : specialCharList) {
            if (name.indexOf(specialChar) == -1) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean isContainJavaVariableForbidChar(String str) {
        if (str == null) {
            return false;
        }
        str = str.trim();
        boolean flag = false;
        for (String specialChar : JAVAVARIABLEFORBIDCHAR_ARRAY) {
            if (str.indexOf(specialChar) == -1) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean isStartWithNumber(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        Matcher isNum = pattern.matcher(str.charAt(0) + "");
        return isNum.matches();
    }

    public static String replaceChar(String str) {
        if (str == null) {
            return str;
        }
        str = str.trim();
        for (char specialChar : JAVANAME_NOTCONTAIN_CHAR_ARRAY) {
            if (str.indexOf(specialChar) == -1) continue;
            str = str.replace(specialChar, '_');
        }
        return str;
    }

    public static boolean isEnglishChar(String str) {
        if (HRStringUtils.isEmpty((String)str)) {
            return false;
        }
        return str.matches("[a-zA-Z]+");
    }
}

