/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.hr.hbp.common.util.HRStringUtils;

public class SITBSFixedFieldListPlugin
extends AbstractListPlugin {
    private Map<String, List<String>> fixFieldListMap;
    private static final String PARAM_ISFIXED = "param_isfixed";

    public void initialize() {
        super.initialize();
        this.initFixFieldListMap();
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        List<String> fixedFieldKeyList = this.getFixedFieldKeyList();
        if (CollectionUtils.isEmpty(fixedFieldKeyList)) {
            return;
        }
        IPageCache pageCache = this.getView().getPageCache();
        String isFixed = pageCache.get(PARAM_ISFIXED);
        if (HRStringUtils.isNotEmpty((String)isFixed)) {
            return;
        }
        List<IListColumn> columns = args.getListColumns().stream().filter(column -> fixedFieldKeyList.contains(column.getListFieldKey())).collect(Collectors.toList());
        columns.forEach(column -> column.setFixed(true));
        pageCache.put(PARAM_ISFIXED, Boolean.TRUE.toString());
    }

    private List<String> getFixedFieldKeyList() {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String formId = listShowParameter.getBillFormId();
        return this.fixFieldListMap.get(formId);
    }

    private void initFixFieldListMap() {
        this.fixFieldListMap = new HashMap<String, List<String>>(16);
        ArrayList<String> taxBlockFixFieldList = new ArrayList<String>();
        taxBlockFixFieldList.add("number");
        taxBlockFixFieldList.add("name");
        this.fixFieldListMap.put("sitbs_taxitem", taxBlockFixFieldList);
        ArrayList<String> taxDataGradeFixFieldList = new ArrayList<String>();
        taxDataGradeFixFieldList.add("createorg.name");
        taxDataGradeFixFieldList.add("number");
        taxDataGradeFixFieldList.add("name");
        this.fixFieldListMap.put("sitbs_datagrade", taxDataGradeFixFieldList);
    }
}

