/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.basecfg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class TaxCategoryList
extends HRDataBaseList {
    private static final String DISABLE_AFTERCONFIRM = "notfirstdisable";
    private static final String ENABLE_AFTERCONFIRM = "notfirstenable";
    private static final String TREE_PANEL = "splitcontainerap";

    public void afterBindData(EventObject ex) {
        super.afterBindData(ex);
        if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            if (!listShowParameter.isLookUp()) {
                SplitContainer splitc = (SplitContainer)this.getControl(TREE_PANEL);
                splitc.hidePanel(SplitDirection.left, true);
            } else {
                FieldEdit isContainLower = (FieldEdit)this.getControl("iscontainlower");
                isContainLower.setVisible("", false);
            }
        }
    }

    public void setFilter(SetFilterEvent ex) {
        super.setFilter(ex);
        List qFilters = ex.getQFilters();
        for (QFilter qFilter : qFilters) {
            if (qFilter == null || !qFilter.getProperty().contains("taxgroupsearch")) continue;
            String property = qFilter.getProperty();
            String newProperty = property.replace("taxgroupsearch", "group");
            qFilter.__setProperty(newProperty);
            List nests = qFilter.getNests(true);
            if (CollectionUtils.isEmpty((Collection)nests)) continue;
            for (QFilter.QFilterNest nest : nests) {
                if (nest.getFilter() == null || !nest.getFilter().getProperty().contains("taxgroupsearch")) continue;
                String nestProperty = nest.getFilter().getProperty();
                String newstNewProperty = nestProperty.replace("taxgroupsearch", "group");
                nest.getFilter().__setProperty(newstNewProperty);
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List commonFilterColumnList;
        super.filterContainerInit(args);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxgroup");
        DynamicObject[] dynamicObjects = helper.query("id, name", null);
        ArrayList<ComboItem> taxGroupSearchNameComboItems = new ArrayList<ComboItem>(16);
        Map<Long, DynamicObject> taxGroupMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        for (Map.Entry<Long, DynamicObject> entry : taxGroupMap.entrySet()) {
            ComboItem taxGroup = new ComboItem();
            taxGroup.setCaption(LocaleString.fromMap((Map)((Map)entry.getValue().get("name"))));
            taxGroup.setValue(entry.getValue().getString("id"));
            taxGroupSearchNameComboItems.add(taxGroup);
        }
        this.setTaxGroupSearchNameValue(args, taxGroupSearchNameComboItems);
        Long taxgroupid = (Long)this.getView().getFormShowParameter().getCustomParam("taxgroupid");
        if (taxgroupid != null && (commonFilterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns()) != null) {
            for (FilterColumn listFilter : commonFilterColumnList) {
                String fieldName;
                CommonFilterColumn commFilter = (CommonFilterColumn)listFilter;
                switch (fieldName = commFilter.getFieldName()) {
                    case "taxgroupsearch.name": {
                        commFilter.setDefaultValues(new Object[]{String.valueOf(taxgroupid)});
                        break;
                    }
                }
            }
        }
    }

    private void setTaxGroupSearchNameValue(FilterContainerInitArgs args, List<ComboItem> taxGroupSearchNameComboItems) {
        FilterColumn taxGroupSearchNameFilterColumn = args.getFilterColumn("taxgroupsearch.name");
        CommonFilterColumn taxGroupSearchNameCommonFilterColumn = (CommonFilterColumn)taxGroupSearchNameFilterColumn;
        taxGroupSearchNameCommonFilterColumn.setComboItems(taxGroupSearchNameComboItems);
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        String fieldName;
        super.filterColumnSetFilter(args);
        switch (fieldName = args.getFieldName()) {
            case "country.name": {
                List countryNameFilters = args.getQFilters();
                Set<Long> allCountryIds = this.getAllCountryIds();
                QFilter countryFilter = new QFilter("id", "in", allCountryIds);
                countryNameFilters.add(countryFilter);
                break;
            }
        }
    }

    private Set<Long> getAllCountryIds() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxcategory");
        DynamicObject[] dynamicObjects = helper.query("id,country", null);
        HashSet<Long> countryIds = new HashSet<Long>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject country = dynamicObject.getDynamicObject("country");
            if (null == country) continue;
            Long id = country.getLong("id");
            countryIds.add(id);
        }
        return countryIds;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (opKey = formOperate.getOperateKey()) {
            case "disable": {
                RefObject DisableAfterConfirm = new RefObject();
                if (formOperate.getOption().tryGetVariableValue(DISABLE_AFTERCONFIRM, DisableAfterConfirm)) break;
                this.confirmDisable();
                args.setCancel(true);
                break;
            }
            case "enable": {
                RefObject EnableAfterConfirm = new RefObject();
                if (formOperate.getOption().tryGetVariableValue(ENABLE_AFTERCONFIRM, EnableAfterConfirm)) break;
                this.confirmEnable();
                args.setCancel(true);
                break;
            }
        }
    }

    private void confirmEnable() {
        boolean hasTaxGroupDisabled = this.hasTaxGroupDisabled(this.getSelectedRowsId());
        String msg = null;
        if (hasTaxGroupDisabled) {
            String msg1 = ResManager.loadKDString((String)"\u542f\u7528\u540e\u5728\u65b0\u589e\u4e2a\u7a0e\u9879\u76ee\u65f6\u5c06\u53ef\u4ee5\u4f7f\u7528\u8be5\u4e2a\u7a0e\u79cd\u7c7b\uff0c\u786e\u5b9a\u8981\u542f\u7528\u9009\u4e2d\u7684\u4e2a\u7a0e\u79cd\u7c7b\u5417\uff1f", (String)"TaxCategoryList_2", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
            String msg2 = ResManager.loadKDString((String)"\u6ce8\u610f\uff1a\u5f53\u524d\u4e2a\u7a0e\u79cd\u7c7b\u6240\u5c5e\u7684\u4e2a\u7a0e\u5927\u7c7b\u5df2\u88ab\u7981\u7528\uff0c\u542f\u7528\u540e\u5c06\u540c\u6b65\u542f\u7528\u6240\u5c5e\u7684\u4e2a\u7a0e\u5927\u7c7b\u3002", (String)"TaxCategoryList_3", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
            msg = msg1 + "\\r\\n" + msg2;
        } else {
            msg = ResManager.loadKDString((String)"\u542f\u7528\u540e\u5728\u65b0\u589e\u4e2a\u7a0e\u9879\u76ee\u65f6\u5c06\u53ef\u4ee5\u4f7f\u7528\u8be5\u4e2a\u7a0e\u79cd\u7c7b\uff0c\u786e\u5b9a\u8981\u542f\u7528\u9009\u4e2d\u7684\u4e2a\u7a0e\u79cd\u7c7b\u5417\uff1f", (String)"TaxCategoryList_1", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
        }
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("enable"));
    }

    private boolean hasTaxGroupDisabled(List<Long> selectedRowsId) {
        DynamicObject[] dynamicObjects;
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxcategory");
        for (DynamicObject dynamicObject : dynamicObjects = helper.query("id,group.enable", new QFilter[]{new QFilter("id", "in", selectedRowsId)})) {
            if (!Boolean.FALSE.equals(dynamicObject.getBoolean("group.enable"))) continue;
            return true;
        }
        return false;
    }

    private List<Long> getSelectedRowsId() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        ArrayList<Long> pKIds = new ArrayList<Long>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            Long primaryKeyValue = (Long)row.getPrimaryKeyValue();
            pKIds.add(primaryKeyValue);
        }
        return pKIds;
    }

    private void confirmDisable() {
        String msg = ResManager.loadKDString((String)"\u7981\u7528\u540e\u5728\u65b0\u589e\u4e2a\u7a0e\u9879\u76ee\u65f6\u5c06\u65e0\u6cd5\u4f7f\u7528\u8be5\u4e2a\u7a0e\u79cd\u7c7b\uff0c\u786e\u5b9a\u8981\u7981\u7528\u9009\u4e2d\u7684\u4e2a\u7a0e\u79cd\u7c7b\u5417\uff1f", (String)"TaxCategoryList_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("disable"));
    }

    public void confirmCallBack(MessageBoxClosedEvent ex) {
        switch (ex.getCallBackId()) {
            case "disable": {
                if (!MessageBoxResult.Yes.equals((Object)ex.getResult())) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(DISABLE_AFTERCONFIRM, "true");
                this.getView().invokeOperation("disable", operateOption);
                break;
            }
            case "enable": {
                if (!MessageBoxResult.Yes.equals((Object)ex.getResult())) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(ENABLE_AFTERCONFIRM, "true");
                this.getView().invokeOperation("enable", operateOption);
                break;
            }
        }
    }
}

