/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.basecfg;

import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class TaxGroupList
extends HRDataBaseList {
    private static final String DISABLE_AFTERCONFIRM = "notfirstdisable";
    private static final String ENABLE_AFTERCONFIRM = "notfirstenable";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (opKey = formOperate.getOperateKey()) {
            case "disable": {
                RefObject DisableAfterConfirm = new RefObject();
                if (formOperate.getOption().tryGetVariableValue(DISABLE_AFTERCONFIRM, DisableAfterConfirm)) break;
                this.confirmDisable();
                args.setCancel(true);
                break;
            }
            case "enable": {
                RefObject EnableAfterConfirm = new RefObject();
                if (formOperate.getOption().tryGetVariableValue(ENABLE_AFTERCONFIRM, EnableAfterConfirm)) break;
                this.confirmEnable();
                args.setCancel(true);
                break;
            }
        }
    }

    private void confirmEnable() {
        String msg = ResManager.loadKDString((String)"\u542f\u7528\u540e\u5728\u65b0\u589e\u4e2a\u7a0e\u9879\u76ee\u65f6\u5c06\u53ef\u4ee5\u4f7f\u7528\u8be5\u4e2a\u7a0e\u5927\u7c7b\u53ca\u5176\u4e0b\u5c5e\u7684\u5168\u90e8\u4e2a\u7a0e\u79cd\u7c7b\uff0c\u786e\u5b9a\u8981\u542f\u7528\u9009\u4e2d\u7684\u4e2a\u7a0e\u5927\u7c7b\u5417\uff1f", (String)"TaxGroupList_1", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("enable"));
    }

    private void confirmDisable() {
        String msg = ResManager.loadKDString((String)"\u7981\u7528\u540e\u5728\u65b0\u589e\u4e2a\u7a0e\u9879\u76ee\u65f6\u5c06\u65e0\u6cd5\u4f7f\u7528\u8be5\u4e2a\u7a0e\u5927\u7c7b\u53ca\u5176\u4e0b\u5c5e\u7684\u5168\u90e8\u4e2a\u7a0e\u79cd\u7c7b\uff0c\u786e\u5b9a\u8981\u7981\u7528\u9009\u4e2d\u7684\u4e2a\u7a0e\u5927\u7c7b\u5417\uff1f", (String)"TaxGroupList_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("disable"));
    }

    public void confirmCallBack(MessageBoxClosedEvent ex) {
        switch (ex.getCallBackId()) {
            case "disable": {
                if (!MessageBoxResult.Yes.equals((Object)ex.getResult())) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(DISABLE_AFTERCONFIRM, "true");
                this.getView().invokeOperation("disable", operateOption);
                break;
            }
            case "enable": {
                if (!MessageBoxResult.Yes.equals((Object)ex.getResult())) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(ENABLE_AFTERCONFIRM, "true");
                this.getView().invokeOperation("enable", operateOption);
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        Long pkId = (Long)billList.getFocusRowPkId();
        DynamicObject dynamicObject = this.queryTaxGroupByPkId(pkId);
        if (dynamicObject == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86\u3002", (String)"TaxGroupList_2", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
            return;
        }
        String fieldName = args.getFieldName();
        if ("name".equals(fieldName)) {
            this.openTaxCategory(dynamicObject);
        }
    }

    private void openTaxCategory(DynamicObject dynamicObject) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setBillFormId("sitbs_taxcategory");
        listShowParameter.setCustomParam("taxgroupid", (Object)dynamicObject.getLong("id"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private DynamicObject queryTaxGroupByPkId(Long Id) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxgroup");
        return helper.queryOne((Object)Id);
    }
}

