/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.accumulator;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.fieldtip.DeleteRule;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hbp.formplugin.web.util.perm.HRPermUtil;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.api.TaxCalItemUniCodeResolver;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbp.common.field.LockableComboEdit;

public class AccumulatorEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final String CACHE_SELECTROWNUM = "selectRowNum";
    private static final String CALLBACK_ADDTAXITEM = "callback_addTaxItem";
    private static final String CALLBACK_SAVECONFIRM = "callback_saveConfirm";
    private static final String CALLBACK_DELETEENTRY_ACCMEMBER = "callback_deleteentry_accmember";
    private static final String OP_SAVEACCMEMBER = "saveaccmember";
    private final Set<String> combos = Sets.newHashSet((Object[])new String[]{"countrytype", "periodtype", "startmonthval"});

    public void initialize() {
        this.getView().addCustomControls(this.combos.toArray(new String[0]));
    }

    public void onGetControl(OnGetControlArgs ex) {
        super.onGetControl(ex);
        String key = ex.getKey();
        if (this.combos.contains(key)) {
            LockableComboEdit edit = new LockableComboEdit();
            edit.setKey(key);
            edit.setView(this.getView());
            ex.setControl((Control)edit);
        }
    }

    public void beforeBindData(EventObject ex) {
        super.beforeBindData(ex);
        OperationStatus viewStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW.equals((Object)viewStatus) || OperationStatus.EDIT.equals((Object)viewStatus)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"countrytype", "periodtype", "startmonthval"});
        }
    }

    public void registerListener(EventObject ex) {
        super.registerListener(ex);
        this.addClickListeners(new String[]{"membername"});
        BasedataEdit taxCategories = (BasedataEdit)this.getControl("taxcategories");
        BasedataEdit country = (BasedataEdit)this.getControl("country");
        taxCategories.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        country.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterLoadData(EventObject ex) {
        this.initMemberName(this.getModel().getDataEntity());
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject ex) {
        super.afterBindData(ex);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.initPeriodFlex(dataEntity.getString("periodtype"));
        this.resetControl("membername", Boolean.TRUE, true);
        this.dataTypeChange(dataEntity.getDynamicObject("datatype"));
        this.initFlexCollapseStatus();
        this.initMemberFlex(dataEntity);
    }

    private void initMemberFlex(DynamicObject dataEntity) {
        if (StringUtils.equals((CharSequence)dataEntity.getString("enable"), (CharSequence)"0") || dataEntity.getBoolean("issyspreset")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"addaccmember", "delaccmember", "accmemmoveup", "accmemmovedown", OP_SAVEACCMEMBER, "modifyaccmember"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
        } else if (StringUtils.equals((CharSequence)dataEntity.getString("status"), (CharSequence)"B") || StringUtils.equals((CharSequence)dataEntity.getString("status"), (CharSequence)"C")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"addaccmember", "delaccmember", "accmemmoveup", "accmemmovedown", OP_SAVEACCMEMBER});
            this.getView().setVisible(Boolean.TRUE, new String[]{"modifyaccmember"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"addaccmember", "delaccmember", "accmemmoveup", "accmemmovedown"});
            this.getView().setVisible(Boolean.FALSE, new String[]{OP_SAVEACCMEMBER, "modifyaccmember"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"entryentity"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
        String key;
        switch (key = args.getProperty().getName()) {
            case "taxcategories": {
                DynamicObject dataEntity = this.getModel().getDataEntity();
                String countryType = dataEntity.getString("countrytype");
                DynamicObject country = dataEntity.getDynamicObject("country");
                if (StringUtils.equals((CharSequence)countryType, (CharSequence)"1") && null == country) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\u548c\u56fd\u5bb6/\u5730\u533a\u3002", (String)"AccumulatorEdit_4", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                QFilter filter = new QFilter("countrytype", "=", (Object)"0");
                long countryId = dataEntity.getLong("country.id");
                if (countryId != 0L) {
                    filter.or("country", "=", (Object)countryId);
                }
                ListShowParameter param = (ListShowParameter)args.getFormShowParameter();
                param.getListFilterParameter().setFilter(filter);
                param.getTreeFilterParameter().setQFilters((List)Lists.newArrayList((Object[])new QFilter[]{filter}));
                break;
            }
            case "country": {
                ListShowParameter listShowParameter = (ListShowParameter)args.getFormShowParameter();
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                String appId = HRPermUtil.getAppIdFromShowParam((FormShowParameter)formShowParameter);
                Set countryIds = SITPermissionServiceHelper.getCountrySetByPermItem((String)appId, (String)"sitbs_accumulator", (String)"47150e89000000ac");
                if (CollectionUtils.isEmpty((Collection)countryIds)) break;
                listShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)countryIds));
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String operateKey;
        Control control = (Control)evt.getSource();
        switch (operateKey = control.getKey()) {
            case "membername": {
                this.memberNameClick();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": {
                this.saveAccumulatorConfirm(operate, args);
                break;
            }
            case "deleteentry_accmember": {
                this.accMemberDelEntryConfirm();
                args.setCancel(true);
                break;
            }
            case "saveaccmember": {
                String checkRightAppNumber = this.getView().getFormShowParameter().getCheckRightAppId();
                String appId = "";
                appId = "itc".equals(checkRightAppNumber) ? "17/+CT1QBPNP" : "17/+7RIW4SCJ";
                boolean isHaveModifyPerm = SITPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)appId, (String)"sitbs_accumulator", (String)"4715a0df000000ac");
                if (isHaveModifyPerm) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4e1a\u52a1\u5bf9\u8c61[\u7d2f\u52a0\u5668]\u7684[\u4fee\u6539]\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"AccumulatorEdit_6", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "enable": 
            case "disable": 
            case "submit": 
            case "audit": 
            case "unsubmit": {
                this.getView().updateView();
                break;
            }
            case "saveaccmember": {
                OperationResult operationResult = args.getOperationResult();
                if (!CollectionUtils.isEmpty((Collection)operationResult.getAllErrorOrValidateInfo())) {
                    return;
                }
                this.showMemberModifyButton(Boolean.FALSE, Boolean.TRUE);
                break;
            }
            case "modifyaccmember": {
                this.showMemberModifyButton(Boolean.TRUE, Boolean.FALSE);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        switch (callBackId) {
            case "callback_saveConfirm": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("saveConfirmResult", "1");
                this.getView().invokeOperation("save", operateOption);
                break;
            }
            case "callback_deleteentry_accmember": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
                int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
                this.getModel().deleteEntryRows("entryentity", selectedRows);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (selectedRows == null || selectedRows.size() == 0) {
            return;
        }
        if (CALLBACK_ADDTAXITEM.equals(actionId)) {
            ListSelectedRow selectedRow = selectedRows.get(0);
            Long taxItemId = (Long)selectedRow.getPrimaryKeyValue();
            IPageCache pageCache = this.getPageCache();
            int rowNum = Integer.parseInt(pageCache.get(CACHE_SELECTROWNUM));
            this.getModel().setValue("taxitem", (Object)taxItemId, rowNum);
            this.getModel().setValue("membername", (Object)selectedRow.getName(), rowNum);
            TaxCalItemUniCodeResolver uniCodeResolver = TaxCalItemUniCodeResolver.getResolverBy((String)"TI");
            this.getModel().setValue("uniquecode", (Object)uniCodeResolver.uniCode(taxItemId.toString()), rowNum);
        }
    }

    public void propertyChanged(PropertyChangedArgs ex) {
        String propertyName = ex.getProperty().getName();
        Object[] changeData = ex.getChangeSet();
        if (ArrayUtils.isEmpty((Object[])changeData)) {
            return;
        }
        Object newValue = changeData[0].getNewValue();
        switch (propertyName) {
            case "periodtype": {
                this.periodTypeChange((String)changeData[0].getNewValue());
                break;
            }
            case "accmenstartdate": 
            case "accmemenddate": {
                this.accMemDateChange(changeData[0].getDataEntity());
                break;
            }
            case "membername": {
                if (!ObjectUtils.isEmpty((Object)newValue)) break;
                int rowNum = changeData[0].getRowIndex();
                this.getModel().setValue("taxitem", null, rowNum);
                this.getModel().setValue("uniquecode", null, rowNum);
                break;
            }
            case "countrytype": {
                if (StringUtils.equals((CharSequence)((String)newValue), (CharSequence)"0")) {
                    this.getModel().setValue("country", null);
                    break;
                }
                this.resetControl("country", Boolean.TRUE, true);
                break;
            }
            case "country": {
                this.countryChange(newValue);
                break;
            }
            case "taxcategories": {
                this.taxCategoriesChange(newValue);
                break;
            }
            case "datatype": {
                this.dataTypeChange(newValue);
                break;
            }
        }
    }

    private void dataTypeChange(Object newValue) {
        String dataType;
        if (ObjectUtils.isEmpty((Object)newValue)) {
            return;
        }
        switch (dataType = ((DynamicObject)newValue).getString("showtype")) {
            case "num": {
                this.resetControl("dataprecision", Boolean.TRUE, true);
                break;
            }
            case "amount": {
                this.resetControl("dataprecision", Boolean.FALSE, false);
                break;
            }
        }
    }

    private void initFlexCollapseStatus() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        this.setFlexCollapse(status != OperationStatus.ADDNEW);
    }

    private void initMemberName(DynamicObject dataEntity) {
        ((FieldEdit)this.getControl("membername")).setMustInput(true);
        DynamicObjectCollection members = dataEntity.getDynamicObjectCollection("entryentity");
        for (DynamicObject member : members) {
            member.set("membername", (Object)member.getString("taxitem.name"));
        }
    }

    private void setFlexCollapse(boolean flag) {
        Container baseInfo = (Container)this.getView().getControl("fs_baseinfo");
        Container dataType = (Container)this.getView().getControl("fs_datatype");
        Container accOpStrategy = (Container)this.getView().getControl("fs_accopstrategy");
        Container accDim = (Container)this.getView().getControl("accdim_flexpanelap");
        baseInfo.setCollapse(flag);
        dataType.setCollapse(flag);
        accOpStrategy.setCollapse(flag);
        accDim.setCollapse(flag);
    }

    private void accMemberDelEntryConfirm() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        if (selectedRows.length > 0) {
            String msg = MessageFormat.format(ResManager.loadKDString((String)"\u4f60\u5df2\u9009\u62e9{0}\u6761\u8bb0\u5f55\uff0c\u5220\u9664\u540e\u4e0d\u53ef\u6062\u590d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AccumulatorEdit_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]), selectedRows.length);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACK_DELETEENTRY_ACCMEMBER));
        }
    }

    private void saveAccumulatorConfirm(FormOperate operate, BeforeDoOperationEventArgs args) {
        DynamicObjectCollection accMemberEntry;
        String confirmResult = operate.getOption().getVariableValue("saveConfirmResult", "0");
        if (!StringUtils.equals((CharSequence)confirmResult, (CharSequence)"1") && (accMemberEntry = this.getModel().getEntryEntity("entryentity")).size() <= 0) {
            String msg = ResManager.loadKDString((String)"\u7d2f\u52a0\u6210\u5458\u5206\u5f55\u5185\u5bb9\u4e3a\u7a7a\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AccumulatorEdit_1", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACK_SAVECONFIRM));
            args.setCancel(true);
        }
    }

    private void memberNameClick() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long taxCategoriesId = dataEntity.getLong("taxcategories.id");
        if (taxCategoriesId == 0L) {
            FieldTip fieldTip = this.getFieldTip("taxcategories");
            this.getView().showFieldTip(fieldTip);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e2a\u7a0e\u79cd\u7c7b\u3002", (String)"AccumulatorEdit_2", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int selectedRow = entryGrid.getEntryState().getSelectedRows()[0];
        this.getPageCache().put(CACHE_SELECTROWNUM, String.valueOf(selectedRow));
        Set<String> selectedTaxItems = this.getSelectedTaxItems(entryGrid, selectedRow);
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"sitbs_taxitem", (boolean)false);
        QFilter filter = new QFilter("taxcategories.fbasedataid_id", "=", (Object)taxCategoriesId);
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        filter.and("datatype", "in", (Object)Lists.newArrayList((Object[])new Long[]{SitDataTypeEnum.NUMBER.getId(), SitDataTypeEnum.AMOUNT.getId(), SitDataTypeEnum.INTEGER.getId()}));
        if (!CollectionUtils.isEmpty(selectedTaxItems)) {
            filter.and("number", "not in", selectedTaxItems);
        }
        showParameter.setListFilterParameter(new ListFilterParameter((List)Lists.newArrayList((Object[])new QFilter[]{filter}), ""));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_ADDTAXITEM));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private FieldTip getFieldTip(String fieldCode) {
        FieldTip fieldTip = new FieldTip(FieldTip.FieldTipsLevel.Error, FieldTip.FieldTipsTypes.notNull, fieldCode, ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"AccumulatorEdit_5", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
        DeleteRule deleteRule = new DeleteRule();
        deleteRule.setAction("isChange");
        deleteRule.setFields(Collections.singletonList(fieldCode));
        fieldTip.setDeleteRule(deleteRule);
        return fieldTip;
    }

    private Set<String> getSelectedTaxItems(EntryGrid entryGrid, int selectedRow) {
        DynamicObject[] dataEntities = entryGrid.getEntryData().getDataEntitys();
        HashSet<String> selectedTaxItems = new HashSet<String>(dataEntities.length);
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject member;
            String itemNumber;
            if (i == selectedRow || StringUtils.isEmpty((CharSequence)(itemNumber = (member = dataEntities[i]).getString("taxitem.number")))) continue;
            selectedTaxItems.add(itemNumber);
        }
        return selectedTaxItems;
    }

    private void accMemDateChange(DynamicObject dataEntity) {
        Date startDate = dataEntity.getDate("accmenstartdate");
        Date endDate = dataEntity.getDate("accmemenddate");
        if (startDate != null && endDate != null && endDate.before(startDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u6216\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"AccumulatorEdit_3", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
        }
    }

    private void periodTypeChange(String value) {
        switch (value) {
            case "1": 
            case "2": {
                this.resetControl("startdatetype", Boolean.FALSE, false, null);
                this.resetControl("startdate", Boolean.FALSE, false, null);
                this.resetControl("startmonthval", Boolean.TRUE, true);
                this.resetControl("startday", Boolean.TRUE, true, 1);
                this.resetControl("bsedstrategy", Boolean.TRUE, true, "2");
                break;
            }
            case "3": {
                this.resetControl("startdatetype", Boolean.FALSE, false, null);
                this.resetControl("startdate", Boolean.FALSE, false, null);
                this.resetControl("startmonthval", Boolean.FALSE, false, null);
                this.resetControl("startday", Boolean.TRUE, true, 1);
                this.resetControl("bsedstrategy", Boolean.TRUE, true, "2");
                break;
            }
            case "4": {
                this.resetControl("startdatetype", Boolean.TRUE, true, "1");
                this.resetControl("startdate", Boolean.TRUE, true);
                this.resetControl("startmonthval", Boolean.FALSE, false, null);
                this.resetControl("startday", Boolean.FALSE, false, 1);
                this.resetControl("bsedstrategy", Boolean.FALSE, false, null);
                break;
            }
        }
    }

    private void countryChange(Object newValue) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject taxCategories = dataEntity.getDynamicObject("taxcategories");
        if (taxCategories != null && !StringUtils.equals((CharSequence)"0", (CharSequence)taxCategories.getString("countrytype"))) {
            long catCountryId = taxCategories.getLong("country.id");
            if (newValue == null || ((DynamicObject)newValue).getLong("id") != catCountryId) {
                this.getModel().setValue("taxcategories", null);
            }
        }
    }

    private void taxCategoriesChange(Object newValue) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        Object[] dataEntities = entryGrid.getEntryData().getDataEntitys();
        if (ArrayUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        long cateId = 0L;
        if (newValue != null) {
            cateId = ((DynamicObject)newValue).getLong("id");
        }
        block0: for (Object member : dataEntities) {
            DynamicObject taxItem = member.getDynamicObject("taxitem");
            if (taxItem == null) continue;
            DynamicObjectCollection memberTaxCates = taxItem.getDynamicObjectCollection("taxcategories");
            for (DynamicObject taxCategory : memberTaxCates) {
                if (taxCategory.getLong("fbasedataid_id") != cateId) continue;
                continue block0;
            }
            this.getModel().setValue("membername", null, member.getInt("seq") - 1);
        }
    }

    private void initPeriodFlex(String value) {
        switch (value) {
            case "1": 
            case "2": {
                this.resetControl("startdatetype", Boolean.FALSE, false);
                this.resetControl("startdate", Boolean.FALSE, false);
                this.resetControl("startmonthval", Boolean.TRUE, true);
                this.resetControl("startday", Boolean.TRUE, true);
                this.resetControl("bsedstrategy", Boolean.TRUE, true);
                break;
            }
            case "3": {
                this.resetControl("startdatetype", Boolean.FALSE, false);
                this.resetControl("startdate", Boolean.FALSE, false);
                this.resetControl("startmonthval", Boolean.FALSE, false);
                this.resetControl("startday", Boolean.TRUE, true);
                this.resetControl("bsedstrategy", Boolean.TRUE, true);
                break;
            }
            case "4": {
                this.resetControl("startdatetype", Boolean.TRUE, true);
                this.resetControl("startdate", Boolean.TRUE, true);
                this.resetControl("startmonthval", Boolean.FALSE, false);
                this.resetControl("startday", Boolean.FALSE, false);
                this.resetControl("bsedstrategy", Boolean.FALSE, false);
                break;
            }
        }
    }

    private void resetControl(String key, Boolean isVisible, boolean isMustInput) {
        this.getView().setVisible(isVisible, new String[]{key});
        ((FieldEdit)this.getControl(key)).setMustInput(isMustInput);
    }

    private void resetControl(String key, Boolean isVisible, boolean isMustInput, Object defaultValue) {
        this.resetControl(key, isVisible, isMustInput);
        this.getModel().beginInit();
        this.getModel().setValue(key, defaultValue);
        this.getModel().endInit();
        this.getView().updateView(key);
    }

    private void showMemberModifyButton(Boolean isAllowModify, Boolean isEnableStatus) {
        this.getView().setVisible(isAllowModify, new String[]{"addaccmember", "delaccmember", "accmemmoveup", "accmemmovedown", OP_SAVEACCMEMBER});
        this.getView().setVisible(isEnableStatus, new String[]{"modifyaccmember"});
        this.getView().setEnable(isAllowModify, new String[]{"entryentity"});
        this.setAccMemberVisible(isAllowModify);
        this.getView().updateView("entryentity");
    }

    private void setAccMemberVisible(Boolean flag) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int index = 0; index < entryEntity.size(); ++index) {
            this.getView().setEnable(flag, index, new String[]{"membername", "accmenstartdate", "accmemenddate", "operator", "percentfixval"});
        }
    }
}

