/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.calrule;

import com.google.common.base.Strings;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.tree.TreeFilterParameter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hbp.formplugin.web.util.perm.HRPermUtil;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbs.business.calrule.CalRuleHelper;

public class CalRuleEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(CalRuleEdit.class);
    private static final String ADVCONTOOLBARAP = "advcontoolbarap";

    public void registerListener(EventObject ex) {
        super.registerListener(ex);
        this.addItemClickListeners(new String[]{ADVCONTOOLBARAP});
        BasedataEdit currencyBE = (BasedataEdit)this.getControl("currency");
        BasedataEdit countryBE = (BasedataEdit)this.getControl("country");
        BasedataEdit taxCategoryBE = (BasedataEdit)this.getControl("taxcategory");
        currencyBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        countryBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        taxCategoryBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("calruleitementry");
        entryGrid.addPackageDataListener(pkEvent -> pkEvent.getRowData().set("calindex", pkEvent.getRowData().get("seq")));
        super.initialize();
    }

    public void afterBindData(EventObject ex) {
        super.afterBindData(ex);
        this.setCountryAndCurrency();
        this.setTaxCategory();
        this.setFieldIfInsertHisVersion();
        this.setBtnInvisiable();
        this.getModel().setDataChanged(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        BasedataEdit basedataEdit = (BasedataEdit)evt.getSource();
        switch (key = basedataEdit.getKey()) {
            case "taxcategory": {
                this.showTaxCategoryF7(evt);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs ex) {
        String propertyName = ex.getProperty().getName();
        ChangeData[] changeData = ex.getChangeSet();
        switch (propertyName) {
            case "countrytype": 
            case "country": {
                this.getModel().setValue("taxcategory", null);
                break;
            }
            case "taxcategory": {
                if (YesOrNoEnum.YES.getCode().equals(this.getPageCache().get("isdone"))) {
                    this.getPageCache().remove("isdone");
                    return;
                }
                DynamicObject newTaxCategory = (DynamicObject)changeData[0].getNewValue();
                if (!ObjectUtils.isEmpty((Object)newTaxCategory)) {
                    long id = this.getModel().getDataEntity().getLong("id");
                    long createOrgId = this.getModel().getDataEntity().getLong("createorg.id");
                    boolean pass = CalRuleHelper.checkTaxCategoryAndCalrule((long)newTaxCategory.getLong("id"), (long)id, (long)createOrgId);
                    if (pass) {
                        DynamicObject oldTaxCategory;
                        int count = this.getModel().getEntryRowCount("calruleitementry");
                        if (count != 0) {
                            String msg = ResManager.loadKDString((String)"\u4e2a\u7a0e\u79cd\u7c7b\u53d8\u66f4\u4f1a\u5bfc\u81f4\u5df2\u9009\u4e2a\u7a0e\u8ba1\u7b97\u516c\u5f0f\u88ab\u6e05\u7a7a\uff0c\u786e\u5b9a\u8981\u7ee7\u7eed\u5417\uff1f", (String)"CalRuleEdit_9", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
                            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("changeTaxCategory2", (IFormPlugin)this));
                        }
                        if (ObjectUtils.isEmpty((Object)(oldTaxCategory = (DynamicObject)changeData[0].getOldValue()))) break;
                        this.getPageCache().put("oldvaluetorecover", String.valueOf(oldTaxCategory.getLong("id")));
                        break;
                    }
                    this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"{0}\u5728\u5f53\u524d\u751f\u6548\u65e5\u671f\u5185\uff0c\u521b\u5efa\u7ec4\u7ec7{1}\u4e0b\u5df2\u7ecf\u5b58\u5728\u8ba1\u7b97\u89c4\u5219\u3002", (String)"CalRuleEdit_1", (String)"sit-sitbs-formplugin", (Object[])new Object[0]), newTaxCategory.getString("name"), this.getModel().getDataEntity().getString("createorg.name")));
                    DynamicObject oldTaxCategory = (DynamicObject)changeData[0].getOldValue();
                    this.getPageCache().put("isdone", YesOrNoEnum.YES.getCode());
                    if (!ObjectUtils.isEmpty((Object)oldTaxCategory)) {
                        this.getModel().setValue("taxcategory", (Object)oldTaxCategory.getLong("id"));
                        break;
                    }
                    this.getModel().setValue("taxcategory", null);
                    break;
                }
                DynamicObject oldTaxCategory = (DynamicObject)changeData[0].getOldValue();
                if (ObjectUtils.isEmpty((Object)oldTaxCategory)) break;
                this.getPageCache().put("isdone", YesOrNoEnum.YES.getCode());
                this.getModel().setValue("taxcategory", (Object)oldTaxCategory.getLong("id"));
                this.getView().updateView("taxcategory");
                break;
            }
            case "bsed": {
                this.comfirmChangeBsed(ex);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "addformula": {
                this.openFormulaF7();
                break;
            }
            case "move": {
                this.openMovePage();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent ex) {
        String callBackId;
        switch (callBackId = ex.getCallBackId()) {
            case "changeTaxCategory2": {
                if (MessageBoxResult.Yes.equals((Object)ex.getResult())) {
                    this.clearCalruleItemEntry();
                    break;
                }
                String oldTaxcategoryId = this.getPageCache().get("oldvaluetorecover");
                if (Strings.isNullOrEmpty((String)oldTaxcategoryId)) {
                    this.getModel().setValue("taxcategory", null);
                    break;
                }
                this.getModel().beginInit();
                this.getModel().setValue("taxcategory", (Object)Long.valueOf(oldTaxcategoryId));
                this.getView().updateView("taxcategory");
                this.getModel().endInit();
                this.getPageCache().remove("oldvaluetorecover");
                break;
            }
            case "changeBsed": {
                this.getView().getPageCache().remove("changingBsed");
                if (!MessageBoxResult.Yes.equals((Object)ex.getResult())) {
                    AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                    model.beginInit();
                    String oldBsedJson = this.getView().getPageCache().get("oldBsed");
                    Date oldBsed = null;
                    if (!StringUtils.isEmpty((Object)oldBsedJson)) {
                        oldBsed = (Date)SerializationUtils.fromJsonString((String)oldBsedJson, Date.class);
                    }
                    this.getModel().setValue("bsed", (Object)oldBsed);
                    model.endInit();
                    this.getView().updateView();
                    break;
                }
                this.clearCalruleItemEntry();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent ex) {
        String callStr;
        switch (callStr = ex.getActionId()) {
            case "addFormula": {
                this.afterCloseFormulaF7(ex);
                break;
            }
            case "callbackmovesync": {
                Object returnData = ex.getReturnData();
                if (returnData == null) {
                    return;
                }
                this.setMove((Map)returnData);
                break;
            }
            case "taxCategory": {
                this.afterCloseTaxcategoryF7(ex);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean isSysPreSet;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("insertdata_his".equals(operateKey) && (isSysPreSet = this.getModel().getDataEntity().getBoolean("issyspreset"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"CalRuleEdit_12", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String changingBsed = this.getView().getPageCache().get("changingBsed");
        if (!StringUtils.isEmpty((Object)changingBsed)) {
            args.setCancel(true);
            this.getView().getPageCache().remove("changingBsed");
            return;
        }
        if ("save".equals(operateKey) || "submit".equals(operateKey) || "confirmchange".equals(operateKey)) {
            this.validateFormulas(args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        int index = 0;
        DynamicObject obj = null;
        DynamicObject formulaObj = null;
        super.afterDoOperation(args);
        switch (args.getOperateKey()) {
            case "viewformula": {
                index = this.getModel().getEntryCurrentRowIndex("calruleitementry");
                obj = this.getModel().getEntryRowEntity("calruleitementry", index);
                formulaObj = obj.getDynamicObject("formula");
                if (formulaObj != null) {
                    CalRuleHelper.openFormulaSettingPage((IFormView)this.getView(), (Long)formulaObj.getLong("id"), (String)formulaObj.getString("name"));
                }
                args.getOperationResult().setSuccess(false);
                args.getOperationResult().setShowMessage(false);
                args.getOperationResult().setSuccessPkIds(new ArrayList());
                break;
            }
        }
    }

    private void clearCalruleItemEntry() {
        this.getModel().deleteEntryData("calruleitementry");
        this.getView().updateView("calruleitementry");
    }

    private void validateFormulas(BeforeDoOperationEventArgs args) {
        int count = this.getModel().getEntryRowCount("calruleitementry");
        if (count == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e2a\u7a0e\u8ba1\u7b97\u516c\u5f0f\u3002", (String)"CalRuleEdit_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void afterCloseTaxcategoryF7(ClosedCallBackEvent ex) {
        Object returnData = ex.getReturnData();
        ListSelectedRowCollection returnDataCollection = null;
        if (!HRObjectUtils.isEmpty((Object)returnData)) {
            returnDataCollection = (ListSelectedRowCollection)returnData;
        }
        if (null == returnDataCollection || returnDataCollection.size() == 0) {
            return;
        }
        long taxCategoryId = (Long)returnDataCollection.get(0).getPrimaryKeyValue();
        this.getModel().setValue("taxcategory", (Object)taxCategoryId);
    }

    private void afterCloseFormulaF7(ClosedCallBackEvent closedCallBackEvent) {
        Object[] toAddFormulaIds;
        ListSelectedRowCollection returnDataCollection = null;
        if (!HRObjectUtils.isEmpty((Object)closedCallBackEvent)) {
            returnDataCollection = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        }
        if (null == returnDataCollection || returnDataCollection.size() == 0) {
            return;
        }
        IFormView view = this.getView();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObjectCollection oldEntryEntityDys = model.getEntryEntity("calruleitementry");
        if (oldEntryEntityDys.size() != 0) {
            Set oldFormulaIds = oldEntryEntityDys.stream().map(oldDy -> oldDy.getDynamicObject("formula").getLong("id")).collect(Collectors.toSet());
            toAddFormulaIds = returnDataCollection.stream().filter(listSelectedRow -> !oldFormulaIds.contains(listSelectedRow.getPrimaryKeyValue())).map(ListSelectedRow::getPrimaryKeyValue).toArray();
        } else {
            toAddFormulaIds = returnDataCollection.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
        }
        if (toAddFormulaIds.length == 0) {
            return;
        }
        List formulaDys = CalRuleHelper.getFormulaDys((Object[])toAddFormulaIds);
        if (CollectionUtils.isEmpty((Collection)formulaDys)) {
            return;
        }
        DynamicObjectCollection entryDys = this.getModel().getEntryEntity("calruleitementry");
        ArrayList<DynamicObject> unPassEntryFormulaDys = new ArrayList<DynamicObject>(formulaDys.size());
        CalRuleHelper.checkEntryFormula((List)formulaDys, unPassEntryFormulaDys, (DynamicObjectCollection)entryDys);
        ArrayList<DynamicObject> unPassFormulaDys = new ArrayList<DynamicObject>(formulaDys.size());
        CalRuleHelper.checkSameTaxItemFormula((List)formulaDys, unPassFormulaDys);
        ArrayList tempDys = new ArrayList(entryDys.size() + formulaDys.size());
        tempDys.addAll(entryDys.stream().map(entryDy -> entryDy.getDynamicObject("formula")).collect(Collectors.toList()));
        tempDys.addAll(formulaDys);
        this.getModel().deleteEntryData("calruleitementry");
        model.beginInit();
        TableValueSetter vs1 = new TableValueSetter(new String[0]);
        vs1.addField("formula", new Object[0]);
        vs1.addField("taxitem", new Object[0]);
        for (DynamicObject formulaDy : tempDys) {
            vs1.addRow(new Object[]{formulaDy.getLong("id"), formulaDy.getLong("resultitem.id")});
        }
        model.batchCreateNewEntryRow("calruleitementry", vs1);
        model.endInit();
        view.updateView("calruleitementry");
        if (!CollectionUtils.isEmpty(unPassFormulaDys) || !CollectionUtils.isEmpty(unPassEntryFormulaDys)) {
            this.showComfirmResult(formulaDys, unPassFormulaDys, unPassEntryFormulaDys);
        }
    }

    private void showComfirmResult(List<DynamicObject> formulaDys, List<DynamicObject> unPassFormulaDys, List<DynamicObject> unPassEntryFormulaDys) {
        String taxitemName;
        String number;
        int failNum = unPassFormulaDys.size() + unPassEntryFormulaDys.size();
        int successNum = formulaDys.size();
        String tip = MessageFormat.format(ResManager.loadKDString((String)"\u5171\u6dfb\u52a0{0}\u4e2a\u516c\u5f0f\uff0c{1}\u4e2a\u6dfb\u52a0\u6210\u529f\uff0c{2}\u4e2a\u6dfb\u52a0\u5931\u8d25\u3002", (String)"CalRuleEdit_7", (String)"sit-sitbs-formplugin", (Object[])new Object[0]), failNum + successNum, successNum, failNum);
        StringBuilder tipBuilder = new StringBuilder();
        if (!CollectionUtils.isEmpty(unPassFormulaDys)) {
            for (DynamicObject unPassFormulaDy : unPassFormulaDys) {
                number = unPassFormulaDy.getString("number");
                taxitemName = unPassFormulaDy.getString("resultitem.name");
                tipBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"{0}:\u4e2a\u7a0e\u9879\u76ee({1})\u6709\u591a\u4e2a\u5bf9\u5e94\u7684\u516c\u5f0f\uff0c\u65e0\u6cd5\u6dfb\u52a0\u3002", (String)"CalRuleEdit_8", (String)"sit-sitbs-formplugin", (Object[])new Object[0]), number, taxitemName));
                tipBuilder.append("\r\n");
            }
        }
        if (!CollectionUtils.isEmpty(unPassEntryFormulaDys)) {
            for (DynamicObject unPassEntryFormulaDy : unPassEntryFormulaDys) {
                number = unPassEntryFormulaDy.getString("number");
                taxitemName = unPassEntryFormulaDy.getString("resultitem.name");
                tipBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"{0}:\u4e2a\u7a0e\u9879\u76ee({1})\u5df2\u5728\u5206\u5f55\u4e2d\u5b58\u5728\u516c\u5f0f\uff0c\u65e0\u6cd5\u6dfb\u52a0\u3002", (String)"CalRuleEdit_11", (String)"sit-sitbs-formplugin", (Object[])new Object[0]), number, taxitemName));
                tipBuilder.append("\r\n");
            }
        }
        this.getView().showConfirm(tip, tipBuilder.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, null);
    }

    private void openMovePage() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] rowIndexs = proxy.getEntryState("calruleitementry").getSelectedRows();
        if (rowIndexs == null || rowIndexs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"CalRuleEdit_2", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        if (rowIndexs.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"CalRuleEdit_3", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("sitbs_calorderadjustment");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        DynamicObjectCollection dyEntryEntity = this.getModel().getEntryEntity("calruleitementry");
        int entryEntitysize = dyEntryEntity.size();
        showParameter.setCustomParam("max", (Object)String.valueOf(entryEntitysize));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "callbackmovesync");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void openFormulaF7() {
        if (YesOrNoEnum.YES.getCode().equals(this.getPageCache().get("changingBsed"))) {
            this.getPageCache().remove("changingBsed");
            return;
        }
        boolean taxCategoryIsEmpty = this.checkTaxCategory();
        if (taxCategoryIsEmpty) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e2a\u7a0e\u79cd\u7c7b\u3002", (String)"CalRuleEdit_4", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean bsedIsEmpty = this.checkBsed();
        if (bsedIsEmpty) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u751f\u6548\u65e5\u671f\u3002", (String)"CalRuleEdit_5", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject taxCategory = dataEntity.getDynamicObject("taxcategory");
        Date calRuleBsed = dataEntity.getDate("bsed");
        DynamicObject country = dataEntity.getDynamicObject("country");
        DynamicObject[] taxitems = CalRuleHelper.getTaxItemsByTaxCategoryIdAndCountry((Long)taxCategory.getLong("id"), (Long)country.getLong("id"));
        Set taxItemsIds = Arrays.stream(taxitems).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("sitbs_taxcalformula");
        listShowParameter.setFormId("hbp_hislistf7");
        OpenStyle style = new OpenStyle();
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("900px");
        cssValue.setHeight("600px");
        style.setInlineStyleCss(cssValue);
        style.setShowType(ShowType.Modal);
        listShowParameter.setOpenStyle(style);
        listShowParameter.setShowTitle(false);
        listShowParameter.setHasRight(true);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setLookUp(true);
        listShowParameter.setMultiSelect(true);
        listShowParameter.setCustomParam("isShowUsed", (Object)Boolean.TRUE);
        List<QFilter> qFilters = this.packageCommonQFilters();
        qFilters.add(new QFilter("taxcategory.id", "=", (Object)taxCategory.getLong("id")));
        qFilters.add(new QFilter("resultitem.id", "in", taxItemsIds));
        qFilters.add(new QFilter("firstbsed", "<=", (Object)calRuleBsed));
        List formulaQFilter = CalRuleHelper.getFormulaQFilter((String)this.getView().getFormShowParameter().getAppId(), (Long)this.getModel().getDataEntity().getLong("createorg.id"));
        if (CollectionUtils.isEmpty((Collection)formulaQFilter)) {
            qFilters.add(new QFilter("1", "!=", (Object)1));
        } else {
            qFilters.addAll(formulaQFilter);
        }
        listShowParameter.getListFilterParameter().setQFilters(qFilters);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addFormula"));
        listShowParameter.setCustomParam("selData", (Object)Boolean.TRUE);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private List<QFilter> packageCommonQFilters() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        qFilters.add(new QFilter("status", "=", (Object)"C"));
        return qFilters;
    }

    private boolean checkTaxCategory() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject taxCategory = dataEntity.getDynamicObject("taxcategory");
        return ObjectUtils.isEmpty((Object)taxCategory);
    }

    private boolean checkBsed() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date bsed = dataEntity.getDate("bsed");
        return ObjectUtils.isEmpty((Object)bsed);
    }

    private void setCountryAndCurrency() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String appId = HRPermUtil.getAppIdFromShowParam((FormShowParameter)formShowParameter);
        Set countryIds = SITPermissionServiceHelper.getCountrySetByPermItem((String)appId, (String)"sitbs_calrule", (String)"47150e89000000ac");
        if (!CollectionUtils.isEmpty((Collection)countryIds) && !countryIds.contains(1000001L)) {
            this.getModel().setValue("countrytype", null);
            this.getModel().setValue("country", null);
            this.getModel().setValue("currency", null);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u56fd\u5bb6/\u5730\u533a\u4e1a\u52a1\u6570\u636e\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxAppItemEdit_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
        } else {
            this.getModel().setValue("countrytype", (Object)"1");
            this.getModel().setValue("country", (Object)"1000001");
            this.getModel().setValue("currency", (Object)"1");
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"countrytype"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"country"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"currency"});
    }

    private void showTaxCategoryF7(BeforeF7SelectEvent evt) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String countryType = model.getDataEntity().getString("countrytype");
        DynamicObject country = model.getDataEntity().getDynamicObject("country");
        if (null == country && "1".equals(countryType)) {
            evt.setCancel(true);
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6307\u5b9a\u56fd\u5bb6/\u5730\u533a\u3002", (String)"CalRuleEdit_6", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        if ("0".equals(countryType)) {
            qFilter.and(new QFilter("countrytype", "=", (Object)"0"));
        }
        if (null != country && "1".equals(countryType)) {
            Long countryId = country.getLong("id");
            qFilter.and(new QFilter("country", "=", (Object)countryId));
        }
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        listShowParameter.getListFilterParameter().setFilter(qFilter);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "taxCategory"));
        TreeFilterParameter treeFilterParameter = listShowParameter.getTreeFilterParameter();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(qFilter);
        treeFilterParameter.setQFilters(qFilters);
    }

    public void setMove(Map<String, Object> returnData) {
        Object rowNumberObj = returnData.get("rownumber");
        String clickStatus = (String)returnData.get("clickStatus");
        if (!HRStringUtils.equals((String)clickStatus, (String)"ok") || rowNumberObj == null) {
            return;
        }
        int rowNumber = Integer.parseInt(rowNumberObj.toString());
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] rowIndexs = proxy.getEntryState("calruleitementry").getSelectedRows();
        DynamicObjectCollection dyEntryEntity = this.getModel().getEntryEntity("calruleitementry");
        int entryEntitysize = dyEntryEntity.size();
        if (rowNumber > entryEntitysize) {
            rowNumber = entryEntitysize;
        } else if (rowNumber < 1) {
            rowNumber = 1;
        }
        ArrayList<Integer> moveList = new ArrayList<Integer>(entryEntitysize);
        if (rowIndexs[0] == --rowNumber) {
            return;
        }
        if (rowIndexs[0] > rowNumber) {
            for (int index = rowNumber; index <= rowIndexs[0] - 1; ++index) {
                moveList.add(index);
            }
            int[] moveArray = new int[moveList.size()];
            for (int index = 0; index < moveList.size(); ++index) {
                moveArray[index] = (Integer)moveList.get(index);
            }
            this.getModel().moveEntryRowsDown("calruleitementry", moveArray);
            if (rowIndexs[0] == entryEntitysize - 1) {
                this.getView().updateView("calruleitementry");
            }
        } else if (rowIndexs[0] < rowNumber) {
            for (int index = rowIndexs[0] + 1; index <= rowNumber; ++index) {
                moveList.add(index);
            }
            int[] moveArray = new int[moveList.size()];
            for (int index = 0; index < moveList.size(); ++index) {
                moveArray[index] = (Integer)moveList.get(index);
            }
            this.getModel().moveEntryRowsUp("calruleitementry", moveArray);
            if (rowIndexs[0] == 0) {
                this.getView().updateView("calruleitementry");
            }
        }
    }

    private void comfirmChangeBsed(PropertyChangedArgs ex) {
        ChangeData[] changeSet = ex.getChangeSet();
        Date oldBsed = (Date)changeSet[0].getOldValue();
        int count = this.getModel().getEntryRowCount("calruleitementry");
        if (count != 0) {
            String msg = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u53d8\u66f4\u4f1a\u5bfc\u81f4\u5df2\u9009\u4e2a\u7a0e\u8ba1\u7b97\u516c\u5f0f\u88ab\u6e05\u7a7a\uff0c\u786e\u5b9a\u8981\u7ee7\u7eed\u5417\uff1f", (String)"CalRuleEdit_10", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("changeBsed", (IFormPlugin)this));
            if (!ObjectUtils.isEmpty((Object)oldBsed)) {
                this.getView().getPageCache().remove("oldBsed");
                this.getView().getPageCache().put("oldBsed", SerializationUtils.toJsonString((Object)oldBsed));
            }
            this.getView().getPageCache().put("changingBsed", "1");
        }
    }

    private void setTaxCategory() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String status = dataEntity.getString("status");
        DynamicObject taxcategory = dataEntity.getDynamicObject("taxcategory");
        String dataStatus = dataEntity.getString("datastatus");
        String isCurrentVersion = dataEntity.getString("iscurrentversion");
        if ("C".equals(status)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"taxcategory"});
        } else if (!ObjectUtils.isEmpty((Object)taxcategory) && "-3".equals(dataStatus) && !YesOrNoEnum.isYes((String)isCurrentVersion)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"taxcategory"});
        }
    }

    private void setFieldIfInsertHisVersion() {
        DynamicObject currentVersionDy;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String option = (String)customParams.get("option");
        Long boid = (Long)customParams.get("boid");
        if ((HRStringUtils.equals((String)option, (String)"insertdata_his") && null != boid || HRStringUtils.equals((String)option, (String)"showhisversion") && null != boid) && !ObjectUtils.isEmpty((Object)(currentVersionDy = CalRuleHelper.getCurrentVersionDy((long)boid)))) {
            this.getModel().setValue("countrytype", (Object)currentVersionDy.getString("countrytype"));
            this.getModel().setValue("country", (Object)currentVersionDy.getDynamicObject("country"));
            this.getModel().setValue("currency", (Object)currentVersionDy.getDynamicObject("currency"));
            this.getModel().setValue("taxcategory", (Object)currentVersionDy.getDynamicObject("taxcategory"));
            this.getModel().setValue("createorg", (Object)currentVersionDy.getDynamicObject("createorg"));
            this.getView().setEnable(Boolean.FALSE, new String[]{"countrytype"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"country"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"currency"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"taxcategory"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"createorg"});
        }
    }

    private void setBtnInvisiable() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter instanceof BaseShowParameter) {
            BaseShowParameter baseShowParameter = (BaseShowParameter)formShowParameter;
            BillOperationStatus billStatus = baseShowParameter.getBillStatus();
            IFormView parentView = this.getView().getParentView();
            if (Objects.nonNull(parentView) && "itc_taxtask".equals(parentView.getFormShowParameter().getFormId()) && BillOperationStatus.VIEW.equals((Object)billStatus)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_disable"});
            }
        }
    }

    private void flushEntitySort() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("calruleitementry");
        for (DynamicObject entryDy : entryEntity) {
            int seq = entryDy.getInt("seq");
            this.getModel().setValue("calindex", (Object)seq, seq - 1);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs ex) {
        this.flushEntitySort();
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs ex) {
        this.flushEntitySort();
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs ex) {
        this.flushEntitySort();
    }
}

