/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.contribution;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class ContrValueRuleEdit
extends HRDataBaseEdit {
    private static final String WP_TYPE = "wptype";
    private static final String WELPAYER = "welpayer";
    private static final String VALUE_METHOD = "valuemethod";
    private static final String FIXED_VALUE = "fixedvalue";
    private static final String ISCOVERLAP = "iscoverlap";
    private static final String GROUP = "group";
    private static final String COUNTRY = "country";

    public void propertyChanged(PropertyChangedArgs ex) {
        ChangeData[] changeData = ex.getChangeSet();
        IDataEntityProperty property = ex.getProperty();
        String controlName = property.getName();
        if (StringUtils.equals((CharSequence)controlName, (CharSequence)WP_TYPE)) {
            String newValue = (String)changeData[0].getNewValue();
            this.setControlByWPType(newValue);
        } else if (StringUtils.equals((CharSequence)controlName, (CharSequence)VALUE_METHOD)) {
            String newValue = (String)changeData[0].getNewValue();
            this.setControlByValueMethod(newValue);
        }
    }

    public void afterCreateNewData(EventObject ex) {
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject(GROUP);
        if (!Objects.isNull(dynamicObject)) {
            this.getModel().setValue(COUNTRY, (Object)dynamicObject.getDynamicObject(COUNTRY));
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{FIXED_VALUE, ISCOVERLAP, WELPAYER});
    }

    public void afterBindData(EventObject ex) {
        super.afterBindData(ex);
        String valueMethod = this.getModel().getDataEntity().getString(VALUE_METHOD);
        String wpType = this.getModel().getDataEntity().getString(WP_TYPE);
        this.setControlByValueMethod(valueMethod);
        this.setControlByWPType(wpType);
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject(GROUP);
        if (!Objects.isNull(dynamicObject)) {
            this.getModel().setValue(COUNTRY, (Object)dynamicObject.getDynamicObject(COUNTRY));
        }
    }

    private void setControlByValueMethod(String value) {
        if (Objects.isNull(value)) {
            return;
        }
        FieldEdit fixedControl = (FieldEdit)this.getView().getControl(FIXED_VALUE);
        FieldEdit coverControl = (FieldEdit)this.getView().getControl(ISCOVERLAP);
        switch (value) {
            case "A": {
                fixedControl.setMustInput(false);
                coverControl.setMustInput(false);
                this.getView().setVisible(Boolean.FALSE, new String[]{FIXED_VALUE, ISCOVERLAP});
                break;
            }
            case "C": {
                fixedControl.setMustInput(true);
                coverControl.setMustInput(true);
                this.getView().setVisible(Boolean.TRUE, new String[]{FIXED_VALUE, ISCOVERLAP});
                break;
            }
        }
    }

    private void setControlByWPType(String value) {
        if (Objects.isNull(value)) {
            return;
        }
        BasedataEdit welpayerControl = (BasedataEdit)this.getView().getControl(WELPAYER);
        switch (value) {
            case "A": {
                welpayerControl.setMustInput(false);
                this.getView().setVisible(Boolean.FALSE, new String[]{WELPAYER});
                break;
            }
            case "B": {
                welpayerControl.setMustInput(true);
                this.getView().setVisible(Boolean.TRUE, new String[]{WELPAYER});
                break;
            }
        }
    }
}

