/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.datagrade;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.tree.TreeFilterParameter;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hbp.formplugin.web.util.perm.HRPermUtil;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.field.LockableComboEdit;

public class TaxDataGradeEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private final Set<String> combos = Sets.newHashSet((Object[])new String[]{"countrytype"});

    public void initialize() {
        this.getView().addCustomControls(this.combos.toArray(new String[0]));
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        if (this.combos.contains(key)) {
            LockableComboEdit edit = new LockableComboEdit();
            edit.setKey(key);
            edit.setView(this.getView());
            args.setControl((Control)edit);
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit countryBE = (BasedataEdit)this.getControl("country");
        BasedataEdit taxCategoryBE = (BasedataEdit)this.getControl("taxcategories");
        countryBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        taxCategoryBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        BasedataEdit source = (BasedataEdit)evt.getSource();
        String flexKey = source.getKey();
        if ("taxcategories".equals(flexKey)) {
            this.showTaxCategoryF7(evt);
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.setCountry();
        this.getModel().setDataChanged(false);
        this.setParamBtn();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if ("taxcategories".equals(name)) {
            this.getModel().getDataEntity().set("datagradeparam", null);
            this.getView().updateView("datagradeparam");
        }
    }

    private void setCountry() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String appId = HRPermUtil.getAppIdFromShowParam((FormShowParameter)formShowParameter);
        Set countryIds = SITPermissionServiceHelper.getCountrySetByPermItem((String)appId, (String)"sitbs_datagrade", (String)"47150e89000000ac");
        if (!CollectionUtils.isEmpty((Collection)countryIds) && !countryIds.contains(1000001L)) {
            this.getModel().setValue("countrytype", null);
            this.getModel().setValue("country", null);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u56fd\u5bb6/\u5730\u533a\u4e1a\u52a1\u6570\u636e\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxAppItemEdit_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
        } else {
            this.getModel().setValue("countrytype", (Object)"1");
            this.getModel().setValue("country", (Object)1000001L);
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"countrytype", "country"});
    }

    private void showTaxCategoryF7(BeforeF7SelectEvent evt) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String countryType = model.getDataEntity().getString("countrytype");
        DynamicObject country = model.getDataEntity().getDynamicObject("country");
        if (null == country && "1".equals(countryType)) {
            evt.setCancel(true);
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6307\u5b9a\u56fd\u5bb6/\u5730\u533a\u3002", (String)"CalRuleEdit_6", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        if ("0".equals(countryType)) {
            qFilter.and(new QFilter("countrytype", "=", (Object)"0"));
        }
        if (null != country && "1".equals(countryType)) {
            Long countryId = country.getLong("id");
            qFilter.and(new QFilter("country", "=", (Object)countryId));
        }
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        listShowParameter.getListFilterParameter().setFilter(qFilter);
        TreeFilterParameter treeFilterParameter = listShowParameter.getTreeFilterParameter();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(qFilter);
        treeFilterParameter.setQFilters(qFilters);
    }

    private void setParamBtn() {
        if (TaxDataGradeEdit.isHisPage(this.getView())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"configurationbtn"});
        }
    }

    public static boolean isHisPage(IFormView view) {
        Map params = view.getFormShowParameter().getCustomParams();
        Object fromPage = params.get("fromPage");
        if (fromPage != null) {
            return "fromHisAction".equals(fromPage);
        }
        return false;
    }
}

