/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.formula;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.formula.entity.item.DataGradeItem;
import kd.hr.hbp.business.service.formula.entity.item.ResultItem;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.business.service.formula.utils.FormulaTreeNodeUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.formula.FormulaSettingEdit;
import kd.hr.hbp.formplugin.web.util.perm.HRPermUtil;
import kd.sit.sitbp.business.api.FormulaNodeItemBuilder;
import kd.sit.sitbp.business.formula.builder.BaseFormulaNodeItemBuilder;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.api.TaxCalItemUniCodeResolver;
import kd.sit.sitbp.common.api.TaxItemService;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.enums.CalDataTypeEnum;
import kd.sit.sitbp.common.enums.CalTaxTypeEnum;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.util.BizServiceFactory;
import kd.sit.sitbs.business.multiview.GetAppInfoService;

public class TaxCalFormulaEdit
extends FormulaSettingEdit
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(TaxCalFormulaEdit.class);
    public static final String DATA_GRADE_META = "sitbs_datagrade";
    public static final String RESULT_ITEM = "resultitem";
    public static final String TAX_CATEGORY = "taxcategory";
    public static final String COUNTRY_ID = "country.id";
    public static final String COUNTRY = "country";
    public static final String TAXCATEGORY_ID = "taxcategory.id";
    public static final String BAR_DISABLE = "bar_disable";
    private final TaxItemService taxItemService = (TaxItemService)BizServiceFactory.lookup((String)"TaxItemService");

    public void registerListener(EventObject ex) {
        super.registerListener(ex);
        BasedataEdit resultItem = (BasedataEdit)this.getControl(RESULT_ITEM);
        resultItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxCategory = (BasedataEdit)this.getControl(TAX_CATEGORY);
        taxCategory.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject ex) {
        super.afterCreateNewData(ex);
        this.setCountryEnable();
    }

    public void beforeBindData(EventObject ex) {
        super.beforeBindData(ex);
        this.setCountryEnable();
    }

    public void afterBindData(EventObject ex) {
        String status;
        super.afterBindData(ex);
        switch (status = this.getModel().getDataEntity().getString("status")) {
            case "A": 
            case "B": {
                this.getView().setEnable(Boolean.TRUE, new String[]{BAR_DISABLE});
                break;
            }
        }
    }

    public void setCountryEnable() {
        IFormView view = this.getView();
        OperationStatus viewStatus = view.getFormShowParameter().getStatus();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String option = (String)customParams.get("option");
        Long boid = (Long)customParams.get("boid");
        if (option != null && null != boid && (option.equals("insertdata_his") || option.equals("showhisversion"))) {
            DynamicObject dy = this.getCurrentVersionDy(boid);
            view.getModel().setValue("name", (Object)dy.getString("name"));
            view.getModel().setValue(TAX_CATEGORY, (Object)dy.getLong(TAXCATEGORY_ID));
            view.getModel().setValue(RESULT_ITEM, (Object)dy.getLong("resultitem.id"));
            view.setEnable(Boolean.FALSE, new String[]{TAX_CATEGORY, RESULT_ITEM});
        }
        if (viewStatus.equals((Object)OperationStatus.ADDNEW)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String appId = HRPermUtil.getAppIdFromShowParam((FormShowParameter)formShowParameter);
            Set countryIds = SITPermissionServiceHelper.getCountrySetByPermItem((String)appId, (String)"sitbs_taxcalformula", (String)"47150e89000000ac");
            if (!CollectionUtils.isEmpty((Collection)countryIds) && !countryIds.contains(1000001L)) {
                this.getModel().setValue(COUNTRY, null);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u56fd\u5bb6/\u5730\u533a\u4e1a\u52a1\u6570\u636e\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxAppItemEdit_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            } else {
                view.getModel().setValue(COUNTRY, (Object)1000001L);
            }
            view.setEnable(Boolean.FALSE, new String[]{COUNTRY});
        }
    }

    protected Optional<List<TreeNodeItem>> getDataGradeItemList() {
        return Optional.of(this.getDataGrade());
    }

    protected Optional<List<TreeNodeItem>> getTreeNodeItemList() {
        LinkedList<TreeNodeItem> treeNodeItems = new LinkedList<TreeNodeItem>();
        if (!this.getModel().isDataLoaded()) {
            return Optional.of(treeNodeItems);
        }
        treeNodeItems.addAll(this.getAllTreeNodeList());
        FormulaTreeNodeUtils.loadTreeNodeItemList(treeNodeItems).ifPresent(treeNodes -> {
            TreeView treeView = (TreeView)this.getView().getControl("itemtreeview");
            treeView.deleteAllNodes();
            treeView.addNodes(treeNodes);
        });
        return Optional.of(treeNodeItems);
    }

    private List<TreeNodeItem> getAllTreeNodeList() {
        LinkedList<TreeNodeItem> treeNodeItems = new LinkedList<TreeNodeItem>();
        long country = this.getModel().getDataEntity().getLong(COUNTRY_ID);
        if (country == 0L) {
            return treeNodeItems;
        }
        long category = this.getModel().getDataEntity().getLong(TAXCATEGORY_ID);
        DynamicObject dy = GetAppInfoService.getInstance().queryAppInfoByCountryId(Long.valueOf(country));
        if (dy == null || StringUtils.isEmpty((CharSequence)dy.getString("app.number"))) {
            return treeNodeItems;
        }
        String appId = dy.getString("app.number");
        HashMap<String, QFilter> cond = new HashMap<String, QFilter>(0);
        ArrayList copyBuilders = Lists.newArrayList(BaseFormulaNodeItemBuilder.getInstances().values());
        long createorgId = this.getModel().getDataEntity().getLong("createorg.id");
        QFilter qFilter = SITPermissionServiceHelper.getBaseDataFilter((String)"sitbs_taxitem", (Long)createorgId);
        cond.put("itemQfilter", qFilter);
        copyBuilders.sort(Comparator.comparingInt(os -> os.seq(Long.valueOf(country), appId, Long.valueOf(category), cond)));
        for (FormulaNodeItemBuilder builder : copyBuilders) {
            List treeNodeItem;
            if (!builder.match(Long.valueOf(country), appId, Long.valueOf(category), cond) || CollectionUtils.isEmpty((Collection)(treeNodeItem = builder.rootWithAllNode(Long.valueOf(country), appId, Long.valueOf(category), cond)))) continue;
            treeNodeItems.addAll(treeNodeItem);
        }
        return treeNodeItems;
    }

    private List<TreeNodeItem> getDataGrade() {
        ArrayList<TreeNodeItem> resultList = new ArrayList<TreeNodeItem>(16);
        long countryId = this.getModel().getDataEntity().getLong(COUNTRY_ID);
        long taxCategoryId = this.getModel().getDataEntity().getLong(TAXCATEGORY_ID);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(DATA_GRADE_META);
        QFilter filter = new QFilter(COUNTRY_ID, "=", (Object)countryId);
        filter.and("taxcategories.fbasedataid_id", "=", (Object)taxCategoryId);
        filter.and("uniquecode", "!=", (Object)"0");
        Object[] objs = serviceHelper.query("id,boid,number,name,description,datagradeparam,uniquecode,status,enable,iscurrentversion,datastatus,uniquecode", new QFilter[]{filter}, "");
        if (ArrayUtils.isEmpty((Object[])objs)) {
            logger.info("getDataGrade size is 0");
            return resultList;
        }
        Map<Long, DynamicObject> idToObjMap = Arrays.stream(objs).collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj, (k1, k2) -> k1));
        for (Object obj2 : objs) {
            resultList.add((TreeNodeItem)DataGradeItem.getDataGradeItem((DynamicObject)obj2));
        }
        for (TreeNodeItem item : resultList) {
            Object obj2;
            String idStr = item.getId();
            obj2 = idToObjMap.get(Long.valueOf(idStr));
            if ("C".equals(obj2.getString("status")) && "1".equals(obj2.getString("enable")) && "1".equals(obj2.getString("datastatus")) && !YesOrNoEnum.NO.getCode().equals(obj2.getString("iscurrentversion"))) continue;
            item.setShow(false);
        }
        logger.info("getDataGrade size is{}:", (Object)resultList.size());
        return resultList;
    }

    public void propertyChanged(PropertyChangedArgs ex) {
        String name;
        IDataEntityProperty property = ex.getProperty();
        switch (name = property.getName()) {
            case "country": {
                this.countryChanged();
                break;
            }
            case "taxcategory": {
                this.taxCategoryChanged();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        switch (fieldKey) {
            case "taxcategory": {
                long countryId = this.getModel().getDataEntity().getLong(COUNTRY_ID);
                if (countryId == 0L) {
                    beforeF7SelectEvent.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u56fd\u9645\u5730\u533a\u3002", (String)"TaxCalFormulaEdit_7", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                showParameter.getListFilterParameter().setFilter(new QFilter(COUNTRY_ID, "=", (Object)countryId));
                break;
            }
            case "resultitem": {
                long taxCategoryId = this.getModel().getDataEntity().getLong(TAXCATEGORY_ID);
                long createorgId = this.getModel().getDataEntity().getLong("createorg.id");
                if (taxCategoryId == 0L) {
                    beforeF7SelectEvent.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u4e2a\u7a0e\u79cd\u7c7b\u3002", (String)"TaxCalFormulaEdit_20", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                beforeF7SelectEvent.setCancel(true);
                ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)"sitbs_taxitem", (boolean)false);
                showListForm.setCaption(ResManager.loadKDString((String)"\u4e2a\u7a0e\u9879\u76ee", (String)"TaxCalFormulaEdit_10", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
                QFilter filter = new QFilter("taxcategories.fbasedataid_id", "=", (Object)taxCategoryId);
                filter.and("enable", "=", (Object)"1");
                filter.and("caltaxtype.id", "=", (Object)CalTaxTypeEnum.RETURN.getId());
                filter.and("status", "=", (Object)"C");
                QFilter qFilter = SITPermissionServiceHelper.getBaseDataFilter((String)"sitbs_taxitem", (Long)createorgId);
                filter.and(qFilter);
                showListForm.getListFilterParameter().setFilter(filter);
                showListForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, RESULT_ITEM));
                this.getView().showForm((FormShowParameter)showListForm);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (RESULT_ITEM.equals(actionId)) {
            ListSelectedRowCollection returnDataCollection = null;
            if (!HRObjectUtils.isEmpty((Object)closedCallBackEvent)) {
                returnDataCollection = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            }
            if (null == returnDataCollection || returnDataCollection.size() == 0) {
                return;
            }
            this.getModel().setValue(RESULT_ITEM, returnDataCollection.get(0).getPrimaryKeyValue());
        }
    }

    private void countryChanged() {
        this.getModel().setValue(TAX_CATEGORY, null);
        this.getModel().setValue(RESULT_ITEM, null);
        this.refleshTree();
        this.clearFormula();
    }

    private void taxCategoryChanged() {
        this.getModel().setValue(RESULT_ITEM, null);
        this.refleshTree();
        String formula = (String)this.getModel().getValue("originalexp");
        if (StringUtils.isNotBlank((CharSequence)formula)) {
            String message = ResManager.loadKDString((String)"\u662f\u5426\u6e05\u7a7a\u516c\u5f0f\u7f16\u8f91\u5668\u7684\u5185\u5bb9\uff1f", (String)"TaxCalFormulaEdit_9", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(message, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("isClearFormula", ""));
        }
        Optional<List<ResultItem>> resultItemList = this.getResultItemList();
        this.initResultItemCache(resultItemList.orElseGet(() -> new ArrayList(0)), true);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (event.getResult() == MessageBoxResult.Yes) {
            switch (event.getCallBackId()) {
                case "isClearFormula": {
                    this.clearFormula();
                    break;
                }
            }
        }
    }

    private void refleshTree() {
        this.initItemTree(this.getAllTreeNodeList(), true);
        this.initDataGradeTree(this.getDataGrade(), true);
    }

    private void clearFormula() {
        CustomControl formulaEditor = (CustomControl)this.getView().getControl("formulaeditor");
        HashMap<String, String> data = new HashMap<String, String>(8);
        data.put("method", "setValue");
        data.put("value", "");
        data.put("date", String.valueOf(new Date().getTime()));
        formulaEditor.setData(data);
    }

    protected void initItemTree(List<TreeNodeItem> treeNodeCacheList, boolean isUpdateCache) {
        super.initItemTree(treeNodeCacheList, isUpdateCache);
    }

    protected void initDataGradeTree(List<TreeNodeItem> treeNodeCacheList, boolean isUpdateCache) {
        super.initDataGradeTree(treeNodeCacheList, isUpdateCache);
    }

    protected Optional<List<ResultItem>> getResultItemList() {
        if (!this.getModel().isDataLoaded()) {
            return Optional.empty();
        }
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>(10);
        long countryId = this.getModel().getDataEntity().getLong(COUNTRY_ID);
        long taxCategoryId = this.getModel().getDataEntity().getLong(TAXCATEGORY_ID);
        if (countryId != 0L && taxCategoryId != 0L) {
            Map taxItems = this.taxItemService.loadTaxItems(countryId, taxCategoryId, 0L, true, new QFilter[0]);
            for (Map.Entry entry : taxItems.entrySet()) {
                TaxItemEntity item = (TaxItemEntity)entry.getValue();
                ResultItem resultItem = new ResultItem();
                String id = item.getId() + "";
                String uniCode = TaxCalItemUniCodeResolver.getResolverBy((String)"TI").uniCode(id);
                resultItem.setId(id);
                resultItem.setUniqueCode(uniCode);
                resultItem.setParentId("TI");
                resultItem.setItemCategory("TI");
                resultItem.setName(LocaleString.fromMap((Map)item.getName()).getLocaleValue());
                resultItem.setDataType(CalDataTypeEnum.getEnumById((long)item.getDatatypeId()));
                resultItem.setCustomItem(false);
                resultItem.setGlobalEffect(true);
                resultItem.setCalProportionItem(false);
                resultItem.setScale(Integer.valueOf(item.getDataPrecisionScale()));
                int dataLength = item.getDataLength();
                if (0 == dataLength) {
                    SitDataTypeEnum enumById = SitDataTypeEnum.getEnumById((long)item.getDatatypeId());
                    resultItem.setDataLength(Integer.valueOf(enumById.getDefLen()));
                } else {
                    resultItem.setDataLength(Integer.valueOf(dataLength));
                }
                resultItems.add(resultItem);
            }
        }
        return Optional.of(resultItems);
    }

    private DynamicObject getCurrentVersionDy(long boid) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxcalformula");
        QFilter qFilter = new QFilter("boid", "=", (Object)boid);
        qFilter.and("iscurrentversion", "=", (Object)YesOrNoEnum.YES.getCode());
        return helper.queryOne("id,name,taxcategory,resultitem", qFilter);
    }

    protected TreeNodeItem getDataGradeRootItem() {
        TreeNodeItem rootItem = new TreeNodeItem("DG", "DG", "", ResManager.loadKDString((String)"\u4e2a\u7a0e\u7a0e\u7387\u8868", (String)"TaxCalFormulaEdit_11", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
        rootItem.setExpand(true);
        return rootItem;
    }
}

