/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.multiview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.sit.sitbs.business.multiview.AppAndCountryRefEnum;
import kd.sit.sitbs.business.multiview.AppCountryCacheService;

public class AppCountryRelListPlugin
extends HRDataBaseList {
    public void registerListener(EventObject ex) {
        super.registerListener(ex);
        this.addItemClickListeners(new String[]{"toolbar"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "clearcache": {
                this.clearCache();
                break;
            }
        }
    }

    private void clearCache() {
        AppCountryCacheService.getInstance().clearCache(this.getBillFormId());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String billFormId;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("disable".equals(operateKey) && (billFormId = this.getBillFormId()) != null) {
            Object[] primaryKeyValues = ((FormOperate)afterDoOperationEventArgs.getSource()).getListSelectedData().getPrimaryKeyValues();
            HRBaseServiceHelper helper = new HRBaseServiceHelper(billFormId);
            DynamicObject[] dys = helper.query("id,app.number", new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
            ArrayList<String> appIds = new ArrayList<String>(dys.length);
            for (DynamicObject dy : dys) {
                String appId = dy.getString("app.number");
                appIds.add(appId);
            }
            AppCountryCacheService.getInstance().updateAppCountryMap(appIds, billFormId);
            this.getView().invokeOperation("refresh");
        }
    }

    private String getBillFormId() {
        String billFormId = ((ListView)this.getView()).getBillFormId();
        Set billFormScopeList = Arrays.stream(AppAndCountryRefEnum.values()).map(AppAndCountryRefEnum::getAppCountryRelEntityName).collect(Collectors.toSet());
        return billFormScopeList.contains(billFormId) ? billFormId : null;
    }
}

