/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.multiview;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class BelongCountryEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final String KEY_COUNTRY = "country";

    public void registerListener(EventObject ex) {
        super.registerListener(ex);
        BasedataEdit country = (BasedataEdit)this.getControl(KEY_COUNTRY);
        country.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        BasedataEdit basedataEdit = (BasedataEdit)evt.getSource();
        String key = basedataEdit.getKey();
        if (KEY_COUNTRY.equals(key)) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_belongcountry");
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            QFilter auditFilter = new QFilter("status", "=", (Object)"C");
            QFilter businessTypeFilter = new QFilter("businesstype", "=", this.getModel().getValue("businesstype"));
            DynamicObject[] countries = helper.query(KEY_COUNTRY, new QFilter[]{enableFilter, auditFilter, businessTypeFilter});
            ArrayList<Long> ids = new ArrayList<Long>(countries.length);
            for (DynamicObject country : countries) {
                long id = country.getLong("country.id");
                ids.add(id);
            }
            QFilter countryFilter = new QFilter("id", "not in", ids);
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.getListFilterParameter().setFilter(countryFilter);
        }
    }
}

