/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.multiview;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sit.sitbp.business.multiview.CombinePageCfgCacheService;
import kd.sit.sitbp.business.multiview.CombinePageCfgHelper;

public class CombinePageCfgEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    public void registerListener(EventObject ex) {
        super.registerListener(ex);
        this.addItemClickListeners(new String[]{"maintoolbar"});
        this.addItemClickListeners(new String[]{"tabtoolbar"});
        this.addItemClickListeners(new String[]{"sidertoolbar"});
        BasedataEdit belongCountriesBE = (BasedataEdit)this.getControl("belongcountry");
        BasedataEdit topPageBE = (BasedataEdit)this.getControl("toppage");
        BasedataEdit pageFrameRegBE = (BasedataEdit)this.getControl("pageframereg");
        belongCountriesBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        topPageBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        pageFrameRegBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "mainnew": {
                this.showPageReg("2");
                break;
            }
            case "tabnew": {
                this.showPageReg("3");
                break;
            }
            case "sidernew": {
                this.showPageReg("4");
                break;
            }
            case "preview": {
                this.showPreview();
                break;
            }
        }
    }

    public void afterBindData(EventObject ex) {
        super.afterBindData(ex);
        this.hideBtn();
        this.setSiderPagePanelVisible();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        BasedataEdit basedataEdit = (BasedataEdit)evt.getSource();
        switch (key = basedataEdit.getKey()) {
            case "toppage": {
                this.showPageRegForTopPage(evt);
                break;
            }
        }
    }

    private void showPageRegForTopPage(BeforeF7SelectEvent evt) {
        DynamicObject belongCountry = this.getModel().getDataEntity().getDynamicObject("belongcountry");
        if (null == belongCountry) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u56fd\u5bb6/\u5730\u533a\u5f52\u5c5e\u3002", (String)"CombinePageCfgEdit_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        long belongCountryId = belongCountry.getLong("id");
        QFilter qFilter = new QFilter("belongcountry", "=", (Object)belongCountryId);
        qFilter.and(new QFilter("area", "=", (Object)"1"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        String caption = ResManager.loadKDString((String)"\u6863\u6848\u5934\u90e8\u5361\u7247\u5217\u8868", (String)"CombinePageCfgEdit_1", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        listShowParameter.getListFilterParameter().setFilter(qFilter);
        listShowParameter.setCaption(caption);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("sitbs_pagereg".equals(actionId)) {
            this.afterClosePageReg(closedCallBackEvent);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": {
                this.checkDataAndSave(args);
                break;
            }
            case "enable": 
            case "audit": {
                this.checkAlreadyUsedBelongCountry(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        boolean isChanged = model.getDataChanged();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("submit".equals(operateKey) || "save".equals(operateKey) || "audit".equals(operateKey)) {
            if (afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                Long cfgId = (Long)model.getValue("id");
                CombinePageCfgCacheService.getInstance().updateCfg(cfgId);
                view.setStatus(OperationStatus.VIEW);
                this.setSiderPagePanelVisible();
            }
        } else if ("tabdel".equals(operateKey)) {
            this.setSiderPagePanelVisible();
        } else if (("disable".equals(operateKey) || "unaudit".equals(operateKey) || "unsubmit".equals(operateKey)) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            Long cfgId = (Long)model.getValue("id");
            CombinePageCfgCacheService.getInstance().updateCfg(cfgId);
        }
        this.hideBtn();
        if (!isChanged) {
            this.getView().getModel().setDataChanged(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs ex) {
        String fieldKey;
        switch (fieldKey = ex.getProperty().getName()) {
            case "belongcountry": {
                ChangeData[] changeData = ex.getChangeSet();
                this.deleteTopAndEntryData(changeData);
                break;
            }
        }
    }

    private void deleteTopAndEntryData(ChangeData[] changeData) {
        ChangeData data = changeData[0];
        DynamicObject oldObjs = (DynamicObject)data.getOldValue();
        if (null != oldObjs) {
            long oldBelongCountryId = oldObjs.getLong("id");
            this.deleteData(oldBelongCountryId);
        }
    }

    private void deleteData(Long oldBelongCountryId) {
        this.checkAndDelTopData(oldBelongCountryId);
        this.checkAndDelEntryData("main", oldBelongCountryId);
        this.checkAndDelEntryData("tab", oldBelongCountryId);
        this.checkAndDelEntryData("sider", oldBelongCountryId);
    }

    private void checkAndDelTopData(Long oldBelongCountryId) {
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("toppage");
        if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
            return;
        }
        long topPageId = dynamicObject.getLong("belongcountry.id");
        if (oldBelongCountryId.equals(topPageId)) {
            this.getModel().setValue("toppage", null);
        }
    }

    private void checkAndDelEntryData(String entryKey, Long oldBelongCountryId) {
        ArrayList<Integer> delIndexs = new ArrayList<Integer>(16);
        int entryRowCount = this.getModel().getEntryRowCount(entryKey + "entry");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(entryKey + "entry", i);
            Long rowbelongCountryId = dynamicObject.getDynamicObject(entryKey + "pagereg").getLong("belongcountry.id");
            if (!oldBelongCountryId.equals(rowbelongCountryId)) continue;
            delIndexs.add(i);
        }
        this.getModel().deleteEntryRows(entryKey + "entry", delIndexs.stream().mapToInt(Integer::valueOf).toArray());
    }

    private void setSiderPagePanelVisible() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObjectCollection tabEntity = model.getEntryEntity("tabentry");
        if (!HRObjectUtils.isEmpty((Object)tabEntity) && tabEntity.size() != 0) {
            view.setVisible(Boolean.TRUE, new String[]{"siderpagepanel"});
        } else {
            this.getModel().deleteEntryData("siderentry");
            view.setVisible(Boolean.FALSE, new String[]{"siderpagepanel"});
        }
    }

    private void checkDataAndSave(BeforeDoOperationEventArgs args) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObjectCollection mainEntryEntity = model.getEntryEntity("mainentry");
        if (mainEntryEntity.size() == 0) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u4e3b\u9875\u5361\u7247\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CombinePageCfgEdit_5", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void checkAlreadyUsedBelongCountry(BeforeDoOperationEventArgs args) {
        Set usedBelongCountryIds = CombinePageCfgHelper.getAlreadyUsedBelongCountries();
        long belongCountryId = this.getModel().getDataEntity().getDynamicObject("belongcountry").getLong("id");
        String status = (String)this.getModel().getValue("status");
        String enable = (String)this.getModel().getValue("enable");
        if (("C".equals(status) && "0".equals(enable) || "B".equals(status) && "1".equals(enable)) && usedBelongCountryIds.size() > 0 && usedBelongCountryIds.contains(belongCountryId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u5ba1\u6838\uff0c\u5df2\u542f\u7528\u4e14\u56fd\u5bb6/\u5730\u533a\u5f52\u5c5e\u76f8\u540c\u7684\u591a\u89c6\u56fe\u65b9\u6848\u3002", (String)"CombinePageCfgEdit_6", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void afterClosePageReg(ClosedCallBackEvent closedCallBackEvent) {
        Object[] queryPageRegIds;
        ListSelectedRowCollection returnDataCollection = null;
        if (!HRObjectUtils.isEmpty((Object)closedCallBackEvent)) {
            returnDataCollection = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        }
        if (null == returnDataCollection || returnDataCollection.size() == 0) {
            return;
        }
        IFormView view = this.getView();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        HRPageCache pageCache = new HRPageCache(view);
        String operateEntry = (String)pageCache.get("entryentity", String.class);
        if (HRStringUtils.isEmpty((String)operateEntry)) {
            return;
        }
        String entryFlag = operateEntry.substring(0, operateEntry.lastIndexOf("entry"));
        DynamicObjectCollection oldEntryEntityDys = model.getEntryEntity(operateEntry);
        if (oldEntryEntityDys.size() != 0) {
            Set oldPageRegIds = oldEntryEntityDys.stream().map(oldDy -> oldDy.getDynamicObject(entryFlag + "pagereg").getString("number")).collect(Collectors.toSet());
            queryPageRegIds = returnDataCollection.stream().filter(listSelectedRow -> !oldPageRegIds.contains(listSelectedRow.getNumber())).map(ListSelectedRow::getPrimaryKeyValue).toArray();
        } else {
            queryPageRegIds = returnDataCollection.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
        }
        if (queryPageRegIds.length == 0) {
            return;
        }
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(entryFlag + "pagereg", new Object[0]);
        for (Object queryPageRegId : queryPageRegIds) {
            vs.addRow(new Object[]{(Long)queryPageRegId});
        }
        model.batchCreateNewEntryRow(operateEntry, vs);
        model.endInit();
        pageCache.remove("entryentity");
        view.updateView(operateEntry);
        this.setSiderPagePanelVisible();
    }

    private void hideBtn() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String status = (String)model.getValue("status");
        if ("A".equals(status)) {
            view.setVisible(Boolean.TRUE, new String[]{"bar_modify", "bar_submit"});
            view.setVisible(Boolean.FALSE, new String[]{"bar_audit", "bar_disable"});
        } else if ("B".equals(status)) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_modify", "bar_submit"});
            view.setVisible(Boolean.TRUE, new String[]{"bar_audit", "bar_disable"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"bar_modify", "bar_submit", "bar_audit", "bar_disable"});
        }
    }

    private void showPreview() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Long cfgId = model.getDataEntity().getLong("id");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("sitbs_pagepreview");
        formShowParameter.setCustomParam("id", (Object)cfgId);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm(formShowParameter);
    }

    private void showPageReg(String areaValue) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject belongCountry = model.getDataEntity().getDynamicObject("belongcountry");
        if (null == belongCountry) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u56fd\u5bb6/\u5730\u533a\u5f52\u5c5e\u3002", (String)"CombinePageCfgEdit_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        long belongCountryId = belongCountry.getLong("id");
        QFilter qFilter = new QFilter("belongcountry", "=", (Object)belongCountryId);
        qFilter.and(new QFilter("area", "=", (Object)areaValue));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        String caption = null;
        String entryEntityKey = null;
        String pageRegKey = null;
        HRPageCache pageCache = new HRPageCache(view);
        boolean isMultiSelect = true;
        switch (areaValue) {
            case "2": {
                caption = ResManager.loadKDString((String)"\u4e3b\u9875\u5361\u7247\u5217\u8868", (String)"CombinePageCfgEdit_2", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
                entryEntityKey = "mainentry";
                pageRegKey = "mainpagereg.id";
                break;
            }
            case "3": {
                caption = ResManager.loadKDString((String)"\u4fa7\u8fb9\u680f\u9875\u7b7e\u5217\u8868", (String)"CombinePageCfgEdit_3", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
                entryEntityKey = "tabentry";
                pageRegKey = "tabpagereg.id";
                break;
            }
            case "4": {
                caption = ResManager.loadKDString((String)"\u4fa7\u8fb9\u680f\u5361\u7247\u5217\u8868", (String)"CombinePageCfgEdit_4", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
                entryEntityKey = "siderentry";
                pageRegKey = "siderpagereg.id";
                break;
            }
        }
        pageCache.put("entryentity", entryEntityKey);
        ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)"sitbs_pagereg", (boolean)isMultiSelect);
        if ("2".equals(areaValue) || "3".equals(areaValue) || "4".equals(areaValue)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryEntityKey);
            ArrayList<Long> pageRegIds = new ArrayList<Long>(entryEntity.size());
            for (DynamicObject dynamicObject : entryEntity) {
                Long pageRegId = dynamicObject.getLong(pageRegKey);
                pageRegIds.add(pageRegId);
            }
            qFilter.and(new QFilter("id", "not in", pageRegIds));
        }
        showListForm.getListFilterParameter().setFilter(qFilter);
        showListForm.setCaption(caption);
        showListForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "sitbs_pagereg"));
        view.showForm((FormShowParameter)showListForm);
    }
}

