/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.multiview;

import java.text.MessageFormat;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.ListRowClickEvent;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.sit.sitbp.business.multiview.CombinePageCfgCacheService;
import kd.sit.sitbp.business.multiview.CombinePageCfgHelper;

public class CombinePageCfgListPlugin
extends HRDataBaseList {
    public void registerListener(EventObject ex) {
        super.registerListener(ex);
        this.addItemClickListeners(new String[]{"toolbar"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "preview": {
                this.showPreview();
                break;
            }
            case "clearcache": {
                this.clearCache();
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        Long pkId = (Long)((BillList)args.getHyperLinkClickEvent().getSource()).getFocusRowPkId();
        this.openConfigPage(pkId);
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
        ListSelectedRow currentListSelectedRow = evt.getCurrentListSelectedRow();
        Long pkId = (Long)currentListSelectedRow.getPrimaryKeyValue();
        this.openConfigPage(pkId);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        if (("audit".equals(opKey) || "enable".equals(opKey)) && this.hasSameBelongCountry(opKey)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u4e2d\u5305\u542b\u76f8\u540c\u56fd\u5bb6/\u5730\u533a\u5f52\u5c5e\uff0c\u8bf7\u9009\u62e9\u5176\u4e2d\u4e4b\u4e00\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"CombinePageCfgListPlugin_2", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private boolean hasSameBelongCountry(String opKey) {
        List<String> selectedRowsId = this.getSelectedRowsId();
        switch (opKey) {
            case "audit": {
                return CombinePageCfgHelper.checkSameBelongCountry(selectedRowsId, (String)"audit");
            }
            case "enable": {
                return CombinePageCfgHelper.checkSameBelongCountry(selectedRowsId, (String)"enable");
            }
        }
        return false;
    }

    private List<String> getSelectedRowsId() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List<String> pKIds = selectedRows.stream().map(row -> String.valueOf(row.getPrimaryKeyValue())).collect(Collectors.toList());
        return pKIds;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (("delete".equals(operateKey) || "disable".equals(operateKey) || "unaudit".equals(operateKey)) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            Object[] primaryKeyValues = ((FormOperate)afterDoOperationEventArgs.getSource()).getListSelectedData().getPrimaryKeyValues();
            CombinePageCfgCacheService.getInstance().updateCfg(primaryKeyValues);
            this.getView().invokeOperation("refresh");
        }
    }

    private void showPreview() {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        if (selectedRows.size() == 0) {
            listView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CombinePageCfgListPlugin_4", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectedRows.size() > 1) {
            listView.showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u53d6\u4e00\u4e2a\u89c6\u56fe\u65b9\u6848\u8fdb\u884c\u9884\u89c8\u3002", (String)"CombinePageCfgListPlugin_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("sitbs_pagepreview");
        formShowParameter.setCustomParam("id", (Object)String.valueOf(selectedRows.getPrimaryKeyValues()[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listView.showForm(formShowParameter);
    }

    private void openConfigPage(Long pkId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_combinepagecfg");
        DynamicObject dy = helper.queryOne("name", (Object)pkId);
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("sitbs_combinepagecfg");
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setCaption(MessageFormat.format(ResManager.loadKDString((String)"\u591a\u89c6\u56fe\u65b9\u6848 - {0}", (String)"CombinePageCfgListPlugin_1", (String)"sit-sitbs-formplugin", (Object[])new Object[0]), dy.getString("name")));
        baseShowParameter.setPkId((Object)pkId);
        baseShowParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private void clearCache() {
        CombinePageCfgCacheService.getInstance().clearCache();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"CombinePageCfgListPlugin_3", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
    }
}

