/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.period;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sit.sitbp.business.servicehelper.SITShowFormServiceHelper;
import kd.sit.sitbp.common.enums.TaxFrequencyEnum;
import kd.sit.sitbp.common.util.SITInteDateTimeUtil;
import kd.sit.sitbs.business.taxperiod.TaxPeriodHelper;

public class TaxPeriodEdit
extends HRDataBaseEdit
implements ItemClickListener {
    private static final String BTN_CANCEL = "btncancel";
    private static final String BTN_SAVE = "btnsave";
    private static final String BTN_CLOSE = "btnclose";

    public void registerListener(EventObject ex) {
        super.registerListener(ex);
        this.addClickListeners(new String[]{"enddate"});
    }

    public void afterCreateNewData(EventObject ex) {
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        String periodPrg = pageCache.get("currentNodeId");
        if (periodPrg != null) {
            this.getModel().setValue("taxperiodprg", (Object)periodPrg.substring(0, periodPrg.length() - 2));
        }
    }

    public void afterBindData(EventObject ex) {
        super.afterBindData(ex);
        DynamicObject taxPeriod = this.getModel().getDataEntity();
        IFormView view = this.getView();
        String periodId = taxPeriod.getString("id");
        if (StringUtils.isNotBlank((CharSequence)periodId) && !StringUtils.equals((CharSequence)"0", (CharSequence)periodId)) {
            this.setRefStatus(periodId);
            this.getModel().setDataChanged(false);
        }
        if ("1".equals(taxPeriod.getString("refstatus"))) {
            view.setEnable(Boolean.FALSE, new String[]{"name", "periodrange", "perioddate", "declarerange"});
            view.setVisible(Boolean.FALSE, new String[]{BTN_CANCEL, BTN_SAVE});
            view.setVisible(Boolean.TRUE, new String[]{BTN_CLOSE});
            return;
        }
        if (OperationStatus.VIEW != this.getView().getFormShowParameter().getStatus()) {
            view.setVisible(Boolean.FALSE, new String[]{BTN_CLOSE});
        }
    }

    public void propertyChanged(PropertyChangedArgs ex) {
        IDataEntityProperty property = ex.getProperty();
        String name = property.getName();
        IDataModel model = this.getModel();
        switch (name) {
            case "enddate": {
                model.setValue("perioddate", model.getValue("enddate"));
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        long frequencyId = this.getModel().getDataEntity().getLong("taxperiodprg.calfrequency.id");
        DynamicObject frequency = new HRBaseServiceHelper("sitbs_calfrequency").loadSingle((Object)frequencyId);
        String frequencyType = frequency.getString("type");
        switch (operateKey) {
            case "save": {
                if (operate.getOption().tryGetVariableValue("operation", new RefObject())) break;
                if (!this.validatePeriodDate()) {
                    args.setCancel(true);
                    return;
                }
                String dateFailMessage = this.validateDateStandard(frequencyType);
                if (!StringUtils.isNotBlank((CharSequence)dateFailMessage)) break;
                args.setCancel(true);
                String errorMsg = this.getIntervalErrorMsg(frequencyType);
                FormShowParameter operationResultParameter = SITShowFormServiceHelper.getOperationConfirmParameter((CloseCallBack)new CloseCallBack((IFormPlugin)this, operateKey), (String)operateKey, (String)errorMsg, Collections.singletonList(dateFailMessage), (boolean)true);
                this.getView().showForm(operationResultParameter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object entrySaveReturnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("save".equals(actionId) && (entrySaveReturnData = closedCallBackEvent.getReturnData()) instanceof Boolean) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("operation", "true");
            this.getView().invokeOperation(actionId, operateOption);
        }
    }

    private boolean validatePeriodDate() {
        DynamicObject taxPeriod = this.getModel().getDataEntity();
        Date periodStartDate = taxPeriod.getDate("startdate");
        Date periodEndDate = taxPeriod.getDate("enddate");
        if (periodStartDate != null && periodEndDate != null && !periodEndDate.after(periodStartDate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u987b\u665a\u4e8e\u671f\u95f4\u5f00\u59cb\u65e5\u671f\u3002", (String)"TaxPeriodEdit_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private String validateDateStandard(String frequency) {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        String msg = "";
        Date startDate = dynamicObject.getDate("startdate");
        Date endDate = dynamicObject.getDate("enddate");
        if (startDate == null || endDate == null) {
            return null;
        }
        long interval = HRDateTimeUtils.dateDiff((String)"d", (Date)startDate, (Date)endDate);
        boolean flag = this.dateDiff(frequency, interval);
        if (flag) {
            String startDateStr = SITInteDateTimeUtil.formatDate((String)"sitbs_taxperiod", (String)"startdate", (Date)startDate);
            String endDateStr = SITInteDateTimeUtil.formatDate((String)"sitbs_taxperiod", (String)"startdate", (Date)startDate);
            msg = ResManager.loadKDString((String)"\u671f\u95f4\u5f00\u59cb\u65e5\u671f-\u671f\u95f4\u7ed3\u675f\u65e5\u671f\uff1a{0}-{1}", (String)"TaxPeriodEdit_10", (String)"sit-sitbs-formplugin", (Object[])new Object[]{startDateStr, endDateStr});
        }
        return msg;
    }

    private void setRefStatus(String periodId) {
        BasedataEntityType basedataEntityType = TaxPeriodHelper.getBaseDataEntityType((String)"sitbs_taxperiod", (String)periodId);
        Map checkResult = TaxPeriodHelper.baseDataCheckReference((BasedataEntityType)basedataEntityType, (Object[])new Object[]{periodId});
        if (checkResult.containsKey(Long.valueOf(periodId))) {
            this.getModel().setValue("refstatus", (Object)"1");
        }
    }

    private String getIntervalErrorMsg(String frequency) {
        String stanard = "";
        String frequencyName = "";
        TaxFrequencyEnum taxFrequencyEnum = TaxFrequencyEnum.valueOf((String)frequency);
        switch (taxFrequencyEnum) {
            case MONTH: {
                stanard = ResManager.loadKDString((String)"28\u81f331\u4e4b\u95f4", (String)"TaxPeriodEdit_3", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
                frequencyName = ResManager.loadKDString((String)"\u6708", (String)"TaxPeriodEdit_4", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        return MessageFormat.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5b58\u5728\u4e0d\u7b26\u5408\u89c4\u8303\u7684\u6570\u636e\uff0c\u786e\u8ba4\u7ee7\u7eed\u4fdd\u5b58\uff1f\uff08\u9891\u5ea6\u7c7b\u578b\u4e3a\u201c{0}\u201d\u7684\u671f\u95f4\uff0c\u8d77\u6b62\u65e5\u671f\u7684\u95f4\u9694\u5e94\u5728{1}\uff09", (String)"TaxPeriodEdit_5", (String)"sit-sitbs-formplugin", (Object[])new Object[0]), frequencyName, stanard);
    }

    private boolean dateDiff(String frequency, long interval) {
        TaxFrequencyEnum taxFrequencyEnum = TaxFrequencyEnum.valueOf((String)frequency);
        switch (taxFrequencyEnum) {
            case MONTH: {
                return interval < 27L || interval > 30L;
            }
            default: {
                return false;
            }
        }
    }
}

