/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.period;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import kd.sit.sitbs.business.taxperiod.TaxPeriodHelper;

public class TaxPeriodGeneratePlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(TaxPeriodGeneratePlugin.class);
    private static Date newPeriodStartDate;

    public void afterCreateNewData(EventObject ev) {
        Long periodPrgId = (Long)BaseDataConverter.convert((Object)this.getFormShowParameter().getCustomParam("periodPrgId"), Long.class);
        DynamicObject dynamicObject = new HRBaseServiceHelper("sitbs_taxperiodprg").loadSingle((Object)periodPrgId);
        this.getModel().setValue("taxperiodprg", (Object)dynamicObject);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("batchgenerate".equals(operateKey)) {
            if (this.checkField() || this.validateDate()) {
                args.setCancel(true);
                return;
            }
            List<DynamicObject> taxPeriods = this.batchGenerateTaxPeriod();
            OperateOption option = OperateOption.create();
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"sitbs_taxperiod", (DynamicObject[])taxPeriods.toArray(new DynamicObject[0]), (OperateOption)option);
            int failCount = operationResult.getValidateResult().getErrorDataIndexs().size();
            int successCount = taxPeriods.size() - failCount;
            List messages = operationResult.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getMessage).collect(Collectors.toList());
            FormShowParameter formShowParameter = TaxPeriodHelper.getBatchGenerateResultForm(null, (int)taxPeriods.size(), (int)successCount, (int)failCount, (Date)newPeriodStartDate, (boolean)operationResult.isSuccess(), messages);
            this.getView().getParentView().showForm(formShowParameter);
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        }
    }

    private boolean checkField() {
        int rowCount = this.getModel().getDataEntity().getInt("rowcount");
        if (rowCount < 0 || rowCount > 24) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5165\u5927\u4e8e0\u4e14\u5c0f\u4e8e\u7b49\u4e8e24\u7684\u6574\u6570\u3002", (String)"TaxPeriodGeneratePlugin_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean validateDate() {
        int declareEndDay;
        if (!this.isNeedDeclareField()) {
            return false;
        }
        boolean flag = false;
        int declareStartDay = this.getDynamicObject().getInt("declarestartday");
        if (declareStartDay > (declareEndDay = this.getDynamicObject().getInt("declareendday"))) {
            this.showErrorNotification(ResManager.loadKDString((String)"\u7533\u62a5\u7ed3\u675f\u65e5\u987b\u665a\u4e8e\u6216\u7b49\u4e8e\u7533\u62a5\u5f00\u59cb\u65e5\u3002", (String)"TaxPeriodGeneratePlugin_1", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return true;
        }
        Date startMonthDateFlag = this.getDynamicObject().getDate("startdate");
        DynamicObject taxPeriodPrg = this.getDynamicObject().getDynamicObject("taxperiodprg");
        int startDay = taxPeriodPrg.getInt("startday");
        int endDay = taxPeriodPrg.getInt("endday");
        Date startDate = TaxPeriodHelper.getRightDate((Date)startMonthDateFlag, (int)startDay);
        Date endDate = TaxPeriodHelper.getEndDate((int)startDay, (int)endDay, (Date)startMonthDateFlag);
        String periodDateUseField = this.getDynamicObject().getString("perioddate");
        Date declareMonthDate = TaxPeriodHelper.getDeclareMonthDate((String)periodDateUseField, (Date)startDate, (Date)endDate);
        Date declareStartDate = TaxPeriodHelper.getRightDate((Date)declareMonthDate, (int)declareStartDay);
        if (declareStartDate.getTime() <= endDate.getTime()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u7533\u62a5\u5f00\u59cb\u65e5\u671f\u987b\u665a\u4e8e\u671f\u95f4\u7ed3\u675f\u65e5\u671f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TaxPeriodGeneratePlugin_2", (String)"sit-sitbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("CALLBACK_DATE", (IFormPlugin)this));
            flag = true;
        }
        return flag;
    }

    protected boolean isNeedDeclareField() {
        return true;
    }

    public List<DynamicObject> batchGenerateTaxPeriod() {
        Date startDate;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject taxPeriodPrg = this.getDynamicObject().getDynamicObject("taxperiodprg");
        int startDay = taxPeriodPrg.getInt("startday");
        int endDay = taxPeriodPrg.getInt("endday");
        int declareStartDay = dataEntity.getInt("declarestartday");
        int declareEndDay = dataEntity.getInt("declareendday");
        int createRowCount = dataEntity.getInt("rowcount");
        Date startMonthDateFlag = dataEntity.getDate("startdate");
        String periodDateUseField = dataEntity.getString("perioddate");
        boolean startDayFlag = TaxPeriodHelper.getRightDateFlag((int)startDay);
        newPeriodStartDate = startDate = TaxPeriodHelper.getRightDate((Date)startMonthDateFlag, (int)startDay);
        boolean endDayFlag = TaxPeriodHelper.getRightDateFlag((int)endDay);
        Date endDate = TaxPeriodHelper.getEndDate((int)startDay, (int)endDay, (Date)startMonthDateFlag);
        Date declareMonthDate = TaxPeriodHelper.getDeclareMonthDate((String)periodDateUseField, (Date)startDate, (Date)endDate);
        boolean declareStartDayFlag = TaxPeriodHelper.getRightDateFlag((int)declareStartDay);
        Date declareStartDate = TaxPeriodHelper.getRightDate((Date)declareMonthDate, (int)declareStartDay);
        boolean declareEndDayFlag = TaxPeriodHelper.getRightDateFlag((int)declareEndDay);
        Date declareEndDate = TaxPeriodHelper.getRightDate((Date)declareMonthDate, (int)declareEndDay);
        ArrayList<DynamicObject> taxPeriods = new ArrayList<DynamicObject>(16);
        HRBaseServiceHelper periodHelper = new HRBaseServiceHelper("sitbs_taxperiod");
        for (int index = 0; index < createRowCount; ++index) {
            if (index > 0) {
                startDate = TaxPeriodHelper.calRightDate((boolean)startDayFlag, (Date)startDate);
                endDate = TaxPeriodHelper.calRightDate((boolean)endDayFlag, (Date)endDate);
                declareStartDate = TaxPeriodHelper.calRightDate((boolean)declareStartDayFlag, (Date)declareStartDate);
                declareEndDate = TaxPeriodHelper.calRightDate((boolean)declareEndDayFlag, (Date)declareEndDate);
            }
            DynamicObject period = periodHelper.generateEmptyDynamicObject();
            period.set("taxperiodprg", (Object)taxPeriodPrg);
            period.set("startdate", (Object)startDate);
            period.set("enddate", (Object)endDate);
            period.set("perioddate", (Object)("startdate".equals(periodDateUseField) ? startDate : endDate));
            period.set("declarestartdate", (Object)declareStartDate);
            period.set("declareenddate", (Object)declareEndDate);
            taxPeriods.add(period);
        }
        return taxPeriods;
    }

    private FormShowParameter getFormShowParameter() {
        return this.getView().getFormShowParameter();
    }

    private void showErrorNotification(String message) {
        this.getView().showErrorNotification(message);
    }

    private DynamicObject getDynamicObject() {
        return this.getModel().getDataEntity();
    }
}

