/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.period;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sit.sitbp.common.enums.TaxFrequencyEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.field.LockableComboEdit;

public class TaxPeriodPrgEdit
extends HRDataBaseEdit {
    protected static final String regEx = "[\u4e00-\u9fa5]";
    protected static final Pattern pat = Pattern.compile("[\u4e00-\u9fa5]");
    protected String specialRegEx = "^[A-Za-z0-9\\@\\#\\$\\%\\^\\&\\*\\[\\]\\.\\-\\_]*$";
    protected Pattern specialCharPat = Pattern.compile(this.specialRegEx);
    protected static final TaxFrequencyEnum[] UNIQUE_PERIOD_DATE = new TaxFrequencyEnum[]{TaxFrequencyEnum.MONTH};
    protected static final String IS_FIRST_COPY = "isFirstCopy";
    private final Set<String> combos = Sets.newHashSet((Object[])new String[]{"startday", "endday", "periodnumbersubject"});
    private final String[] DISABLE_FIELDS = new String[]{"number", "generalenname", "index", "generationruleflex"};

    public void initialize() {
        this.getView().addCustomControls(this.combos.toArray(new String[0]));
    }

    public void onGetControl(OnGetControlArgs ex) {
        super.onGetControl(ex);
        String key = ex.getKey();
        if (this.combos.contains(key)) {
            LockableComboEdit edit = new LockableComboEdit();
            edit.setKey(key);
            edit.setView(this.getView());
            ex.setControl((Control)edit);
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        DynamicObject taxPeriod = this.queryTaxPeriod();
        if (taxPeriod != null) {
            this.getView().setEnable(Boolean.FALSE, this.DISABLE_FIELDS);
        }
        if (this.getDynamicObject().getBoolean("issyspreset")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object isMutexOpen = formShowParameter.getCustomParam("isMutexOpen");
        if (YesOrNoEnum.YES.getCode().equals(String.valueOf(isMutexOpen))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5176\u4ed6\u7528\u6237\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"TaxPeriodPrgEdit_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterCreateNewData(EventObject ex) {
        this.generateSampleNumber();
    }

    public void afterLoadData(EventObject ex) {
        this.generateSampleNumber();
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey)) {
            this.validateBaseInfo(args);
            this.checkFieldEnable(args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        IFormView parentView;
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey) && (parentView = this.getView().getParentView()) != null) {
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
        }
    }

    public void propertyChanged(PropertyChangedArgs ex) {
        String[] fieldKey;
        switch (fieldKey = ex.getProperty().getName()) {
            case "periodnumbersubject": 
            case "periodnumberprefix": 
            case "periodnumbersuffix": 
            case "serialnumber": {
                this.generateSampleNumber();
                break;
            }
        }
        for (String disableField : this.DISABLE_FIELDS) {
            if (!StringUtils.equals((CharSequence)disableField, (CharSequence)fieldKey)) continue;
            this.getView().getPageCache().put("disableFieldChanged", YesOrNoEnum.YES.getCode());
            break;
        }
    }

    public void beforeClosed(BeforeClosedEvent ex) {
        HashMap<String, Object> returnData = new HashMap<String, Object>(2);
        DynamicObject dy = this.getModel().getDataEntity();
        long id = dy.getLong("id");
        String name = dy.getString("name");
        returnData.put("id", id);
        returnData.put("name", name);
        this.getView().returnDataToParent(returnData);
    }

    protected String getPeriodInfoEntityName() {
        return "sitbs_taxperiod";
    }

    private boolean validateBaseInfo(BeforeDoOperationEventArgs args) {
        String message = null;
        int startDay = this.getDynamicObject().getInt("startday");
        int endDay = this.getDynamicObject().getInt("endday");
        String frequency = this.getDynamicObject().getString("calfrequency.type");
        if (HRStringUtils.isEmpty((String)frequency) && startDay == 0 && endDay == 0) {
            message = ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u57fa\u672c\u4fe1\u606f\u4e2d\u7684\u201c\u671f\u95f4\u5f00\u59cb\u65e5\u201d\u548c\u201c\u671f\u95f4\u7ed3\u675f\u65e5\u201d\u4e24\u5b57\u6bb5\u7684\u503c\u3002", (String)"TaxPeriodPrgEdit_1", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
            this.validateTip(message, "warn_0");
            args.setCancel(true);
            return false;
        }
        if (startDay == endDay) {
            message = ResManager.loadKDString((String)"\u671f\u95f4\u5f00\u59cb\u65e5\u548c\u671f\u95f4\u7ed3\u675f\u65e5\u4e0d\u80fd\u76f8\u7b49\u3002", (String)"TaxPeriodPrgEdit_2", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
            this.validateTip(message, "warn_0");
            args.setCancel(true);
            return false;
        }
        if (startDay > endDay) {
            message = ResManager.loadKDString((String)"\u671f\u95f4\u5f00\u59cb\u65e5\u5927\u4e8e\u671f\u95f4\u7ed3\u675f\u65e5\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TaxPeriodPrgEdit_3", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(message, MessageBoxOptions.YesNo);
            return false;
        }
        return true;
    }

    private void generateSampleNumber() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (this.checkPeriodNumberInValid(dataEntity)) {
            return;
        }
        String periodNumberSubject = dataEntity.getString("periodnumbersubject");
        String periodNumberSubjectValue = "perioddate".equals(periodNumberSubject) ? HRDateTimeUtils.format((Date)new Date(), (String)"yyyyMM") : HRDateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd");
        int serialNumber = dataEntity.getInt("serialnumber");
        String periodNumberSerialNumber = "";
        if (serialNumber == 1) {
            periodNumberSerialNumber = "1";
        } else if (serialNumber == 2) {
            periodNumberSerialNumber = "01";
        }
        String periodNumberSample = dataEntity.getString("periodnumberprefix") + periodNumberSubjectValue + dataEntity.getString("periodnumbersuffix") + periodNumberSerialNumber;
        this.getModel().setValue("periodnumberexample", (Object)periodNumberSample);
    }

    private boolean checkPeriodNumberInValid(DynamicObject dataEntity) {
        String periodNumberPrefix = dataEntity.getString("periodnumberprefix");
        String periodNumberSuffix = dataEntity.getString("periodnumbersuffix");
        boolean isPrefixSpecialCharInValid = false;
        boolean isSuffixSpecialCharInValid = false;
        boolean isPrefixContainsChinese = false;
        boolean isSuffixContainsChinese = false;
        isPrefixContainsChinese = this.isContainsChinese(periodNumberPrefix);
        if (isPrefixContainsChinese || (isSuffixContainsChinese = this.isContainsChinese(periodNumberSuffix)) || (isPrefixSpecialCharInValid = this.checkSpecialCharInValid(periodNumberPrefix)) || (isSuffixSpecialCharInValid = this.checkSpecialCharInValid(periodNumberSuffix))) {
            String errMsg = "";
            if (isPrefixSpecialCharInValid) {
                errMsg = ResManager.loadKDString((String)"\u8bf7\u6309\u7167\u89c4\u8303\u586b\u5199\u7f16\u7801\u524d\u7f00\u3002", (String)"TaxPeriodPrgEdit_4", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
                dataEntity.set("periodnumberprefix", null);
            } else if (isSuffixSpecialCharInValid) {
                errMsg = ResManager.loadKDString((String)"\u8bf7\u6309\u7167\u89c4\u8303\u586b\u5199\u7f16\u7801\u540e\u7f00\u3002", (String)"TaxPeriodPrgEdit_5", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
                dataEntity.set("periodnumbersuffix", null);
            } else if (isPrefixContainsChinese) {
                errMsg = ResManager.loadKDString((String)"\u7f16\u7801\u524d\u7f00\u4e0d\u5141\u8bb8\u8f93\u5165\u4e2d\u6587\u3002", (String)"TaxPeriodPrgEdit_6", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
                dataEntity.set("periodnumberprefix", null);
            } else if (isSuffixContainsChinese) {
                errMsg = ResManager.loadKDString((String)"\u7f16\u7801\u540e\u7f00\u4e0d\u5141\u8bb8\u8f93\u5165\u4e2d\u6587\u3002", (String)"TaxPeriodPrgEdit_7", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
                dataEntity.set("periodnumbersuffix", null);
            }
            this.validateTip(errMsg, "warn_0");
            return true;
        }
        return false;
    }

    protected boolean checkSpecialCharInValid(String str) {
        if (HRStringUtils.isEmpty((String)str)) {
            return false;
        }
        Matcher matcher = this.specialCharPat.matcher(str);
        return !matcher.find();
    }

    private boolean isContainsChinese(String str) {
        if (HRStringUtils.isEmpty((String)str)) {
            return false;
        }
        Matcher matcher = pat.matcher(str);
        return matcher.find();
    }

    protected void validateTip(String message, String callBackId) {
        IFormView view = this.getView();
        switch (callBackId) {
            case "warn_0": {
                view.showMessage(message);
                break;
            }
            case "updateEntryEntityView": {
                view.showMessage(message, MessageTypes.Default, new ConfirmCallBackListener(callBackId, (IFormPlugin)this));
                break;
            }
            case "error_0": {
                view.showErrorNotification(message);
                break;
            }
            case "disable": 
            case "submit": {
                view.showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(callBackId, (IFormPlugin)this));
                break;
            }
            case "warn_1": {
                view.showTipNotification(message);
                break;
            }
        }
    }

    private DynamicObject getDynamicObject() {
        return this.getModel().getDataEntity();
    }

    private DynamicObject queryTaxPeriod() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxperiod");
        QFilter filter = new QFilter("taxperiodprg.id", "=", (Object)this.getDynamicObject().getLong("id"));
        return helper.queryOne("taxperiodprg", filter);
    }

    private void checkFieldEnable(BeforeDoOperationEventArgs args) {
        if (!this.getModel().getDataChanged()) {
            return;
        }
        String fieldChanged = this.getView().getPageCache().get("disableFieldChanged");
        if (!YesOrNoEnum.isYes((String)fieldChanged)) {
            return;
        }
        DynamicObject taxPeriod = this.queryTaxPeriod();
        if (taxPeriod != null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u7c7b\u578b\u4e0b\u5df2\u5b58\u5728\u671f\u95f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u671f\u95f4\u7c7b\u578b\u3002", (String)"TaxPeriodPrgEdit_8", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }
}

