/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.period;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.util.perm.HRPermUtil;
import kd.sit.sitbp.business.servicehelper.MutexServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import kd.sit.sitbs.business.multiview.GetAppInfoService;
import kd.sit.sitbs.business.taxperiod.TaxPeriodHelper;

public class TaxPeriodTreeListPlugin
extends StandardTreeListPlugin {
    private static final Log LOGGER = LogFactory.getLog(TaxPeriodTreeListPlugin.class);
    private Map<Object, BaseDataCheckRefrenceResult> checkResult;
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_MODIFY = "btnedit";
    private static final String BTN_DEL = "btndel";
    private static final String FIRST_LEVEL_SUFFIX = "_1";
    private static final String SECOND_LEVEL_SUFFIX = "_2";
    private static final String SPLITTER = "_";
    private static final HashMap<String, String> PERMISSIONMAP = new HashMap(3);
    private static final String TREE_PANEL = "splitcontainerap";

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        TreeView treeView;
        super.filterContainerAfterSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List fastFilters = (List)filterValues.get("fastfilter");
        if (CollectionUtils.isEmpty((Collection)fastFilters) && Objects.nonNull(treeView = (TreeView)this.getView().getControl("treeview"))) {
            DynamicObject presetPeriodPrg = new HRBaseServiceHelper("sitbs_taxperiodprg").queryOne("id,name,country.id", new QFilter[]{new QFilter("issyspreset", "=", (Object)Character.valueOf('1'))});
            String parentNodeId = presetPeriodPrg.getLong("country.id") + FIRST_LEVEL_SUFFIX;
            String nodeId = presetPeriodPrg.getString("id") + SECOND_LEVEL_SUFFIX;
            TreeNode treeNode = new TreeNode(parentNodeId, nodeId, presetPeriodPrg.getString("name"));
            treeView.focusNode(treeNode);
            treeView.treeNodeClick(parentNodeId, nodeId);
        }
    }

    public void beforeBindData(EventObject ex) {
        super.beforeBindData(ex);
        LocaleString localeString = ResManager.getLocaleString((String)"\u8bf7\u8f93\u5165\u4e2a\u7a0e\u671f\u95f4\u7c7b\u578b", (String)"TaxPeriodTreeListPlugin_15", (String)"sit-sitbs-formplugin");
        HashMap searchApCtrl = Maps.newHashMapWithExpectedSize((int)1);
        searchApCtrl.put("emptytip", localeString);
        this.getView().updateControlMetadata("searchap", (Map)searchApCtrl);
    }

    public void afterBindData(EventObject ex) {
        super.afterBindData(ex);
        if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            String appNumber = listShowParameter.getCheckRightAppId();
            if (listShowParameter.isLookUp()) {
                return;
            }
            if ("itc".equals(appNumber)) {
                SplitContainer splitc = (SplitContainer)this.getControl(TREE_PANEL);
                splitc.hidePanel(SplitDirection.left, true);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        String currentNodeIdStr = (String)this.getTreeModel().getCurrentNodeId();
        switch (operateKey) {
            case "batchgenerate": {
                if (Strings.isNullOrEmpty((String)currentNodeIdStr)) {
                    this.nullCurNodeAction(args);
                    return;
                }
                if (this.checkSecondNode(currentNodeIdStr)) {
                    this.showBatchGenerateForm();
                    return;
                }
                args.setCancel(true);
                break;
            }
            case "new": {
                if (Strings.isNullOrEmpty((String)currentNodeIdStr)) {
                    this.nullCurNodeAction(args);
                    return;
                }
                if (this.checkSecondNode(currentNodeIdStr)) {
                    this.getView().getPageCache().put("currentNodeId", currentNodeIdStr);
                    return;
                }
                args.setCancel(true);
                break;
            }
            case "refresh": {
                if (!Strings.isNullOrEmpty((String)currentNodeIdStr)) {
                    args.setCancel(true);
                    this.refreshNode(new RefreshNodeEvent((Object)this, (Object)currentNodeIdStr));
                    return;
                }
                args.setCancel(true);
                break;
            }
        }
    }

    private void nullCurNodeAction(BeforeDoOperationEventArgs args) {
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.deleteAllNodes();
        args.setCancel(true);
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\u7684\u56fd\u5bb6/\u5730\u533a\u4e0b\u65e0\u53ef\u64cd\u4f5c\u6570\u636e\u3002", (String)"TaxPeriodTreeListPlugin_16", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
    }

    private boolean checkSecondNode(String currentNodeIdStr) {
        if (!currentNodeIdStr.endsWith(SECOND_LEVEL_SUFFIX)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u4e2a\u671f\u95f4\u7c7b\u578b\u3002", (String)"TaxPeriodTreeListPlugin_11", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void initializeTree(EventObject ex) {
        this.initTree();
    }

    public void initTreeToolbar(EventObject ex) {
        super.initTreeToolbar(ex);
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_NEW, BTN_DEL});
    }

    private void initTree() {
        TreeNode root = this.initTreeNode();
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setRootVisable(false);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.addNode(root);
        this.loadChildNode();
    }

    protected TreeNode initTreeNode() {
        TreeNode root = new TreeNode();
        root.setId("100000");
        root.setText(ResManager.loadKDString((String)"\u4e2a\u7a0e\u671f\u95f4\u6839\u8282\u70b9", (String)"TaxPeriodTreeListPlugin_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
        root.setData((Object)"");
        root.setParentid("");
        root.setIsOpened(true);
        return root;
    }

    protected void loadChildNode() {
        String appId = HRPermUtil.getAppIdFromShowParam((FormShowParameter)this.getView().getFormShowParameter());
        Set countryIds = SITPermissionServiceHelper.getCountrySetByPermItem((String)appId, (String)"sitbs_taxperiodprg", (String)"47150e89000000ac");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("sitbs_taxperiodprg");
        QFilter filter = new QFilter("issyspreset", "=", (Object)Character.valueOf('1'));
        if (Objects.nonNull(countryIds)) {
            filter.and("country.id", "in", (Object)countryIds);
        }
        DynamicObject[] taxPeriodTypes = serviceHelper.query("id,number,name,country", new QFilter[]{filter});
        this.buildFirstLevelTreeNodes(taxPeriodTypes);
        this.buildSecondLevelTreeNodes(taxPeriodTypes);
    }

    private void buildFirstLevelTreeNodes(DynamicObject[] taxPeriodTypes) {
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        ITreeModel treeModel = this.getTreeModel();
        TreeMap countries = Arrays.stream(taxPeriodTypes).collect(Collectors.toMap(dy -> dy.getLong("country.id"), dy -> dy.getString("country.name"), (k1, k2) -> k1, TreeMap::new));
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(countries.size());
        for (Map.Entry country : countries.entrySet()) {
            TreeNode treeNode = new TreeNode("100000", country.getKey() + FIRST_LEVEL_SUFFIX, (String)country.getValue());
            treeNode.setIsOpened(true);
            treeNodes.add(treeNode);
        }
        treeModel.addNodes((Object)treeModel.getRoot().getId(), treeNodes);
        treeView.addNodes(treeNodes);
    }

    private void buildSecondLevelTreeNodes(DynamicObject[] taxPeriodTypes) {
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        ITreeModel treeModel = this.getTreeModel();
        String nodeId = null;
        TreeNode focusNode = null;
        for (DynamicObject taxPeriodType : taxPeriodTypes) {
            long countryId = taxPeriodType.getLong("country.id");
            TreeNode treeNode = new TreeNode(countryId + FIRST_LEVEL_SUFFIX, taxPeriodType.getString("id") + SECOND_LEVEL_SUFFIX, taxPeriodType.getString("name"));
            treeModel.addNode((Object)(countryId + FIRST_LEVEL_SUFFIX), treeNode);
            treeView.addNode(treeNode);
            if (Strings.isNullOrEmpty(nodeId)) {
                nodeId = taxPeriodType.getString("id") + SECOND_LEVEL_SUFFIX;
            }
            if (!Objects.isNull(focusNode)) continue;
            focusNode = treeNode;
        }
        String currentNodeIdStr = (String)treeModel.getCurrentNodeId();
        String appNumber = this.getView().getFormShowParameter().getCheckRightAppId();
        if (!Strings.isNullOrEmpty((String)currentNodeIdStr) && "itc".equals(appNumber)) {
            String presetPrgId = this.queryPresetPrgId();
            this.getTreeModel().setCurrentNodeId((Object)(presetPrgId + SECOND_LEVEL_SUFFIX));
        } else if (!Strings.isNullOrEmpty(nodeId)) {
            this.getTreeModel().setCurrentNodeId(nodeId);
            treeView.focusNode(focusNode);
        }
    }

    private String queryPresetPrgId() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("sitbs_taxperiodprg");
        QFilter filter = new QFilter("issyspreset", "=", (Object)Character.valueOf('1'));
        DynamicObject taxPeriodPrg = serviceHelper.queryOne("id", new QFilter[]{filter});
        return taxPeriodPrg.getString("id");
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent ex) {
        TreeNode root = this.getTreeModel().getRoot();
        String currNodeIdStr = (String)ex.getNodeId();
        String[] currentNodeIds = currNodeIdStr.split(SPLITTER);
        QFilter qFilter = new QFilter("taxperiodprg.id", "=", (Object)Long.valueOf(currentNodeIds[0]));
        ex.addQFilter(qFilter);
        ex.setCancel(true);
    }

    public void setFilter(SetFilterEvent ex) {
        String countryId;
        super.setFilter(ex);
        QFilter listFilter = new QFilter("taxperiodprg.enable", "=", (Object)YesOrNoEnum.YES.getCode());
        String appNumber = this.getView().getFormShowParameter().getCheckRightAppId();
        if (StringUtils.isNotEmpty((CharSequence)appNumber) && StringUtils.isNotEmpty((CharSequence)(countryId = GetAppInfoService.getInstance().getCountryId(appNumber, "sitbs_appcountryrel")))) {
            listFilter.and("taxperiodprg.country.id", "=", (Object)Long.valueOf(countryId));
        }
        ex.addCustomQFilter(listFilter);
    }

    public void treeToolbarClick(EventObject ex) {
        String opKey;
        ITreeModel treeModel = this.getTreeModel();
        String currentNodeIdStr = (String)treeModel.getCurrentNodeId();
        if (Strings.isNullOrEmpty((String)currentNodeIdStr)) {
            return;
        }
        if ("100000".equals(currentNodeIdStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u8282\u70b9\u3002", (String)"TaxPeriodTreeListPlugin_1", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        Control ctl = (Control)ex.getSource();
        switch (opKey = ctl.getKey()) {
            case "btnnew": {
                String msg = ResManager.loadKDString((String)"\u65e0\u65b0\u589e\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxPeriodTreeListPlugin_2", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
                this.checkPermAndDoAction(ex, opKey, msg, currentNodeIdStr);
                break;
            }
            case "btnedit": {
                String msg = ResManager.loadKDString((String)"\u65e0\u4fee\u6539\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxPeriodTreeListPlugin_3", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
                this.checkPermAndDoAction(ex, opKey, msg, currentNodeIdStr);
                break;
            }
            case "btndel": {
                String msg = ResManager.loadKDString((String)"\u65e0\u5220\u9664\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxPeriodTreeListPlugin_4", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
                this.checkPermAndDoAction(ex, opKey, msg, currentNodeIdStr);
                break;
            }
        }
    }

    private void checkPermAndDoAction(EventObject ex, String opKey, String msg, String currentNodeIdStr) {
        String permItemId = PERMISSIONMAP.get(opKey);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        boolean permFlag = SITPermissionServiceHelper.hasPerm((long)userId, (String)"sitbs", (String)"sitbs_taxperiodprg", (String)permItemId);
        if (!permFlag) {
            this.getView().showErrorNotification(msg);
            ((BeforeClickEvent)ex).setCancel(true);
        } else {
            switch (opKey) {
                case "btnnew": {
                    this.addGroupNode(currentNodeIdStr);
                    break;
                }
                case "btnedit": {
                    this.editAction(currentNodeIdStr);
                    break;
                }
                case "btndel": {
                    this.delAction(currentNodeIdStr);
                    break;
                }
            }
        }
    }

    private void delAction(String currentNodeIdStr) {
        if (currentNodeIdStr.endsWith(FIRST_LEVEL_SUFFIX)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u4e00\u7ea7\u8282\u70b9\u3002", (String)"TaxPeriodTreeListPlugin_12", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        String currentNodeId = currentNodeIdStr.split(SPLITTER)[0];
        DynamicObject taxPeriodTypeDy = this.getTaxPeriodType(Long.parseLong(currentNodeId));
        if (Objects.nonNull(taxPeriodTypeDy)) {
            boolean issyspreset = taxPeriodTypeDy.getBoolean("issyspreset");
            if (issyspreset) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"TaxPeriodTreeListPlugin_7", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
                return;
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u671f\u95f4\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"TaxPeriodTreeListPlugin_8", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseResult require = MutexServiceHelper.require((String)"sitbs_taxperiodprg", (String)currentNodeId, (String)"modify");
        if (!require.isSuccess()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5176\u4ed6\u7528\u6237\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"TaxItemTreeListPlugin_17", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        int taxPeriodCount = this.getTaxPeriodCount(Long.parseLong(currentNodeId));
        if (taxPeriodCount > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u671f\u95f4\u7c7b\u578b\u201c{0}\u201d\u88ab\u4e2a\u7a0e\u671f\u95f4\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"TaxPeriodTreeListPlugin_9", (String)"sit-sitbs-formplugin", (Object[])new Object[]{taxPeriodTypeDy.getString("name")}));
            return;
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("group_bar_del", (IFormPlugin)this);
        String strs = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u4e2a\u7a0e\u671f\u95f4\u7c7b\u578b\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u60a8\u786e\u8ba4\u5220\u9664\u4e2a\u7a0e\u671f\u95f4\u7c7b\u578b\u201c{0}\u201d\uff1f", (String)"TaxPeriodTreeListPlugin_10", (String)"sit-sitbs-formplugin", (Object[])new Object[]{taxPeriodTypeDy.getString("name")});
        this.getView().getPageCache().put("delid", currentNodeId);
        this.getView().showConfirm(strs, MessageBoxOptions.YesNo, confirmCallBacks);
    }

    private int getTaxPeriodCount(long taxPeriodTypeId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxperiod");
        QFilter filter = new QFilter("taxperiodprg.id", "=", (Object)taxPeriodTypeId);
        return helper.count(helper.getEntityName(), new QFilter[]{filter});
    }

    private DynamicObject getTaxPeriodType(long taxPeriodTypeId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxperiodprg");
        QFilter filter = new QFilter("id", "=", (Object)taxPeriodTypeId);
        return helper.queryOne("id,number,name,issyspreset", new QFilter[]{filter});
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        switch (event.getCallBackId()) {
            case "group_bar_del": {
                String currentNodeId = this.getView().getPageCache().get("delid");
                this.getView().getPageCache().remove("delid");
                if (MessageBoxResult.Yes.equals((Object)event.getResult())) {
                    this.doDel(Long.parseLong(currentNodeId));
                    break;
                }
                MutexServiceHelper.release((String)"sitbs_taxperiodprg", (String)currentNodeId, (String)"modify");
                break;
            }
        }
    }

    private void doDel(long taxPeriodTypeId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxperiodprg");
        helper.deleteOne((Object)taxPeriodTypeId);
    }

    private void editAction(String currentNodeIdStr) {
        if (currentNodeIdStr.endsWith(FIRST_LEVEL_SUFFIX)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7f16\u8f91\u4e00\u7ea7\u8282\u70b9\u3002", (String)"TaxPeriodTreeListPlugin_5", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("sitbs_taxperiodprg");
        baseShowParameter.setPkId((Object)currentNodeIdStr.split(SPLITTER)[0]);
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setStatus(OperationStatus.EDIT);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "group_bar_edit");
        baseShowParameter.setCloseCallBack(callBack);
        baseShowParameter.setStatus(OperationStatus.EDIT);
        baseShowParameter.setBillStatus(BillOperationStatus.SUBMIT);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private void addGroupNode(String currentNodeIdStr) {
        if (currentNodeIdStr.endsWith(SECOND_LEVEL_SUFFIX)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5728\u671f\u95f4\u7c7b\u578b\u4e0b\u521b\u5efa\u5b50\u7c7b\u522b\u3002", (String)"TaxPeriodTreeListPlugin_13", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.checkPeriodPrgRepeat(currentNodeIdStr)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u9891\u5ea6\u4e3a\u201c\u6708\u201d\u7684\u671f\u95f4\u7c7b\u578b\uff0c\u4e0d\u5141\u8bb8\u518d\u65b0\u589e\u3002", (String)"TaxPeriodTreeListPlugin_14", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("sitbs_taxperiodprg");
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setStatus(OperationStatus.ADDNEW);
        baseShowParameter.setCustomParam("countryId", (Object)currentNodeIdStr.split(SPLITTER)[0]);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private boolean checkPeriodPrgRepeat(String currentNodeIdStr) {
        Long countryId = (Long)BaseDataConverter.convert((Object)currentNodeIdStr.substring(0, currentNodeIdStr.length() - 2), Long.class);
        if (1000001L == countryId) {
            HRBaseServiceHelper prgHelper = new HRBaseServiceHelper("sitbs_taxperiodprg");
            QFilter filter = new QFilter("country.id", "=", (Object)countryId);
            filter.and("calfrequency.type", "=", (Object)"MONTH");
            filter.and("enable", "=", (Object)YesOrNoEnum.YES.getCode());
            DynamicObject periodPrg = prgHelper.queryOne("calfrequency.type,country.id", filter);
            return periodPrg != null;
        }
        return false;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "group_bar_add": 
            case "group_bar_edit": {
                Object map = closedCallBackEvent.getReturnData();
                if (!(map instanceof HashMap)) {
                    return;
                }
                this.refreshTree();
                HashMap returnData = (HashMap)map;
                this.focusNodeBySearchName((String)returnData.get("name"));
                break;
            }
        }
    }

    private void refreshTree() {
        ITreeListView treeListView = ((IListView)this.getView()).getTreeListView();
        String rootId = treeListView.getTreeModel().getRoot().getId();
        treeListView.getTreeModel().refreshNode((Object)rootId);
        treeListView.refreshTreeNode(rootId);
    }

    private void focusNodeBySearchName(String name) {
        SearchEnterEvent searchEnterEvent = new SearchEnterEvent((Object)this, name + "#s#");
        this.search(searchEnterEvent);
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        if (!searchText.endsWith("#s#")) {
            super.search(evt);
        } else {
            searchText = searchText.substring(0, searchText.length() - 3);
            TreeNode rootNode = this.getTreeModel().getRoot();
            List treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, arg_0 -> ((TaxPeriodTreeListPlugin)this).loadChildNodes(arg_0), 16);
            TreeNode targetNode = this.initTreeNode();
            for (TreeNode treeNode : treeNodes) {
                if (!searchText.equals(treeNode.getText())) continue;
                targetNode = treeNode;
            }
            if (targetNode.getId().equals("100000")) {
                return;
            }
            TreeView treeView = this.getTreeListView().getTreeView();
            this.focusNode(treeView, rootNode, targetNode);
        }
    }

    private void focusNode(TreeView treeView, TreeNode rootNode, TreeNode treeNode) {
        this.expandParents(treeView, rootNode, treeNode);
        treeView.showNode(treeNode.getParentid());
        treeView.focusNode(treeNode);
        treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
    }

    private void expandParents(TreeView treeView, TreeNode rootNode, TreeNode node) {
        String parentid = node.getParentid();
        if (StringUtils.isNotBlank((CharSequence)parentid)) {
            TreeNode pnode = rootNode.getTreeNode(parentid, 20);
            if (pnode != null) {
                this.expandParents(treeView, rootNode, pnode);
                treeView.expand(parentid);
                if (pnode == rootNode) {
                    treeView.updateNode(node);
                }
            } else {
                treeView.updateNode(node);
            }
        } else {
            treeView.updateNode(node);
        }
    }

    public void refreshNode(RefreshNodeEvent ex) {
        super.refreshNode(ex);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.deleteAllNodes();
        this.initTree();
        TreeNode root = this.getTreeModel().getRoot();
        String currNodeId = (String)ex.getNodeId();
        TreeNode currNode = root.getTreeNode(currNodeId, 10);
        if (currNode != null && currNode.getChildren() != null && !currNode.getChildren().isEmpty()) {
            ex.setChildNodes(currNode.getChildren());
        }
        treeView.setRootVisible(false);
        this.getTreeModel().setCurrentNodeId(ex.getNodeId());
        treeView.focusNode(currNode);
        if (Objects.nonNull(currNode)) {
            treeView.treeNodeClick(currNode.getParentid(), currNodeId);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection collection = super.getData(arg0, arg1);
                List pkIds = collection.stream().map(dy -> String.valueOf(dy.getPkValue())).collect(Collectors.toList());
                if (!pkIds.isEmpty()) {
                    BasedataEntityType basedataEntityType = TaxPeriodHelper.getBaseDataEntityType((String)"sitbs_taxperiod", (String)((String)pkIds.get(0)));
                    TaxPeriodTreeListPlugin.this.checkResult = TaxPeriodHelper.baseDataCheckReference((BasedataEntityType)basedataEntityType, (Object[])pkIds.toArray());
                }
                return collection;
            }
        });
    }

    public void packageData(PackageDataEvent ex) {
        super.packageData(ex);
        DynamicObject rowData = ex.getRowData();
        ColumnDesc columnDesc = (ColumnDesc)ex.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if ("refstatus".equals(fieldKey) && this.checkResult.containsKey(rowData.get("id"))) {
            ex.setFormatValue((Object)"1");
        }
    }

    private void showBatchGenerateForm() {
        String currentNodeIdStr = this.treeListView.getTreeModel().getCurrentNodeId().toString();
        String periodPrgId = currentNodeIdStr.substring(0, currentNodeIdStr.length() - 2);
        List<Map<String, Date>> periodInfoList = this.getPeriodInfoList(periodPrgId);
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("sitbs_taxperiodgenerate");
        parameters.setCustomParam("periodPrgId", (Object)periodPrgId);
        parameters.setCustomParam("taxPeriod", periodInfoList);
        this.getView().showForm(parameters);
    }

    private List<Map<String, Date>> getPeriodInfoList(String periodPrgId) {
        HRBaseServiceHelper periodHelper = new HRBaseServiceHelper("sitbs_taxperiod");
        QFilter filter = new QFilter("taxperiodprg.id", "=", (Object)Long.valueOf(periodPrgId));
        DynamicObject[] taxPeriods = periodHelper.query("id,startdate,enddate,perioddate,declarestartdate,declareenddate", new QFilter[]{filter});
        if (taxPeriods == null || taxPeriods.length == 0) {
            return Lists.newArrayList();
        }
        ArrayList<Map<String, Date>> result = new ArrayList<Map<String, Date>>(taxPeriods.length);
        List<String> dateFieldList = this.getDateFieldList();
        for (DynamicObject taxPeriod : taxPeriods) {
            HashMap map = new HashMap(16);
            dateFieldList.forEach(dateField -> map.put(dateField, taxPeriod.getDate(dateField)));
            result.add(map);
        }
        return result;
    }

    protected List<String> getDateFieldList() {
        return Arrays.asList("startdate", "enddate", "declarestartdate", "declareenddate");
    }

    static {
        PERMISSIONMAP.put(BTN_NEW, "47156aff000000ac");
        PERMISSIONMAP.put(BTN_MODIFY, "4715a0df000000ac");
        PERMISSIONMAP.put(BTN_DEL, "4715e1f1000000ac");
    }
}

