/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.sdkspi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sdk.annotation.SdkSPI;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.util.SITDateTimeUtils;
import kd.sit.sitbp.common.util.SITMServiceUtils;

public class SitSdkSpiTestPlugin
extends HRDataBaseEdit {
    private static final String SEARCHMSGBTN = "searchmsg";
    private static final String MSGNUMBER = "msgnumber";
    private static final String MSGENTRY = "msgentry";
    private static final String SERVICEBTN = "servicebtn";
    private static final String SDKBTN = "sdkbtn";
    private static final String CLOUDID = "cloudid";
    private static final String APPID = "appid";
    private static final String SERVICENAME = "servicename";
    private static final String METHODNAME = "methodname";
    private static final String ENTRYENTITY = "entryentity";
    private static final String PARAMTYPE = "paramtype";
    private static final String PARAMARRTYPE = "paramarrtype";
    private static final String PARAMKEY = "paramkey";
    private static final String PARAMDATA = "paramdata";
    private static final String PARAMRESULT = "issuccess";
    private static final String PARAMS = "params";
    private static final String PARAM_TYPES = "paramTypes";
    private static final String SERVICERESPONSE = "serviceresponse";
    private static final String APPID_HJM = "hjm";
    private static final String CACHE_KEY_PRE = "TestToolsPlugin-CACHE-";
    private static final int MAX_PARAM_SIZE = 10;
    private static final int INIT_HASH_SIZE = 8;
    private static final int MAX_LIST_SIZE = 500;
    private static final String LISTENTRYENTITY = "listentryentity";
    private static final String LISTCLOUDID = "listcloudid";
    private static final String LISTAPPID = "listappid";
    private static final String LISTSERVICENAME = "listservicename";
    private static final String LISTMETHODNAME = "listmethodname";
    private static final String LISTPARAMS = "listparams";
    private static final String SERVICEDATE = "servicedate";
    private static final String SEARCHSERVICEBTN = "searchservicebtn";
    private static final String COPYSERVICEBTN = "copyservicebtn";
    private static final List<String> MSG_SHOW_COLS = Arrays.asList("number", "msgtitle", "msgtag", "sendtime", "params");

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        FormShowParameter formShowParameter = args.getFormShowParameter();
        if (formShowParameter == null || formShowParameter.getParentPageId() == null) {
            args.setCancel(true);
            return;
        }
        if (!SITPermissionServiceHelper.isSuperUser()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u5168\u529f\u80fd\u7528\u6237\u6743\u9650\u3002", (String)"SitSdkSpiTestPlugin_18", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void registerListener(EventObject evn) {
        super.registerListener(evn);
        Button buttonmsg = (Button)this.getView().getControl(SEARCHMSGBTN);
        buttonmsg.addClickListener((ClickListener)this);
        Button servicebtn = (Button)this.getView().getControl(SERVICEBTN);
        servicebtn.addClickListener((ClickListener)this);
        Button spibtn = (Button)this.getView().getControl(SDKBTN);
        spibtn.addClickListener((ClickListener)this);
        Button searchservicebtn = (Button)this.getView().getControl(SEARCHSERVICEBTN);
        searchservicebtn.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        DynamicObject data = this.getModel().getDataEntity();
        if (HRStringUtils.equals((String)SEARCHMSGBTN, (String)source.getKey())) {
            this.getModel().deleteEntryData(MSGENTRY);
            String msgNumber = data.getString(MSGNUMBER);
            if (HRStringUtils.isEmpty((String)msgNumber)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6d88\u606f\u7f16\u7801\u8fdb\u884c\u67e5\u8be2", (String)"SitSdkSpiTestPlugin_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
                return;
            }
            HRBaseServiceHelper service = new HRBaseServiceHelper("hrcs_msgcenter");
            DynamicObject msg = service.loadDynamicObject(new QFilter("number", "=", (Object)msgNumber));
            if (ObjectUtils.isEmpty((Object)msg)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e", (String)"SitSdkSpiTestPlugin_16", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
                return;
            }
            this.setMsgInfo(msg);
        } else if (HRStringUtils.equals((String)SEARCHSERVICEBTN, (String)source.getKey())) {
            this.getDataFromCache();
        }
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String parentData = (String)showParameter.getCustomParam("parentData");
        if (HRStringUtils.isEmpty((String)parentData)) {
            return;
        }
        DynamicObject data = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)parentData);
        String cloudId = data.getString(CLOUDID) != null ? data.getString(CLOUDID).trim() : "";
        String appId = data.getString(APPID) != null ? data.getString(APPID).trim() : "";
        String serviceName = data.getString(SERVICENAME) != null ? data.getString(SERVICENAME).trim() : "";
        String methodName = data.getString(METHODNAME) != null ? data.getString(METHODNAME).trim() : "";
        this.getModel().setValue(CLOUDID, (Object)cloudId);
        this.getModel().setValue(APPID, (Object)appId);
        this.getModel().setValue(SERVICENAME, (Object)serviceName);
        this.getModel().setValue(METHODNAME, (Object)methodName);
        this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY).clear();
        DynamicObjectCollection entries = data.getDynamicObjectCollection(ENTRYENTITY);
        if (entries.size() > 0) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, entries.size());
        }
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject entryInfo = (DynamicObject)entries.get(i);
            this.getModel().setValue(PARAMTYPE, (Object)entryInfo.getString(PARAMTYPE), i);
            this.getModel().setValue(PARAMARRTYPE, (Object)entryInfo.getString(PARAMARRTYPE), i);
            this.getModel().setValue(PARAMKEY, (Object)entryInfo.getString(PARAMKEY), i);
            this.getModel().setValue(PARAMDATA, (Object)entryInfo.getString("paramdata_tag"), i);
            this.getModel().setValue("paramdata_tag", (Object)entryInfo.getString("paramdata_tag"), i);
        }
        showParameter.getCustomParams().remove("parentData");
        String operateKey = (String)this.getView().getFormShowParameter().getCustomParam("operateKey");
        if (HRStringUtils.isNotEmpty((String)operateKey)) {
            this.getView().getFormShowParameter().getCustomParams().remove("operateKey");
            this.getView().invokeOperation(operateKey);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        DynamicObject data = this.getModel().getDataEntity();
        String cloudId = data.getString(CLOUDID) != null ? data.getString(CLOUDID).trim() : "";
        String appId = data.getString(APPID) != null ? data.getString(APPID).trim() : "";
        String serviceName = data.getString(SERVICENAME) != null ? data.getString(SERVICENAME).trim() : "";
        String methodName = data.getString(METHODNAME) != null ? data.getString(METHODNAME).trim() : "";
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (SERVICEBTN.equals(operateKey)) {
            if (!this.checkServiceParams(data.getString(CLOUDID), data.getString(APPID), data.getString(SERVICENAME), data.getString(METHODNAME))) return;
            try {
                Map<String, Object> result = this.getParams();
                if (!((Boolean)result.get(PARAMRESULT)).booleanValue()) return;
                Object returnInfo = this.invokeMethod(cloudId, appId, serviceName, methodName, (List)result.get(PARAMS));
                this.handleResultInfo(returnInfo);
                return;
            }
            catch (Exception e) {
                boolean notFindService;
                String errorMsg = ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"SitSdkSpiTestPlugin_1", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
                boolean bl = notFindService = e.getMessage() != null && e.getMessage().indexOf(errorMsg) > -1;
                if (e.getCause() instanceof ClassNotFoundException || notFindService) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u5e94\u7528\u6807\u8bc6\u3001\u670d\u52a1\u914d\u7f6e\u4ee5\u53ca\u53c2\u6570", (String)"SitSdkSpiTestPlugin_17", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showErrorNotification(e.getMessage());
                throw e;
            }
        } else if (SDKBTN.equals(operateKey)) {
            if (!this.checkServiceParams(data.getString(CLOUDID), data.getString(APPID), data.getString(SERVICENAME), data.getString(METHODNAME))) return;
            if (!HRStringUtils.equals((String)(appId = appId.trim()), (String)this.getView().getFormShowParameter().getAppId())) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
                showParameter.setFormId(this.getView().getEntityId());
                showParameter.setAppId(appId);
                showParameter.setCustomParam("operateKey", (Object)operateKey);
                FormConfig formConfig = FormMetadataCache.getFormConfig((String)showParameter.getFormId());
                formConfig.setAppId(appId);
                String parentData = SerializationUtils.serializeToBase64((Object)this.getModel().getDataEntity(true));
                showParameter.setCustomParam("parentData", (Object)parentData);
                if (!Boolean.TRUE.toString().equals(this.getView().getFormShowParameter().getCustomParam("isUnitTest"))) {
                    this.getView().showForm(showParameter);
                    return;
                }
            }
            if (!Boolean.TRUE.toString().equals(this.getView().getFormShowParameter().getCustomParam("isUnitTest")) && this.getView().getParentView() != null) {
                this.getView().getParentView().close();
            }
            this.getView().getFormShowParameter().setCustomParam("isCurrent", (Object)Boolean.TRUE.toString());
            try {
                Map<String, Object> result = this.getParams();
                if (!((Boolean)result.get(PARAMRESULT)).booleanValue()) return;
                Object returnInfo = this.invokeSdkMethod(serviceName, methodName, (List)result.get(PARAMS), (Class[])result.get(PARAM_TYPES));
                this.handleResultInfo(returnInfo);
                return;
            }
            catch (Exception e) {
                boolean notFindService;
                String errorMsg = ResManager.loadKDString((String)"SDK\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"SitSdkSpiTestPlugin_2", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
                boolean bl = notFindService = e.getMessage() != null && e.getMessage().indexOf(errorMsg) > -1;
                if (e.getCause() instanceof ClassNotFoundException || notFindService) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"SDK\u670d\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u5e94\u7528\u6807\u8bc6\u3001\u670d\u52a1\u914d\u7f6e\u4ee5\u53ca\u53c2\u6570", (String)"SitSdkSpiTestPlugin_3", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showErrorNotification(e.getMessage());
                throw e;
            }
        } else {
            List personalData;
            if (!HRStringUtils.equals((String)COPYSERVICEBTN, (String)afterDoOperationEventArgs.getOperateKey())) return;
            EntryGrid entryGrid = (EntryGrid)this.getControl(LISTENTRYENTITY);
            int[] selectIndex = entryGrid.getSelectRows();
            if (selectIndex == null || selectIndex.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e", (String)"SitSdkSpiTestPlugin_4", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
                return;
            }
            if (selectIndex.length > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e", (String)"SitSdkSpiTestPlugin_5", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
                return;
            }
            String cacheStringData = (String)HRAppCache.get((String)APPID_HJM).get(this.getCacheKey(), String.class);
            if (HRStringUtils.isNotEmpty((String)cacheStringData) && !ObjectUtils.isEmpty((Object)(personalData = (List)SerializationUtils.deSerializeFromBase64((String)cacheStringData))) && personalData.size() > selectIndex[0]) {
                Map info = (Map)personalData.get(selectIndex[0]);
                this.getModel().setValue(CLOUDID, info.get(CLOUDID));
                this.getModel().setValue(APPID, info.get(APPID));
                this.getModel().setValue(SERVICENAME, info.get(SERVICENAME));
                this.getModel().setValue(METHODNAME, info.get(METHODNAME));
                this.getModel().deleteEntryData(ENTRYENTITY);
                DynamicObjectCollection entries = (DynamicObjectCollection)info.get(ENTRYENTITY);
                this.getModel().batchCreateNewEntryRow(ENTRYENTITY, entries.size());
                for (int i = 0; i < entries.size(); ++i) {
                    DynamicObject entryInfo = (DynamicObject)entries.get(i);
                    this.getModel().setValue(PARAMTYPE, (Object)entryInfo.getString(PARAMTYPE), i);
                    this.getModel().setValue(PARAMARRTYPE, (Object)entryInfo.getString(PARAMARRTYPE), i);
                    this.getModel().setValue(PARAMKEY, (Object)entryInfo.getString(PARAMKEY), i);
                    this.getModel().setValue(PARAMDATA, (Object)entryInfo.getString("paramdata_tag"), i);
                    this.getModel().setValue("paramdata_tag", (Object)entryInfo.getString("paramdata_tag"), i);
                }
            }
            this.getView().updateView();
        }
    }

    public void handleResultInfo(Object returnInfo) {
        ValueFilter valueFilter = (obj, str, obj1) -> this.dealDynaObjectData(obj1);
        if (returnInfo instanceof DynamicObject) {
            CodeEdit edit = (CodeEdit)this.getView().getControl(SERVICERESPONSE);
            String serialize = DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{(DynamicObject)returnInfo}, (DynamicObjectType)((DynamicObject)returnInfo).getDynamicObjectType());
            edit.setText(serialize);
            this.saveToCache();
        } else if (returnInfo instanceof DynamicObjectCollection) {
            CodeEdit edit = (CodeEdit)this.getView().getControl(SERVICERESPONSE);
            AtomicReference<String> text = new AtomicReference<String>("");
            if (((DynamicObjectCollection)returnInfo).size() != 0) {
                DynamicObject dynamicObject = (DynamicObject)((DynamicObjectCollection)returnInfo).get(0);
                String serialize = DynamicObjectSerializeUtil.serialize((Object[])((DynamicObjectCollection)returnInfo).toArray(), (DynamicObjectType)dynamicObject.getDynamicObjectType());
                ((DynamicObjectCollection)returnInfo).forEach(key -> text.set(serialize));
            }
            edit.setText(text.toString());
            this.saveToCache();
        } else {
            String pretty = JSON.toJSONString((Object)returnInfo, (SerializeFilter)valueFilter, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.DisableCircularReferenceDetect});
            CodeEdit edit = (CodeEdit)this.getView().getControl(SERVICERESPONSE);
            edit.setText(pretty);
            this.saveToCache();
        }
    }

    public void setMsgInfo(DynamicObject msg) {
        IDataEntityType dataEntityType = msg.getDataEntityType();
        DataEntityPropertyCollection props = dataEntityType.getProperties();
        this.getModel().batchCreateNewEntryRow(MSGENTRY, MSG_SHOW_COLS.size());
        for (int i = 0; i < MSG_SHOW_COLS.size(); ++i) {
            String col = MSG_SHOW_COLS.get(i);
            IDataEntityProperty prop = (IDataEntityProperty)props.get((Object)col);
            if (ObjectUtils.isEmpty((Object)prop)) continue;
            this.getModel().setValue("msgcolname", (Object)prop.getDisplayName(), i);
            this.getModel().setValue("msgcolcode", (Object)col, i);
            if (HRStringUtils.equals((String)PARAMS, (String)col)) {
                String info = msg.getString(col);
                if (!HRStringUtils.isNotEmpty((String)info)) continue;
                Object content = SerializationUtils.deSerializeFromBase64((String)info);
                this.getModel().setValue("msgcoldata", content, i);
                continue;
            }
            this.getModel().setValue("msgcoldata", msg.get(col), i);
        }
    }

    public boolean checkServiceParams(String cloudId, String appId, String serviceName, String methodName) {
        if (HRStringUtils.isEmpty((String)cloudId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4e91\u5e94\u7528\u6807\u8bc6", (String)"SitSdkSpiTestPlugin_6", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (HRStringUtils.isEmpty((String)appId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e94\u7528\u6807\u8bc6", (String)"SitSdkSpiTestPlugin_7", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (HRStringUtils.isEmpty((String)serviceName)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u670d\u52a1\u540d\u79f0", (String)"SitSdkSpiTestPlugin_8", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (HRStringUtils.isEmpty((String)methodName)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u670d\u52a1\u65b9\u6cd5", (String)"SitSdkSpiTestPlugin_9", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Map<String, Object> getParams() {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        StringBuilder errorInfo = new StringBuilder();
        DynamicObject data = this.getModel().getDataEntity();
        DynamicObjectCollection params = data.getDynamicObjectCollection(ENTRYENTITY);
        if (ObjectUtils.isEmpty((Object)params)) {
            result.put(PARAMRESULT, Boolean.FALSE);
            return result;
        }
        Class[] outParamTypes = new Class[params.size()];
        ArrayList<Object> resultData = new ArrayList<Object>();
        for (int i = 0; i < params.size(); ++i) {
            DynamicObject param = (DynamicObject)params.get(i);
            String paramtype = param.getString(PARAMTYPE);
            String paramarrtype = param.getString(PARAMARRTYPE);
            String paramkey = param.getString(PARAMKEY);
            String paramdata = param.getString("paramdata_tag");
            boolean success = true;
            if (HRStringUtils.isEmpty((String)paramtype) && HRStringUtils.isEmpty((String)paramkey) && HRStringUtils.isEmpty((String)paramdata)) continue;
            if (HRStringUtils.isEmpty((String)paramtype)) {
                errorInfo.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%s\u884c\u8bf7\u9009\u62e9\u53c2\u6570\u7c7b\u578b\u3002", (String)"SitSdkSpiTestPlugin_10", (String)"sit-sitbs-formplugin", (Object[])new Object[0]), i + 1));
                success = false;
            }
            if (HRStringUtils.isEmpty((String)paramarrtype)) {
                errorInfo.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%s\u884c\u8bf7\u9009\u62e9\u53c2\u6570\u96c6\u5408\u7c7b\u578b\u3002", (String)"SitSdkSpiTestPlugin_11", (String)"sit-sitbs-formplugin", (Object[])new Object[0]), i + 1));
                success = false;
            }
            if (HRStringUtils.equals((String)"dynamicObject", (String)paramtype) && HRStringUtils.isEmpty((String)paramkey)) {
                errorInfo.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%s\u884c\u8bf7\u9009\u62e9\u5b9e\u4f53\u7f16\u7801\u3002", (String)"SitSdkSpiTestPlugin_12", (String)"sit-sitbs-formplugin", (Object[])new Object[0]), i + 1));
                success = false;
            }
            if (!HRStringUtils.equals((String)"string", (String)paramtype) && !HRStringUtils.equals((String)"date", (String)paramtype) && !HRStringUtils.equals((String)"map", (String)paramtype) && HRStringUtils.isEmpty((String)paramdata)) {
                errorInfo.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%s\u884c\u8bf7\u586b\u5199\u53c2\u6570\u503c\u3002", (String)"SitSdkSpiTestPlugin_13", (String)"sit-sitbs-formplugin", (Object[])new Object[0]), i + 1));
                success = false;
            }
            paramtype = paramtype != null ? paramtype.trim() : "";
            paramarrtype = paramarrtype != null ? paramarrtype.trim() : "";
            paramkey = paramkey != null ? paramkey.trim() : "";
            String string = paramdata = paramdata != null ? paramdata.trim() : "";
            if (!success) continue;
            try {
                if (HRStringUtils.equals((String)"single", (String)paramarrtype)) {
                    outParamTypes[i] = this.dealSingleTypeData(paramtype, paramkey, paramdata, resultData);
                    continue;
                }
                if (HRStringUtils.equals((String)"array", (String)paramarrtype)) {
                    outParamTypes[i] = this.dealArrayTypeData(paramtype, paramkey, paramdata, resultData);
                    continue;
                }
                if (HRStringUtils.equals((String)"list", (String)paramarrtype)) {
                    outParamTypes[i] = this.dealListTypeData(paramtype, paramkey, paramdata, resultData);
                    continue;
                }
                if (!HRStringUtils.equals((String)"set", (String)paramarrtype)) continue;
                outParamTypes[i] = this.dealSetTypeData(paramtype, paramkey, paramdata, resultData);
                continue;
            }
            catch (Exception e) {
                errorInfo.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%s\u884c\u53c2\u6570\u503c\u89e3\u6790\u9519\u8bef\u3002", (String)"SitSdkSpiTestPlugin_14", (String)"sit-sitbs-formplugin", (Object[])new Object[0]), i + 1));
                result.put(PARAMRESULT, Boolean.FALSE);
            }
        }
        if (HRStringUtils.isNotEmpty((String)errorInfo.toString())) {
            this.getView().showErrorNotification(errorInfo.toString());
            result.put(PARAMRESULT, Boolean.FALSE);
        } else {
            result.put(PARAMS, resultData);
            result.put(PARAMRESULT, Boolean.TRUE);
            result.put(PARAM_TYPES, outParamTypes);
        }
        return result;
    }

    public Class<?> dealSingleTypeData(String paramtype, String paramkey, String paramdata, List<Object> resultData) throws ParseException {
        Class classType = null;
        if (HRStringUtils.equals((String)"int", (String)paramtype)) {
            classType = Integer.class;
            resultData.add(Integer.parseInt(paramdata));
        } else if (HRStringUtils.equals((String)"long", (String)paramtype)) {
            classType = Long.class;
            resultData.add(Long.parseLong(paramdata));
        } else if (HRStringUtils.equals((String)"boolean", (String)paramtype)) {
            classType = Boolean.class;
            resultData.add(Boolean.parseBoolean(paramdata));
        } else if (HRStringUtils.equals((String)"string", (String)paramtype)) {
            classType = String.class;
            if (HRStringUtils.isEmpty((String)paramdata)) {
                resultData.add(null);
            } else {
                resultData.add(paramdata);
            }
        } else if (HRStringUtils.equals((String)"date", (String)paramtype)) {
            classType = Date.class;
            if (HRStringUtils.isEmpty((String)paramdata)) {
                resultData.add(null);
            } else {
                resultData.add(HRDateTimeUtils.parseDate((String)String.valueOf(paramdata)));
            }
        } else if (HRStringUtils.equals((String)"bigdecimal", (String)paramtype)) {
            classType = BigDecimal.class;
            if (HRStringUtils.isEmpty((String)paramdata)) {
                resultData.add(null);
            } else {
                resultData.add(new BigDecimal(paramdata));
            }
        } else if (HRStringUtils.equals((String)"map", (String)paramtype)) {
            classType = Map.class;
            if (HRStringUtils.isEmpty((String)paramdata)) {
                resultData.add(null);
            } else {
                resultData.add(this.parseJsonMap(paramdata));
            }
        } else if (HRStringUtils.equals((String)"dynamicObject", (String)paramtype)) {
            classType = DynamicObject.class;
            Object[] datas = this.getDataFromDb(paramkey, paramdata);
            if (!ObjectUtils.isEmpty((Object[])datas)) {
                resultData.add(datas[0]);
            }
        } else if (HRStringUtils.equals((String)"qFilter", (String)paramtype)) {
            classType = DynamicObject.class;
            QFilter filter = this.getFilter(paramdata);
            if (null != filter) {
                resultData.add(filter);
            }
        }
        return classType;
    }

    private QFilter getFilter(String paramdata) {
        if (StringUtils.isEmpty((String)paramdata)) {
            return null;
        }
        return (QFilter)SerializationUtils.fromJsonString((String)paramdata, QFilter.class);
    }

    private List<QFilter> getFilters(String paramdata) {
        if (StringUtils.isEmpty((String)paramdata)) {
            return new ArrayList<QFilter>(0);
        }
        List objects = SerializationUtils.fromJsonStringToList((String)paramdata, QFilter.class);
        return objects;
    }

    private Map<String, Object> parseJsonMap(String paramdata) throws ParseException {
        Map map = (Map)JSON.parseObject((String)paramdata, Map.class);
        return this.parseJsonObject(map);
    }

    private Map<String, Object> parseJsonObject(Map<String, Object> value) throws ParseException {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            if (entry.getValue() instanceof String && entry.getValue().toString().endsWith("DATE")) {
                dataMap.put(entry.getKey(), SITDateTimeUtils.parseDate((String)entry.getValue().toString()));
                continue;
            }
            if (entry.getValue() instanceof JSONArray) {
                dataMap.put(entry.getKey(), this.parseJsonArray((JSONArray)entry.getValue()));
                continue;
            }
            if (entry.getValue() instanceof JSONObject) {
                dataMap.put(entry.getKey(), this.parseJsonObject((Map<String, Object>)((JSONObject)entry.getValue())));
                continue;
            }
            dataMap.put(entry.getKey(), entry.getValue());
        }
        return dataMap;
    }

    private List<Object> parseJsonArray(JSONArray value) throws ParseException {
        ArrayList<Object> list = new ArrayList<Object>(10);
        for (Object obj : value) {
            if (obj instanceof JSONObject) {
                list.add(this.parseJsonObject((Map<String, Object>)((JSONObject)obj)));
                continue;
            }
            if (obj instanceof String && obj.toString().endsWith("DATE")) {
                list.add(SITDateTimeUtils.parseDate((String)obj.toString()));
                continue;
            }
            list.add(obj);
        }
        return list;
    }

    private Class<?> dealArrayTypeData(String paramtype, String paramkey, String paramdata, List<Object> resultData) throws ParseException {
        Class classType = null;
        if (HRStringUtils.equals((String)"int", (String)paramtype)) {
            classType = Integer[].class;
            resultData.add(this.parseIntegerList(paramdata).toArray());
        } else if (HRStringUtils.equals((String)"long", (String)paramtype)) {
            classType = Long[].class;
            resultData.add(this.parseLongList(paramdata).toArray());
        } else if (HRStringUtils.equals((String)"boolean", (String)paramtype)) {
            classType = Boolean[].class;
            resultData.add(this.parseBooleanList(paramdata).toArray());
        } else if (HRStringUtils.equals((String)"date", (String)paramtype)) {
            classType = Date[].class;
            if (HRStringUtils.isEmpty((String)paramdata)) {
                resultData.add(null);
            } else {
                resultData.add(this.parseDateList(paramdata).toArray());
            }
        } else if (HRStringUtils.equals((String)"bigdecimal", (String)paramtype)) {
            classType = BigDecimal[].class;
            if (HRStringUtils.isEmpty((String)paramdata)) {
                resultData.add(null);
            } else {
                resultData.add(this.parseBigDecimalList(paramdata).toArray());
            }
        } else if (HRStringUtils.equals((String)"string", (String)paramtype)) {
            classType = String[].class;
            if (HRStringUtils.isEmpty((String)paramdata)) {
                resultData.add(null);
            } else {
                resultData.add(this.parseStringList(paramdata).toArray());
            }
        } else if (HRStringUtils.equals((String)"map", (String)paramtype)) {
            classType = Map[].class;
            if (HRStringUtils.isEmpty((String)paramdata)) {
                resultData.add(null);
            } else {
                resultData.add(this.parseMapList(paramdata).toArray());
            }
        } else if (HRStringUtils.equals((String)"dynamicObject", (String)paramtype)) {
            classType = DynamicObject[].class;
            DynamicObject[] datas = this.getDataFromDb(paramkey, paramdata);
            resultData.add(datas);
        }
        return classType;
    }

    private Class<?> dealListTypeData(String paramtype, String paramkey, String paramdata, List<Object> resultData) throws ParseException {
        if (HRStringUtils.equals((String)"int", (String)paramtype)) {
            resultData.add(this.parseIntegerList(paramdata));
        } else if (HRStringUtils.equals((String)"long", (String)paramtype)) {
            resultData.add(this.parseLongList(paramdata));
        } else if (HRStringUtils.equals((String)"boolean", (String)paramtype)) {
            resultData.add(this.parseBooleanList(paramdata));
        } else if (HRStringUtils.equals((String)"string", (String)paramtype)) {
            if (HRStringUtils.isEmpty((String)paramdata)) {
                resultData.add(null);
            } else {
                resultData.add(this.parseStringList(paramdata));
            }
        } else if (HRStringUtils.equals((String)"date", (String)paramtype)) {
            if (HRStringUtils.isEmpty((String)paramdata)) {
                resultData.add(null);
            } else {
                resultData.add(this.parseDateList(paramdata));
            }
        } else if (HRStringUtils.equals((String)"bigdecimal", (String)paramtype)) {
            if (HRStringUtils.isEmpty((String)paramdata)) {
                resultData.add(null);
            } else {
                resultData.add(this.parseBigDecimalList(paramdata));
            }
        } else if (HRStringUtils.equals((String)"map", (String)paramtype)) {
            if (HRStringUtils.isEmpty((String)paramdata)) {
                resultData.add(null);
            } else {
                resultData.add(this.parseJsonList(paramdata));
            }
        } else if (HRStringUtils.equals((String)"dynamicObject", (String)paramtype)) {
            DynamicObject[] datas = this.getDataFromDb(paramkey, paramdata);
            resultData.add(Arrays.stream(datas).collect(Collectors.toList()));
        } else if (HRStringUtils.equals((String)"qFilter", (String)paramtype)) {
            List<QFilter> filters = this.getFilters(paramdata);
            resultData.add(filters);
        }
        return List.class;
    }

    private Class<?> dealSetTypeData(String paramtype, String paramkey, String paramdata, List<Object> resultData) throws ParseException {
        if (HRStringUtils.equals((String)"long", (String)paramtype)) {
            resultData.add(this.parseLongSet(paramdata));
        } else if (HRStringUtils.equals((String)"string", (String)paramtype)) {
            if (HRStringUtils.isEmpty((String)paramdata)) {
                resultData.add(null);
            } else {
                resultData.add(this.parseStringSet(paramdata));
            }
        }
        return Set.class;
    }

    private List<Object> parseJsonList(String paramdata) throws ParseException {
        return this.parseJsonArray(JSON.parseArray((String)paramdata));
    }

    private List<Integer> parseIntegerList(String paramdata) {
        String[] datas;
        ArrayList<Integer> result = new ArrayList<Integer>(8);
        for (String data : datas = paramdata.split(",")) {
            result.add(Integer.parseInt(data));
        }
        return result;
    }

    private List<BigDecimal> parseBigDecimalList(String paramdata) {
        String[] datas;
        ArrayList<BigDecimal> result = new ArrayList<BigDecimal>(8);
        for (String data : datas = paramdata.split(",")) {
            result.add(new BigDecimal(data));
        }
        return result;
    }

    public Set<BigDecimal> parseBigDecimalSet(String paramdata) {
        String[] datas;
        HashSet<BigDecimal> result = new HashSet<BigDecimal>(8);
        for (String data : datas = paramdata.split(",")) {
            result.add(new BigDecimal(data));
        }
        return result;
    }

    private Set<Long> parseLongSet(String paramdata) {
        String[] datas;
        HashSet<Long> result = new HashSet<Long>(8);
        for (String data : datas = paramdata.split(",")) {
            result.add(Long.parseLong(data));
        }
        return result;
    }

    private List<Long> parseLongList(String paramdata) {
        String[] datas;
        ArrayList<Long> result = new ArrayList<Long>(8);
        for (String data : datas = paramdata.split(",")) {
            result.add(Long.parseLong(data));
        }
        return result;
    }

    private List<Boolean> parseBooleanList(String paramdata) {
        String[] datas;
        ArrayList<Boolean> result = new ArrayList<Boolean>(8);
        for (String data : datas = paramdata.split(",")) {
            result.add(Boolean.parseBoolean(data));
        }
        return result;
    }

    private List<Date> parseDateList(String paramdata) throws ParseException {
        String[] datas;
        ArrayList<Date> result = new ArrayList<Date>(8);
        for (String data : datas = paramdata.split(",")) {
            result.add(HRDateTimeUtils.parseDate((String)String.valueOf(paramdata)));
        }
        return result;
    }

    private Set<String> parseStringSet(String paramdata) {
        String[] datas;
        HashSet<String> result = new HashSet<String>(8);
        for (String data : datas = paramdata.split(",")) {
            result.add(data);
        }
        return result;
    }

    private List<String> parseStringList(String paramdata) {
        String[] datas;
        ArrayList<String> result = new ArrayList<String>(8);
        for (String data : datas = paramdata.split(",")) {
            result.add(data);
        }
        return result;
    }

    public List<Map> parseMapList(String paramdata) throws ParseException {
        String[] datas;
        ArrayList<Map> result = new ArrayList<Map>(8);
        for (String data : datas = paramdata.split("},")) {
            if (!(data = data.trim()).endsWith("}")) {
                data = data + "}";
            }
            Map mapdata = (Map)JSON.parseObject((String)data, Map.class);
            for (Map.Entry entry : mapdata.entrySet()) {
                if (!String.valueOf(entry.getValue()).endsWith("DATE")) continue;
                String dealData = String.valueOf(entry.getValue());
                dealData = dealData.substring(0, dealData.length() - 4);
                mapdata.put(entry.getKey(), HRDateTimeUtils.parseDate((String)dealData));
            }
            result.add(mapdata);
        }
        return result;
    }

    public DynamicObject[] getDataFromDb(String paramkey, String paramdata) {
        try {
            List<Long> searchIds = this.parseLongList(paramdata);
            HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper(paramkey);
            DynamicObject[] datas = baseServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", searchIds)});
            return datas;
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
        }
    }

    public Object invokeMethod(String cloudId, String appId, String serviceName, String methodName, List<Object> params) {
        if (params != null && params.size() > 10) {
            this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u53c2\u6570\u6761\u76ee\u4e0d\u80fd\u5927\u4e8e%s", (String)"SitSdkSpiTestPlugin_15", (String)"sit-sitbs-formplugin", (Object[])new Object[0]), 10));
            return null;
        }
        return SITMServiceUtils.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])(params == null ? null : params.toArray()));
    }

    public Object invokeSdkMethod(String serviceName, String methodName, List<Object> params, Class<?>[] paramTypes) {
        if (params != null && params.size() > 10) {
            this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u53c2\u6570\u6761\u76ee\u4e0d\u80fd\u5927\u4e8e%s", (String)"SitSdkSpiTestPlugin_15", (String)"sit-sitbs-formplugin", (Object[])new Object[0]), 10));
            return null;
        }
        Object result = null;
        try {
            if (paramTypes == null) {
                paramTypes = new Class[]{};
            }
            Class serviceClass = TypesContainer.getOrRegister((String)serviceName);
            Object instance = null;
            boolean isSpIService = serviceClass.isAnnotationPresent(SdkSPI.class);
            if (isSpIService) {
                instance = SitSdkSpiTestPlugin.getSpiInstance(serviceClass);
            }
            Method[] srcMethods = serviceClass.getMethods();
            Method targetMethod = null;
            for (Method srcMethod : srcMethods) {
                Class<?>[] srcParameterTypes;
                if (!srcMethod.getName().equals(methodName)) continue;
                if (!isSpIService && !Modifier.isStatic(srcMethod.getModifiers())) {
                    instance = TypesContainer.createInstance((Class)serviceClass);
                }
                if ((srcParameterTypes = srcMethod.getParameterTypes()).length != paramTypes.length) continue;
                targetMethod = srcMethod;
                boolean isAllMatch = true;
                for (int i = 0; i < srcParameterTypes.length; ++i) {
                    Class<?> srcParameterType = srcParameterTypes[i];
                    Class<?> paramType = paramTypes[i];
                    if (srcParameterType != null && srcParameterType.isAssignableFrom(paramType)) continue;
                    isAllMatch = false;
                    break;
                }
                if (isAllMatch) break;
            }
            if (targetMethod == null) {
                throw new KDBizException("no such method");
            }
            Object[] paramValues = new Object[]{};
            if (params != null) {
                paramValues = params.toArray();
            }
            result = targetMethod.invoke(instance, paramValues);
        }
        catch (Exception ex) {
            throw new KDBizException((Throwable)ex, new ErrorCode("", ex.toString()), new Object[0]);
        }
        return result;
    }

    public static Object getSpiInstance(Class<?> serviceClass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method[] methods = serviceClass.getMethods();
        Method instanceMethod = null;
        for (Method srcMethod : methods) {
            if (!Modifier.isStatic(srcMethod.getModifiers()) || !serviceClass.isAssignableFrom(srcMethod.getReturnType())) continue;
            instanceMethod = srcMethod;
            break;
        }
        if (instanceMethod == null) {
            instanceMethod = serviceClass.getMethod("get", new Class[0]);
        }
        return instanceMethod.invoke(null, new Object[0]);
    }

    public void saveToCache() {
        DynamicObject data = this.getModel().getDataEntity();
        String cloudid = data.getString(CLOUDID);
        String appId = data.getString(APPID);
        String serviceName = data.getString(SERVICENAME);
        String methodName = data.getString(METHODNAME);
        DynamicObjectCollection params = data.getDynamicObjectCollection(ENTRYENTITY);
        HashMap<String, Object> datas = new HashMap<String, Object>(8);
        datas.put(CLOUDID, cloudid);
        datas.put(APPID, appId);
        datas.put(SERVICENAME, serviceName);
        datas.put(METHODNAME, methodName);
        datas.put(ENTRYENTITY, params);
        datas.put(SERVICEDATE, new Date());
        String cacheStringData = (String)HRAppCache.get((String)APPID_HJM).get(this.getCacheKey(), String.class);
        List personalData = null;
        if (HRStringUtils.isNotEmpty((String)cacheStringData) && !methodName.contains("saveBizData")) {
            personalData = (List)SerializationUtils.deSerializeFromBase64((String)cacheStringData);
        }
        if (personalData == null) {
            personalData = new ArrayList<HashMap<String, Object>>();
        }
        personalData.add(datas);
        if (personalData.size() >= 500) {
            personalData.remove(0);
        }
        HRAppCache.get((String)APPID_HJM).remove(this.getCacheKey());
        HRAppCache.get((String)APPID_HJM).put(this.getCacheKey(), (Object)SerializationUtils.serializeToBase64(personalData));
        this.getDataFromCache();
    }

    private void getDataFromCache() {
        try {
            this.getModel().deleteEntryData(LISTENTRYENTITY);
            String cacheStringData = (String)HRAppCache.get((String)APPID_HJM).get(this.getCacheKey(), String.class);
            List personalData = null;
            if (HRStringUtils.isNotEmpty((String)cacheStringData)) {
                personalData = (List)SerializationUtils.deSerializeFromBase64((String)cacheStringData);
                this.getModel().batchCreateNewEntryRow(LISTENTRYENTITY, personalData.size());
                for (int i = 0; i < personalData.size(); ++i) {
                    Map datainfo = (Map)personalData.get(i);
                    this.getModel().setValue(LISTCLOUDID, datainfo.get(CLOUDID), i);
                    this.getModel().setValue(LISTAPPID, datainfo.get(APPID), i);
                    this.getModel().setValue(LISTSERVICENAME, datainfo.get(SERVICENAME), i);
                    this.getModel().setValue(LISTMETHODNAME, datainfo.get(METHODNAME), i);
                    DynamicObjectCollection params = (DynamicObjectCollection)datainfo.get(ENTRYENTITY);
                    StringBuilder sb = new StringBuilder();
                    for (DynamicObject entry : params) {
                        sb.append(HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)entry));
                        sb.append("\t\n");
                    }
                    this.getModel().setValue(LISTPARAMS, (Object)sb, i);
                    this.getModel().setValue(SERVICEDATE, datainfo.get(SERVICEDATE), i);
                }
            }
        }
        catch (Exception ex) {
            HRAppCache.get((String)APPID_HJM).remove(this.getCacheKey());
        }
    }

    private String getCacheKey() {
        return CACHE_KEY_PRE + RequestContext.get().getCurrUserId();
    }

    public Object dealDynaObjectData(Object datas) {
        if (datas == null) {
            return null;
        }
        if (datas instanceof DynamicObjectCollection) {
            DynamicObjectCollection coll = (DynamicObjectCollection)datas;
            ArrayList<HashMap> returnInfo = new ArrayList<HashMap>(coll.size());
            for (DynamicObject oo : coll) {
                HashMap map = (HashMap)HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)oo);
                returnInfo.add(map);
            }
            return returnInfo;
        }
        if (datas instanceof List) {
            List coll = (List)datas;
            ArrayList<Object> returnInfo = new ArrayList<Object>(coll.size());
            for (Object oo : coll) {
                returnInfo.add(this.dealDynaObjectData(oo));
            }
            return returnInfo;
        }
        if (datas.getClass().isArray()) {
            Object[] arrs = (Object[])datas;
            ArrayList<Object> returnInfo = new ArrayList<Object>(arrs.length);
            for (Object oo : arrs) {
                returnInfo.add(this.dealDynaObjectData(oo));
            }
            return returnInfo;
        }
        if (datas instanceof DynamicObject) {
            HashMap map = (HashMap)HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)((DynamicObject)datas));
            return map;
        }
        if (datas instanceof Map) {
            Map mapdata = (Map)datas;
            for (Map.Entry entry : mapdata.entrySet()) {
                Object oo = this.dealDynaObjectData(entry.getValue());
                mapdata.put(entry.getKey(), oo);
            }
            return mapdata;
        }
        return datas;
    }
}

