/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.sinsurbasecalrule;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hbp.formplugin.web.util.perm.HRPermUtil;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbs.business.socinsurance.basecalrule.service.SInsurBaseCalRuleService;
import kd.sit.sitbs.business.socinsurance.errinfo.SocInsuranceErrInfoEnum;
import kd.sit.sitbs.business.socinsurance.service.SInsuranceCommonService;

public class SInsurBaseCalRuleEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final String ADD_SOC_INSURE_ITEM = "addsinsuritem";
    private static final String ADD_SOC_CAL_FORMULA = "addcalformula";

    public void initialize() {
        super.initialize();
        this.getView().getPageCache().put("BOS.setRowDataByNumberDisable", Boolean.TRUE.toString());
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addClickListeners(new String[]{ADD_SOC_INSURE_ITEM, ADD_SOC_CAL_FORMULA});
        SInsuranceCommonService.createInstance().multiSetBeforeF7SelectListener((Object)this, new String[]{"insuritem", "calformula"});
    }

    public void afterCreateNewData(EventObject ex) {
        super.afterCreateNewData(ex);
        this.setCountryEnable();
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        this.updateEntryEntityFSeq();
        this.setCountryEnable();
    }

    public void setView(IFormView formView) {
        super.setView(formView);
        if (formView != null && BaseDataHisHelper.isHisPage((IFormView)formView)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"createorg", "ctrlstrategy"});
        }
    }

    private void updateEntryEntityFSeq() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        this.getModel().beginInit();
        int index = 0;
        for (DynamicObject entry : entryEntity) {
            entry.set("fseq", (Object)(++index));
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
        if (selectRows != null && selectRows.length > 0) {
            for (Object selectRow : (Object)selectRows) {
                if (selectRow < 0 || selectRow >= entryEntity.size()) continue;
                entryGrid.selectRows(selectRows, (int)selectRow);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        IDataEntityProperty property = beforeF7SelectEvent.getProperty();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        QFilter filter = null;
        switch (property.getName()) {
            case "insuritem": {
                filter = SInsurBaseCalRuleService.createInstance().getCommonQFilter(dataEntity, ((BasedataProp)beforeF7SelectEvent.getProperty()).getBaseEntityId());
                beforeF7SelectEvent.setCustomQFilters(Collections.singletonList(filter));
                break;
            }
            case "calformula": {
                if (this.checkBsedInvalid()) {
                    beforeF7SelectEvent.setCancel(true);
                    break;
                }
                filter = SInsurBaseCalRuleService.createInstance().getCommonQFilter(dataEntity, ((BasedataProp)beforeF7SelectEvent.getProperty()).getBaseEntityId());
                int row = beforeF7SelectEvent.getRow();
                DynamicObject entity = this.getModel().getEntryRowEntity("entryentity", row);
                long insurItemId = entity.getLong("insuritem.id");
                if (insurItemId != 0L) {
                    filter.and("resultitem", "=", (Object)insurItemId);
                }
                beforeF7SelectEvent.setCustomQFilters(Collections.singletonList(filter));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        ChangeData[] changeSet = args.getChangeSet();
        if (changeSet == null || changeSet.length == 0) {
            return;
        }
        IDataEntityProperty property = args.getProperty();
        switch (property.getName()) {
            case "insuritem": {
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", changeSet[0].getRowIndex());
                if (entryRowEntity == null || entryRowEntity.getLong("calformula.id") == 0L) break;
                this.getModel().beginInit();
                this.getModel().setValue("calformula", null, changeSet[0].getRowIndex());
                this.getModel().endInit();
                this.getView().updateView("calformula", changeSet[0].getRowIndex());
                break;
            }
            case "bsed": {
                Date oldBsed = (Date)changeSet[0].getOldValue();
                Date newBsed = (Date)changeSet[0].getNewValue();
                if (oldBsed != null && newBsed != null && newBsed.compareTo(oldBsed) >= 0) break;
                IDataModel model = this.getModel();
                DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
                for (DynamicObject entity : entryEntity) {
                    long calFormulaId = entity.getLong("calformula.id");
                    if (calFormulaId == 0L) continue;
                    model.beginInit();
                    int index = entity.getInt("seq") - 1;
                    model.setValue("calformula", null, index);
                    model.endInit();
                }
                this.getView().updateView("entryentity");
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (formOperate.getOperateKey()) {
            case "addsinsuritem": {
                this.openSocInsuranceBaseView("sitbs_insuranceitem");
                break;
            }
            case "addcalformula": {
                if (this.checkBsedInvalid()) break;
                this.openSocInsuranceBaseView("sitbs_sinsurformula");
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("deleteentry".equals(operateKey) || "moveentryup".equals(operateKey) || "moveentrydown".equals(operateKey)) {
            this.updateEntryEntityFSeq();
        }
    }

    private boolean checkBsedInvalid() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (dataEntity.getDate("bsed") == null) {
            this.getView().showTipNotification(SocInsuranceErrInfoEnum.BASE_CAL_RULE_FOR_BSED_IS_NULL.getErrInfo());
            return true;
        }
        return false;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (closedCallBackEvent.getActionId()) {
            case "sitbs_insuranceitem": {
                this.updateEntryEntity(returnData, "sitbs_insuranceitem");
                break;
            }
            case "sitbs_sinsurformula": {
                this.updateEntryEntity(returnData, "sitbs_sinsurformula");
                break;
            }
        }
    }

    public void openSocInsuranceBaseView(String entityNumber) {
        int currRowIndex = ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).getEntryState("entryentity").getFocusRow();
        this.getModel().setEntryCurrentRowIndex("entryentity", currRowIndex);
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)entityNumber, (boolean)true);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, entityNumber));
        QFilter filter = SInsurBaseCalRuleService.createInstance().getCommonQFilter(this.getModel().getDataEntity(true), entityNumber);
        showParameter.setListFilterParameter(new ListFilterParameter(Arrays.asList(filter.toArray()), null));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void updateEntryEntity(Object returnData, String entityNumber) {
        ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)returnData;
        if (listSelectedRowCollection == null || listSelectedRowCollection.isEmpty()) {
            return;
        }
        Set newItemIds = listSelectedRowCollection.stream().map(obj -> (Long)obj.getPrimaryKeyValue()).collect(Collectors.toCollection(LinkedHashSet::new));
        boolean isFormula = "sitbs_sinsurformula".equals(entityNumber);
        Map<Long, Long> formulaAndRefItemMap = new LinkedHashMap(0);
        LinkedHashMap itemRefFormulaMap = new LinkedHashMap(16);
        if ("sitbs_sinsurformula".equals(entityNumber)) {
            formulaAndRefItemMap = SInsurBaseCalRuleService.createInstance().getFormulaAndRefItemMap((Collection)newItemIds);
            formulaAndRefItemMap.forEach((key, val) -> itemRefFormulaMap.put(val, key));
        }
        String fieldKey = SInsurBaseCalRuleService.createInstance().getFieldKey(entityNumber);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        Set existedItemIds = entryEntity.stream().map(entryDyObj -> entryDyObj.getLong(fieldKey)).collect(Collectors.toSet());
        newItemIds.removeAll(existedItemIds);
        HashSet<Long> existedInsuranceItemIds = new HashSet<Long>(16);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int index = 0;
        for (DynamicObject lastInsuranceItemDyObj : entryEntity) {
            long sInsurItemId = lastInsuranceItemDyObj.getLong("insuritem.id");
            Long formulaId = (Long)itemRefFormulaMap.get(sInsurItemId);
            if (formulaId == null) {
                formulaId = lastInsuranceItemDyObj.getLong("calformula.id");
            } else {
                formulaAndRefItemMap.values().remove(sInsurItemId);
            }
            formulaId = Long.valueOf(0L).equals(formulaId) ? null : formulaId;
            vs.set("insuritem", (Object)sInsurItemId, index);
            vs.set("calformula", (Object)formulaId, index);
            vs.set("fseq", (Object)(index + 1), index);
            existedInsuranceItemIds.add(sInsurItemId);
            ++index;
        }
        for (Long itemId : newItemIds) {
            if (isFormula) {
                Long sinsurItemId = (Long)formulaAndRefItemMap.get(itemId);
                if (sinsurItemId == null || Long.valueOf(0L).equals(sinsurItemId) || !existedInsuranceItemIds.add(sinsurItemId)) continue;
                vs.set("insuritem", (Object)sinsurItemId, index);
                vs.set("calformula", (Object)itemId, index);
                vs.set("fseq", (Object)(index + 1), index);
                ++index;
                continue;
            }
            vs.set("insuritem", (Object)itemId, index);
            vs.set("fseq", (Object)(index + 1), index);
            ++index;
        }
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void setCountryEnable() {
        OperationStatus viewStatus = this.getView().getFormShowParameter().getStatus();
        DynamicObject countryDy = this.getModel().getDataEntity(true).getDynamicObject("country");
        if (countryDy == null) {
            this.getView().showErrorNotification(SocInsuranceErrInfoEnum.PERIOD_TYPE_WITHOUT_COUNTRY_PERMISSION.getErrInfo(new Object[]{SocInsuranceErrInfoEnum.COMMON_COUNTRY_CHINA.getErrInfo()}));
            return;
        }
        if (OperationStatus.ADDNEW.equals((Object)viewStatus) && !HRObjectUtils.isEmpty((Object)countryDy)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String appId = HRPermUtil.getAppIdFromShowParam((FormShowParameter)formShowParameter);
            Set countryIds = SITPermissionServiceHelper.getCountrySetByPermItem((String)appId, (String)"sitbs_basecalrule", (String)"47150e89000000ac");
            Long currCountryId = countryDy.getLong("id");
            if (countryIds != null && !countryIds.contains(currCountryId)) {
                this.getModel().setValue("country", null);
                this.getView().showErrorNotification(SocInsuranceErrInfoEnum.PERIOD_TYPE_WITHOUT_COUNTRY_PERMISSION.getErrInfo(new Object[]{countryDy.getString("name")}));
            } else {
                this.getModel().setValue("country", (Object)1000001L);
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"country"});
        }
    }
}

