/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.sinsurbasefetchitem;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbs.business.socinsurance.basefetchitem.service.BaseFetchItemService;

public class SocInsuranceBaseFetchItemList
extends HRDataBaseList {
    private Log log = LogFactory.getLog(SocInsuranceBaseFetchItemList.class);
    private final String SINSUR_BS_FETCH_CFG_NAME = "sinsurbsfetchcfgname";
    private final String SINSUR_BS_FETCH_ITEM_AND_CFG_REF = "SINSUR_BS_FETCH_ITEM_AND_CFG_REF";

    public void setFilter(SetFilterEvent event) {
        event.setOrderBy("createtime desc,number asc");
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        IListDataProvider listDataProvider = args.getListDataProvider();
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        DynamicObjectCollection rows = event.getPageData();
        if (rows == null || rows.isEmpty()) {
            return;
        }
        List billIds = rows.stream().map(object -> object.getLong("id")).collect(Collectors.toList());
        Map resultMap = BaseFetchItemService.getBaseFetchCfgInfoByStatus(billIds, (int)1);
        GlobalParam.set((String)"SINSUR_BS_FETCH_ITEM_AND_CFG_REF", (Object)resultMap);
    }

    public void packageData(PackageDataEvent evt) {
        super.packageData(evt);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)evt.getSource();
        Map baseFetchCfgInfoMap = (Map)GlobalParam.get((String)"SINSUR_BS_FETCH_ITEM_AND_CFG_REF");
        if (baseFetchCfgInfoMap == null || baseFetchCfgInfoMap.isEmpty()) {
            return;
        }
        switch (columnDesc.getKey()) {
            case "sinsurbsfetchcfgname": {
                Long billId = evt.getRowData().getLong("id");
                Map baseFetchCfgInfo = (Map)baseFetchCfgInfoMap.get(billId);
                if (baseFetchCfgInfo == null || baseFetchCfgInfo.get("name") == null) break;
                evt.setFormatValue(baseFetchCfgInfo.get("name"));
                break;
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent event) {
        BillShowParameter parameter = event.getParameter();
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if ("sinsurbsfetchcfgname".equals(fieldName)) {
            args.setCancel(true);
            IListView listView = (IListView)this.getView();
            Long baseFetchItemId = Long.valueOf(String.valueOf(listView.getFocusRowPkId()));
            Map baseFetchCfgInfo = (Map)BaseFetchItemService.getBaseFetchCfgInfoByStatus(Collections.singletonList(baseFetchItemId), (int)1).get(baseFetchItemId);
            if (baseFetchCfgInfo == null || baseFetchCfgInfo.get("id") == null) {
                return;
            }
            Long baseFetchCfgId = Long.parseLong((String)baseFetchCfgInfo.get("id"));
            BaseShowParameter baseShowParameter = new BaseShowParameter();
            baseShowParameter.setPkId((Object)baseFetchCfgId);
            baseShowParameter.setStatus(OperationStatus.VIEW);
            baseShowParameter.setCustomParam("boid", (Object)baseFetchCfgId);
            baseShowParameter.setBillStatus(BillOperationStatus.AUDIT);
            baseShowParameter.setCustomParam("fromPage", (Object)"fromHisAction");
            baseShowParameter.setCustomParam("fromHisPageToEdit", (Object)"fromHisAction");
            baseShowParameter.setCustomParam("hideHisversion", (Object)Boolean.TRUE.toString());
            String appId = this.getView().getFormShowParameter().getCheckRightAppId();
            String pageId = this.getView().getPageId() + appId + baseFetchCfgId;
            baseShowParameter.setPageId(pageId);
            baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            baseShowParameter.setFormId("hsbs_sinsbsfetchcfg");
            this.log.info("SocInsuranceBaseFetchItemList.billListHyperLinkClick: begin to open baseFetchCfg.");
            this.getView().showForm((FormShowParameter)baseShowParameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "delete": {
                super.beforeDoOperation(args);
                SocInsuranceBaseFetchItemList.ignoreRefEntityIds(formOperate);
                break;
            }
        }
    }

    public static void ignoreRefEntityIds(FormOperate formOperate) {
        StringJoiner ignoreEntityNames = new StringJoiner(",");
        formOperate.getOption().setVariableValue("ignorerefentityids", ignoreEntityNames.toString());
    }
}

