/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.sinsurformula;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.formula.entity.item.ResultItem;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.business.service.formula.utils.FormulaTreeNodeUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.formula.FormulaSettingEdit;
import kd.hr.hbp.formplugin.web.util.perm.HRPermUtil;
import kd.sdk.sit.sitbp.entity.SInsurFormulaConditionDTO;
import kd.sdk.sit.sitbp.service.spi.SInsurCalItemUniCodeResolver;
import kd.sit.sitbp.business.formula.sinsurbuilder.SInsurBaseFormulaNodeItemBuilder;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.enums.CalDataTypeEnum;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbs.business.socinsurance.errinfo.SocInsuranceErrInfoEnum;
import kd.sit.sitbs.business.socinsurance.service.SInsuranceCommonService;

public class SinsurCalFormulaEdit
extends FormulaSettingEdit
implements BeforeF7SelectListener {
    public static final String RESULT_ITEM = "resultitem";
    public static final String BAR_DISABLE = "bar_disable";

    public void registerListener(EventObject ex) {
        super.registerListener(ex);
        BasedataEdit resultItem = (BasedataEdit)this.getControl(RESULT_ITEM);
        resultItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit insurTypeEdit = (BasedataEdit)this.getControl("insurtype");
        insurTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject ex) {
        super.afterCreateNewData(ex);
        this.setPropDataEnable();
        this.setCountryEnable();
    }

    public void beforeBindData(EventObject ex) {
        super.beforeBindData(ex);
        this.setPropDataEnable();
        this.setCountryEnable();
    }

    public void afterBindData(EventObject ex) {
        String status;
        super.afterBindData(ex);
        switch (status = this.getModel().getDataEntity().getString("status")) {
            case "A": 
            case "B": {
                this.getView().setEnable(Boolean.TRUE, new String[]{BAR_DISABLE});
                break;
            }
        }
    }

    protected Optional<List<TreeNodeItem>> getDataGradeItemList() {
        return Optional.of(new ArrayList(0));
    }

    protected Optional<List<TreeNodeItem>> getTreeNodeItemList() {
        LinkedList<TreeNodeItem> treeNodeItems = new LinkedList<TreeNodeItem>();
        if (!this.getModel().isDataLoaded()) {
            return Optional.of(treeNodeItems);
        }
        treeNodeItems.addAll(this.getAllTreeNodeList());
        FormulaTreeNodeUtils.loadTreeNodeItemList(treeNodeItems).ifPresent(treeNodes -> {
            TreeView treeView = (TreeView)this.getView().getControl("itemtreeview");
            treeView.deleteAllNodes();
            treeView.addNodes(treeNodes);
        });
        return Optional.of(treeNodeItems);
    }

    public void propertyChanged(PropertyChangedArgs ex) {
        String name;
        IDataEntityProperty property = ex.getProperty();
        switch (name = property.getName()) {
            case "country": {
                this.countryChanged();
                break;
            }
            case "insurtype": {
                this.sinsurTypeChanged();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        switch (fieldKey) {
            case "insurtype": {
                long countryId = this.getModel().getDataEntity().getLong("country.id");
                if (countryId == 0L) {
                    beforeF7SelectEvent.setCancel(true);
                    this.getView().showTipNotification(SocInsuranceErrInfoEnum.COUNTRY_NOT_EXISTS.getErrInfo());
                    return;
                }
                showParameter.getListFilterParameter().setFilter(new QFilter("country.id", "=", (Object)countryId));
                break;
            }
            case "resultitem": {
                long sinsurTypeId = this.getModel().getDataEntity().getLong("insurtype.id");
                if (sinsurTypeId == 0L) {
                    beforeF7SelectEvent.setCancel(true);
                    this.getView().showTipNotification(SocInsuranceErrInfoEnum.INSUR_TYPE_NOT_EXISTS.getErrInfo());
                    return;
                }
                beforeF7SelectEvent.getFormShowParameter().setFormId("bos_templatetreelistf7");
                ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).setBillFormId("sitbs_insuranceitem");
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("group", "=", (Object)sinsurTypeId));
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (event.getResult() == MessageBoxResult.Yes) {
            switch (event.getCallBackId()) {
                case "isClearFormula": {
                    this.clearFormula();
                    break;
                }
            }
        }
    }

    protected void initItemTree(List<TreeNodeItem> treeNodeCacheList, boolean isUpdateCache) {
        super.initItemTree(treeNodeCacheList, isUpdateCache);
    }

    protected void initDataGradeTree(List<TreeNodeItem> treeNodeCacheList, boolean isUpdateCache) {
        super.initDataGradeTree(treeNodeCacheList, isUpdateCache);
    }

    protected Optional<List<ResultItem>> getResultItemList() {
        if (!this.getModel().isDataLoaded()) {
            return Optional.empty();
        }
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>(10);
        long countryId = this.getModel().getDataEntity().getLong("country.id");
        long insurTypeId = this.getModel().getDataEntity().getLong("insurtype.id");
        if (countryId != 0L && insurTypeId != 0L) {
            HRBaseServiceHelper helper = HRBaseServiceHelper.create((String)"sitbs_insuranceitem");
            QFilter filter = new QFilter("group", "=", (Object)insurTypeId);
            filter.and(SInsuranceCommonService.getAuditAndEnableQFilter());
            DynamicObject[] insuranceItemDys = helper.loadDynamicObjectArray(filter.toArray());
            if (insuranceItemDys == null || insuranceItemDys.length == 0) {
                return Optional.empty();
            }
            for (DynamicObject insuranceItemDy : insuranceItemDys) {
                ResultItem resultItem = new ResultItem();
                String id = insuranceItemDy.getString("id");
                String uniCode = SInsurCalItemUniCodeResolver.getResolverBy((String)"II").uniCode(id);
                resultItem.setId(id);
                resultItem.setUniqueCode(uniCode);
                resultItem.setParentId("II");
                resultItem.setItemCategory("II");
                resultItem.setName(insuranceItemDy.getString("name"));
                long dataTypeId = insuranceItemDy.getLong("datatype.id");
                resultItem.setDataType(CalDataTypeEnum.getEnumById((long)dataTypeId));
                resultItem.setCustomItem(false);
                resultItem.setGlobalEffect(true);
                resultItem.setCalProportionItem(false);
                if (SitDataTypeEnum.AMOUNT.getId() == dataTypeId) {
                    resultItem.setScale(Integer.valueOf(insuranceItemDy.getInt("group.currency.amtprecision")));
                } else {
                    resultItem.setScale(Integer.valueOf(insuranceItemDy.getInt("dataprecision.scale")));
                }
                SitDataTypeEnum enumById = SitDataTypeEnum.getEnumById((long)dataTypeId);
                resultItem.setDataLength(Integer.valueOf(enumById.getDefLen()));
                resultItems.add(resultItem);
            }
        }
        return Optional.of(resultItems);
    }

    private List<TreeNodeItem> getAllTreeNodeList() {
        List<Object> treeNodeItems = new LinkedList<TreeNodeItem>();
        long countryId = this.getModel().getDataEntity().getLong("country.id");
        if (countryId == 0L) {
            return treeNodeItems;
        }
        long insurTypeId = this.getModel().getDataEntity(true).getLong("insurtype.id");
        String appId = this.getView().getFormShowParameter().getAppId();
        long createorgId = this.getModel().getDataEntity().getLong("createorg.id");
        ArrayList<SInsurFormulaConditionDTO> sInsurFormulaConditionDTOS = new ArrayList<SInsurFormulaConditionDTO>(10);
        sInsurFormulaConditionDTOS.add(new SInsurFormulaConditionDTO(Long.valueOf(insurTypeId), Long.valueOf(countryId), appId, Long.valueOf(createorgId), "$"));
        treeNodeItems = SInsurBaseFormulaNodeItemBuilder.getTreeNodeItem(sInsurFormulaConditionDTOS);
        return treeNodeItems;
    }

    private void clearFormula() {
        CustomControl formulaEditor = (CustomControl)this.getView().getControl("formulaeditor");
        HashMap<String, String> data = new HashMap<String, String>(8);
        data.put("method", "setValue");
        data.put("value", "");
        data.put("date", String.valueOf(new Date().getTime()));
        formulaEditor.setData(data);
    }

    private void refleshTree() {
        this.initItemTree(this.getAllTreeNodeList(), true);
        this.initDataGradeTree(new ArrayList<TreeNodeItem>(0), true);
    }

    private void sinsurTypeChanged() {
        this.getModel().setValue(RESULT_ITEM, null);
        this.refleshTree();
        String formula = (String)this.getModel().getValue("originalexp");
        if (StringUtils.isNotBlank((CharSequence)formula)) {
            this.getView().showConfirm(SocInsuranceErrInfoEnum.COMMON_MAKE_SURE_TO_CLEAR_FORMULA.getErrInfo(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("isClearFormula", ""));
        }
        Optional<List<ResultItem>> resultItemList = this.getResultItemList();
        this.initResultItemCache(resultItemList.orElseGet(() -> new ArrayList(0)), true);
    }

    private void countryChanged() {
        this.getModel().setValue("insurtype", null);
        this.getModel().setValue(RESULT_ITEM, null);
        this.refleshTree();
        this.clearFormula();
    }

    private void setPropDataEnable() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String option = (String)customParams.get("option");
        Long boid = (Long)customParams.get("boid");
        if (boid != null && ("insertdata_his".equals(option) || "showhisversion".equals(option))) {
            DynamicObject formulaDy = this.getCurrentVersionDy(boid);
            IDataModel model = this.getView().getModel();
            model.setValue("number", (Object)formulaDy.getString("number"));
            model.setValue("insurtype", (Object)formulaDy.getLong("insurtype.id"));
            model.setValue(RESULT_ITEM, (Object)formulaDy.getLong("resultitem.id"));
            this.getView().setEnable(Boolean.FALSE, new String[]{"insurtype", RESULT_ITEM, "number"});
        }
    }

    private void setCountryEnable() {
        OperationStatus viewStatus = this.getView().getFormShowParameter().getStatus();
        DynamicObject countryDy = this.getModel().getDataEntity(true).getDynamicObject("country");
        if (countryDy == null) {
            this.getView().showErrorNotification(SocInsuranceErrInfoEnum.PERIOD_TYPE_WITHOUT_COUNTRY_PERMISSION.getErrInfo(new Object[]{SocInsuranceErrInfoEnum.COMMON_COUNTRY_CHINA.getErrInfo()}));
            return;
        }
        if (OperationStatus.ADDNEW.equals((Object)viewStatus) && !HRObjectUtils.isEmpty((Object)countryDy)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String appId = HRPermUtil.getAppIdFromShowParam((FormShowParameter)formShowParameter);
            Set countryIds = SITPermissionServiceHelper.getCountrySetByPermItem((String)appId, (String)"sitbs_sinsurformula", (String)"47150e89000000ac");
            Long currCountryId = countryDy.getLong("id");
            if (countryIds != null && !countryIds.contains(currCountryId)) {
                this.getModel().setValue("country", null);
                this.getView().showErrorNotification(SocInsuranceErrInfoEnum.PERIOD_TYPE_WITHOUT_COUNTRY_PERMISSION.getErrInfo(new Object[]{countryDy.getString("name")}));
            } else {
                this.getModel().setValue("country", (Object)1000001L);
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"country"});
        }
    }

    private DynamicObject getCurrentVersionDy(long boid) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_sinsurformula");
        QFilter qFilter = new QFilter("boid", "=", (Object)boid);
        qFilter.and("iscurrentversion", "=", (Object)Boolean.TRUE);
        return helper.queryOne("id,name,number,insurtype.id,resultitem", qFilter);
    }
}

