/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.sinsurperiod;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sit.sitbp.common.enums.FrequencyEnum;
import kd.sit.sitbp.common.util.SITDateTimeUtils;
import kd.sit.sitbp.common.util.SITInteDateTimeUtil;
import kd.sit.sitbp.common.util.SitDateUtil;
import kd.sit.sitbs.business.socinsurance.errinfo.SocInsuranceErrInfoEnum;
import kd.sit.sitbs.business.socinsurance.period.helper.SocInsurancePeriodHelper;

public class SocInsurancePeriodEdit
extends HRDataBaseEdit
implements ItemClickListener {
    private static final Log LOGGER = LogFactory.getLog(SocInsurancePeriodEdit.class);
    private static final String BTN_CANCEL = "btncancel";
    private static final String BTN_SAVE = "btnsave";
    private static final String BTN_CLOSE = "btnclose";

    public void registerListener(EventObject ex) {
        super.registerListener(ex);
        this.addClickListeners(new String[]{"enddate"});
    }

    public void afterCreateNewData(EventObject ex) {
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        String periodType = pageCache.get("currentNodeId");
        if (periodType != null) {
            this.getModel().setValue("periodtype", (Object)periodType.substring(0, periodType.length() - 2));
        } else {
            this.getModel().setValue("periodtype", null);
        }
    }

    public void afterBindData(EventObject ex) {
        super.afterBindData(ex);
        DynamicObject period = this.getModel().getDataEntity();
        IFormView view = this.getView();
        String periodId = period.getString("id");
        if (StringUtils.isNotBlank((CharSequence)periodId) && !StringUtils.equals((CharSequence)"0", (CharSequence)periodId)) {
            this.setRefStatus(periodId);
            this.getModel().setDataChanged(false);
        }
        if ("1".equals(period.getString("refstatus"))) {
            view.setEnable(Boolean.FALSE, new String[]{"name", "periodrange", "perioddate"});
            view.setVisible(Boolean.FALSE, new String[]{BTN_CANCEL, BTN_SAVE});
            view.setVisible(Boolean.TRUE, new String[]{BTN_CLOSE});
            return;
        }
        if (OperationStatus.VIEW != this.getView().getFormShowParameter().getStatus()) {
            view.setVisible(Boolean.FALSE, new String[]{BTN_CLOSE});
        }
    }

    public void propertyChanged(PropertyChangedArgs ex) {
        IDataEntityProperty property = ex.getProperty();
        String name = property.getName();
        IDataModel model = this.getModel();
        switch (name) {
            case "enddate": {
                model.setValue("perioddate", model.getValue("enddate"));
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        DynamicObject periodDy = this.getModel().getDataEntity(true);
        DynamicObject periodTypeObj = periodDy.getDynamicObject("periodtype");
        if (HRObjectUtils.isEmpty((Object)periodTypeObj)) {
            this.getView().showErrorNotification(SocInsuranceErrInfoEnum.PERIOD_TYPE_NOT_EXISTS.getErrInfo());
            args.setCancel(true);
            return;
        }
        long frequencyId = periodTypeObj.getLong("calfrequency.id");
        DynamicObject frequency = new HRBaseServiceHelper("sitbs_calfrequency").loadSingle((Object)frequencyId);
        String frequencyType = frequency.getString("type");
        switch (operateKey) {
            case "save": {
                RefObject refObject = new RefObject();
                OperateOption option = operate.getOption();
                if (!this.validatePeriodDate()) {
                    args.setCancel(true);
                    return;
                }
                FrequencyEnum frequencyEnum = FrequencyEnum.valueOf((String)frequencyType);
                if (!this.checkUnneeded(operate.getOption(), Arrays.asList(SocInsuranceErrInfoEnum.CAL_FREQUENCY_INVALID, SocInsuranceErrInfoEnum.PERIOD_YEAR_AND_START_OR_END_TIME_ERROR))) {
                    StringBuilder mainSb = new StringBuilder();
                    Boolean isInvalid = this.validateDateStandard(frequencyEnum, mainSb);
                    if (isInvalid == null) break;
                    List<String> periodStartAndEndDateErrMsgs = null;
                    if (frequencyEnum == FrequencyEnum.MONTH) {
                        periodStartAndEndDateErrMsgs = this.validatePeriodStartAndEndDate();
                    }
                    if (isInvalid.booleanValue() || !CollectionUtils.isEmpty(periodStartAndEndDateErrMsgs)) {
                        args.setCancel(true);
                        StringJoiner errorMsg = new StringJoiner("\n");
                        if (periodStartAndEndDateErrMsgs != null) {
                            periodStartAndEndDateErrMsgs.forEach(errorMsg::add);
                        }
                        if (isInvalid.booleanValue()) {
                            errorMsg.add(MessageFormat.format(SocInsuranceErrInfoEnum.CAL_FREQUENCY_INVALID.getErrInfo(), frequencyEnum.getI18nName().loadKDString(), frequencyEnum.getTips()));
                        }
                        String mainFailMessage = SocInsuranceErrInfoEnum.PERIOD_START_AND_END_DATE_MAY_INVALID.getErrInfo(new Object[]{mainSb});
                        this.getView().showConfirm(mainFailMessage, errorMsg.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Save, new ConfirmCallBackListener(SocInsuranceErrInfoEnum.CAL_FREQUENCY_INVALID.getErrCode()));
                        return;
                    }
                }
                if (option.tryGetVariableValue(SocInsuranceErrInfoEnum.PERIOD_YEAR_AND_START_OR_END_TIME_ERROR.getErrCode(), refObject)) break;
                int startDate = SitDateUtil.toYearMonth((Date)periodDy.getDate("startdate"));
                int endDate = SitDateUtil.toYearMonth((Date)periodDy.getDate("enddate"));
                int periodDate = SitDateUtil.toYearMonth((Date)periodDy.getDate("perioddate"));
                if (FrequencyEnum.MONTH == frequencyEnum || periodDate == startDate || periodDate == endDate) break;
                this.getView().showConfirm(SocInsuranceErrInfoEnum.PERIOD_YEAR_AND_START_OR_END_TIME_ERROR.getErrInfo(), MessageBoxOptions.YesNo, ConfirmTypes.Save, new ConfirmCallBackListener(SocInsuranceErrInfoEnum.PERIOD_YEAR_AND_START_OR_END_TIME_ERROR.getErrCode()));
                args.setCancel(true);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String callBackId = messageBoxClosedEvent.getCallBackId();
            if (SocInsuranceErrInfoEnum.CAL_FREQUENCY_INVALID.getErrCode().equals(callBackId) || SocInsuranceErrInfoEnum.PERIOD_YEAR_AND_START_OR_END_TIME_ERROR.getErrCode().equals(callBackId)) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(callBackId, Boolean.TRUE.toString());
                this.getView().invokeOperation("save", operateOption);
            }
        }
    }

    private boolean validatePeriodDate() {
        DynamicObject period = this.getModel().getDataEntity();
        Date periodStartDate = period.getDate("startdate");
        Date periodEndDate = period.getDate("enddate");
        if (periodStartDate != null && periodEndDate != null) {
            periodStartDate = SITDateTimeUtils.getDayDate((Date)periodStartDate);
            if (!(periodEndDate = SITDateTimeUtils.getDayDate((Date)periodEndDate)).after(periodStartDate)) {
                this.getView().showErrorNotification(SocInsuranceErrInfoEnum.START_TIME_CAN_MUST_BEFORE_END_TIME.getErrInfo());
                return false;
            }
            this.getModel().setValue("startdate", (Object)periodStartDate);
            this.getModel().setValue("enddate", (Object)periodEndDate);
        }
        return true;
    }

    private boolean checkUnneeded(OperateOption option, List<SocInsuranceErrInfoEnum> errInfoEnums) {
        RefObject refObject = new RefObject();
        for (SocInsuranceErrInfoEnum errInfoEnum : errInfoEnums) {
            if (!option.tryGetVariableValue(errInfoEnum.getErrCode(), refObject)) continue;
            return true;
        }
        return false;
    }

    private Boolean validateDateStandard(FrequencyEnum frequencyEnum, StringBuilder stringBuilder) {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        Date startDate = dynamicObject.getDate("startdate");
        Date endDate = dynamicObject.getDate("enddate");
        if (startDate == null || endDate == null) {
            return null;
        }
        stringBuilder.append(SITInteDateTimeUtil.formateDate((Date)startDate));
        stringBuilder.append('-');
        stringBuilder.append(SITInteDateTimeUtil.formateDate((Date)endDate));
        long interval = HRDateTimeUtils.dateDiff((String)"d", (Date)startDate, (Date)endDate) + 1L;
        return this.dateDiff(frequencyEnum, interval);
    }

    private List<String> validatePeriodStartAndEndDate() {
        ArrayList<String> errInfoList = new ArrayList<String>(16);
        this.checkDateInvalid(errInfoList, "startdate", "startday", SocInsuranceErrInfoEnum.PERIOD_AND_PERIOD_TYPE_START_DATE_NOT_SAME);
        this.checkDateInvalid(errInfoList, "enddate", "endday", SocInsuranceErrInfoEnum.PERIOD_AND_PERIOD_TYPE_END_DATE_NOT_SAME);
        return errInfoList;
    }

    private void checkDateInvalid(ArrayList<String> errInfoList, String periodDate, String periodTypeDate, SocInsuranceErrInfoEnum socInsuranceErrInfoEnum) {
        String errDes;
        DynamicObject periodInfoDy = this.getModel().getDataEntity(true);
        DynamicObject periodTypeInfoDy = periodInfoDy.getDynamicObject("periodtype");
        Calendar calendar = Calendar.getInstance();
        Date date = periodInfoDy.getDate(periodDate);
        if (date == null) {
            return;
        }
        calendar.setTime(periodInfoDy.getDate(periodDate));
        int periodDay = calendar.get(5);
        int periodTypeDay = periodTypeInfoDy.getInt(periodTypeDate);
        if (periodTypeDay == 31) {
            periodTypeDay = calendar.getActualMaximum(5);
            errDes = SocInsuranceErrInfoEnum.PERIOD_LAST_DAY_DES.getErrInfo();
        } else {
            errDes = SocInsuranceErrInfoEnum.PERIOD_DAY_DES.getErrInfo(new Object[]{periodTypeDay});
        }
        if (periodTypeDay != periodDay) {
            errInfoList.add(socInsuranceErrInfoEnum.getErrInfo(new Object[]{errDes}));
        }
    }

    private void setRefStatus(String periodId) {
        BasedataEntityType basedataEntityType = SocInsurancePeriodHelper.getBaseDataEntityType((String)"sitbs_sinsurperiod", (String)periodId);
        Map checkResult = SocInsurancePeriodHelper.baseDataCheckReference((BasedataEntityType)basedataEntityType, (Object[])new Object[]{periodId});
        if (checkResult.containsKey(Long.valueOf(periodId))) {
            this.getModel().setValue("refstatus", (Object)"1");
        }
    }

    private boolean dateDiff(FrequencyEnum frequencyEnum, long interval) {
        if (frequencyEnum == FrequencyEnum.YEAR || frequencyEnum == FrequencyEnum.HALF_YEAR || frequencyEnum == FrequencyEnum.SEASON || frequencyEnum == FrequencyEnum.MONTH) {
            return interval < (long)frequencyEnum.getBeginIndex() || interval > (long)frequencyEnum.getEndIndex();
        }
        return false;
    }
}

