/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.sinsurperiod;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class SocInsurancePeriodExportPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(SocInsurancePeriodExportPlugin.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterExportFile(ExportFileEvent ex) {
        File file = ex.getFile();
        if (file != null) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"sitbs_sinsurperiod");
            ComboProp refStatus = (ComboProp)mainEntityType.getProperty("refstatus");
            List comboItems = refStatus.getComboItems();
            String fieldName = refStatus.getDisplayName().getLocaleValue();
            XSSFWorkbook wb = null;
            FileOutputStream out = null;
            try (FileInputStream fis = new FileInputStream(file);){
                wb = new XSSFWorkbook((InputStream)fis);
                Sheet sheet = wb.getSheetAt(0);
                Iterator rowIterator = sheet.rowIterator();
                int columnIndex = 0;
                while (rowIterator.hasNext()) {
                    Row row = (Row)rowIterator.next();
                    int rowNum = row.getRowNum();
                    if (rowNum == 0) {
                        Iterator cellIterator = row.cellIterator();
                        while (cellIterator.hasNext()) {
                            Cell cell = (Cell)cellIterator.next();
                            if (!fieldName.equals(cell.getStringCellValue())) continue;
                            columnIndex = cell.getColumnIndex();
                        }
                        continue;
                    }
                    Cell cell = row.getCell(columnIndex);
                    if (cell == null) continue;
                    CellStyle cellStyle = cell.getCellStyle();
                    for (ValueMapItem comboItem : comboItems) {
                        if (!comboItem.getValue().equals(cell.getStringCellValue())) continue;
                        cell = row.createCell(columnIndex);
                        cell.setCellStyle(cellStyle);
                        cell.setCellValue(comboItem.getName().getLocaleValue());
                    }
                }
                out = new FileOutputStream(file);
                wb.write((OutputStream)out);
                out.close();
            }
            catch (Throwable ext) {
                logger.error(ext);
            }
            finally {
                try {
                    if (wb != null) {
                        wb.close();
                    }
                }
                catch (IOException iex) {
                    logger.error((Throwable)iex);
                }
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e1) {
                    logger.error((Throwable)e1);
                }
            }
        }
    }
}

