/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.sinsurperiod;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sit.sitbp.business.appnum.AppHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.enums.FrequencyEnum;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import kd.sit.sitbs.business.socinsurance.errinfo.SocInsuranceErrInfoEnum;
import kd.sit.sitbs.business.socinsurance.period.helper.SocInsurancePeriodHelper;

public class SocInsurancePeriodGeneratePlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(SocInsurancePeriodGeneratePlugin.class);
    private static Date newPeriodStartDate;

    public void afterCreateNewData(EventObject ex) {
        Long periodTypeId = (Long)BaseDataConverter.convert((Object)this.getFormShowParameter().getCustomParam("periodtype.id"), Long.class);
        DynamicObject dynamicObject = new HRBaseServiceHelper("sitbs_sinsurperiodtype").loadSingle((Object)periodTypeId);
        this.getModel().setValue("periodtype", (Object)dynamicObject);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("batchgenerate".equals(operateKey)) {
            if (this.checkField()) {
                args.setCancel(true);
                return;
            }
            if (!SITPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)AppHelper.getAppNumberById((String)this.getView().getFormShowParameter().getCheckRightAppId()), (String)"sitbs_sinsurperiod", (String)"47156aff000000ac")) {
                this.getView().showTipNotification(SocInsuranceErrInfoEnum.PERIOD_WITHOUT_PERMISSION_ADD_NEW.getErrInfo());
                args.setCancel(true);
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            long periodTypeId = dataEntity.getLong("periodtype.id");
            DynamicObject periodTypeDy = new HRBaseServiceHelper("sitbs_sinsurperiodtype").loadSingle((Object)periodTypeId);
            if (HRObjectUtils.isEmpty((Object)periodTypeDy)) {
                this.getView().showErrorNotification(SocInsuranceErrInfoEnum.PERIOD_TYPE_NOT_EXISTS.getErrInfo());
                args.setCancel(true);
                return;
            }
            FrequencyEnum frequencyEnum = FrequencyEnum.valueOf((String)periodTypeDy.getString("calfrequency.type"));
            if (FrequencyEnum.MONTH != frequencyEnum) {
                args.setCancel(true);
                this.getView().showErrorNotification(SocInsuranceErrInfoEnum.CAN_NOT_ADD_PERIOD_TYPE_FOR_CURR_FREQUENCY.getErrInfo());
                args.setCancel(true);
                return;
            }
            DynamicObject countryDy = periodTypeDy.getDynamicObject("country");
            if (countryDy == null || countryDy.getLong("id") == 0L) {
                this.getView().showErrorNotification(SocInsuranceErrInfoEnum.PERIOD_WITHOUT_PERMISSION_ADD_NEW.getErrInfo());
                args.setCancel(true);
                return;
            }
            Long countryId = countryDy.getLong("id");
            Set permCountryIdSet = SITPermissionServiceHelper.getCountrySetByPermItem((String)AppHelper.getAppNumberById((String)this.getView().getFormShowParameter().getCheckRightAppId()), (String)"sitbs_sinsurperiod", (String)"47150e89000000ac");
            if (permCountryIdSet != null && !permCountryIdSet.contains(countryId)) {
                this.getView().showErrorNotification(SocInsuranceErrInfoEnum.PERIOD_TYPE_WITHOUT_COUNTRY_PERMISSION.getErrInfo(new Object[]{countryDy.getString("name")}));
                args.setCancel(true);
                return;
            }
            int createRowCount = dataEntity.getInt("rowcount");
            Date startMonthDateFlag = dataEntity.getDate("startdate");
            if (createRowCount <= 0 || createRowCount > 24 || startMonthDateFlag == null) {
                this.getView().showErrorNotification(SocInsuranceErrInfoEnum.COMMON_MUST_INPUT_DES.getErrInfo());
                args.setCancel(true);
                return;
            }
            List<DynamicObject> periods = this.batchGeneratePeriod();
            OperateOption option = OperateOption.create();
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"sitbs_sinsurperiod", (DynamicObject[])periods.toArray(new DynamicObject[0]), (OperateOption)option);
            int failCount = operationResult.getValidateResult().getErrorDataIndexs().size();
            int successCount = periods.size() - failCount;
            List messages = operationResult.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getMessage).collect(Collectors.toList());
            FormShowParameter formShowParameter = SocInsurancePeriodHelper.getBatchGenerateResultForm(null, (int)periods.size(), (int)successCount, (int)failCount, (Date)newPeriodStartDate, (boolean)operationResult.isSuccess(), messages);
            this.getView().getParentView().showForm(formShowParameter);
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        }
    }

    private boolean checkField() {
        int rowCount = this.getModel().getDataEntity().getInt("rowcount");
        if (rowCount < 0 || rowCount > 24) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5165\u5927\u4e8e0\u4e14\u5c0f\u4e8e\u7b49\u4e8e24\u7684\u6574\u6570\u3002", (String)"TaxPeriodGeneratePlugin_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public List<DynamicObject> batchGeneratePeriod() {
        Date startDate;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject periodTypeDy = dataEntity.getDynamicObject("periodtype");
        int startDay = periodTypeDy.getInt("startday");
        int endDay = periodTypeDy.getInt("endday");
        int createRowCount = dataEntity.getInt("rowcount");
        Date startMonthDateFlag = dataEntity.getDate("startdate");
        String periodDateUseField = dataEntity.getString("perioddate");
        boolean startDayFlag = SocInsurancePeriodHelper.getRightDateFlag((int)startDay);
        newPeriodStartDate = startDate = SocInsurancePeriodHelper.getRightDate((Date)startMonthDateFlag, (int)startDay);
        boolean endDayFlag = SocInsurancePeriodHelper.getRightDateFlag((int)endDay);
        Date endDate = SocInsurancePeriodHelper.getEndDate((int)startDay, (int)endDay, (Date)startMonthDateFlag);
        ArrayList<DynamicObject> periods = new ArrayList<DynamicObject>(16);
        HRBaseServiceHelper periodHelper = new HRBaseServiceHelper("sitbs_sinsurperiod");
        for (int index = 0; index < createRowCount; ++index) {
            if (index > 0) {
                startDate = SocInsurancePeriodHelper.calRightDate((boolean)startDayFlag, (Date)startDate);
                endDate = SocInsurancePeriodHelper.calRightDate((boolean)endDayFlag, (Date)endDate);
            }
            DynamicObject period = periodHelper.generateEmptyDynamicObject();
            period.set("periodtype", (Object)periodTypeDy);
            period.set("startdate", (Object)startDate);
            period.set("enddate", (Object)endDate);
            period.set("perioddate", (Object)("startdate".equals(periodDateUseField) ? startDate : endDate));
            periods.add(period);
        }
        return periods;
    }

    private FormShowParameter getFormShowParameter() {
        return this.getView().getFormShowParameter();
    }
}

