/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.sinsurperiod;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.business.appnum.AppHelper;
import kd.sit.sitbp.business.helper.SITLogServiceHelper;
import kd.sit.sitbp.business.servicehelper.MutexServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.enums.FrequencyEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbs.business.socinsurance.errinfo.SocInsuranceErrInfoEnum;
import kd.sit.sitbs.business.socinsurance.period.helper.SocInsurancePeriodHelper;
import kd.sit.sitbs.business.socinsurance.service.SInsuranceCommonService;

public class SocInsurancePeriodTreeListPlugin
extends StandardTreeListPlugin {
    private static final Log LOGGER = LogFactory.getLog(SocInsurancePeriodTreeListPlugin.class);
    private Map<Object, BaseDataCheckRefrenceResult> checkResult = null;
    private static final String BTN_ADD_PERIOD_TYPE = "btnnew";
    private static final String BTN_MODIFY_PERIOD_TYPE = "btnedit";
    private static final String BTN_DEL_PERIOD_TYPE = "btndel";
    private static final String FIRST_LEVEL_SUFFIX = "_1";
    private static final String SECOND_LEVEL_SUFFIX = "_2";
    private static final String SPLITTER = "_";
    private static final HashMap<String, String> PERMISSION_MAP = new HashMap(4);
    private static final HashMap<String, String> PERMISSION_ERR_INFO_MAP = new HashMap(4);
    private static final String TREE_PANEL = "splitcontainerap";

    public void initializeTree(EventObject ex) {
        this.initTree();
    }

    public void beforeBindData(EventObject ex) {
        super.beforeBindData(ex);
        HashMap searchApCtrl = Maps.newHashMapWithExpectedSize((int)1);
        searchApCtrl.put("emptytip", SocInsuranceErrInfoEnum.INPUT_SOC_INSURANCE_PERIOD_TYPE.getErrInfo());
        this.getView().updateControlMetadata("searchap", (Map)searchApCtrl);
    }

    public void afterBindData(EventObject ex) {
        super.afterBindData(ex);
        if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            String appNumber = listShowParameter.getCheckRightAppId();
            if (listShowParameter.isLookUp()) {
                return;
            }
            if (!"sitbs".equals(appNumber)) {
                SplitContainer splitc = (SplitContainer)this.getControl(TREE_PANEL);
                splitc.hidePanel(SplitDirection.left, true);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean isNewOrBatchAdd;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        String currentNodeIdStr = (String)this.getTreeModel().getCurrentNodeId();
        LOGGER.info("SocInsurancePeriodTreeListPlugin.beforeDoOperation: current node id is {}", (Object)currentNodeIdStr);
        boolean bl = isNewOrBatchAdd = "batchgenerate".equals(operateKey) || "new".equals(operateKey);
        if (isNewOrBatchAdd && HRStringUtils.isEmpty((String)currentNodeIdStr)) {
            TreeView treeView = (TreeView)this.getView().getControl("treeview");
            treeView.deleteAllNodes();
            args.setCancel(true);
            boolean baseService = this.isBaseService();
            Long countryId = SInsuranceCommonService.getCountryIdByAppId((String)this.getView().getFormShowParameter().getAppId());
            if (!baseService && countryId != null) {
                String appNumber = AppHelper.getAppNumberById((String)this.getView().getFormShowParameter().getCheckRightAppId());
                Set permCountryIdSet = SITPermissionServiceHelper.getCountrySetByPermItem((String)appNumber, (String)"sitbs_sinsurperiod", (String)"47150e89000000ac");
                if (permCountryIdSet != null && !permCountryIdSet.contains(countryId)) {
                    String errMsg = new HRBaseServiceHelper("bd_country").loadSingle((Object)countryId).getString("name");
                    this.getView().showErrorNotification(SocInsuranceErrInfoEnum.PERIOD_TYPE_WITHOUT_COUNTRY_PERMISSION.getErrInfo(new Object[]{errMsg}));
                }
                return;
            }
        }
        if (isNewOrBatchAdd && !this.isBaseService() && !HRStringUtils.isEmpty((String)currentNodeIdStr) && !currentNodeIdStr.endsWith(SECOND_LEVEL_SUFFIX)) {
            currentNodeIdStr = "1010_2";
            this.getTreeModel().setCurrentNodeId((Object)currentNodeIdStr);
        }
        switch (operateKey) {
            case "batchgenerate": {
                if (this.checkSecondNode(currentNodeIdStr)) {
                    Long periodTypeId = Long.valueOf(currentNodeIdStr.substring(0, currentNodeIdStr.length() - 2));
                    DynamicObject periodTypeInfo = this.getPeriodType(periodTypeId);
                    if (HRObjectUtils.isEmpty((Object)periodTypeInfo)) {
                        this.getView().showErrorNotification(SocInsuranceErrInfoEnum.PERIOD_TYPE_NOT_EXISTS.getErrInfo());
                        args.setCancel(true);
                        return;
                    }
                    FrequencyEnum frequencyEnum = FrequencyEnum.valueOf((String)periodTypeInfo.getString("calfrequency.type"));
                    if (FrequencyEnum.YEAR == frequencyEnum || FrequencyEnum.HALF_YEAR == frequencyEnum || FrequencyEnum.SEASON == frequencyEnum) {
                        args.setCancel(true);
                        this.getView().showTipNotification(SocInsuranceErrInfoEnum.CAN_NOT_ADD_PERIOD_TYPE_FOR_CURR_FREQUENCY.getErrInfo());
                        break;
                    }
                    this.showBatchGenerateForm(periodTypeInfo.getLong("country.id"));
                    break;
                }
                args.setCancel(true);
                break;
            }
            case "new": {
                if (this.checkSecondNode(currentNodeIdStr)) {
                    this.getView().getPageCache().put("currentNodeId", currentNodeIdStr);
                    return;
                }
                args.setCancel(true);
                break;
            }
            case "refresh": {
                args.setCancel(true);
                if (currentNodeIdStr == null) {
                    currentNodeIdStr = "";
                }
                this.updateCurrView();
                this.refreshNode(new RefreshNodeEvent((Object)this, (Object)currentNodeIdStr));
                break;
            }
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent ex) {
        TreeNode root = this.getTreeModel().getRoot();
        String currNodeIdStr = (String)ex.getNodeId();
        if (HRStringUtils.isEmpty((String)currNodeIdStr)) {
            return;
        }
        String[] currentNodeIds = currNodeIdStr.split(SPLITTER);
        if (currNodeIdStr.contains(SECOND_LEVEL_SUFFIX)) {
            QFilter qFilter = new QFilter("periodtype.id", "=", (Object)Long.valueOf(currentNodeIds[0]));
            ex.addQFilter(qFilter);
            ex.setCancel(true);
        } else if (currNodeIdStr.contains(FIRST_LEVEL_SUFFIX)) {
            Long countryId = Long.valueOf(currentNodeIds[0]);
            List periodTypeDys = SocInsurancePeriodHelper.queryPeriodTypeDys((String)"id", (QFilter)SocInsurancePeriodHelper.getPeriodTypeQFilter((Long)countryId, null, null));
            Set periodTypeIdSet = periodTypeDys.stream().map(periodTypeDy -> periodTypeDy.getLong("id")).collect(Collectors.toSet());
            QFilter qFilter = new QFilter("periodtype.id", "in", periodTypeIdSet);
            ex.addQFilter(qFilter);
            ex.setCancel(true);
        }
    }

    public void treeToolbarClick(EventObject ex) {
        Set permCountryIdSet;
        ITreeModel treeModel = this.getTreeModel();
        String currentNodeIdStr = (String)treeModel.getCurrentNodeId();
        if ((HRStringUtils.isEmpty((String)currentNodeIdStr) || "100000".equals(currentNodeIdStr)) && (permCountryIdSet = SITPermissionServiceHelper.getCountrySetByPermItem((String)AppHelper.getAppNumberById((String)this.getView().getFormShowParameter().getCheckRightAppId()), (String)"sitbs_sinsurperiodtype", (String)"47150e89000000ac")) != null && permCountryIdSet.isEmpty()) {
            this.getView().showErrorNotification(SocInsuranceErrInfoEnum.PERIOD_TYPE_WITHOUT_COUNTRY_PERMISSION.getErrInfo(new Object[]{SocInsuranceErrInfoEnum.COMMON_FIELD_COUNTRY.getErrCode()}));
            return;
        }
        String opKey = ((Control)ex.getSource()).getKey();
        String opDesc = this.getOpNameBy(opKey);
        String appNumber = this.getView().getFormShowParameter().getCheckRightAppId();
        String permItemId = PERMISSION_MAP.get(opKey);
        if (permItemId != null && !SITPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)AppHelper.getAppNumberById((String)this.getView().getFormShowParameter().getCheckRightAppId()), (String)"sitbs_sinsurperiodtype", (String)permItemId)) {
            this.getView().showErrorNotification(PERMISSION_ERR_INFO_MAP.get(opKey));
            ((BeforeClickEvent)ex).setCancel(true);
            SITLogServiceHelper.addLog((String)appNumber, (String)"sitbs_sinsurperiodtype", (String)opDesc, (String)PERMISSION_ERR_INFO_MAP.get(opKey));
            return;
        }
        if ((BTN_MODIFY_PERIOD_TYPE.equals(opKey) || BTN_DEL_PERIOD_TYPE.equals(opKey)) && (HRStringUtils.isEmpty((String)currentNodeIdStr) || "100000".equals(currentNodeIdStr))) {
            this.getView().showTipNotification(SocInsuranceErrInfoEnum.SELECT_ONE_NODE_AT_LEAST.getErrInfo());
            SITLogServiceHelper.addLog((String)appNumber, (String)"sitbs_sinsurperiodtype", (String)opDesc, (String)SocInsuranceErrInfoEnum.SELECT_ONE_NODE_AT_LEAST.getErrInfo());
            return;
        }
        switch (opKey) {
            case "btnnew": {
                this.addGroupNode(opDesc);
                break;
            }
            case "btnedit": {
                this.editAction(currentNodeIdStr, opDesc);
                break;
            }
            case "btndel": {
                this.delAction(currentNodeIdStr, opDesc);
                break;
            }
        }
    }

    private String getOpNameBy(String opKey) {
        switch (opKey) {
            case "btnnew": {
                return SocInsuranceErrInfoEnum.COMMON_OP_ADD.getErrInfo();
            }
            case "btnedit": {
                return SocInsuranceErrInfoEnum.COMMON_OP_MODIFY.getErrInfo();
            }
            case "btndel": {
                return SocInsuranceErrInfoEnum.COMMON_OP_DEL.getErrInfo();
            }
        }
        return null;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        switch (event.getCallBackId()) {
            case "group_bar_del": {
                if (!MessageBoxResult.Yes.equals((Object)event.getResult())) break;
                String currentNodeId = this.getView().getPageCache().get("delid");
                this.getView().getPageCache().remove("delid");
                this.doDel(Long.parseLong(currentNodeId));
                this.clearSearchCache();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "group_bar_add": 
            case "group_bar_edit": {
                Object map = closedCallBackEvent.getReturnData();
                if (!(map instanceof HashMap)) {
                    return;
                }
                this.refreshTree();
                HashMap returnData = (HashMap)map;
                this.focusNodeBySearchName((String)returnData.get("name"));
                MutexServiceHelper.release((String)"sitbs_sinsurperiodtype", (String)String.valueOf(this.getTreeModel().getCurrentNodeId()), (String)"modify");
                break;
            }
        }
    }

    public void refreshNode(RefreshNodeEvent ex) {
        super.refreshNode(ex);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.deleteAllNodes();
        boolean isPeriodTypeEmpty = this.initTree();
        String currNodeId = (String)ex.getNodeId();
        if (isPeriodTypeEmpty) {
            currNodeId = "";
        } else if (HRStringUtils.isEmpty((String)currNodeId)) {
            currNodeId = treeView.getTreeState().getFocusNodeId();
        }
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode currNode = root.getTreeNode(currNodeId, 10);
        if (currNode != null && currNode.getChildren() != null && !currNode.getChildren().isEmpty()) {
            ex.setChildNodes(currNode.getChildren());
        }
        treeView.setRootVisible(false);
        this.getTreeModel().setCurrentNodeId((Object)currNodeId);
        treeView.focusNode(currNode);
        if (Objects.nonNull(currNode)) {
            treeView.treeNodeClick(currNode.getParentid(), currNodeId);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection collection = super.getData(arg0, arg1);
                List pkIds = collection.stream().map(dy -> String.valueOf(dy.getPkValue())).collect(Collectors.toList());
                if (!pkIds.isEmpty()) {
                    BasedataEntityType basedataEntityType = SocInsurancePeriodHelper.getBaseDataEntityType((String)"sitbs_sinsurperiod", (String)((String)pkIds.get(0)));
                    SocInsurancePeriodTreeListPlugin.this.checkResult = SocInsurancePeriodHelper.baseDataCheckReference((BasedataEntityType)basedataEntityType, (Object[])pkIds.toArray());
                }
                return collection;
            }
        });
    }

    public void packageData(PackageDataEvent ex) {
        super.packageData(ex);
        DynamicObject rowData = ex.getRowData();
        ColumnDesc columnDesc = (ColumnDesc)ex.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if ("refstatus".equals(fieldKey) && !CollectionUtils.isEmpty(this.checkResult) && this.checkResult.containsKey(rowData.get("id"))) {
            ex.setFormatValue((Object)"1");
        }
    }

    public void setFilter(SetFilterEvent ex) {
        super.setFilter(ex);
        ex.setOrderBy("periodtype.country.name asc,periodtype.name desc,perioddate desc,name desc");
    }

    private boolean checkSecondNode(String currentNodeIdStr) {
        if (HRStringUtils.isEmpty((String)currentNodeIdStr) || !currentNodeIdStr.endsWith(SECOND_LEVEL_SUFFIX)) {
            this.getView().showTipNotification(SocInsuranceErrInfoEnum.SELECT_ONE_PERIOD_TYPE_AT_LEAST.getErrInfo());
            return false;
        }
        return true;
    }

    private boolean initTree() {
        List<DynamicObject> periodTypeDys = this.getCurrentPermPeriodTypes();
        TreeNode root = this.initTreeNode();
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setRootVisable(false);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.addNode(root);
        this.loadChildNode(periodTypeDys);
        return CollectionUtils.isEmpty(periodTypeDys);
    }

    protected TreeNode initTreeNode() {
        TreeNode root = new TreeNode();
        root.setId("100000");
        root.setText(SocInsuranceErrInfoEnum.SOC_PERIOD_ROOT_NODE.getErrInfo());
        root.setData((Object)"");
        root.setParentid("");
        root.setIsOpened(true);
        return root;
    }

    private void loadChildNode(List<DynamicObject> periodTypeDys) {
        this.buildFirstLevelTreeNodes(periodTypeDys);
        this.buildSecondLevelTreeNodes(periodTypeDys);
    }

    private void buildFirstLevelTreeNodes(List<DynamicObject> periodTypes) {
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        ITreeModel treeModel = this.getTreeModel();
        TreeMap countries = periodTypes.stream().collect(Collectors.toMap(dy -> dy.getLong("country.id"), dy -> dy.getString("country.name"), (k1, k2) -> k1, TreeMap::new));
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(countries.size());
        for (Map.Entry country : countries.entrySet()) {
            TreeNode treeNode = new TreeNode("100000", country.getKey() + FIRST_LEVEL_SUFFIX, (String)country.getValue());
            treeNode.setIsOpened(true);
            treeNodes.add(treeNode);
        }
        treeModel.addNodes((Object)treeModel.getRoot().getId(), treeNodes);
        treeView.addNodes(treeNodes);
    }

    private void buildSecondLevelTreeNodes(List<DynamicObject> periodTypes) {
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        ITreeModel treeModel = this.getTreeModel();
        String nodeId = null;
        TreeNode focusNode = null;
        String presetPeriodTypeId = null;
        for (DynamicObject periodType : periodTypes) {
            long countryId = periodType.getLong("country.id");
            String countryNodeId = countryId + FIRST_LEVEL_SUFFIX;
            String periodTypeNodeId = periodType.getString("id") + SECOND_LEVEL_SUFFIX;
            TreeNode periodTypeNode = new TreeNode(countryNodeId, periodTypeNodeId, periodType.getString("name"));
            treeModel.addNode((Object)countryNodeId, periodTypeNode);
            treeView.addNode(periodTypeNode);
            if (Strings.isNullOrEmpty(nodeId)) {
                nodeId = periodTypeNodeId;
            }
            if (Objects.isNull(focusNode)) {
                focusNode = periodTypeNode;
            }
            if (!periodType.getBoolean("issyspreset")) continue;
            presetPeriodTypeId = periodType.getString("id");
            focusNode = periodTypeNode;
        }
        if (presetPeriodTypeId != null && !this.isBaseService()) {
            this.getTreeModel().setCurrentNodeId((Object)(presetPeriodTypeId + SECOND_LEVEL_SUFFIX));
            treeView.focusNode(focusNode);
        } else if (!Strings.isNullOrEmpty(nodeId)) {
            this.getTreeModel().setCurrentNodeId(nodeId);
            treeView.focusNode(focusNode);
        }
    }

    private void delAction(String currentNodeIdStr, String opDesc) {
        if (HRStringUtils.isEmpty((String)currentNodeIdStr) || currentNodeIdStr.endsWith(FIRST_LEVEL_SUFFIX)) {
            this.getView().showTipNotification(SocInsuranceErrInfoEnum.CAN_NOT_DEL_FIRST_LEVEL.getErrInfo());
            SITLogServiceHelper.addLog((String)this.getView().getFormShowParameter().getCheckRightAppId(), (String)"sitbs_sinsurperiodtype", (String)opDesc, (String)SocInsuranceErrInfoEnum.CAN_NOT_DEL_FIRST_LEVEL.getErrInfo());
            return;
        }
        String currentNodeId = currentNodeIdStr.split(SPLITTER)[0];
        TreeNode currNode = this.getTreeModel().getRoot().getTreeNode(currentNodeId, 3);
        DynamicObject periodTypeDy = this.getPeriodType(Long.parseLong(currentNodeId));
        if (Objects.nonNull(periodTypeDy)) {
            boolean issyspreset = periodTypeDy.getBoolean("issyspreset");
            if (issyspreset) {
                this.getView().showErrorNotification(SocInsuranceErrInfoEnum.SYS_PRE_SET_DATA_CAN_NOT_DEL.getErrInfo());
                SITLogServiceHelper.addLog((String)this.getView().getFormShowParameter().getCheckRightAppId(), (String)"sitbs_sinsurperiodtype", (String)opDesc, (String)SocInsuranceErrInfoEnum.SYS_PRE_SET_DATA_CAN_NOT_DEL.getErrInfo());
                return;
            }
        } else {
            this.getView().showErrorNotification(SocInsuranceErrInfoEnum.PERIOD_TYPE_NOT_EXISTS.getErrInfo());
            SITLogServiceHelper.addLog((String)this.getView().getFormShowParameter().getCheckRightAppId(), (String)"sitbs_sinsurperiodtype", (String)opDesc, (String)SocInsuranceErrInfoEnum.PERIOD_TYPE_NOT_EXISTS.getErrInfo());
            return;
        }
        int periodCount = SocInsurancePeriodHelper.queryPeriodDys((String)"id", (QFilter)new QFilter("periodtype.id", "=", (Object)Long.parseLong(currentNodeId))).size();
        if (periodCount > 0) {
            String errMsg = MessageFormat.format(SocInsuranceErrInfoEnum.PERIOD_TYPE_IS_REF.getErrInfo(), periodTypeDy.getString("name"));
            this.getView().showErrorNotification(errMsg);
            SITLogServiceHelper.addLog((String)this.getView().getFormShowParameter().getCheckRightAppId(), (String)"sitbs_sinsurperiodtype", (String)opDesc, (String)errMsg);
            return;
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("group_bar_del", (IFormPlugin)this);
        this.getView().getPageCache().put("delid", currentNodeId);
        this.getView().showConfirm(MessageFormat.format(SocInsuranceErrInfoEnum.MAKE_SURE_TO_DEL_PERIOD_TYPE.getErrInfo(), periodTypeDy.getString("name")), MessageBoxOptions.YesNo, confirmCallBacks);
    }

    private DynamicObject getPeriodType(long periodTypeId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_sinsurperiodtype");
        QFilter filter = new QFilter("id", "=", (Object)periodTypeId);
        return helper.loadDynamicObject(filter.toArray());
    }

    private void doDel(long periodTypeId) {
        DynamicObject periodTypeDy = new HRBaseServiceHelper("sitbs_sinsurperiodtype").loadDynamicObject(new QFilter("id", "=", (Object)periodTypeId).toArray());
        if (!HRObjectUtils.isEmpty((Object)periodTypeDy)) {
            OperateOption option = OperateOption.create();
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"sitbs_sinsurperiodtype", (DynamicObject[])new DynamicObject[]{periodTypeDy}, (OperateOption)option);
            List messages = operationResult.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getMessage).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(messages)) {
                String errMsg = String.join((CharSequence)",", messages);
                this.getView().showErrorNotification(errMsg);
                return;
            }
        }
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.deleteNode(periodTypeId + SECOND_LEVEL_SUFFIX);
        this.getView().invokeOperation("refresh");
        this.getView().showSuccessNotification(SocInsuranceErrInfoEnum.COMMON_OP_DEL_SUCCESS.getErrInfo());
        SITLogServiceHelper.addLog((String)this.getView().getFormShowParameter().getCheckRightAppId(), (String)"sitbs_sinsurperiodtype", (String)this.getOpNameBy(BTN_DEL_PERIOD_TYPE), (String)SocInsuranceErrInfoEnum.COMMON_OP_SUCCESS.getErrInfo());
    }

    private void editAction(String currentNodeIdStr, String opDesc) {
        if (HRStringUtils.isEmpty((String)currentNodeIdStr) || currentNodeIdStr.endsWith(FIRST_LEVEL_SUFFIX)) {
            this.getView().showTipNotification(SocInsuranceErrInfoEnum.CAN_NOT_EDIT_FIRST_LEVEL.getErrInfo());
            SITLogServiceHelper.addLog((String)this.getView().getFormShowParameter().getCheckRightAppId(), (String)"sitbs_sinsurperiodtype", (String)opDesc, (String)SocInsuranceErrInfoEnum.CAN_NOT_EDIT_FIRST_LEVEL.getErrInfo());
            return;
        }
        DynamicObject periodTypeDy = this.getPeriodType(Long.parseLong(currentNodeIdStr.split(SPLITTER)[0]));
        if (HRObjectUtils.isEmpty((Object)periodTypeDy)) {
            this.getView().showErrorNotification(SocInsuranceErrInfoEnum.PERIOD_TYPE_NOT_EXISTS.getErrInfo());
            SITLogServiceHelper.addLog((String)this.getView().getFormShowParameter().getCheckRightAppId(), (String)"sitbs_sinsurperiodtype", (String)opDesc, (String)SocInsuranceErrInfoEnum.PERIOD_TYPE_NOT_EXISTS.getErrInfo());
            return;
        }
        BaseShowParameter formShowParameter = this.openInsurancePeriodTypeView();
        formShowParameter.setPkId((Object)currentNodeIdStr.split(SPLITTER)[0]);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "group_bar_edit"));
        BaseResult require = MutexServiceHelper.require((String)"sitbs_sinsurperiodtype", (String)String.valueOf(this.getTreeModel().getCurrentNodeId()), (String)"modify");
        if (require.isSuccess()) {
            formShowParameter.setStatus(OperationStatus.EDIT);
        } else {
            formShowParameter.setStatus(OperationStatus.VIEW);
            formShowParameter.setCustomParam("isMutexOpen", (Object)YesOrNoEnum.YES.getCode());
        }
        SITLogServiceHelper.addLog((String)this.getView().getFormShowParameter().getCheckRightAppId(), (String)"sitbs_sinsurperiodtype", (String)opDesc, (String)SocInsuranceErrInfoEnum.COMMON_OP_SUCCESS.getErrInfo());
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void addGroupNode(String opDesc) {
        SITLogServiceHelper.addLog((String)this.getView().getFormShowParameter().getCheckRightAppId(), (String)"sitbs_sinsurperiodtype", (String)opDesc, (String)SocInsuranceErrInfoEnum.COMMON_OP_SUCCESS.getErrInfo());
        BaseShowParameter formShowParameter = this.openInsurancePeriodTypeView();
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "group_bar_edit"));
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private BaseShowParameter openInsurancePeriodTypeView() {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("sitbs_sinsurperiodtype");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        return showParameter;
    }

    private void refreshTree() {
        ITreeListView treeListView = ((IListView)this.getView()).getTreeListView();
        String rootId = treeListView.getTreeModel().getRoot().getId();
        treeListView.getTreeModel().refreshNode((Object)rootId);
        treeListView.refreshTreeNode(rootId);
    }

    private void focusNodeBySearchName(String name) {
        SearchEnterEvent searchEnterEvent = new SearchEnterEvent((Object)this, name + "#s#");
        this.search(searchEnterEvent);
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        if (!searchText.endsWith("#s#")) {
            super.search(evt);
        } else {
            this.clearSearchCache();
            searchText = searchText.substring(0, searchText.length() - 3);
            TreeNode rootNode = this.getTreeModel().getRoot();
            List treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, node -> this.loadChildNodes((TreeNode)node), 16);
            TreeNode targetNode = this.initTreeNode();
            for (TreeNode treeNode : treeNodes) {
                if (!searchText.equals(treeNode.getText())) continue;
                targetNode = treeNode;
            }
            if (targetNode.getId().equals("100000")) {
                return;
            }
            TreeView treeView = this.getTreeListView().getTreeView();
            this.focusNode(treeView, rootNode, targetNode);
        }
    }

    private void clearSearchCache() {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String currPageId = this.getView().getPageId();
        pageCache.remove(currPageId + "_searchNodes");
        pageCache.remove(currPageId + "_matchNodes");
        pageCache.remove(currPageId + "_oldSearchText");
        pageCache.remove(currPageId + "_searchIndex");
    }

    private void focusNode(TreeView treeView, TreeNode rootNode, TreeNode treeNode) {
        this.expandParents(treeView, rootNode, treeNode);
        treeView.showNode(treeNode.getParentid());
        treeView.focusNode(treeNode);
        treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
    }

    private void expandParents(TreeView treeView, TreeNode rootNode, TreeNode node) {
        String parentid = node.getParentid();
        if (StringUtils.isNotBlank((CharSequence)parentid)) {
            TreeNode pnode = rootNode.getTreeNode(parentid, 20);
            if (pnode != null) {
                this.expandParents(treeView, rootNode, pnode);
                treeView.expand(parentid);
                if (pnode == rootNode) {
                    treeView.updateNode(node);
                }
            } else {
                treeView.updateNode(node);
            }
        } else {
            treeView.updateNode(node);
        }
    }

    private void showBatchGenerateForm(long countryId) {
        String currentNodeIdStr = this.treeListView.getTreeModel().getCurrentNodeId().toString();
        String periodTypeId = currentNodeIdStr.substring(0, currentNodeIdStr.length() - 2);
        List<Map<String, Date>> periodInfoList = this.getPeriodInfoList(periodTypeId);
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("sitbs_sinsurperiodg");
        parameters.setCustomParam("periodtype.id", (Object)periodTypeId);
        parameters.setCustomParam("country.id", (Object)countryId);
        parameters.setCustomParam("periodInfo", periodInfoList);
        this.getView().showForm(parameters);
    }

    private List<Map<String, Date>> getPeriodInfoList(String periodTypeId) {
        HRBaseServiceHelper periodHelper = new HRBaseServiceHelper("sitbs_sinsurperiod");
        QFilter filter = new QFilter("period.id", "=", (Object)Long.valueOf(periodTypeId));
        DynamicObject[] periodDys = periodHelper.query("id,startdate,enddate,perioddate", new QFilter[]{filter});
        if (periodDys == null || periodDys.length == 0) {
            return Lists.newArrayList();
        }
        ArrayList<Map<String, Date>> result = new ArrayList<Map<String, Date>>(periodDys.length);
        List<String> dateFieldList = this.getDateFieldList();
        for (DynamicObject periodDy : periodDys) {
            HashMap map = new HashMap(16);
            dateFieldList.forEach(dateField -> map.put(dateField, periodDy.getDate(dateField)));
            result.add(map);
        }
        return result;
    }

    private List<String> getDateFieldList() {
        return Arrays.asList("startdate", "enddate");
    }

    private boolean isBaseService() {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String appNumber = listShowParameter.getCheckRightAppId();
        return "sitbs".equals(appNumber);
    }

    private List<DynamicObject> getCurrentPermPeriodTypes() {
        Long countryId;
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        HashSet<Long> countryIds = SITPermissionServiceHelper.getCountrySetByPermItem((String)AppHelper.getAppNumberById((String)this.getView().getFormShowParameter().getCheckRightAppId()), (String)"sitbs_sinsurperiodtype", (String)"47150e89000000ac");
        if (!this.isBaseService() && (countryId = SInsuranceCommonService.getCountryIdByAppId((String)this.getView().getFormShowParameter().getAppId())) != null) {
            HashSet<Long> tmpCountryIds = new HashSet<Long>(1);
            if (countryIds == null || countryIds.contains(countryId)) {
                tmpCountryIds.add(countryId);
            }
            countryIds = tmpCountryIds;
        }
        if (countryIds != null) {
            filter.and("country.id", "in", (Object)countryIds);
        }
        return SocInsurancePeriodHelper.queryPeriodTypeDys((String)"id,number,name,country.id,country.name,issyspreset", (QFilter)filter);
    }

    public void updateCurrView() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        if (billList != null) {
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            AbstractListView list = (AbstractListView)this.getView();
            ITimeService timeService = (ITimeService)this.getModel().getService(ITimeService.class);
            IUserService userService = (IUserService)this.getModel().getService(IUserService.class);
            long userId = Long.parseLong(RequestContext.get().getUserId());
            String entityNumber = list.getListModel().getDataEntityType().getName();
            String bizAppId = ShowFormHelper.getBizAppId((FormShowParameter)list.getFormShowParameter());
            PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
            billList.setSpecialDataPermQFilter(PermissionFilterUtil.getSpecialDataPermissionFilter((String)bizAppId, (String)entityNumber, (String)"view", (ITimeService)timeService, (IUserService)userService));
            HashMap<String, Boolean> customParams = new HashMap<String, Boolean>();
            customParams.put("isLookUp", listShowParameter.isLookUp());
            billList.setDataPermQFilters(Collections.singletonList(permissionService.getDataPermWithOrg(userId, bizAppId, entityNumber, customParams)));
            FieldControlRules fieldControlRules = permissionService.getFieldControlRules(userId, bizAppId, entityNumber);
            if (fieldControlRules != null) {
                billList.setFieldControlRules(fieldControlRules);
            }
        }
    }

    static {
        PERMISSION_MAP.put(BTN_ADD_PERIOD_TYPE, "47156aff000000ac");
        PERMISSION_MAP.put(BTN_MODIFY_PERIOD_TYPE, "4715a0df000000ac");
        PERMISSION_MAP.put(BTN_DEL_PERIOD_TYPE, "4715e1f1000000ac");
        PERMISSION_ERR_INFO_MAP.put(BTN_ADD_PERIOD_TYPE, SocInsuranceErrInfoEnum.WITHOUT_NEW_PERMISSION.getErrInfo());
        PERMISSION_ERR_INFO_MAP.put(BTN_MODIFY_PERIOD_TYPE, SocInsuranceErrInfoEnum.WITHOUT_MODIFY_PERMISSION.getErrInfo());
        PERMISSION_ERR_INFO_MAP.put(BTN_DEL_PERIOD_TYPE, SocInsuranceErrInfoEnum.WITHOUT_DEL_PERMISSION.getErrInfo());
    }
}

