/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.sinsurperiod;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.field.LockableComboEdit;
import kd.sit.sitbs.business.socinsurance.errinfo.SocInsuranceErrInfoEnum;
import kd.sit.sitbs.business.socinsurance.period.constants.SocInsurancePeriodConstants;
import kd.sit.sitbs.business.socinsurance.period.helper.SocInsurancePeriodHelper;
import kd.sit.sitbs.business.socinsurance.service.SInsuranceCommonService;
import org.apache.commons.lang.StringUtils;

public class SocInsurancePeriodTypeEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final String regEx = "[\u4e00-\u9fa5]";
    private static final Pattern pat = Pattern.compile("[\u4e00-\u9fa5]");
    private static final String specialRegEx = "^[A-Za-z0-9\\@\\#\\$\\%\\^\\&\\*\\[\\]\\.\\-\\_]*$";
    private static final Pattern specialCharPat = Pattern.compile("^[A-Za-z0-9\\@\\#\\$\\%\\^\\&\\*\\[\\]\\.\\-\\_]*$");
    private final Set<String> combos = Sets.newHashSet((Object[])new String[]{"startday", "endday", "periodnumbersubject"});

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit welfarePayer = (BasedataEdit)this.getControl("calfrequency");
        welfarePayer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void initialize() {
        this.getView().addCustomControls(this.combos.toArray(new String[0]));
    }

    public void onGetControl(OnGetControlArgs ex) {
        super.onGetControl(ex);
        String key = ex.getKey();
        if (this.combos.contains(key)) {
            LockableComboEdit edit = new LockableComboEdit();
            edit.setKey(key);
            edit.setView(this.getView());
            ex.setControl((Control)edit);
        }
    }

    public void beforeBindData(EventObject ex) {
        super.beforeBindData(ex);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long periodTypeId = dataEntity.getLong("id");
        if (periodTypeId != 0L) {
            List dynamicObjects = SocInsurancePeriodHelper.queryPeriodDys((String)"id", (QFilter)SocInsurancePeriodHelper.getPeriodQFilter(null, (Long)dataEntity.getLong("id")));
            if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"number", "index", "generationruleflex", "country", "startday", "endday"});
                BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("calfrequency");
                if (basedataEdit != null) {
                    basedataEdit.setEnable(null, false, 0);
                }
                LockableComboEdit startDay = (LockableComboEdit)this.getView().getControl("startday");
                startDay.setEnable(null, false, 0);
                LockableComboEdit endDay = (LockableComboEdit)this.getView().getControl("endday");
                endDay.setEnable(null, false, 0);
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"country"});
                if (dataEntity.getBoolean("issyspreset")) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
                }
                this.getPageCache().put("periodNotExists", Boolean.TRUE.toString());
            }
        }
        this.setCalFrequency();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object isMutexOpen = formShowParameter.getCustomParam("isMutexOpen");
        if (YesOrNoEnum.YES.getCode().equals(String.valueOf(isMutexOpen))) {
            this.getView().showTipNotification(SocInsuranceErrInfoEnum.PERIOD_MUTEX.getErrInfo());
        }
    }

    public void afterCreateNewData(EventObject ex) {
        SInsuranceCommonService.createInstance().setDefaultCountryAndCurrency((Object)this, Collections.singletonList("country"));
        this.generateSampleNumber();
    }

    public void afterLoadData(EventObject ex) {
        this.generateSampleNumber();
        this.getModel().setDataChanged(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        BasedataEdit basedataEdit = (BasedataEdit)beforeF7SelectEvent.getSource();
        String key = basedataEdit.getKey();
        if (StringUtils.equals((String)"calfrequency", (String)key) && 1000001L != this.getModel().getDataEntity(true).getLong("country.id")) {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List<Long> calFrequencyIds = Arrays.asList(1095454955659095040L, 1095454220800487424L, 1095454325456760832L, 1095454403613421568L);
            QFilter frequencyFilter = new QFilter("id", "in", calFrequencyIds);
            formShowParameter.getListFilterParameter().setFilter(frequencyFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": {
                List dynamicObjects;
                long periodTypeId = this.getModel().getDataEntity(true).getLong("id");
                if (periodTypeId != 0L && Boolean.TRUE.toString().equals(this.getPageCache().get("periodNotExists")) && (dynamicObjects = SocInsurancePeriodHelper.queryPeriodDys((String)"id", (QFilter)SocInsurancePeriodHelper.getPeriodQFilter(null, (Long)periodTypeId))).size() > 0) {
                    this.getView().showErrorNotification(SocInsuranceErrInfoEnum.PERIODS_HAS_EXISTED.getErrInfo());
                    args.setCancel(true);
                    this.getPageCache().put("periodNotExists", null);
                    this.getView().updateView();
                    return;
                }
                if (operate.getOption().tryGetVariableValue(SocInsuranceErrInfoEnum.CONTINUE_OR_NOT.getErrCode(), new RefObject())) break;
                this.validateBaseInfoBeforeSave(args);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs ex) {
        String fieldKey;
        switch (fieldKey = ex.getProperty().getName()) {
            case "periodnumbersubject": 
            case "periodnumberprefix": 
            case "periodnumbersuffix": 
            case "serialnumber": {
                this.generateSampleNumber();
                break;
            }
            case "country": {
                this.setCalFrequency();
                break;
            }
            case "calfrequency": {
                ComboEdit endDay = (ComboEdit)this.getView().getControl("endday");
                boolean isMustInput = SocInsurancePeriodConstants.MONTH_FREQUENCY_ID.longValue() == this.getModel().getDataEntity(true).getLong("calfrequency.id");
                endDay.setMustInput(isMustInput);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String callBackId = messageBoxClosedEvent.getCallBackId();
            if (SocInsuranceErrInfoEnum.CONTINUE_OR_NOT.getErrCode().equals(callBackId)) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(SocInsuranceErrInfoEnum.CONTINUE_OR_NOT.getErrCode(), Boolean.TRUE.toString());
                this.getView().invokeOperation("save", operateOption);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent ex) {
        HashMap<String, Object> returnData = new HashMap<String, Object>(2);
        DynamicObject dy = this.getModel().getDataEntity();
        long id = dy.getLong("id");
        String name = dy.getString("name");
        if (id == 0L || HRStringUtils.isEmpty((String)name)) {
            return;
        }
        returnData.put("id", id);
        returnData.put("name", name);
        this.getView().returnDataToParent(returnData);
        IFormView parentView = this.getView().getParentView();
        if (parentView instanceof IListView && "sitbs_sinsurperiod".equals(((IListView)parentView).getBillFormId())) {
            parentView.invokeOperation("refresh");
        }
    }

    private void validateBaseInfoBeforeSave(BeforeDoOperationEventArgs args) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        int startDay = dataEntity.getInt("startday");
        int endDay = dataEntity.getInt("endday");
        String frequency = dataEntity.getString("calfrequency.type");
        if (HRStringUtils.isEmpty((String)frequency) && startDay == 0 && endDay == 0) {
            this.getView().showMessage(SocInsuranceErrInfoEnum.INPUT_START_TIME_AND_END_TIME.getErrInfo());
            args.setCancel(true);
        } else if (startDay == endDay) {
            this.getView().showMessage(SocInsuranceErrInfoEnum.START_TIME_CAN_NOT_EQUAL_END_TIME.getErrInfo());
            args.setCancel(true);
        } else if (startDay > endDay) {
            this.getView().showConfirm(SocInsuranceErrInfoEnum.CONTINUE_OR_NOT.getErrInfo(), MessageBoxOptions.YesNo, new ConfirmCallBackListener(SocInsuranceErrInfoEnum.CONTINUE_OR_NOT.getErrCode()));
            args.setCancel(true);
        }
    }

    private void generateSampleNumber() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (this.checkPeriodNumberInValid(dataEntity)) {
            return;
        }
        String periodNumberSubject = dataEntity.getString("periodnumbersubject");
        String periodNumberSubjectValue = "perioddate".equals(periodNumberSubject) ? HRDateTimeUtils.format((Date)new Date(), (String)"yyyyMM") : HRDateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd");
        int serialNumber = dataEntity.getInt("serialnumber");
        String periodNumberSerialNumber = "";
        if (serialNumber == 1) {
            periodNumberSerialNumber = "1";
        } else if (serialNumber == 2) {
            periodNumberSerialNumber = "01";
        }
        String periodNumberSample = dataEntity.getString("periodnumberprefix") + periodNumberSubjectValue + dataEntity.getString("periodnumbersuffix") + periodNumberSerialNumber;
        this.getModel().setValue("periodnumberexample", (Object)periodNumberSample);
    }

    private boolean checkPeriodNumberInValid(DynamicObject dataEntity) {
        String periodNumberPrefix = dataEntity.getString("periodnumberprefix");
        String periodNumberSuffix = dataEntity.getString("periodnumbersuffix");
        boolean isPrefixSpecialCharInValid = false;
        boolean isSuffixSpecialCharInValid = false;
        boolean isPrefixContainsChinese = false;
        boolean isSuffixContainsChinese = false;
        isPrefixContainsChinese = this.isContainsChinese(periodNumberPrefix);
        if (isPrefixContainsChinese || (isSuffixContainsChinese = this.isContainsChinese(periodNumberSuffix)) || (isPrefixSpecialCharInValid = this.checkSpecialCharInValid(periodNumberPrefix)) || (isSuffixSpecialCharInValid = this.checkSpecialCharInValid(periodNumberSuffix))) {
            String errMsg = "";
            if (isPrefixSpecialCharInValid) {
                errMsg = SocInsuranceErrInfoEnum.PERIOD_NUMBER_PREFIX.getErrInfo();
                dataEntity.set("periodnumberprefix", null);
            } else if (isSuffixSpecialCharInValid) {
                errMsg = SocInsuranceErrInfoEnum.PERIOD_NUMBER_SUFFIX.getErrInfo();
                dataEntity.set("periodnumbersuffix", null);
            } else if (isPrefixContainsChinese) {
                errMsg = SocInsuranceErrInfoEnum.PERIOD_NUMBER_PREFIX_LANG.getErrInfo();
                dataEntity.set("periodnumberprefix", null);
            } else if (isSuffixContainsChinese) {
                errMsg = SocInsuranceErrInfoEnum.PERIOD_NUMBER_SUFFIX_LANG.getErrInfo();
                dataEntity.set("periodnumbersuffix", null);
            }
            this.getView().showMessage(errMsg);
            return true;
        }
        return false;
    }

    protected boolean checkSpecialCharInValid(String str) {
        if (HRStringUtils.isEmpty((String)str)) {
            return false;
        }
        Matcher matcher = specialCharPat.matcher(str);
        return !matcher.find();
    }

    private boolean isContainsChinese(String str) {
        if (HRStringUtils.isEmpty((String)str)) {
            return false;
        }
        Matcher matcher = pat.matcher(str);
        return matcher.find();
    }

    private void setCalFrequency() {
        if (1000001L == this.getModel().getDataEntity().getLong("country.id")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"calfrequency", "startday", "endday"});
            this.getModel().setValue("calfrequency", (Object)SocInsurancePeriodConstants.MONTH_FREQUENCY_ID);
            this.getModel().setValue("startday", (Object)"1");
            this.getModel().setValue("endday", (Object)"31");
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"calfrequency", "startday", "endday"});
        }
    }
}

