/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.sinsurstandard;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.TreeEntryType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.BindingContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.LargeTextOtherEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbs.business.socinsurance.dto.DetailStandardDimDTO;
import kd.sit.sitbs.business.socinsurance.errinfo.SocInsuranceErrInfoEnum;
import kd.sit.sitbs.business.socinsurance.standard.helper.SocInsuranceStandardHelper;
import kd.sit.sitbs.business.socinsurance.standard.service.DyStandardEntityService;
import kd.sit.sitbs.business.socinsurance.standard.service.SocInsuranceStandardService;

public class SInsuranceStandardDimEntryPlugin
extends HRDataBaseEdit {
    private static final String COMMAND_CREATE_ENTRYAP = "createEntryAp";
    private static final String COMMAND_CREATE_PROPERTIES = "createProperties";
    private static final String TMP_KEY_ENTITY_META_DATA = "entitymetadata";
    private static final String TMP_KEY_ENTRY_AP = "entryAp";
    private static final String TMP_KEY_ENTRY_TYPE = "entryType";
    private static final List<String> DY_STANDARD_ENTITY_SERVICE_NAMES = Arrays.asList("DimDyStandardEntityService", "ItemDyStandardEntityService", "RoundTypeDyStandardEntityService");

    public void loadCustomControlMetas(LoadCustomControlMetasArgs ex) {
        super.loadCustomControlMetas(ex);
        FormShowParameter formShow = (FormShowParameter)ex.getSource();
        EntryAp dynamicEntryAp = this.initEntryAp(formShow);
        if (dynamicEntryAp == null) {
            return;
        }
        HashMap<String, String> mapEntry = new HashMap<String, String>(16);
        mapEntry.put("id", "entryentity");
        mapEntry.put("columns", (String)dynamicEntryAp.createControl().get("columns"));
        ex.getItems().add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs ex) {
        MainEntityType oldMainType = ex.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new KDBizException((Throwable)exception, new ErrorCode("", exception.toString()), new Object[0]);
        }
        this.registerDynamicProps(newMainType);
        ex.setNewEntityType(newMainType);
    }

    public void onGetControl(OnGetControlArgs ex) {
        String key = ex.getKey();
        if (key.startsWith("bt") || key.startsWith("it") || key.startsWith("rt")) {
            this.createGetControlByType(ex);
        }
    }

    public void beforeBindData(EventObject ex) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        List<Control> allControls = this.getControls();
        if (allControls.isEmpty()) {
            return;
        }
        for (Control control : allControls) {
            control.setView(this.getView());
            entryGrid.getItems().add(control);
        }
    }

    public void createNewData(BizDataEventArgs ex) {
        DetailStandardDimDTO detailStandardDimDTO = this.getDetailStandardDimDTO(this.getView().getFormShowParameter(), false);
        if (detailStandardDimDTO == null) {
            return;
        }
        List itemValueLinkedMaps = detailStandardDimDTO.getValueMaps();
        LinkedHashSet fieldKeyLinkedSet = detailStandardDimDTO.getFieldSet();
        Map nameMap = detailStandardDimDTO.getNameMap();
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("entryentity");
        for (LinkedHashMap detailItemValueLinkedMap : itemValueLinkedMaps) {
            DynamicObject newRow = new DynamicObject(rows.getDynamicObjectType());
            for (String fieldKey : fieldKeyLinkedSet) {
                String cellValue = (String)detailItemValueLinkedMap.get(fieldKey);
                if (fieldKey.contains("it")) {
                    newRow.set(fieldKey, (Object)(cellValue != null ? new BigDecimal(cellValue) : null));
                    continue;
                }
                newRow.set(fieldKey, (Object)cellValue);
            }
            rows.add((Object)newRow);
        }
        ex.setDataEntity((Object)dataEntity);
    }

    public void propertyChanged(PropertyChangedArgs ex) {
        super.propertyChanged(ex);
        String key = ex.getProperty().getName();
        ChangeData[] changes = ex.getChangeSet();
        ChangeData changeData = changes[0];
        if (key.startsWith("bt")) {
            if (this.checkStdDimExists(key, changeData)) {
                return;
            }
            this.setStdDimDataToCache();
        } else if (key.startsWith("rt")) {
            if (changeData != null && changeData.getNewValue() != null && !changeData.getNewValue().equals(changeData.getOldValue())) {
                DynamicObjectCollection stdDimDatas = this.getModel().getEntryEntity("entryentity");
                for (int i = 0; i < stdDimDatas.size(); ++i) {
                    this.getModel().setValue(key, changeData.getNewValue(), i);
                }
            }
            this.setStdDimDataToCache();
        } else if (key.startsWith("it")) {
            this.setStdDimDataToCache();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DetailStandardDimDTO detailStandardDimDTO;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (HRStringUtils.equals((String)formOperate.getOperateKey(), (String)"addline") && this.checkSizeInvalied(detailStandardDimDTO = this.getDetailStandardDimDTO(this.getView().getFormShowParameter(), true))) {
            this.getView().showTipNotification(SocInsuranceErrInfoEnum.STD_DIM_ENTITY_REACTH_MAX.getErrInfo());
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"addline")) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            int rowIndex = model.createNewEntryRow("entryentity");
            DynamicObject rowDataEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            model.endInit();
            BindingContext bindCtx = new BindingContext(rowDataEntity.getDataEntityType(), rowDataEntity, rowDataEntity.getInt("seq") - 1);
            List<Object> rowValues = this.getRowBindValue(bindCtx, this.getView());
            if (HRObjectUtils.isEmpty(rowValues) || rowValues.size() == 0) {
                return;
            }
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            EntryGrid grid = (EntryGrid)this.getControl("entryentity");
            proxy.appendRow(grid.getKey(), rowValues);
            this.setStdDimDataToCache();
        } else if (HRStringUtils.equals((String)operateKey, (String)"delline")) {
            this.setStdDimDataToCache();
        }
    }

    private boolean checkSizeInvalied(DetailStandardDimDTO detailStandardDimDTO) {
        LinkedHashMap tmpLinkeMap;
        if (detailStandardDimDTO == null || detailStandardDimDTO.getValueMaps().isEmpty() || detailStandardDimDTO.getNameMap().isEmpty()) {
            return false;
        }
        int maxSize = 1;
        if (detailStandardDimDTO.getFieldSet().contains("bt0_")) {
            tmpLinkeMap = (LinkedHashMap)detailStandardDimDTO.getNameMap().get("bt0_");
            int n = maxSize = tmpLinkeMap == null ? 1 : tmpLinkeMap.size();
        }
        if (detailStandardDimDTO.getFieldSet().contains("bt1_")) {
            tmpLinkeMap = (LinkedHashMap)detailStandardDimDTO.getNameMap().get("bt1_");
            maxSize = tmpLinkeMap == null ? maxSize : maxSize * tmpLinkeMap.size();
        }
        return detailStandardDimDTO.getValueMaps().size() + 1 > maxSize;
    }

    private List<Object> getRowBindValue(BindingContext arg, IFormView view) {
        ArrayList<Object> entryRow = new ArrayList<Object>(10);
        entryRow.add(arg.getRowIndex());
        entryRow.add(arg.getRowIndex() + 1);
        if (arg.getDataEntity() instanceof DynamicObject && arg.getEntityEntityType() != null && arg.getEntityEntityType() instanceof TreeEntryType) {
            DynamicObject obj = (DynamicObject)arg.getDataEntity();
            entryRow.add("" + obj.getPkValue());
            entryRow.add("" + obj.get("pid"));
            entryRow.add(obj.get("isGroupNode"));
        } else {
            entryRow.add(null);
            entryRow.add(null);
        }
        List<Control> allControls = this.getControls();
        if (HRObjectUtils.isEmpty(allControls) || allControls.size() == 0) {
            return new ArrayList<Object>(0);
        }
        for (Control ctl : allControls) {
            Object formatVal = null;
            ArrayList<OperationColItem> operationColItems = new ArrayList<OperationColItem>(10);
            if (ctl instanceof FieldEdit) {
                FieldEdit fldEdit = (FieldEdit)ctl;
                if (fldEdit instanceof LargeTextOtherEdit && StringUtils.isBlank((Object)(formatVal = view.getModel().getValue(fldEdit.getFieldKey() + "_tag", arg.getRowIndex()))) && StringUtils.isNotBlank((Object)fldEdit.getBindingValue(arg))) {
                    formatVal = fldEdit.getBindingValue(arg);
                }
            } else if (ctl instanceof OperationColumn) {
                for (OperationColItem operationColItem : ((OperationColumn)ctl).getOperationColItems()) {
                    OperationColItem newOperationColItem = new OperationColItem(operationColItem);
                    operationColItems.add(newOperationColItem);
                }
                formatVal = operationColItems;
            }
            PackageDataEvent packageDataEvent = new PackageDataEvent((Object)ctl, (DynamicObject)arg.getDataEntity(), formatVal);
            if (ctl instanceof OperationColumn) {
                entryRow.add(((OperationColumn)ctl).getBindingOperationColItems(operationColItems));
                continue;
            }
            if (!(ctl instanceof FieldEdit) || ((FieldEdit)ctl).isFlatField()) continue;
            entryRow.add(packageDataEvent.getFormatValue());
        }
        entryRow.add(new HashMap(0));
        entryRow.add(new HashMap(0));
        entryRow.add(new HashMap(0));
        entryRow.add(new HashMap(0));
        return entryRow;
    }

    private void setStdDimDataToCache() {
        DynamicObjectCollection stdDimDatas = this.getModel().getEntryEntity("entryentity");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        DetailStandardDimDTO oldDetailStandardDimDTO = this.getDetailStandardDimDTO(formShowParameter, true);
        if (stdDimDatas == null || stdDimDatas.size() == 0 || oldDetailStandardDimDTO == null) {
            if (oldDetailStandardDimDTO != null) {
                oldDetailStandardDimDTO.getValueMaps().clear();
                this.updateDetailDataToUpLevelCache(oldDetailStandardDimDTO, formShowParameter);
            }
            return;
        }
        DetailStandardDimDTO newDetailStandardDimDTO = DetailStandardDimDTO.updateInstance(null);
        newDetailStandardDimDTO.getFieldSet().addAll(oldDetailStandardDimDTO.getFieldSet());
        newDetailStandardDimDTO.setUseStdDim(oldDetailStandardDimDTO.getUseStdDim());
        int index = 0;
        for (DynamicObject dataObj : stdDimDatas) {
            ++index;
            List itemValueLinkedHashMaps = newDetailStandardDimDTO.getValueMaps();
            LinkedHashMap<String, String> itemValueLinkedHashMap = new LinkedHashMap<String, String>(16);
            for (String fieldKey : newDetailStandardDimDTO.getFieldSet()) {
                Object value = dataObj.getDynamicObjectType().getProperties().containsKey((Object)fieldKey) ? dataObj.get(fieldKey) : null;
                itemValueLinkedHashMap.put(fieldKey, value == null ? null : String.valueOf(value));
            }
            itemValueLinkedHashMaps.add(itemValueLinkedHashMap);
        }
        this.updateDetailDataToUpLevelCache(newDetailStandardDimDTO, formShowParameter);
    }

    private String getStdDimKey(LinkedHashSet<String> fieldSet, LinkedHashMap<String, String> detailStandardDimDTOValueMap) {
        String stdDimType = null;
        if (fieldSet.contains("bt0_") && (stdDimType = detailStandardDimDTOValueMap.get("bt0_")) == null) {
            return null;
        }
        String stdDimPro = null;
        if (fieldSet.contains("bt1_") && (stdDimPro = detailStandardDimDTOValueMap.get("bt1_")) == null) {
            return null;
        }
        return stdDimType == null ? stdDimPro : (stdDimPro == null ? stdDimType : stdDimType + ',' + stdDimPro);
    }

    private void registerDynamicProps(MainEntityType newMainType) {
        EntryType entryType = (EntryType)newMainType.getAllEntities().get("entryentity");
        IFormView parentView = this.getView().getParentView();
        if (HRObjectUtils.isEmpty((Object)parentView)) {
            return;
        }
        FormShowParameter formShow = this.getView().getFormShowParameter();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        paramMap.put(TMP_KEY_ENTRY_TYPE, entryType);
        this.executeCommand(formShow, COMMAND_CREATE_PROPERTIES, paramMap);
    }

    private boolean executeCommand(FormShowParameter formShow, String command, Map<String, Object> paramMap) {
        DetailStandardDimDTO detailStandardDimDTO;
        if (HRStringUtils.isEmpty((String)command) || paramMap.isEmpty() || (detailStandardDimDTO = this.getDetailStandardDimDTO(formShow, true)) == null) {
            return false;
        }
        for (String dyStandardEntityServiceName : DY_STANDARD_ENTITY_SERVICE_NAMES) {
            DyStandardEntityService dimDyStandardService = DyStandardEntityService.getService((DetailStandardDimDTO)detailStandardDimDTO, (String)dyStandardEntityServiceName);
            switch (command) {
                case "createEntryAp": {
                    EntityMetadata entityMetadata = (EntityMetadata)paramMap.get(TMP_KEY_ENTITY_META_DATA);
                    EntryAp entryAp = (EntryAp)paramMap.get(TMP_KEY_ENTRY_AP);
                    if (entityMetadata == null || entryAp == null) {
                        return false;
                    }
                    dimDyStandardService.createEntryAp(entityMetadata, entryAp);
                    break;
                }
                case "createProperties": {
                    EntryType entryType = (EntryType)paramMap.get(TMP_KEY_ENTRY_TYPE);
                    if (entryType == null) {
                        return false;
                    }
                    dimDyStandardService.createProperties(entryType);
                    break;
                }
            }
        }
        return true;
    }

    private Long getInsurTypeId(FormShowParameter formShow) {
        String insurTypeIdStr;
        Map customParams = formShow.getCustomParams();
        if (customParams == null || customParams.isEmpty() || (insurTypeIdStr = (String)customParams.get(formShow.getParentPageId() + "insurtype.id")) == null) {
            return null;
        }
        return Long.parseLong(insurTypeIdStr);
    }

    private void createGetControlByType(OnGetControlArgs ex) {
        String key = ex.getKey();
        ComboEdit fieldEdit = null;
        if (key.contains("bt") || key.contains("rt")) {
            fieldEdit = new ComboEdit();
        } else {
            DynamicObject insurItemInfo;
            Long insurItemId;
            int index = key.indexOf("it");
            if (index > -1 && (insurItemId = Long.valueOf(Long.parseLong(key.substring(index + "it".length())))) != 0L && (insurItemInfo = (DynamicObject)SocInsuranceStandardHelper.queryInsurItemInfoById(Collections.singletonList(insurItemId), null).get(0)) != null) {
                long dataTypeId = SitDataTypeEnum.getEnumById((long)insurItemInfo.getLong("datatype.id")).getId();
                Object object = fieldEdit = dataTypeId == SitDataTypeEnum.NUMBER.getId() ? new DecimalEdit() : new AmountEdit();
            }
        }
        if (fieldEdit != null) {
            fieldEdit.setKey(key);
            fieldEdit.setEntryKey("entryentity");
            fieldEdit.setView(this.getView());
            fieldEdit.setFieldKey(key.toLowerCase());
            fieldEdit.setModel(this.getView().getModel());
            ex.setControl((Control)fieldEdit);
        }
    }

    private List<Control> getControls() {
        EntryAp dynamicEntryAp = this.initEntryAp(this.getView().getFormShowParameter());
        if (dynamicEntryAp == null) {
            return new ArrayList<Control>(0);
        }
        ArrayList<Control> allControls = new ArrayList<Control>(10);
        List fieldEdits = ((Container)dynamicEntryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : fieldEdits) {
            if (fieldEdit instanceof Container) {
                allControls.addAll(((Container)fieldEdit).getItems());
                continue;
            }
            allControls.add(fieldEdit);
        }
        return allControls;
    }

    private EntryAp initEntryAp(FormShowParameter formShow) {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"sitbs_sinsurstandardent", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        EntryAp entryAp = new EntryAp();
        entryAp.setKey("entryentity");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        paramMap.put(TMP_KEY_ENTITY_META_DATA, entityMetadata);
        paramMap.put(TMP_KEY_ENTRY_AP, entryAp);
        if (!this.executeCommand(formShow, COMMAND_CREATE_ENTRYAP, paramMap)) {
            return null;
        }
        entryAp.setShowSeq(true);
        entryAp.setOrderAndFilter(1);
        entryAp.setShowSelChexkbox(true);
        entryAp.setMulti(true);
        entryAp.setAutoRowHeight(true);
        return entryAp;
    }

    private DetailStandardDimDTO getDetailStandardDimDTO(FormShowParameter formShow, boolean notAllowValue) {
        Long insurTypeId = this.getInsurTypeId(formShow);
        if (insurTypeId != null) {
            DetailStandardDimDTO detailStandardDimDTO = SocInsuranceStandardService.getDetailStandardDimDTO((String)formShow.getParentPageId(), (Long)insurTypeId);
            if (!notAllowValue && detailStandardDimDTO.getValueMaps().isEmpty()) {
                return null;
            }
            if (detailStandardDimDTO.getFieldSet() != null && !detailStandardDimDTO.getFieldSet().isEmpty() && !detailStandardDimDTO.getNameMap().isEmpty()) {
                return detailStandardDimDTO;
            }
        }
        return null;
    }

    private void updateDetailDataToUpLevelCache(DetailStandardDimDTO detailStandardDimDTO, FormShowParameter formShow) {
        Long insurTypeId = this.getInsurTypeId(formShow);
        if (insurTypeId != null) {
            SocInsuranceStandardService.updateDetailDataToUpLevelCache((Long)insurTypeId, (String)formShow.getParentPageId(), (DetailStandardDimDTO)detailStandardDimDTO);
        }
    }

    private boolean checkStdDimExists(String key, ChangeData changeData) {
        DetailStandardDimDTO detailStandardDimDTO;
        String currStdDimVal;
        if (changeData != null && (currStdDimVal = (String)changeData.getNewValue()) != null && !currStdDimVal.equals(changeData.getOldValue()) && (detailStandardDimDTO = this.getDetailStandardDimDTO(this.getView().getFormShowParameter(), true)) != null && changeData.getRowIndex() <= detailStandardDimDTO.getValueMaps().size()) {
            int index = changeData.getRowIndex();
            String typeVal = null;
            String proVal = null;
            LinkedHashSet fieldSet = detailStandardDimDTO.getFieldSet();
            if ("bt0_".equals(key)) {
                typeVal = currStdDimVal;
                if (fieldSet.contains("bt1_") && (proVal = (String)((LinkedHashMap)detailStandardDimDTO.getValueMaps().get(index)).get("bt1_")) == null) {
                    return false;
                }
            } else {
                if (fieldSet.contains("bt0_") && (typeVal = (String)((LinkedHashMap)detailStandardDimDTO.getValueMaps().get(index)).get("bt0_")) == null) {
                    return false;
                }
                proVal = currStdDimVal;
            }
            String currStdKey = typeVal == null ? proVal : (proVal == null ? typeVal : typeVal + ',' + proVal);
            for (int i = 0; i < detailStandardDimDTO.getValueMaps().size(); ++i) {
                String stdDim;
                if (i == index || (stdDim = this.getStdDimKey(fieldSet, (LinkedHashMap)detailStandardDimDTO.getValueMaps().get(i))) == null || !stdDim.equals(currStdKey)) continue;
                String errInfo = MessageFormat.format(SocInsuranceErrInfoEnum.STD_DIM_ARE_SAME.getErrInfo(), i + 1);
                String tmpErrInfo = null;
                if (fieldSet.contains("bt0_")) {
                    tmpErrInfo = SocInsuranceErrInfoEnum.CENSUS_REGISTER_TYPE.getErrInfo();
                    errInfo = errInfo + tmpErrInfo;
                }
                if (fieldSet.contains("bt1_")) {
                    errInfo = tmpErrInfo != null ? errInfo + SocInsuranceErrInfoEnum.AND.getErrInfo() + SocInsuranceErrInfoEnum.HOUSEHOLD_TYPE.getErrInfo() : errInfo + SocInsuranceErrInfoEnum.HOUSEHOLD_TYPE.getErrInfo();
                }
                this.getView().showTipNotification(errInfo);
                this.getModel().setValue(key, null, index);
                return true;
            }
        }
        return false;
    }
}

