/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.sinsurstandard;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sit.sitbp.business.datachanged.BizChangedHelper;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbp.business.util.MultiLangHelper;
import kd.sit.sitbp.common.cache.ISITAppCache;
import kd.sit.sitbp.common.cache.SITAppCache;
import kd.sit.sitbp.common.enums.ZhInsurTypeEnum;
import kd.sit.sitbp.common.util.ReflectUtils;
import kd.sit.sitbp.common.util.SITStringUtils;
import kd.sit.sitbs.business.socinsurance.dto.DetailStandardDimDTO;
import kd.sit.sitbs.business.socinsurance.dto.StandardDimDTO;
import kd.sit.sitbs.business.socinsurance.errinfo.SocInsuranceErrInfoEnum;
import kd.sit.sitbs.business.socinsurance.service.SInsuranceCommonService;
import kd.sit.sitbs.business.socinsurance.standard.helper.SocInsuranceStandardHelper;
import kd.sit.sitbs.business.socinsurance.standard.service.SocInsuranceStandardService;

public class SInsuranceStandardEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
TreeNodeClickListener {
    private static final String ADD_INSUR_TYPE = "addinsurtype";
    private static final String DEL_INSUR_TYPE = "delinsurtype";
    private static final String IS_CREATE_DATA_FIRST = "is_create_data_first";
    private static final String IS_FIRST_LOAD_DATA_FROM_RESULT_TABLE = "is_first_load_data_from_result_table";
    private static final String CURR_TREE_NODE_INFO_CACHE_KEY = "curr_tree_node_cache_key";
    private static final String SUB_PAGE_KEY = "sub_page_key";
    private static final String AP_FULL_PAGE_IF_EXISTS_DATA = "fullpage";
    private static final String AP_NULL_PAGE_IF_NOT_EXIST_DATA = "nullpage";
    private static final String CALLBACK_ID_BEFORE_SAVE_COMMON = "callback_id_before_save_common";
    private static final String CURR_STORE_LINES_CACHE_KEY = "storeLines";
    private static final String KEY_MOVE_UP = "moveup";
    private static final String KEY_MOVE_DOWN = "movedown";
    private static final Set<Long> DEFAULT_VIEW_ZH_INSUR_TYPE_NUMBER_SET = new HashSet<Long>(Arrays.asList(ZhInsurTypeEnum.ENDOWMENT_INSURANCE.getId(), ZhInsurTypeEnum.MEDICAL_INSURANCE.getId(), ZhInsurTypeEnum.UNEMPLOYMENT_INSURANCE.getId(), ZhInsurTypeEnum.EMPLOYMENT_INSURANCE.getId(), ZhInsurTypeEnum.MATERNITY_INSURANCE.getId(), ZhInsurTypeEnum.Housing_Provident_Fund.getId()));

    public void registerListener(EventObject ex) {
        super.registerListener(ex);
        SInsuranceCommonService.createInstance().multiSetBeforeF7SelectListener((Object)this, new String[]{"country", "insurtype", "insurarea"});
        this.addClickListeners(new String[]{ADD_INSUR_TYPE, DEL_INSUR_TYPE, "addline", "delline", "adddata", "refresh_page", KEY_MOVE_UP, KEY_MOVE_DOWN});
        TreeView insurTypeTreeView = (TreeView)this.getView().getControl("insurtypetreeview");
        insurTypeTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        this.getPageCache().put(IS_CREATE_DATA_FIRST + this.getView().getPageId(), Boolean.TRUE.toString());
        this.getModel().setDataChanged(false);
    }

    public void setView(IFormView formView) {
        BasedataEdit basedataEdit;
        super.setView(formView);
        SInsuranceCommonService.createInstance().lockCommonFields(this.getView());
        if (BaseDataHisHelper.isHisPage((IFormView)this.getView()) && (basedataEdit = (BasedataEdit)formView.getControl("insurarea")) != null) {
            basedataEdit.setEnable(null, false, 0);
        }
    }

    public void beforeBindData(EventObject ex) {
        if (!Long.valueOf(0L).equals(this.getModel().getDataEntity(true).getPkValue())) {
            TextEdit textEdit = (TextEdit)this.getControl("number");
            textEdit.setEnable(null, false, 0);
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        }
        this.updateBtnView();
        this.showInsurStandardEntityView(Boolean.TRUE, Boolean.TRUE);
        IPageCache pageCache = this.getPageCache();
        if (!Boolean.FALSE.toString().equals(pageCache.get(IS_FIRST_LOAD_DATA_FROM_RESULT_TABLE + this.getView().getPageId()))) {
            this.updateResultDataToCache();
        }
        if (Boolean.TRUE.toString().equals(pageCache.get(IS_CREATE_DATA_FIRST + this.getView().getPageId()))) {
            if (!BaseDataHisHelper.isHisPage((IFormView)this.getView())) {
                this.setStdDimDyVisable(Boolean.FALSE);
                List<DynamicObject> insurTypeInfoDys = this.getInsurTypeInfoDys(true, null);
                List<Long> insurTypeIds = insurTypeInfoDys.stream().map(insurTypeInfoDy -> insurTypeInfoDy.getLong("id")).collect(Collectors.toList());
                this.updateInsurTypeInfoCache(insurTypeIds, true);
                this.buildInsurTypeTree(insurTypeInfoDys, true, null);
                this.buildEntityView(null);
                this.getModel().setDataChanged(false);
                this.setFirstCache();
                this.getPageCache().remove(IS_CREATE_DATA_FIRST + this.getView().getPageId());
                return;
            }
            this.showConfirm(null);
            this.getPageCache().remove(IS_CREATE_DATA_FIRST + this.getView().getPageId());
        }
        String isFirstCopy = "isFirstCopy";
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("iscopy") && !Boolean.FALSE.toString().equals(pageCache.get(this.getView().getPageId() + isFirstCopy))) {
            StandardDimDTO standardDimDTOFromCache = SocInsuranceStandardService.getStandardDimDTOFromCache((String)this.getView().getPageId());
            this.updateInsurTypeInfoCache(standardDimDTOFromCache.getFieldMap().keySet(), false);
        }
        if (!Boolean.FALSE.toString().equals(pageCache.get(this.getView().getPageId() + isFirstCopy))) {
            StandardDimDTO standardDimDTO = SocInsuranceStandardService.getStandardDimDTOFromCache((String)this.getView().getPageId());
            Set<Long> insurTypeIdSet = standardDimDTO.getFieldMap().keySet();
            this.buildInsurTypeTree(null, false, insurTypeIdSet);
            this.buildEntityView(null);
            pageCache.put(this.getView().getPageId() + isFirstCopy, Boolean.FALSE.toString());
        }
        this.setFirstCache();
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Control source = (Control)evt.getSource();
        if (HRStringUtils.equals((String)source.getKey(), (String)"insurtypetreeview")) {
            Object nodeId = evt.getNodeId();
            this.showViewForCurrNode(nodeId);
        }
    }

    public void propertyChanged(PropertyChangedArgs ex) {
        Object changeData;
        super.propertyChanged(ex);
        String key = ex.getProperty().getName();
        Object[] changes = ex.getChangeSet();
        if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus()) || ArrayUtils.isEmpty((Object[])changes) || (changeData = changes[0]) == null || changeData.getNewValue() != null && changeData.getNewValue().equals(changeData.getOldValue())) {
            return;
        }
        switch (key) {
            case "isstddimdy": {
                if (Boolean.TRUE.equals(changeData.getNewValue())) {
                    this.setStdDimDyVisable(Boolean.TRUE);
                    this.updateCurrTreeNodeInfoCache(null, null, 1);
                    this.updateDetailCache();
                    break;
                }
                DetailStandardDimDTO detailStandardDimDTO = this.getDetailStandardDimDTO();
                this.updateCurrTreeNodeInfoCache(null, null, 1);
                if (detailStandardDimDTO != null && detailStandardDimDTO.getValueMaps().size() > 1) {
                    this.getView().showConfirm(SocInsuranceErrInfoEnum.STD_DIM_CHANGED.getErrInfo(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(SocInsuranceErrInfoEnum.STD_DIM_CHANGED.getErrCode()));
                    return;
                }
                this.setStdDimDyVisable(Boolean.FALSE);
                this.updateDetailCache();
                if (this.getModel().getValue("stddimdy") == null) break;
                this.buildEntityView(null);
                break;
            }
            case "stddimdy": {
                String oldDyStdDim = (String)changeData.getOldValue();
                String oldType = !HRStringUtils.isEmpty((String)oldDyStdDim) && oldDyStdDim.contains("0") ? "1" : "0";
                String oldPro = !HRStringUtils.isEmpty((String)oldDyStdDim) && oldDyStdDim.contains("1") ? "1" : "0";
                oldDyStdDim = oldType + oldPro;
                String newDyStdDim = (String)changeData.getNewValue();
                String newType = !HRStringUtils.isEmpty((String)newDyStdDim) && newDyStdDim.contains("0") ? "1" : "0";
                String newPro = !HRStringUtils.isEmpty((String)newDyStdDim) && newDyStdDim.contains("1") ? "1" : "0";
                newDyStdDim = newType + newPro;
                DetailStandardDimDTO detailStandardDimDTO = this.getDetailStandardDimDTO();
                Integer storeLines = 0;
                if ("00".equals(oldDyStdDim) || !"11".equals(newDyStdDim) && !oldDyStdDim.equals(newDyStdDim)) {
                    storeLines = 1;
                } else if ("11".equals(newDyStdDim) || oldDyStdDim.equals(newDyStdDim)) {
                    storeLines = detailStandardDimDTO == null ? 0 : detailStandardDimDTO.getValueMaps().size();
                }
                this.updateCurrTreeNodeInfoCache(null, null, storeLines);
                if (!(detailStandardDimDTO == null || detailStandardDimDTO.getValueMaps().size() <= 1 || oldDyStdDim.equals(newDyStdDim) || "00".equals(oldDyStdDim) || "11".equals(newDyStdDim))) {
                    this.getView().showConfirm(SocInsuranceErrInfoEnum.STD_DIM_CHANGED.getErrInfo(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(SocInsuranceErrInfoEnum.STD_DIM_CHANGED.getErrCode()));
                    return;
                }
                this.updateDetailCache();
                this.buildEntityView(null);
                break;
            }
            case "createorg": 
            case "useorg": {
                if (BaseDataHisHelper.isHisPage((IFormView)this.getView()) || !this.getModel().getDataEntity().getPkValue().equals(0L)) break;
                IHRAppCache appCache = HRAppCache.get((String)("insur_type_cache_key" + this.getView().getPageId()));
                appCache.remove("insur_type_cache_key");
                this.getPageCache().put(IS_CREATE_DATA_FIRST + this.getView().getPageId(), Boolean.TRUE.toString());
                this.getView().updateView();
                this.getModel().setDataChanged(false);
                break;
            }
        }
        this.updateDataChanged();
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "adddata": {
                this.openInsurTypePage();
                break;
            }
            case "refresh_page": {
                TreeView insurTypeTreeView = (TreeView)this.getView().getControl("insurtypetreeview");
                TreeView.TreeState treeState = insurTypeTreeView.getTreeState();
                String lastFocusNodeId = treeState.getFocusNodeId();
                if (lastFocusNodeId == null) break;
                this.showViewForCurrNode(lastFocusNodeId);
                break;
            }
            case "moveup": 
            case "movedown": {
                this.moveTreeNode(key);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name;
        switch (name = beforeF7SelectEvent.getProperty().getName()) {
            case "insurarea": {
                QFilter filter = SocInsuranceStandardService.createInstance().getCommonQFilter(this.getView(), "sitbs_placeofwelfare");
                beforeF7SelectEvent.addCustomQFilter(filter);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (formOperate.getOperateKey()) {
            case "addinsurtype": {
                this.openSocInsurTypeView();
                break;
            }
            case "delinsurtype": {
                this.delInsurTypeTreeNode();
                break;
            }
            case "addline": {
                if (this.checkStdDimInvalid()) {
                    args.setCancel(true);
                    return;
                }
                this.operateSubPage(formOperate.getOperateKey());
                break;
            }
            case "delline": {
                this.operateSubPage(formOperate.getOperateKey());
                break;
            }
            case "changesave": 
            case "save": 
            case "submit": 
            case "confirmchange": 
            case "confirmchangenoaudit": {
                OperateOption option = formOperate.getOption();
                if (!option.tryGetVariableValue(CALLBACK_ID_BEFORE_SAVE_COMMON, new RefObject((Object)Boolean.TRUE.toString())) && this.showConfirm(formOperate.getOperateKey())) {
                    args.setCancel(true);
                    return;
                }
                option.removeVariable(CALLBACK_ID_BEFORE_SAVE_COMMON);
                option.setVariableValue("is_detail_view", Boolean.TRUE.toString());
                option.setVariableValue("insur_type_cache_key", this.getView().getPageId());
                this.getPageCache().remove(this.getView().getPageId() + CALLBACK_ID_BEFORE_SAVE_COMMON);
                break;
            }
            case "first": 
            case "previous": 
            case "next": 
            case "last": {
                this.updateResultDataToCache();
                Set<Long> insurTypeIdSet = SocInsuranceStandardService.getStandardDimDTOFromCache((String)this.getView().getPageId()).getFieldMap().keySet();
                this.buildInsurTypeTree(null, false, insurTypeIdSet);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        switch (args.getOperateKey()) {
            case "changesave": 
            case "save": 
            case "submit": 
            case "audit": 
            case "unsubmit": 
            case "unaudit": 
            case "donothing_confirmchange": 
            case "auditconfirmchange": {
                this.updateBtnView();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (closedCallBackEvent.getActionId()) {
            case "sitbs_welfaretype": {
                ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)returnData;
                StandardDimDTO standardDimDTOFromCache = SocInsuranceStandardService.getStandardDimDTOFromCache((String)this.getView().getPageId());
                ArrayList<Long> newInsurTypeIds = new ArrayList<Long>(standardDimDTOFromCache.getFieldMap().keySet());
                listSelectedRowCollection.forEach(pkDy -> newInsurTypeIds.add((Long)pkDy.getPrimaryKeyValue()));
                List<DynamicObject> insurTypeInfoDys = this.getInsurTypeInfoDys(false, newInsurTypeIds);
                if (CollectionUtils.isEmpty(insurTypeInfoDys)) {
                    return;
                }
                this.updateInsurTypeInfoCache(newInsurTypeIds, false);
                if (insurTypeInfoDys.size() == 1) {
                    this.showInsurStandardEntityView(Boolean.TRUE, Boolean.FALSE);
                }
                this.buildInsurTypeTree(insurTypeInfoDys, true, newInsurTypeIds);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if (CALLBACK_ID_BEFORE_SAVE_COMMON.equals(callBackId)) {
            Set<Long> insurTypeIdSet = SocInsuranceStandardService.getStandardDimDTOFromCache((String)this.getView().getPageId()).getFieldMap().keySet();
            this.buildInsurTypeTree(null, false, insurTypeIdSet);
            String opKey = this.getPageCache().get(this.getView().getPageId() + CALLBACK_ID_BEFORE_SAVE_COMMON);
            this.getPageCache().remove(this.getView().getPageId() + CALLBACK_ID_BEFORE_SAVE_COMMON);
            if (!HRStringUtils.isEmpty((String)opKey)) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(CALLBACK_ID_BEFORE_SAVE_COMMON, Boolean.TRUE.toString());
                this.getView().invokeOperation(opKey, operateOption);
            }
        } else if (callBackId.equals(SocInsuranceErrInfoEnum.STD_DIM_CHANGED.getErrCode())) {
            if (MessageBoxResult.Yes.equals((Object)event.getResult())) {
                if (Boolean.FALSE.equals(this.getModel().getValue("isstddimdy"))) {
                    this.getModel().beginInit();
                    this.setStdDimDyVisable(Boolean.FALSE);
                    this.getModel().endInit();
                    this.getView().updateView("stddimdy");
                    this.updateCurrTreeNodeInfoCache(null, null, 1);
                }
                this.updateDetailCache();
                this.buildEntityView(null);
            } else {
                this.updateStdDim();
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent ex) {
        super.beforeClosed(ex);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("stdentryentity");
        List<String> entityFields = Arrays.asList("insurtype", "isstddim", "stddim", "sinsurstdcfg");
        List<String> subEntityFields = Arrays.asList("registertype", "category", "insuritem", "itemvalue", "roundtype");
        for (DynamicObject entity : entryEntity) {
            BizChangedHelper.operateBizChangedSet((DynamicObject)entity, entityFields, (BizChangedHelper.OperateEnum)BizChangedHelper.OperateEnum.DELETE);
            DynamicObjectCollection subEntryEntity = entity.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subEntity : subEntryEntity) {
                BizChangedHelper.operateBizChangedSet((DynamicObject)subEntity, subEntityFields, (BizChangedHelper.OperateEnum)BizChangedHelper.OperateEnum.DELETE);
            }
        }
    }

    public void pageRelease(EventObject ex) {
        super.pageRelease(ex);
        ISITAppCache appCache = SITAppCache.get((String)("insur_type_cache_key" + this.getView().getPageId()));
        appCache.clear();
    }

    private void moveTreeNode(String key) {
        StandardDimDTO standardDimDTOFromCache = SocInsuranceStandardService.getStandardDimDTOFromCache((String)this.getView().getPageId());
        ArrayList<Long> existInsurTypeIds = new ArrayList<Long>(standardDimDTOFromCache.getFieldMap().keySet());
        TreeView treeView = (TreeView)this.getView().getControl("insurtypetreeview");
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        if (SITStringUtils.isEmpty((String)focusNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u9669\u79cd\u8282\u70b9\u518d\u64cd\u4f5c\u3002", (String)"SInsuranceStandardEdit_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        Long curInsurTypeId = Long.parseLong(focusNodeId);
        int curIndex = existInsurTypeIds.indexOf(curInsurTypeId);
        this.swapInsurTypeId(key, existInsurTypeIds, curIndex);
        List<DynamicObject> insurTypeInfoDys = this.getInsurTypeInfoDys(false, existInsurTypeIds);
        if (CollectionUtils.isEmpty(insurTypeInfoDys)) {
            return;
        }
        Map insurTypeInfoMap = insurTypeInfoDys.stream().collect(Collectors.toMap(k1 -> k1.getLong("id"), Function.identity()));
        this.buildInsurTypeTree(insurTypeInfoDys, true, existInsurTypeIds);
        TreeNode selectedNode = new TreeNode("", curInsurTypeId + "", ((DynamicObject)insurTypeInfoMap.get(curInsurTypeId)).getString("name"));
        treeView.checkNode(selectedNode);
        treeView.focusNode(selectedNode);
        SocInsuranceStandardService.updateStandardDimDTO(existInsurTypeIds, (StandardDimDTO)standardDimDTOFromCache, (String)this.getView().getPageId());
        this.showViewForCurrNode(curInsurTypeId);
    }

    private void swapInsurTypeId(String key, List<Long> existInsurTypeIds, int curIndex) {
        if (SITStringUtils.equals((String)KEY_MOVE_UP, (String)key) && curIndex != 0) {
            Collections.swap(existInsurTypeIds, curIndex, curIndex - 1);
        }
        if (SITStringUtils.equals((String)KEY_MOVE_DOWN, (String)key) && curIndex != existInsurTypeIds.size() - 1) {
            Collections.swap(existInsurTypeIds, curIndex, curIndex + 1);
        }
    }

    private boolean showConfirm(String operateKey) {
        StandardDimDTO oldStandardDimDTOFromCache = SocInsuranceStandardService.getStandardDimDTOFromCache((String)this.getView().getPageId());
        if (!CollectionUtils.isEmpty((Map)oldStandardDimDTOFromCache.getFieldMap())) {
            Set currAllInsurTypeIds = oldStandardDimDTOFromCache.getFieldMap().keySet();
            this.updateInsurTypeInfoCache(oldStandardDimDTOFromCache.getFieldMap().keySet(), false);
            StandardDimDTO newStandardDimDTO = SocInsuranceStandardService.getStandardDimDTOFromCache((String)this.getView().getPageId());
            ArrayList<Long> changedInsurIds = new ArrayList<Long>(currAllInsurTypeIds.size());
            block0: for (Long insurTypeId : currAllInsurTypeIds) {
                LinkedHashSet oldDetailFieldLinkedSet = (LinkedHashSet)oldStandardDimDTOFromCache.getFieldMap().get(insurTypeId);
                LinkedHashSet newDetailFieldLinkedSet = (LinkedHashSet)newStandardDimDTO.getFieldMap().get(insurTypeId);
                if (newDetailFieldLinkedSet == null || !oldDetailFieldLinkedSet.containsAll(newDetailFieldLinkedSet) || !newDetailFieldLinkedSet.containsAll(oldDetailFieldLinkedSet)) {
                    changedInsurIds.add(insurTypeId);
                    continue;
                }
                Iterator newFieldIter = newDetailFieldLinkedSet.iterator();
                for (String oldDetailField : oldDetailFieldLinkedSet) {
                    if (HRStringUtils.equals((String)oldDetailField, (String)((String)newFieldIter.next()))) continue;
                    changedInsurIds.add(insurTypeId);
                    continue block0;
                }
            }
            if (!changedInsurIds.isEmpty()) {
                List insurTypeInfoDyColl = SocInsuranceStandardHelper.queryDefaultInsurTypeInfo((QFilter)new QFilter("id", "in", changedInsurIds), (boolean)false);
                StringJoiner changedNames = new StringJoiner(MultiLangHelper.getMultiLangCommaDelimiter());
                insurTypeInfoDyColl.forEach(insurTypeInfoDy -> changedNames.add(insurTypeInfoDy.getString("name")));
                String errInfo = MessageFormat.format(SocInsuranceErrInfoEnum.STD_DIM_TABLE_CHANGED.getErrInfo(), changedNames.toString());
                this.getPageCache().put(this.getView().getPageId() + CALLBACK_ID_BEFORE_SAVE_COMMON, operateKey);
                this.getView().showConfirm(errInfo, MessageBoxOptions.OK, ConfirmTypes.Save, new ConfirmCallBackListener(CALLBACK_ID_BEFORE_SAVE_COMMON));
                return true;
            }
        }
        return false;
    }

    private void buildInsurTypeTree(List<DynamicObject> insurTypeInfoDys, boolean isCreateNewData, Collection<Long> orderInsurTypeIdColl) {
        if (CollectionUtils.isEmpty(insurTypeInfoDys) && (isCreateNewData || !CollectionUtils.isEmpty(orderInsurTypeIdColl))) {
            insurTypeInfoDys = this.getInsurTypeInfoDys(isCreateNewData, orderInsurTypeIdColl);
            this.orderInsurTypeDys(insurTypeInfoDys, orderInsurTypeIdColl);
        }
        this.updateInsurTypeTree(insurTypeInfoDys);
    }

    private void orderInsurTypeDys(List<DynamicObject> insurTypeInfoDys, Collection<Long> orderInsurTypeIdColl) {
        if (!CollectionUtils.isEmpty(insurTypeInfoDys) && !CollectionUtils.isEmpty(orderInsurTypeIdColl)) {
            Map<Long, DynamicObject> insurTypeInfoDyMap = insurTypeInfoDys.stream().collect(Collectors.toMap(insurTypeInfoDy -> insurTypeInfoDy.getLong("id"), insurTypeInfoDy -> insurTypeInfoDy, (oldVal, newVal) -> oldVal));
            insurTypeInfoDys.clear();
            orderInsurTypeIdColl.forEach(orderInsurTypeId -> {
                if (insurTypeInfoDyMap.get(orderInsurTypeId) != null) {
                    insurTypeInfoDys.add((DynamicObject)insurTypeInfoDyMap.get(orderInsurTypeId));
                }
            });
        }
    }

    private List<DynamicObject> getInsurTypeInfoDys(boolean isCreateNewData, Collection<Long> orderInsurTypeIdColl) {
        List insurTypeInfoDys = null;
        boolean enableAndAudit = false;
        QFilter filter = null;
        if (isCreateNewData) {
            filter = new QFilter("id", "in", DEFAULT_VIEW_ZH_INSUR_TYPE_NUMBER_SET);
            enableAndAudit = true;
        }
        if (!CollectionUtils.isEmpty(orderInsurTypeIdColl)) {
            filter = new QFilter("id", "in", orderInsurTypeIdColl);
        }
        if ((insurTypeInfoDys = SocInsuranceStandardHelper.queryDefaultInsurTypeInfo(filter, (boolean)enableAndAudit)) == null) {
            return Collections.emptyList();
        }
        if (!CollectionUtils.isEmpty(orderInsurTypeIdColl)) {
            this.orderInsurTypeDys(insurTypeInfoDys, orderInsurTypeIdColl);
        }
        return insurTypeInfoDys;
    }

    private void buildEntityView(String insurTypeIdStr) {
        String currInsurTypeIdStr;
        String string = currInsurTypeIdStr = !HRStringUtils.isEmpty((String)insurTypeIdStr) ? insurTypeIdStr : this.getCurrTreeNodeCache().getString("insurtype.id");
        if (currInsurTypeIdStr == null) {
            return;
        }
        FormShowParameter formShow = new FormShowParameter();
        formShow.setStatus(this.getView().getFormShowParameter().getStatus());
        OpenStyle openStyle = formShow.getOpenStyle();
        openStyle.setTargetKey("contentpanel");
        openStyle.setShowType(ShowType.InContainer);
        formShow.setFormId("sitbs_sinsurstandardent");
        formShow.setParentPageId(this.getView().getPageId());
        String pageId = this.getView().getPageId();
        IFormView childView = this.getChildView();
        if (childView != null) {
            childView.close();
        }
        this.updateCurrTreeNodeInfoCache(currInsurTypeIdStr, formShow.getPageId(), null);
        formShow.setCustomParam(pageId + "insurtype.id", (Object)currInsurTypeIdStr);
        this.getView().showForm(formShow);
    }

    private void openInsurTypePage() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setBillFormId("sitbs_sinsurstdcfg");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void updateSubPage() {
        IFormView childView = this.getChildView();
        this.getView().getView("");
        if (childView != null) {
            childView.updateView();
            IDataModel iDataModel = childView.getModel();
        }
    }

    private void operateSubPage(String opKey) {
        IFormView childView = this.getChildView();
        if (opKey == null || childView == null) {
            return;
        }
        childView.invokeOperation(opKey);
        this.getView().sendFormAction(childView);
    }

    private IFormView getChildView() {
        IFormView childView;
        JSONObject currTreeNodeCache = this.getCurrTreeNodeCache();
        Long insurTypeId = currTreeNodeCache.getLong("insurtype.id");
        String subPageId = currTreeNodeCache.getString(SUB_PAGE_KEY);
        if (insurTypeId == null || subPageId == null || (childView = this.getView().getView(subPageId)) == null) {
            return null;
        }
        return childView;
    }

    private void openSocInsurTypeView() {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"sitbs_welfaretype", (boolean)true);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "sitbs_welfaretype"));
        QFilter filter = SocInsuranceStandardService.createInstance().getCommonQFilter(this.getView(), "sitbs_welfaretype");
        showParameter.setListFilterParameter(new ListFilterParameter(Arrays.asList(filter.toArray()), null));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void delInsurTypeTreeNode() {
        TreeView insurTypeTreeView = (TreeView)this.getView().getControl("insurtypetreeview");
        TreeView.TreeState treeState = insurTypeTreeView.getTreeState();
        if (treeState == null || HRStringUtils.isEmpty((String)treeState.getFocusNodeId())) {
            this.getView().showTipNotification(SocInsuranceErrInfoEnum.DEL_INSUR_TYPE_IN_STD.getErrInfo());
        } else {
            Long focusNodeId = Long.valueOf(treeState.getFocusNodeId());
            StandardDimDTO standardDimDTOFromCache = SocInsuranceStandardService.getStandardDimDTOFromCache((String)this.getView().getPageId());
            standardDimDTOFromCache.getFieldMap().remove(focusNodeId);
            standardDimDTOFromCache.getValueMap().remove(focusNodeId);
            standardDimDTOFromCache.getUseStdDimMap().remove(focusNodeId);
            ArrayList<Long> insurTypes = new ArrayList<Long>(standardDimDTOFromCache.getFieldMap().keySet());
            List<DynamicObject> insurTypeDys = this.getInsurTypeInfoDys(false, insurTypes);
            this.updateStandardDimDTOToCache(standardDimDTOFromCache);
            this.updateInsurTypeTree(insurTypeDys);
            if (standardDimDTOFromCache.getFieldMap().isEmpty()) {
                IFormView childView = this.getChildView();
                if (childView != null) {
                    childView.close();
                }
                this.showInsurStandardEntityView(Boolean.FALSE, Boolean.FALSE);
                this.getPageCache().put(this.getView().getPageId() + CURR_TREE_NODE_INFO_CACHE_KEY, new JSONObject().toJSONString());
            }
        }
    }

    private void updateInsurTypeTree(List<DynamicObject> insurTypeInfoDys) {
        TreeView insurTypeTreeView = (TreeView)this.getView().getControl("insurtypetreeview");
        if (CollectionUtils.isEmpty(insurTypeInfoDys)) {
            insurTypeTreeView.deleteAllNodes();
            return;
        }
        ArrayList<TreeNode> insurTypeNodes = new ArrayList<TreeNode>(insurTypeInfoDys.size());
        for (DynamicObject insurTypeInfo : insurTypeInfoDys) {
            TreeNode levelOneNode = new TreeNode("", insurTypeInfo.getString("id"), insurTypeInfo.getString("name"));
            insurTypeNodes.add(levelOneNode);
        }
        TreeView.TreeState treeState = insurTypeTreeView.getTreeState();
        String lastFocusNodeId = treeState.getFocusNodeId();
        insurTypeTreeView.deleteAllNodes();
        insurTypeTreeView.addNodes(insurTypeNodes);
        List insurTypeTreeNodeClickListeners = (List)ReflectUtils.getFieldValue((String)"treeNodeClickListeners", (Object)insurTypeTreeView);
        if (insurTypeTreeNodeClickListeners == null || insurTypeTreeNodeClickListeners.isEmpty() || !insurTypeTreeNodeClickListeners.contains((Object)this)) {
            insurTypeTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        }
        if (insurTypeNodes.size() > 0) {
            insurTypeTreeView.focusNode((TreeNode)insurTypeNodes.get(0));
            insurTypeTreeView.checkNode((TreeNode)insurTypeNodes.get(0));
            this.setStdDimByInsurTypeId(insurTypeInfoDys.get(0).getLong("id"));
            insurTypeTreeView.treeNodeClick("", insurTypeInfoDys.get(0).getString("id"));
        }
        insurTypeTreeView.setMulti(false);
        insurTypeTreeView.setDraggable(false);
        insurTypeTreeView.setDroppable(false);
        this.updateDataChanged();
    }

    private void showInsurStandardEntityView(Boolean isVisible, Boolean closeImage) {
        this.getView().setVisible(isVisible, new String[]{AP_FULL_PAGE_IF_EXISTS_DATA});
        this.getView().setVisible(Boolean.valueOf(isVisible == false), new String[]{AP_NULL_PAGE_IF_NOT_EXIST_DATA});
        if (!isVisible.booleanValue()) {
            this.getView().setVisible(closeImage, new String[]{"imageap", "tipap"});
        }
    }

    private void updateCurrTreeNodeInfoCache(String treeNodeId, String subPageId, Integer storeLines) {
        JSONObject currTreeNodeJson = this.getCurrTreeNodeCache();
        if (treeNodeId != null) {
            currTreeNodeJson.put("insurtype.id", (Object)treeNodeId);
        }
        if (subPageId != null) {
            currTreeNodeJson.put(SUB_PAGE_KEY, (Object)subPageId);
        }
        if (storeLines != null) {
            currTreeNodeJson.put(CURR_STORE_LINES_CACHE_KEY, (Object)storeLines);
        }
        this.getPageCache().put(this.getView().getPageId() + CURR_TREE_NODE_INFO_CACHE_KEY, currTreeNodeJson.toJSONString());
    }

    private JSONObject getCurrTreeNodeCache() {
        JSONObject currTreeNodeJson;
        String currTreeNodeJsonStr = this.getPageCache().get(this.getView().getPageId() + CURR_TREE_NODE_INFO_CACHE_KEY);
        if (currTreeNodeJsonStr == null || (currTreeNodeJson = JSON.parseObject((String)currTreeNodeJsonStr)) == null) {
            currTreeNodeJson = new JSONObject(true);
        }
        return currTreeNodeJson;
    }

    private void updateInsurTypeInfoCache(Collection<Long> insurTypeIds, boolean isCreateNewData) {
        IHRAppCache appCache = HRAppCache.get((String)("insur_type_cache_key" + this.getView().getPageId()));
        StandardDimDTO standardDimDTO = (StandardDimDTO)appCache.get("insur_type_cache_key", StandardDimDTO.class);
        if (CollectionUtils.isEmpty(insurTypeIds)) {
            if (standardDimDTO != null) {
                standardDimDTO.clearData();
            }
            appCache.put("insur_type_cache_key", (Object)standardDimDTO);
            return;
        }
        standardDimDTO = SocInsuranceStandardService.updateInsurTypeInfoCache(insurTypeIds, (StandardDimDTO)standardDimDTO, (boolean)isCreateNewData);
        appCache.put("insur_type_cache_key", (Object)standardDimDTO);
    }

    private void updateResultDataToCache() {
        DynamicObjectCollection stdEntryEntity = this.getModel().getEntryEntity("stdentryentity");
        StandardDimDTO standardDimDTO = SocInsuranceStandardService.createInstance().getInsurTypeInfoInResultLinkedMap(stdEntryEntity, this.isSubmitOrAuditOrHis());
        IHRAppCache appCache = HRAppCache.get((String)("insur_type_cache_key" + this.getView().getPageId()));
        appCache.put("insur_type_cache_key", (Object)standardDimDTO);
    }

    private void updateDetailCache() {
        StandardDimDTO standardDimDTO;
        Long insurTypeId;
        JSONObject currTreeNodeJson = this.getCurrTreeNodeCache();
        if (currTreeNodeJson.isEmpty() || (insurTypeId = currTreeNodeJson.getLong("insurtype.id")) == null || (standardDimDTO = SocInsuranceStandardService.getStandardDimDTOFromCache((String)this.getView().getPageId())).getFieldMap().isEmpty()) {
            return;
        }
        Integer currStoreLines = currTreeNodeJson.getInteger(CURR_STORE_LINES_CACHE_KEY);
        LinkedHashSet fieldSet = standardDimDTO.getFieldMap().computeIfAbsent(insurTypeId, key -> new LinkedHashSet(16));
        Boolean isStdDimDy = (Boolean)this.getModel().getValue("isstddimdy");
        standardDimDTO.getUseStdDimMap().put(insurTypeId, isStdDimDy != false ? "1" : "0");
        if (isStdDimDy.booleanValue()) {
            String dyStdDim = (String)this.getModel().getValue("stddimdy");
            boolean isContainType = !HRStringUtils.isEmpty((String)dyStdDim) && dyStdDim.contains("0");
            boolean isContainPro = !HRStringUtils.isEmpty((String)dyStdDim) && dyStdDim.contains("1");
            LinkedHashSet<String> newFieldSet = new LinkedHashSet<String>(16);
            if (isContainType) {
                newFieldSet.add("bt0_");
            } else {
                fieldSet.remove("bt0_");
            }
            if (isContainPro) {
                fieldSet.add("bt1_");
            } else {
                fieldSet.remove("bt1_");
            }
            if (fieldSet.contains("bt0_")) {
                newFieldSet.add("bt0_");
                fieldSet.remove("bt0_");
            }
            if (fieldSet.contains("bt1_")) {
                newFieldSet.add("bt1_");
                fieldSet.remove("bt1_");
            }
            newFieldSet.addAll(fieldSet);
            fieldSet.clear();
            fieldSet.addAll(newFieldSet);
            newFieldSet.clear();
        } else {
            fieldSet.remove("bt0_");
            fieldSet.remove("bt1_");
        }
        standardDimDTO = SocInsuranceStandardService.updateInsurTypeInfoCache(Collections.singletonList(insurTypeId), (StandardDimDTO)standardDimDTO, (boolean)false, (boolean)false, (Integer)currStoreLines);
        this.updateStandardDimDTOToCache(standardDimDTO);
    }

    private DetailStandardDimDTO getDetailStandardDimDTO() {
        Long insurTypeId;
        JSONObject currTreeNodeJson = this.getCurrTreeNodeCache();
        DetailStandardDimDTO detailStandardDimDTO = null;
        if (currTreeNodeJson.isEmpty() || (insurTypeId = currTreeNodeJson.getLong("insurtype.id")) == null || (detailStandardDimDTO = this.getDetailStandardDimDTOByInsurId(insurTypeId)) == null) {
            return null;
        }
        return detailStandardDimDTO;
    }

    private DetailStandardDimDTO getDetailStandardDimDTOByInsurId(Long insurTypeId) {
        DetailStandardDimDTO detailStandardDimDTO = SocInsuranceStandardService.getDetailStandardDimDTO((String)this.getView().getPageId(), (Long)insurTypeId);
        if (detailStandardDimDTO.getFieldSet().isEmpty()) {
            return null;
        }
        return detailStandardDimDTO;
    }

    private void updateStdDim() {
        Long insurTypeId;
        JSONObject currTreeNodeJson = this.getCurrTreeNodeCache();
        if (!currTreeNodeJson.isEmpty() && (insurTypeId = currTreeNodeJson.getLong("insurtype.id")) != null) {
            this.setStdDimByInsurTypeId(insurTypeId);
        }
    }

    private void setStdDimByInsurTypeId(long insurTypeId) {
        DetailStandardDimDTO detailStandardDimDTO = this.getDetailStandardDimDTOByInsurId(insurTypeId);
        if (detailStandardDimDTO != null) {
            HashSet bizChangedSet = new HashSet(16);
            this.getModel().getDataEntity(true).getDataEntityState().getBizChangedProperties().forEach(next -> bizChangedSet.add(next.getOrdinal()));
            this.getModel().beginInit();
            Boolean isStdDim = "1".equals(detailStandardDimDTO.getUseStdDim());
            LinkedHashSet fieldSet = detailStandardDimDTO.getFieldSet();
            this.getModel().setValue("isstddimdy", (Object)isStdDim);
            this.setStdDimDyVisable(isStdDim);
            String stdDimDyType = fieldSet.contains("bt0_") ? "0" : "";
            String stdDimDyPro = fieldSet.contains("bt1_") ? "1" : "";
            String stdDimDy = stdDimDyType.length() == 0 ? stdDimDyPro : stdDimDyType + "," + stdDimDyPro;
            this.getModel().setValue("stddimdy", (Object)(stdDimDy.length() > 0 ? stdDimDy : null));
            this.getModel().endInit();
            this.getView().updateView("isstddimdy");
            this.getView().updateView("stddimdy");
            DataEntityState dataEntityState = this.getModel().getDataEntity(true).getDataEntityState();
            Iterable bizChangedProperties = this.getModel().getDataEntity(true).getDataEntityState().getBizChangedProperties();
            for (IDataEntityProperty next2 : bizChangedProperties) {
                dataEntityState.setBizChanged(next2.getOrdinal(), bizChangedSet.contains(next2.getOrdinal()));
            }
        }
    }

    private void setStdDimDyVisable(Boolean openSwitch) {
        this.getView().setVisible(openSwitch, new String[]{"stddimdy"});
        this.getView().setEnable(openSwitch, new String[]{"stddimdy"});
        ((MulComboEdit)this.getControl("stddimdy")).setMustInput(openSwitch.booleanValue());
        this.getModel().setValue("stddimdy", null);
        this.updateDataChanged();
    }

    private void updateCacheOfCurrInsureType(Long insurTypeId) {
        if (!OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            IHRAppCache appCache = HRAppCache.get((String)("insur_type_cache_key" + this.getView().getPageId()));
            StandardDimDTO standardDimDTO = (StandardDimDTO)appCache.get("insur_type_cache_key", StandardDimDTO.class);
            standardDimDTO = StandardDimDTO.updateInstance((StandardDimDTO)standardDimDTO);
            List<Long> insurTypeIdSingletonList = Collections.singletonList(insurTypeId);
            if (CollectionUtils.isEmpty((Collection)((Collection)standardDimDTO.getFieldMap().get(insurTypeId))) && !ArrayUtils.isEmpty((Object[])SocInsuranceStandardHelper.queryInsurItemInfo(insurTypeIdSingletonList, null))) {
                SocInsuranceStandardService.updateInsurTypeInfoCache(insurTypeIdSingletonList, (StandardDimDTO)standardDimDTO, (boolean)true);
                this.updateStandardDimDTOToCache(standardDimDTO);
            }
        }
    }

    private void updateStandardDimDTOToCache(StandardDimDTO standardDimDTOFromCache) {
        IHRAppCache appCache = HRAppCache.get((String)("insur_type_cache_key" + this.getView().getPageId()));
        StandardDimDTO standardDimDTO = StandardDimDTO.updateInstance((StandardDimDTO)standardDimDTOFromCache);
        appCache.put("insur_type_cache_key", (Object)standardDimDTO);
    }

    private boolean checkStdDimInvalid() {
        DetailStandardDimDTO detailStandardDimDTO;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (dataEntity.getBoolean("isstddimdy") && HRStringUtils.isEmpty((String)dataEntity.getString("stddimdy"))) {
            this.getView().showTipNotification(SocInsuranceErrInfoEnum.MUST_SELECT_STD_DIM.getErrInfo());
            return true;
        }
        if (!dataEntity.getBoolean("isstddimdy") && (detailStandardDimDTO = this.getDetailStandardDimDTO()) != null && detailStandardDimDTO.getValueMaps().size() == 1) {
            this.getView().showTipNotification(SocInsuranceErrInfoEnum.SELECT_ONLY_ONE_WITHOUT_STD_SWITCH_OFF.getErrInfo());
            return true;
        }
        return false;
    }

    private void updateBtnView() {
        Object status = this.getModel().getValue("status");
        if (BaseDataHisHelper.isHisPage((IFormView)this.getView()) || "B".equals(status) || "C".equals(status)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ADD_INSUR_TYPE, DEL_INSUR_TYPE});
            this.getView().setEnable(Boolean.FALSE, new String[]{ADD_INSUR_TYPE, DEL_INSUR_TYPE});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{ADD_INSUR_TYPE, DEL_INSUR_TYPE});
            this.getView().setEnable(Boolean.TRUE, new String[]{ADD_INSUR_TYPE, DEL_INSUR_TYPE});
        }
    }

    private void updateDataChanged() {
        if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getModel().setDataChanged(false);
        }
    }

    private void showViewForCurrNode(Object nodeId) {
        Long insurTypeId = Long.parseLong(String.valueOf(nodeId));
        this.updateCacheOfCurrInsureType(insurTypeId);
        DetailStandardDimDTO detailStandardDimDTO = SocInsuranceStandardService.getDetailStandardDimDTO((String)this.getView().getPageId(), (Long)insurTypeId);
        if (detailStandardDimDTO.getFieldSet().isEmpty() || detailStandardDimDTO.getNameMap().isEmpty()) {
            this.showInsurStandardEntityView(Boolean.FALSE, Boolean.TRUE);
            this.updateCurrTreeNodeInfoCache(String.valueOf(nodeId), null, null);
        } else {
            this.showInsurStandardEntityView(Boolean.TRUE, Boolean.TRUE);
            this.setStdDimByInsurTypeId(insurTypeId);
            this.buildEntityView(String.valueOf(insurTypeId));
        }
    }

    private void setFirstCache() {
        IPageCache pageCache = this.getPageCache();
        if (!Boolean.FALSE.toString().equals(pageCache.get(IS_FIRST_LOAD_DATA_FROM_RESULT_TABLE + this.getView().getPageId()))) {
            this.getPageCache().put(IS_FIRST_LOAD_DATA_FROM_RESULT_TABLE + this.getView().getPageId(), Boolean.FALSE.toString());
            this.getModel().setDataChanged(false);
        }
    }

    private boolean isSubmitOrAuditOrHis() {
        String status = this.getModel().getDataEntity(true).getString("status");
        return !Long.valueOf(0L).equals(this.getModel().getDataEntity(true).getPkValue()) || "submit".equals(status) || "audit".equals(status) || BaseDataHisHelper.isHisPage((IFormView)this.getView());
    }
}

