/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.sinsurstandard;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IBaseDataService;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.sit.sitbs.business.coandDimRef.CoandDimRefHelper;
import kd.sit.sitbs.formplugin.web.sinsurstandard.imported.SInsuranceStandardBatchImportPlugin;
import kd.sit.sitbs.formplugin.web.welfare.CoanddimRefEdit;

public class SInsuranceStandardList
extends HRDataBaseList {
    private static final Log LOGGER = LogFactory.getLog(CoanddimRefEdit.class);
    private static final String SHOW_ALL_COMPANY_REFERENCED = "showallcoref";
    public static final String COANDDIM_REF = "CoanddimRef";
    public static final String PLACE_OF_WELFAREID = "placeOfWelfareId";
    public static final String IMPORT_STANDARD_DATA_OP = "donothing_importdata";
    public static final String SIN_SUR_STD = "sinsurstd";

    public void setFilter(SetFilterEvent ex) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String coanddimRef = (String)listShowParameter.getCustomParam(COANDDIM_REF);
        if (listShowParameter.isLookUp() && HRStringUtils.isNotEmpty((String)coanddimRef)) {
            String bsed = (String)listShowParameter.getCustomParam("bsed");
            Long placeOfWelfareId = (Long)listShowParameter.getCustomParam(PLACE_OF_WELFAREID);
            String orgId = (String)listShowParameter.getCustomParam("orgId");
            QFilter insurAreaFilter = new QFilter("insurarea", "=", (Object)placeOfWelfareId);
            try {
                QFilter firstBsedFilter = new QFilter("firstbsed", "<=", (Object)HRDateTimeUtils.parseDate((String)bsed, (String)"yyyy-MM-dd"));
                insurAreaFilter.and(firstBsedFilter);
            }
            catch (ParseException parseException) {
                LOGGER.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
            }
            IBaseDataService baseDataService = (IBaseDataService)this.getModel().getService(IBaseDataService.class);
            QFilter orgFilter = baseDataService.getBaseDataFilter("sitbs_sinsurstd", Long.valueOf(orgId));
            if (orgFilter != null) {
                insurAreaFilter.and(orgFilter);
            }
            ex.getQFilters().add(insurAreaFilter);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"insertdatabtn"});
        boolean isHisList = this.isHisList(this.getView());
        if (isHisList) {
            List columnList = args.getListColumns();
            Iterator iterator = columnList.iterator();
            while (iterator.hasNext()) {
                IListColumn next = (IListColumn)iterator.next();
                String listFieldKey = next.getListFieldKey();
                if (!"description".equals(listFieldKey)) continue;
                iterator.remove();
            }
        }
    }

    private boolean isHisList(IFormView view) {
        Map params = view.getFormShowParameter().getCustomParams();
        return "hisinfolist".equals(params.get("hisinfolist")) || "showhisversion".equals(params.get("option"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (formOperate.getOperateKey()) {
            case "showallcoref": {
                HashMap<String, String> customParamMap = new HashMap<String, String>(16);
                customParamMap.put("currentversion", "1");
                FormShowParameter showParameter = CoandDimRefHelper.showCurrentList(customParamMap, (String)(this.getView().getPageId() + "sitbs_coanddimref" + RequestContext.get().getLocalSessionId()));
                this.getView().showForm(showParameter);
                break;
            }
            case "donothing_importdata": {
                this.showInsuranceStandardDataImpView();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        BillList billlist = (BillList)this.getView().getControl("billlistap");
        switch (closedCallBackEvent.getActionId()) {
            case "sitbs_sinsurstdmd": {
                billlist.refresh();
                break;
            }
        }
    }

    private void showInsuranceStandardDataImpView() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("sitbs_sinsurstdhisimport");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("ServiceAppId", (Object)formShowParameter.getServiceAppId());
        showParameter.setCustomParam("CheckRightAppId", (Object)formShowParameter.getCheckRightAppId());
        showParameter.setCustomParam("BillFormId", (Object)"sitbs_sinsurstdmd");
        showParameter.setCustomParam("RealPermissionEntityId", (Object)"sitbs_sinsurstdmd");
        showParameter.setCustomParam("ListName", (Object)this.getView().getFormShowParameter().getCaption());
        showParameter.setCustomParam("ImportPlugin", (Object)SInsuranceStandardBatchImportPlugin.class.getName());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "sitbs_sinsurstdmd"));
        this.getView().showForm(showParameter);
    }

    public static void beforeSinSurStdF7Select(DynamicObject welfarePayer, Date bsed, String orgId, FormShowParameter listShowParameter) {
        listShowParameter.setCustomParam(COANDDIM_REF, (Object)"CoanddimRefEdit");
        listShowParameter.setCustomParam("bsed", (Object)HRDateTimeUtils.format((Date)bsed, (String)"yyyy-MM-dd"));
        listShowParameter.setCustomParam("orgId", (Object)orgId);
        if (welfarePayer != null) {
            listShowParameter.setCustomParam(PLACE_OF_WELFAREID, (Object)welfarePayer.getLong("placeofwelfare.id"));
        }
    }
}

