/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.sinsurstandard.export;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.list.option.ListUserOption;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbp.business.servicehelper.SITBaseDataHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.entity.social.InsurTypeAttrEntity;
import kd.sit.sitbp.common.enums.InsurTypeAttrEnum;
import kd.sit.sitbs.business.socinsurance.errinfo.SocInsuranceErrInfoEnum;
import kd.sit.sitbs.business.socinsurance.standard.helper.SocInsuranceStandardHelper;
import kd.sit.sitbs.business.socinsurance.standard.service.SocInsuranceStandardService;

public class SInsuranceStandardExportList
extends AbstractListPlugin {
    private static final Log LOGGER = LogFactory.getLog(SInsuranceStandardExportList.class);
    private static final String CALLBACK_EXPORT = "callBack_export";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        long startTime = System.currentTimeMillis();
        super.beforeDoOperation(args);
        this.getView().getPageCache().remove("entitynumber");
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "exportlist": {
                args.setCancel(true);
                if (this.checkListDataInvalid()) {
                    return;
                }
                this.showExportDataProgressView("1560784484213859328");
                break;
            }
            case "exportdetails": {
                args.setCancel(true);
                this.openExportDetail();
                break;
            }
        }
        LOGGER.info(" SinsurFileExportListPlugin run time: {}", (Object)(System.currentTimeMillis() - startTime));
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent event) {
        DynamicObject[] stdDyArr = event.getQueryValues();
        List stdPkIds = Arrays.stream(stdDyArr).map(stdDy -> stdDy.getLong("id")).collect(Collectors.toList());
        HRBaseServiceHelper stdHelper = new HRBaseServiceHelper("sitbs_sinsurstd");
        QFilter filter = new QFilter("id", "in", stdPkIds);
        BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
        List listQFilters = ((BillList)this.getView().getControl("billlistap")).generalFilterParameter().getQFilters();
        if (listQFilters != null) {
            listQFilters.forEach(arg_0 -> ((QFilter)filter).and(arg_0));
        }
        String selectProperties = SITBaseDataHelper.getSelectProperties((String)"sitbs_sinsurstd");
        stdDyArr = stdHelper.query(selectProperties, filter.toArray(), "number asc");
        DynamicObject[] stdMdDyArr = new DynamicObject[stdDyArr.length];
        Map<Long, Integer> insurItemIdAndPrecisionMap = this.getInsurItemIdAndAttrInfoMap(stdDyArr);
        HRBaseServiceHelper stdMdHelper = new HRBaseServiceHelper("sitbs_sinsurstdmd");
        for (int i = 0; i < stdDyArr.length; ++i) {
            DynamicObject stdMdDy = stdMdHelper.generateEmptyEntryDynamicObject("sitbs_sinsurstdmd");
            this.copyStdDyToMd(stdDyArr[i], stdMdDy, insurItemIdAndPrecisionMap);
            stdMdDyArr[i] = stdMdDy;
        }
        event.setQueryValues(stdMdDyArr);
        event.setCustomOrder(true);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (MessageBoxResult.Yes.equals((Object)event.getResult()) && "ExportListConfirmCallBack".equals(event.getCallBackId())) {
            if (SITPermissionServiceHelper.checkCancelDataAndFunctionRight((IFormView)this.getView(), (boolean)true)) {
                return;
            }
            this.showExportDataProgressView("1560784484213859328");
        }
    }

    private void showExportDataProgressView(String templateId) {
        FormShowParameter formShowParameterv = this.getView().getFormShowParameter();
        FormShowParameter formShowParameterExport = new FormShowParameter();
        formShowParameterExport.setFormId("bos_exportdataprogress");
        formShowParameterExport.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameterExport.setCustomParam("ServiceAppId", (Object)formShowParameterv.getServiceAppId());
        formShowParameterExport.setCustomParam("fillparent", null);
        formShowParameterExport.setCustomParam("entitynumber", (Object)"sitbs_sinsurstdmd");
        String entityName = EntityMetadataCache.getDataEntityType((String)"sitbs_sinsurstd").getDisplayName().toString();
        formShowParameterExport.setCustomParam("entityname", (Object)entityName);
        formShowParameterExport.setCustomParam("templateId", (Object)templateId);
        formShowParameterExport.setCustomParam("byList", null);
        formShowParameterExport.setCustomParam("EXPORT_LIST_TYPE", (Object)"IMPT");
        formShowParameterExport.setCustomParam("billViewExport", (Object)Boolean.FALSE);
        formShowParameterExport.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_EXPORT));
        this.getView().showForm(formShowParameterExport);
    }

    private void openExportDetail() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("bos_exportlog");
        showParameter.setFormId("bos_list");
        showParameter.setCaption(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_EXPORT_RESULT_CAPTION.getErrInfo());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        QFilter filter = new QFilter("bizobject", "=", (Object)EntityMetadataCache.getDataEntityType((String)"sitbs_sinsurstd").getDisplayName().toString());
        ListFilterParameter filterParameter = new ListFilterParameter((List)Lists.newArrayList((Object[])new QFilter[]{filter}), null);
        showParameter.setListFilterParameter(filterParameter);
        showParameter.setPageId(this.getView().getPageId() + "bill" + "sitbs_sinsurstdmd");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private Map<Long, Integer> getInsurItemIdAndAttrInfoMap(DynamicObject[] stdDyArr) {
        HashSet<Long> allInsurItemIdSet = new HashSet<Long>(16);
        for (DynamicObject stdDy : stdDyArr) {
            DynamicObjectCollection stdEntryEntity = stdDy.getDynamicObjectCollection("stdentryentity");
            this.getInsurEntryObj(allInsurItemIdSet, stdEntryEntity);
        }
        DynamicObjectCollection insurItemInfoDyColl = SocInsuranceStandardHelper.queryInsurItemInfoById(allInsurItemIdSet, null);
        return insurItemInfoDyColl.stream().collect(Collectors.toMap(insurItemInfoDy -> insurItemInfoDy.getLong("id"), insurItemInfoDy -> insurItemInfoDy.getInt("dataprecision.scale")));
    }

    private void getInsurEntryObj(Set<Long> allInsurItemIdSet, DynamicObjectCollection stdEntryEntity) {
        for (DynamicObject stdEntry : stdEntryEntity) {
            DynamicObjectCollection stdSubEntryEntity = stdEntry.getDynamicObjectCollection("subentryentity");
            for (DynamicObject stdSubEntry : stdSubEntryEntity) {
                DynamicObject insurItemDy = stdSubEntry.getDynamicObject("insuritem");
                Long insurItemId = insurItemDy.getLong("id");
                long insurTypeAttrId = insurItemDy.getLong("insurancetypeattr.id");
                if (!InsurTypeAttrEnum.PAY_PROPORTION_OF_COMPANY.getId().equals(insurTypeAttrId) && !InsurTypeAttrEnum.PAY_PROPORTION_OF_EMPLOYEE.getId().equals(insurTypeAttrId)) continue;
                allInsurItemIdSet.add(insurItemId);
            }
        }
    }

    private void copyStdDyToMd(DynamicObject stdDy, DynamicObject stdMdDy, Map<Long, Integer> insurItemIdAndPrecisionMap) {
        stdMdDy.set("id", stdDy.getPkValue());
        stdMdDy.set("createorg", (Object)stdDy.getDynamicObject("createorg"));
        stdMdDy.set("number", (Object)stdDy.getString("number"));
        stdMdDy.set("name", stdDy.get("name"));
        stdMdDy.set("generalenname", (Object)stdDy.getString("generalenname"));
        stdMdDy.set("country", (Object)stdDy.getDynamicObject("country"));
        stdMdDy.set("insurarea", (Object)stdDy.getDynamicObject("insurarea"));
        stdMdDy.set("bsed", (Object)stdDy.getDate("bsed"));
        stdMdDy.set("ctrlstrategy", (Object)stdDy.getString("ctrlstrategy"));
        stdMdDy.set("description", stdDy.get("description"));
        DynamicObjectCollection stdEntryEntity = stdDy.getDynamicObjectCollection("stdentryentity");
        DynamicObjectCollection stdMdEntryEntity = stdMdDy.getDynamicObjectCollection("stdentryentity");
        for (DynamicObject stdEntry : stdEntryEntity) {
            DynamicObject stdMdEntry = stdMdEntryEntity.addNew();
            stdMdEntry.set("insurtype", (Object)stdEntry.getDynamicObject("insurtype"));
            stdMdEntry.set("entryboid", stdEntry.get("entryboid"));
            stdMdEntry.set("id", stdEntry.getPkValue());
            this.copySubEntityEntryToMd(stdEntry, stdMdEntry, insurItemIdAndPrecisionMap);
        }
    }

    private void copySubEntityEntryToMd(DynamicObject stdEntry, DynamicObject stdMdEntry, Map<Long, Integer> insurItemIdAndPrecisionMap) {
        Map<Long, InsurTypeAttrEntity> insurTypeAttrIdAndEntityMap = SocInsuranceStandardService.getInsurTypeAttrFieldKeyAndEntityMap().values().stream().collect(Collectors.toMap(InsurTypeAttrEntity::getId, val -> val, (oldVal, newVal) -> oldVal));
        DynamicObjectCollection stdSubEntryEntity = stdEntry.getDynamicObjectCollection("subentryentity");
        DynamicObjectCollection stdMdSubEntryEntity = stdMdEntry.getDynamicObjectCollection("subentryentity");
        LinkedHashMap<String, List> stdDimAndDyMap = new LinkedHashMap<String, List>(16);
        for (DynamicObject stdSubEntry : stdSubEntryEntity) {
            String stdDimKey = stdSubEntry.getLong("registertype.id") + "," + stdSubEntry.getLong("category.id");
            List itemDys = stdDimAndDyMap.computeIfAbsent(stdDimKey, key -> new ArrayList(10));
            itemDys.add(stdSubEntry);
        }
        for (Map.Entry entry : stdDimAndDyMap.entrySet()) {
            DynamicObject stdMdSubEntry = stdMdSubEntryEntity.addNew();
            List stdSubEntrys = (List)entry.getValue();
            boolean registerDim = false;
            for (DynamicObject stdSubEntry : stdSubEntrys) {
                String insurTypeAttrFieldKey;
                long insurTypeAttrId;
                InsurTypeAttrEntity insurTypeAttrEntity;
                DynamicObject insurItemDy;
                Long insurItemId;
                if (!registerDim) {
                    stdMdSubEntry.set("registertype", (Object)stdSubEntry.getDynamicObject("registertype"));
                    stdMdSubEntry.set("category", (Object)stdSubEntry.getDynamicObject("category"));
                    registerDim = true;
                }
                if ((insurItemId = Long.valueOf((insurItemDy = stdSubEntry.getDynamicObject("insuritem")).getLong("id"))) <= 0L || (insurTypeAttrEntity = insurTypeAttrIdAndEntityMap.get(insurTypeAttrId = insurItemDy.getLong("insurancetypeattr.id"))) == null || (insurTypeAttrFieldKey = insurTypeAttrEntity.getFieldKey()) == null) continue;
                String itemVal = stdSubEntry.getString("itemvalue");
                if (HRStringUtils.isEmpty((String)itemVal)) {
                    itemVal = stdSubEntry.getString("roundtype");
                } else {
                    Integer precision = insurItemIdAndPrecisionMap.get(insurItemId);
                    if (precision != null) {
                        precision = Math.max(precision - 2, 0);
                        BigDecimal insurItemBigVal = new BigDecimal(itemVal).setScale((int)precision, 1);
                        itemVal = String.valueOf(insurItemBigVal);
                    }
                }
                stdMdSubEntry.set(insurTypeAttrFieldKey, (Object)itemVal);
            }
        }
    }

    private boolean checkListDataInvalid() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        int billNum = billList.getSelectedRows().getPrimaryKeyValues().length;
        if (billNum == 0) {
            ListUserOption listUserOption = ((ListShowParameter)this.getView().getFormShowParameter()).getListUserOption();
            ListUserOption listUserOption2 = listUserOption = listUserOption == null ? new ListUserOption() : listUserOption;
            if (listUserOption.isDefaultExportListAll() && (billNum = billList.queryBillDataCount()) > 0) {
                this.getView().showConfirm(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_EXPORT_ALL_CONFIRM.getErrInfo(new Object[]{billNum}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("ExportListConfirmCallBack", (IFormPlugin)this));
            } else {
                this.getView().showTipNotification(SocInsuranceErrInfoEnum.COMMON_EXPORT_DATA_EMPTY.getErrInfo());
            }
            return true;
        }
        return false;
    }
}

