/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.sinsurstandard.imported;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.newhismodel.impt.HisBatchImportPlugin;
import kd.sit.sitbp.business.appnum.AppHelper;
import kd.sit.sitbp.business.importutil.ImportOperationResultHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.business.util.MultiLangHelper;
import kd.sit.sitbp.common.cache.ISITAppCache;
import kd.sit.sitbp.common.cache.SITAppCache;
import kd.sit.sitbp.common.entity.social.InsurTypeAttrEntity;
import kd.sit.sitbp.common.enums.InsurTypeAttrEnum;
import kd.sit.sitbp.common.util.SITDateTimeUtils;
import kd.sit.sitbs.business.socinsurance.constants.SInsuranceConstants;
import kd.sit.sitbs.business.socinsurance.dto.StandardDimImportDTO;
import kd.sit.sitbs.business.socinsurance.dto.StandardDimItemImportDTO;
import kd.sit.sitbs.business.socinsurance.dto.StandardImportBasePropDTO;
import kd.sit.sitbs.business.socinsurance.dto.StandardMainImportDTO;
import kd.sit.sitbs.business.socinsurance.errinfo.SocInsuranceErrInfoEnum;
import kd.sit.sitbs.business.socinsurance.service.SInsuranceCommonService;
import kd.sit.sitbs.business.socinsurance.standard.helper.SocInsuranceStandardHelper;
import kd.sit.sitbs.business.socinsurance.standard.service.SocInsuranceStandardService;

public class SInsuranceStandardBatchImportPlugin
extends HisBatchImportPlugin {
    private static final Log log = LogFactory.getLog(SInsuranceStandardBatchImportPlugin.class);
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\d+(\\.\\d+)?");
    private static final String IMPORT_ROW_NUMBER = "rowNum";
    private BiMap<String, InsurTypeAttrEntity> insurTypeAttrFieldKeyAndEntityMap;
    private static final BiMap<String, SocInsuranceErrInfoEnum> BASED_FIELD_KEY_AND_SOC_ENUM_MAP;
    private Map<Integer, String> rowNumAndStandardNumMap = new LinkedHashMap<Integer, String>(64);
    private Map<String, DynamicObject> existsStandardNumAndDyForAddNewMap = new LinkedHashMap<String, DynamicObject>(64);
    private Set<String> usedStandardNumberSet = new LinkedHashSet<String>(64);
    private Set<String> standardNameInDbSet = new LinkedHashSet<String>(64);
    private Set<String> usedStandardNameSet = new LinkedHashSet<String>(64);
    private Map<Long, Map<Long, String>> insurTypeIdAndCfgInfoLinkedMap = new LinkedHashMap<Long, Map<Long, String>>(16);
    private Map<Long, DynamicObject> insurTypeIdAndCfgIdLinkedMap = new HashMap<Long, DynamicObject>(16);
    private HashBasedTable<Long, Long, Long> insurTypeAndAttrAndItemTable = HashBasedTable.create((int)16, (int)16);
    private Map<String, LinkedHashMap<String, Object>> insurItemIdAndAttrInfoMap = new HashMap<String, LinkedHashMap<String, Object>>(16);
    private static final List<String> ALL_BASE_FIELDS;
    private Map<String, Map<String, Long>> baseFieldAndPropAndIdMap = new HashMap<String, Map<String, Long>>(16);
    private int registerTypeMaxCountInDb = 1;
    private int categoryMaxCountInDb = 1;
    private StandardImportBasePropDTO standardImportBasePropDTO = StandardImportBasePropDTO.createInstance();
    private static final List<String> ALL_UPDATE_FIELDS;
    private static final List<String> DIM_FIELDS;
    private Set<String> updateFieldSet = null;
    private Map<Integer, String> rowNumAndFieldValueMap = new HashMap<Integer, String>(64);
    private QFilter updateQFilter = null;
    private Map<Integer, List<String>> rowNumAndErrInfoMap = new HashMap<Integer, List<String>>(64);
    private Map<Long, Integer> pkIdAndRowNumMap = new HashMap<Long, Integer>(16);
    private Map<String, Object> updateKeysValAndStdDyInDbMap = new HashMap<String, Object>(64);
    private Set<Long> featureBoIdSet = new HashSet<Long>(16);
    private Map<String, StandardMainImportDTO> stdNumberAndStdMainInfoLinkedMap = new LinkedHashMap<String, StandardMainImportDTO>(64);
    private HashBasedTable<String, Long, StandardDimImportDTO> stdNumberInsurTypeAndStdDimTable = HashBasedTable.create((int)64, (int)16);
    private HashBasedTable<String, Long, HashBasedTable<Long, Long, Map<Long, StandardDimItemImportDTO>>> stdDimItemImportAddDTOTable = HashBasedTable.create();
    private HashBasedTable<String, Long, HashBasedTable<Long, Long, Map<Long, StandardDimItemImportDTO>>> stdDimItemImportSaveDTOTable = HashBasedTable.create();
    private HashBasedTable<String, Long, HashBasedTable<Long, Long, Map<Long, StandardDimItemImportDTO>>> stdDimItemImportAuditDTOTable = HashBasedTable.create();
    private static final Set<String> ROUND_TYPE_ENUM_SET;
    private HashBasedTable<String, Long, DynamicObject> basedPkTable = HashBasedTable.create();
    private Set<Long> hasPermOrgs = null;
    private Set<Long> permCountryIdSet = null;
    private static final Set<String> CTRL_STRATEGY_SET;
    private static DynamicObject countryChinaDy;
    private static final List<List<Enum<? extends Enum<?>>>> PAY_BASE_TOP_AND_BOTTOMS;
    private final Map<String, Object> cachedAdminDivision = new LinkedHashMap<String, Object>(100, 0.75f, true){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Object> pEldest) {
            return this.size() > 1000;
        }

        @Override
        public boolean containsKey(Object key) {
            return super.containsKey(key);
        }
    };

    public SInsuranceStandardBatchImportPlugin() {
        BiMap insurTypeAttrFieldKeyAndEnumMap = SocInsuranceStandardService.getInsurTypeAttrFieldKeyAndEntityMap();
        this.insurTypeAttrFieldKeyAndEntityMap = ImmutableBiMap.copyOf((Map)insurTypeAttrFieldKeyAndEnumMap);
    }

    protected int getBatchImportSize() {
        return 2000;
    }

    protected void importData() throws Throwable {
        try {
            super.importData();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            ISITAppCache appCache = null;
            Set allUrls = this.ctx.getAllUrls();
            if (!CollectionUtils.isEmpty((Collection)allUrls)) {
                for (String allUrl : this.ctx.getAllUrls()) {
                    appCache = SITAppCache.get((String)("cache_key" + allUrl));
                    if (appCache == null) continue;
                    appCache.clear();
                }
            }
        }
    }

    protected void beforeSave(List<ImportBillData> billDatas, ImportLogger logger) {
        ImportHelper.invalidBill(billDatas, (ImportLogger)logger, this.cachedAdminDivision);
    }

    protected ApiResult save(List<ImportBillData> rowDatas, ImportLogger logger) {
        boolean needAddNew;
        boolean needUpdate;
        String importType;
        String updateType = this.getUpdateType();
        if (updateType == null) {
            return null;
        }
        Map option = this.ctx.getOption();
        if (CollectionUtils.isEmpty((Map)option) || (importType = (String)option.get("importtype")) == null) {
            return null;
        }
        boolean bl = needUpdate = "override".equals(importType) || "overridenew".equals(importType);
        if (!this.initUpdateFields(option, needUpdate)) {
            return null;
        }
        for (String string : ALL_BASE_FIELDS) {
            this.baseFieldAndPropAndIdMap.computeIfAbsent(string, key -> new HashMap(16));
        }
        this.getPermIdSet();
        countryChinaDy = new HRBaseServiceHelper("bd_country").loadDynamicObject(new QFilter("id", "=", (Object)SInsuranceConstants.COUNTRY_ID_CHINA));
        for (ImportBillData importBillData : rowDatas) {
            JSONObject jsonData = importBillData.getData();
            this.getMainTableInfo(jsonData);
            this.getInsurTypeEntityInfo(jsonData);
        }
        if (needUpdate) {
            this.filterDataToUpdate(updateType);
        }
        boolean bl2 = needAddNew = "new".equals(importType) || "overridenew".equals(importType);
        if (needAddNew) {
            this.filterDataToAddNew();
        }
        this.filterNameInDb();
        this.getAllBaseInfo();
        this.setInsuranceInfo();
        for (ImportBillData rowData : rowDatas) {
            JSONObject jsonData = rowData.getData();
            if (jsonData == null || jsonData.isEmpty()) continue;
            this.checkDataValidAndBuildData(importType, jsonData);
        }
        log.info("SInsuranceStandardBatchImportPlugin.save: begin to save data.");
        this.saveInsuranceStandardInfo();
        ApiResult apiResult = this.loggerForResult(rowDatas, logger);
        this.clearMemoryCache();
        log.info("SInsuranceStandardBatchImportPlugin.save: end to save data.");
        return apiResult;
    }

    private void getPermIdSet() {
        String appNumber = AppHelper.getAppNumberById((String)this.ctx.getCheckRightAppId());
        HasPermOrgResult hasPermOrgResult = SITPermissionServiceHelper.getPermOrgs((String)"31", (String)appNumber, (String)"sitbs_sinsurstd", (String)"47150e89000000ac");
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            this.hasPermOrgs = Optional.ofNullable(hasPermOrgResult.getHasPermOrgs()).map(orgs -> orgs.stream().filter(Objects::nonNull).collect(Collectors.toSet())).orElseGet(() -> new HashSet(0));
        }
        this.permCountryIdSet = SITPermissionServiceHelper.getCountrySetByPermItem((String)appNumber, (String)"sitbs_sinsurstd", (String)"47150e89000000ac");
    }

    private boolean initUpdateFields(Map<String, Object> option, boolean needUpdate) {
        if (needUpdate && CollectionUtils.isEmpty(this.updateFieldSet)) {
            String keyFields = (String)option.get("KeyFields");
            if (keyFields == null) {
                return false;
            }
            String[] keyFieldArr = keyFields.split(",");
            this.updateFieldSet = Arrays.stream(keyFieldArr).filter(HRStringUtils::isNotEmpty).collect(Collectors.toSet());
            return true;
        }
        return true;
    }

    private String getUpdateType() {
        String updateType = null;
        Set allUrls = this.ctx.getAllUrls();
        if (!CollectionUtils.isEmpty((Collection)allUrls)) {
            for (String allUrl : this.ctx.getAllUrls()) {
                ISITAppCache appCache = SITAppCache.get((String)("cache_key" + allUrl));
                updateType = (String)appCache.get("updatetype", String.class);
                if (HRStringUtils.isEmpty((String)updateType)) continue;
                break;
            }
        }
        if (updateType == null) {
            log.error("SInsuranceStandardBatchImportPlugin.getUpdateType: updatetype is null.");
            return null;
        }
        return updateType;
    }

    private boolean checkDataValidAndBuildData(String importType, JSONObject jsonData) {
        boolean needAddNew;
        log.info("SInsuranceStandardBatchImportPlugin.checkDataValidAndBuildData: begin to check data.");
        boolean needUpdate = "override".equals(importType) || "overridenew".equals(importType);
        int rowNum = jsonData.getIntValue(IMPORT_ROW_NUMBER);
        StandardMainImportDTO stdMainImportDTO = new StandardMainImportDTO();
        LinkedHashMap<Long, StandardDimImportDTO> stdDimImportDTOLinkedMap = new LinkedHashMap<Long, StandardDimImportDTO>(16);
        LinkedHashMap<Long, Object> stdDimItemImportDTOLinkedMap = null;
        List errInfoList = this.rowNumAndErrInfoMap.computeIfAbsent(jsonData.getIntValue(IMPORT_ROW_NUMBER), key -> new ArrayList(10));
        if (needUpdate) {
            String updateFieldKeyVal = this.rowNumAndFieldValueMap.get(rowNum);
            Object stdDyInDb = this.updateKeysValAndStdDyInDbMap.get(updateFieldKeyVal);
            if ("override".equals(importType)) {
                if (updateFieldKeyVal == null) {
                    return false;
                }
                if (stdDyInDb == null) {
                    errInfoList.add(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_DATA_NOT_EXISTS.getErrInfo());
                    return false;
                }
            }
            if (updateFieldKeyVal != null && stdDyInDb != null) {
                if (!(stdDyInDb instanceof DynamicObject)) {
                    errInfoList.add(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_DATA_EXIST_MORE_ONE_LINE.getErrInfo());
                    return false;
                }
                DynamicObject currStdDyInDb = (DynamicObject)stdDyInDb;
                if ("B".equals(currStdDyInDb.getString("status"))) {
                    errInfoList.add(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_MUST_IMPORT_ENABLED_DATA.getErrInfo());
                    return false;
                }
                if (this.featureBoIdSet.contains(currStdDyInDb.getLong("boid"))) {
                    errInfoList.add(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_FEATURE_BO_INVALID.getErrInfo());
                    return false;
                }
                boolean isMainInfoInvalid = this.checkMainTableInvalidAndBuildDataInfo(currStdDyInDb, jsonData, errInfoList, stdMainImportDTO);
                stdDimItemImportDTOLinkedMap = new LinkedHashMap(16);
                this.buildEntityMapAndSubEntityMap(currStdDyInDb, stdDimImportDTOLinkedMap, stdDimItemImportDTOLinkedMap);
                boolean isAuditStatus = "C".equals(currStdDyInDb.getString("status"));
                boolean isEntityInfoInvalid = !this.checkEntityTableInfoValidAndBuildDataInfo(jsonData, isAuditStatus, stdDimImportDTOLinkedMap, stdDimItemImportDTOLinkedMap);
                log.info("SInsuranceStandardBatchImportPlugin.checkDataValidAndBuildData: is update scene, and isMainInfoInvalid is {}, isEntityInfoInvalid is {}", (Object)isMainInfoInvalid, (Object)isEntityInfoInvalid);
                log.info("SInsuranceStandardBatchImportPlugin.checkDataValidAndBuildData: stdMainImportDTO is {}, stdDimImportDTOLinkedMap is {}, stdDimItemImportDTOLinkedMap is {}, and rowNum is {}", new Object[]{stdMainImportDTO.toString(), ((Object)stdDimImportDTOLinkedMap).toString(), ((Object)stdDimItemImportDTOLinkedMap).toString(), rowNum});
                if (isMainInfoInvalid || isEntityInfoInvalid) {
                    stdDimImportDTOLinkedMap.clear();
                    stdDimItemImportDTOLinkedMap.clear();
                    return false;
                }
                this.setStdInfo(currStdDyInDb.getString("status"), jsonData.getString("number"), stdMainImportDTO, stdDimImportDTOLinkedMap, stdDimItemImportDTOLinkedMap);
                this.updateNumberNameRepeatCheckSet(jsonData, "name", currStdDyInDb.getString("name"));
                return true;
            }
        }
        boolean bl = needAddNew = "new".equals(importType) || "overridenew".equals(importType);
        if (needAddNew && !this.rowNumAndStandardNumMap.isEmpty()) {
            boolean isMainInfoInvalid = this.checkMainTableInvalidAndBuildDataInfo(null, jsonData, errInfoList, stdMainImportDTO);
            stdDimItemImportDTOLinkedMap = new LinkedHashMap<Long, HashBasedTable<Long, Long, Map<Long, StandardDimItemImportDTO>>>(16);
            boolean isEntityInfoInvalid = !this.checkEntityTableInfoValidAndBuildDataInfo(jsonData, false, stdDimImportDTOLinkedMap, stdDimItemImportDTOLinkedMap);
            log.info("SInsuranceStandardBatchImportPlugin.checkDataValidAndBuildData: is new scene, and isMainInfoInvalid is {}, isEntityInfoInvalid is {}", (Object)isMainInfoInvalid, (Object)isEntityInfoInvalid);
            log.info("SInsuranceStandardBatchImportPlugin.checkDataValidAndBuildData: stdMainImportDTO is {}, stdDimImportDTOLinkedMap is {}, stdDimItemImportDTOLinkedMap is {}, and rowNum is {}", new Object[]{stdMainImportDTO.toString(), ((Object)stdDimImportDTOLinkedMap).toString(), ((Object)stdDimItemImportDTOLinkedMap).toString(), rowNum});
            if (isMainInfoInvalid || isEntityInfoInvalid) {
                stdDimImportDTOLinkedMap.clear();
                stdDimItemImportDTOLinkedMap.clear();
                return false;
            }
            this.setStdInfo("new", jsonData.getString("number"), stdMainImportDTO, stdDimImportDTOLinkedMap, stdDimItemImportDTOLinkedMap);
            this.updateNumberNameRepeatCheckSet(jsonData, "number", null);
            this.updateNumberNameRepeatCheckSet(jsonData, "name", null);
            return true;
        }
        return true;
    }

    private void getMainTableInfo(JSONObject jsonData) {
        JSONObject nameJson;
        HashMap<String, Object> rowMap = new HashMap<String, Object>(4);
        this.getBaseInfo(jsonData, rowMap, "createorg");
        this.getBaseInfo(jsonData, rowMap, "insurarea");
        this.getBaseInfo(jsonData, rowMap, "country");
        String numberInExcel = jsonData.getString("number");
        if (HRStringUtils.isNotEmpty((String)numberInExcel)) {
            rowMap.put("number", numberInExcel);
            this.rowNumAndStandardNumMap.put(jsonData.getInteger(IMPORT_ROW_NUMBER), numberInExcel);
        }
        if ((nameJson = jsonData.getJSONObject("name")) != null && HRStringUtils.isNotEmpty((String)nameJson.getString(RequestContext.get().getLang().name()))) {
            String currName = nameJson.getString(RequestContext.get().getLang().name());
            rowMap.put("name", currName);
            this.standardNameInDbSet.add(currName);
        }
        if (!CollectionUtils.isEmpty(this.updateFieldSet) && !CollectionUtils.isEmpty(rowMap)) {
            this.setFieldValueStringAndQFilter(jsonData.getInteger(IMPORT_ROW_NUMBER), rowMap);
        }
    }

    private Date checkDateInvalidAndRecord(JSONObject jsonData, String dateFieldKey, SocInsuranceErrInfoEnum socInsuranceErrInfoEnum, List<String> errInfoList, StringJoiner emptySj) {
        Date date;
        block3: {
            String dateValInExcel = jsonData.getString(dateFieldKey);
            if (dateValInExcel == null) {
                emptySj.add(socInsuranceErrInfoEnum.getErrInfo());
                return null;
            }
            date = null;
            try {
                date = SITDateTimeUtils.parseDate((String)jsonData.getString(dateFieldKey));
            }
            catch (Exception e) {
                if (!"bsed".equals(dateFieldKey)) break block3;
                errInfoList.add(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_DATE_INVALID.getErrInfo(new Object[]{socInsuranceErrInfoEnum.getErrInfo()}));
                return null;
            }
        }
        return date;
    }

    private boolean checkMainTableInvalidAndBuildDataInfo(DynamicObject stdDyInDb, JSONObject jsonData, List<String> errInfoList, StandardMainImportDTO standardMainImportDTO) {
        boolean auditStatus;
        StringJoiner emptySj = new StringJoiner(SocInsuranceErrInfoEnum.INSURANCE_ATTR_STOP_SIGN.getErrInfo());
        StringJoiner notExistInDbSj = new StringJoiner(SocInsuranceErrInfoEnum.INSURANCE_ATTR_STOP_SIGN.getErrInfo());
        StringJoiner repeatedNumAndNameJS = new StringJoiner(SocInsuranceErrInfoEnum.INSURANCE_ATTR_STOP_SIGN.getErrInfo());
        Long createOrgId = this.checkBaseInvalid(jsonData, "createorg", errInfoList, emptySj, notExistInDbSj);
        String number = jsonData.getString("number");
        if (HRStringUtils.isEmpty((String)number)) {
            emptySj.add(SocInsuranceErrInfoEnum.COMMON_FIELD_NUMBER.getErrInfo());
        } else {
            String valInDb = stdDyInDb == null ? null : stdDyInDb.getString("number");
            this.checkNameAndNumberRepeated(number, valInDb, repeatedNumAndNameJS, SocInsuranceErrInfoEnum.COMMON_FIELD_NUMBER);
        }
        JSONObject nameJson = jsonData.getJSONObject("name");
        if (nameJson == null || HRStringUtils.isEmpty((String)nameJson.getString(RequestContext.get().getLang().name()))) {
            emptySj.add(SocInsuranceErrInfoEnum.COMMON_FIELD_NAME.getErrInfo());
        } else {
            String currName = nameJson.getString(RequestContext.get().getLang().name());
            String valInDb = stdDyInDb == null ? null : stdDyInDb.getString("name");
            this.checkNameAndNumberRepeated(currName, valInDb, repeatedNumAndNameJS, SocInsuranceErrInfoEnum.COMMON_FIELD_NAME);
        }
        Long countryId = this.checkBaseInvalid(jsonData, "country", errInfoList, emptySj, null);
        if (countryId == null || !countryId.equals(countryChinaDy.getLong("id"))) {
            errInfoList.add(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_COUNTRY_NOT_CHINA.getErrInfo());
        }
        Long insurAreaId = this.checkBaseInvalid(jsonData, "insurarea", errInfoList, emptySj, notExistInDbSj);
        Date bsedInExcel = this.checkDateInvalidAndRecord(jsonData, "bsed", SocInsuranceErrInfoEnum.COMMON_FIELD_BSED, errInfoList, emptySj);
        String ctrlStrategy = this.checkCtrlStrategy(jsonData.getString("ctrlstrategy"), errInfoList);
        if (!HRObjectUtils.isEmpty((Object)stdDyInDb)) {
            boolean isInvalid;
            boolean bl = isInvalid = number != null && !HRStringUtils.equals((String)stdDyInDb.getString("number"), (String)number) || createOrgId != null && !createOrgId.equals(stdDyInDb.getLong("createorg.id")) || !stdDyInDb.getString("ctrlstrategy").equals(ctrlStrategy);
            if (isInvalid) {
                errInfoList.add(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_CAN_NOT_MODIFY_WHEN_IMPORT.getErrInfo());
            }
        }
        boolean bl = auditStatus = stdDyInDb != null && "C".equals(stdDyInDb.getString("status"));
        if (auditStatus) {
            if (insurAreaId != null && !insurAreaId.equals(stdDyInDb.getLong("insurarea.id"))) {
                errInfoList.add(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_CAN_NOT_MODIFY_AUDITED_INSUR_AREA.getErrInfo());
            }
            Date bsedInDb = stdDyInDb.getDate("bsed");
            if (bsedInExcel != null && bsedInDb != null && bsedInExcel.before(bsedInDb)) {
                errInfoList.add(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_BSED_IN_EXCEL_BEFORE_BSED_IN_DB.getErrInfo());
            }
            if (insurAreaId != null && stdDyInDb.getLong("insurarea.id") != insurAreaId.longValue()) {
                errInfoList.add(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_CAN_NOT_MODIFY_AUDITED_INSUR_AREA.getErrInfo());
            }
        }
        if (emptySj.length() > 0) {
            errInfoList.add(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_IS_NULL.getErrInfo(new Object[]{emptySj.toString()}));
        }
        if (repeatedNumAndNameJS.length() > 0) {
            errInfoList.add(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_NAME_REPEATED.getErrInfo(new Object[]{repeatedNumAndNameJS.toString()}));
        }
        if (notExistInDbSj.length() > 0) {
            errInfoList.add(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_BASE_NOT_EXISTS.getErrInfo(new Object[]{notExistInDbSj.toString()}));
        }
        if (errInfoList.isEmpty()) {
            if (!HRObjectUtils.isEmpty((Object)stdDyInDb)) {
                Long boId = stdDyInDb.getLong("boid");
                if (boId != 0L) {
                    standardMainImportDTO.setBoId(Long.valueOf(stdDyInDb.getLong("boid")));
                }
                if (auditStatus) {
                    Date defaultBsled = SocInsuranceStandardHelper.getDefaultBsled();
                    standardMainImportDTO.setBsled(defaultBsled);
                }
                ctrlStrategy = stdDyInDb.getString("ctrlstrategy");
                standardMainImportDTO.setCreator(Long.valueOf(stdDyInDb.getLong("creator.id")));
                standardMainImportDTO.setCreatetime(stdDyInDb.getDate("createtime"));
                standardMainImportDTO.setEnable(stdDyInDb.getString("enable"));
            }
            standardMainImportDTO.setNumber(jsonData.getString("number"));
            int rowNum = jsonData.getIntValue(IMPORT_ROW_NUMBER);
            standardMainImportDTO.setRowNum(rowNum);
            standardMainImportDTO.setNumber(number);
            LocaleString nameLocal = new LocaleString();
            if (nameJson != null) {
                nameJson.forEach((key, value) -> nameLocal.setItem(key, (Object)((String)value)));
            }
            standardMainImportDTO.setName(nameLocal);
            standardMainImportDTO.setGeneralenName(jsonData.getString("generalenname"));
            standardMainImportDTO.setBsed(bsedInExcel);
            JSONObject descriptionJson = jsonData.getJSONObject("description");
            if (descriptionJson != null) {
                LocaleString descriptionLocal = new LocaleString();
                descriptionJson.forEach((key, value) -> descriptionLocal.setItem(key, (Object)((String)value)));
                standardMainImportDTO.setDescription(descriptionLocal);
            }
            if (HRStringUtils.isNotEmpty((String)ctrlStrategy)) {
                standardMainImportDTO.setCtrlStrategy(ctrlStrategy);
            }
            standardMainImportDTO.setCreateOrg(createOrgId);
            standardMainImportDTO.setInsurArea(insurAreaId);
        }
        return !errInfoList.isEmpty();
    }

    private String checkCtrlStrategy(String ctrlStrategy, List<String> errInfoList) {
        if (ctrlStrategy != null && !CTRL_STRATEGY_SET.contains(ctrlStrategy)) {
            errInfoList.add(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_CTRL_STRATEGY_ERR.getErrInfo());
            return null;
        }
        return ctrlStrategy;
    }

    private void buildEntityMapAndSubEntityMap(DynamicObject currStdDyInDb, Map<Long, StandardDimImportDTO> stdDimImportDTOLinkedMap, Map<Long, HashBasedTable<Long, Long, Map<Long, StandardDimItemImportDTO>>> stdDimItemImportDTOLinkedMap) {
        if ("C".equals(currStdDyInDb.getString("status"))) {
            DynamicObjectCollection stdColl = currStdDyInDb.getDynamicObjectCollection("stdentryentity");
            for (DynamicObject entity : stdColl) {
                long insurTypeId = entity.getLong("insurtype.id");
                StandardDimImportDTO standardDimImportDTO = stdDimImportDTOLinkedMap.computeIfAbsent(insurTypeId, key -> new StandardDimImportDTO());
                standardDimImportDTO.setInsurTypeName(entity.getString("insurtype.name"));
                stdDimItemImportDTOLinkedMap.computeIfAbsent(insurTypeId, key -> HashBasedTable.create());
            }
        }
    }

    private boolean checkEntityTableInfoValidAndBuildDataInfo(JSONObject jsonData, boolean isAuditStatus, Map<Long, StandardDimImportDTO> stdDimImportDTOLinkedMap, Map<Long, HashBasedTable<Long, Long, Map<Long, StandardDimItemImportDTO>>> stdDimItemImportDTOLinkedMap) {
        List errInfoList = this.rowNumAndErrInfoMap.computeIfAbsent(jsonData.getIntValue(IMPORT_ROW_NUMBER), key -> new ArrayList(10));
        JSONArray stdEntryEntity = jsonData.getJSONArray("stdentryentity");
        if (CollectionUtils.isEmpty((Collection)stdEntryEntity)) {
            errInfoList.add(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_MUST_INPUT_INSUR_TYPE.getErrInfo());
            log.info("SInsuranceStandardBatchImportPlugin.checkEntityTableInfoValidAndBuildDataInfo: stdEntryEntity is empty.");
            return false;
        }
        boolean isValid = true;
        HashSet<Long> usedInsurTypeIdSet = new HashSet<Long>(0);
        if (isAuditStatus) {
            usedInsurTypeIdSet = new LinkedHashSet(stdDimImportDTOLinkedMap.size());
        }
        for (int i = 0; i < stdEntryEntity.size(); ++i) {
            JSONObject currJson = stdEntryEntity.getJSONObject(i);
            int entityRowNum = currJson.getIntValue(IMPORT_ROW_NUMBER) + 1;
            JSONObject insurTypeJson = currJson.getJSONObject("insurtype");
            String errMsg = this.checkBaseInvalid(insurTypeJson, SocInsuranceErrInfoEnum.COMMON_FIELD_INSURANCE_TYPE);
            if (!HRStringUtils.isEmpty((String)errMsg)) {
                errInfoList.add(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_ERR_LINE.getErrInfo(new Object[]{entityRowNum, errMsg}));
                log.info("SInsuranceStandardBatchImportPlugin.checkEntityTableInfoValidAndBuildDataInfo: the insurTypeJson is {}", (Object)(insurTypeJson != null ? insurTypeJson.toJSONString() : null));
                isValid = false;
                continue;
            }
            String baseValInExcel = this.getBaseValFrom(currJson, "insurtype");
            String insurTypeDetailName = this.getBaseTypeDetailName("insurtype", SocInsuranceErrInfoEnum.COMMON_FIELD_INSURANCE_TYPE, baseValInExcel);
            Long insurTypeId = this.baseFieldAndPropAndIdMap.get("insurtype").get(baseValInExcel);
            if (insurTypeId == null) {
                errInfoList.add(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_INSUR_TYPE_NOT_EXISTS.getErrInfo(new Object[]{entityRowNum, insurTypeDetailName}));
                log.info("SInsuranceStandardBatchImportPlugin.checkEntityTableInfoValidAndBuildDataInfo: row of 810, {}", (Object)SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_ERR_LINE.getErrInfo(new Object[]{entityRowNum, errMsg}));
                isValid = false;
                continue;
            }
            Map<Long, String> cfgInfoLinkeMap = this.insurTypeIdAndCfgInfoLinkedMap.get(insurTypeId);
            if (CollectionUtils.isEmpty(cfgInfoLinkeMap)) {
                errInfoList.add(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_INSUR_TYPE_NO_REF_CFG.getErrInfo(new Object[]{entityRowNum, insurTypeDetailName}));
                log.info("SInsuranceStandardBatchImportPlugin.checkEntityTableInfoValidAndBuildDataInfo: cfgInfoLinkeMap is null.");
                isValid = false;
                continue;
            }
            StandardDimImportDTO standardDimImportDTO2 = stdDimImportDTOLinkedMap.get(insurTypeId);
            if (isAuditStatus && standardDimImportDTO2 == null) {
                errInfoList.add(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_STD_NOT_CONTAIN_INSUR_TYPE.getErrInfo(new Object[]{entityRowNum, insurTypeDetailName}));
                log.info("SInsuranceStandardBatchImportPlugin.checkEntityTableInfoValidAndBuildDataInfo: standardDimImportDTO is null.");
                isValid = false;
                continue;
            }
            if (!isAuditStatus) {
                standardDimImportDTO2 = stdDimImportDTOLinkedMap.computeIfAbsent(insurTypeId, key -> new StandardDimImportDTO());
            } else {
                usedInsurTypeIdSet.add(insurTypeId);
            }
            JSONArray subEntryEntity = currJson.getJSONArray("subentryentity");
            if (CollectionUtils.isEmpty((Collection)subEntryEntity)) {
                errInfoList.add(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_INSUR_ITEM_ENTITY_EMPTY.getErrInfo(new Object[]{entityRowNum, insurTypeDetailName}));
                log.info("SInsuranceStandardBatchImportPlugin.checkEntityTableInfoValidAndBuildDataInfo: subEntryEntity is null.");
                isValid = false;
                continue;
            }
            log.info("SInsuranceStandardBatchImportPlugin.checkEntityTableInfoValidAndBuildDataInfo: insurTypeId is {}, entityRowNum is {}.", (Object)insurTypeId, (Object)entityRowNum);
            boolean isTmpValid = this.checkSubEntityTableInfoValidAndBuildDataInfo(insurTypeId, currJson, standardDimImportDTO2, stdDimItemImportDTOLinkedMap, errInfoList, entityRowNum, insurTypeDetailName);
            log.info("SInsuranceStandardBatchImportPlugin.checkEntityTableInfoValidAndBuildDataInfo: standardDimImportDTO is {}, stdDimItemImportDTOLinkedMap is {}.", (Object)standardDimImportDTO2.toString(), (Object)stdDimItemImportDTOLinkedMap.toString());
            log.info("SInsuranceStandardBatchImportPlugin.checkEntityTableInfoValidAndBuildDataInfo: isTmpValid is {}, insurTypeId is {}, insurTypeDetailName is {}", new Object[]{isTmpValid, insurTypeId, insurTypeDetailName});
            isValid = isValid && isTmpValid;
        }
        if (isAuditStatus) {
            LinkedHashMap<Long, StandardDimImportDTO> tmpStdDimImportDTOLinkedMap = new LinkedHashMap<Long, StandardDimImportDTO>(stdDimImportDTOLinkedMap);
            tmpStdDimImportDTOLinkedMap.keySet().removeAll(usedInsurTypeIdSet);
            if (tmpStdDimImportDTOLinkedMap.size() > 0) {
                isValid = false;
                StringJoiner insurTypeLoseSj = new StringJoiner(SocInsuranceErrInfoEnum.INSURANCE_ATTR_STOP_SIGN.getErrInfo());
                tmpStdDimImportDTOLinkedMap.values().forEach(standardDimImportDTO -> insurTypeLoseSj.add(standardDimImportDTO.getInsurTypeName()));
                String siStdCanNotDelInsurTypeErrInfo = SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_CAN_NOT_DEL_INSUR_TYPE.getErrInfo(new Object[]{insurTypeLoseSj.toString()});
                errInfoList.add(siStdCanNotDelInsurTypeErrInfo);
                log.info("SInsuranceStandardBatchImportPlugin.checkEntityTableInfoValidAndBuildDataInfo: {}, insurTypeLoseSj is {}, usedInsurTypeIdSet is {}", new Object[]{tmpStdDimImportDTOLinkedMap.keySet().toString(), siStdCanNotDelInsurTypeErrInfo, ((Object)usedInsurTypeIdSet).toString()});
                tmpStdDimImportDTOLinkedMap.clear();
                usedInsurTypeIdSet.clear();
            }
        }
        return isValid;
    }

    private boolean checkSubEntityTableInfoValidAndBuildDataInfo(Long insurTypeId, JSONObject jsonData, StandardDimImportDTO standardDimImportDTO, Map<Long, HashBasedTable<Long, Long, Map<Long, StandardDimItemImportDTO>>> stdDimItemImportDTOLinkedMap, List<String> errInfoList, int entityRowNum, String insurTypeDetailName) {
        JSONArray subEntryEntity = jsonData.getJSONArray("subentryentity");
        HashBasedTable stdDimItemImportDTOTable = stdDimItemImportDTOLinkedMap.computeIfAbsent(insurTypeId, key -> HashBasedTable.create());
        Map<Long, StandardDimItemImportDTO> tmpStandardDimItemImportDTOLinkedMap = new LinkedHashMap(0);
        Map<Long, String> cfgInfoLinkedMap = this.insurTypeIdAndCfgInfoLinkedMap.get(insurTypeId);
        boolean isInvalid = false;
        int maxCount = this.registerTypeMaxCountInDb * this.categoryMaxCountInDb;
        for (int i = 0; i < subEntryEntity.size(); ++i) {
            LinkedHashMap<Long, StandardDimItemImportDTO> standardDimItemImportDTOLinkedMap;
            JSONObject currJson = subEntryEntity.getJSONObject(i);
            standardDimImportDTO.setCurrDimEntityLength(i + 1);
            int n = maxCount = standardDimImportDTO.getMaxDimEntityLength() == 0 ? maxCount : standardDimImportDTO.getMaxDimEntityLength();
            if (standardDimImportDTO.getCurrDimEntityLength() > maxCount) {
                errInfoList.add(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_INSUR_ITEM_ENTITY_TO_BIG.getErrInfo(new Object[]{entityRowNum, insurTypeDetailName, maxCount}));
                log.info("SInsuranceStandardBatchImportPlugin.checkSubEntityTableInfoValidAndBuildDataInfo: maxCount is {}", (Object)maxCount);
                return false;
            }
            Long registerTypeId = 0L;
            Long categoryId = 0L;
            HashMap<String, Long> dimKeyVal = new HashMap<String, Long>(2);
            if (this.checkDimInvalidAndGetVal(currJson, errInfoList, entityRowNum, dimKeyVal)) {
                isInvalid = true;
                continue;
            }
            registerTypeId = (Long)dimKeyVal.get("registertype");
            categoryId = (Long)dimKeyVal.get("category");
            standardDimImportDTO.setInsurStdCfgDy(this.insurTypeIdAndCfgIdLinkedMap.get(insurTypeId));
            this.buildStandardDimImportDTO(standardDimImportDTO, registerTypeId, categoryId);
            Iterator iterator = stdDimItemImportDTOTable.cellSet().iterator();
            if (iterator.hasNext()) {
                Table.Cell cell = (Table.Cell)iterator.next();
                Long firstRegisterTypeId = (Long)cell.getRowKey();
                Long firstCategoryId = (Long)cell.getColumnKey();
                if (CollectionUtils.isEmpty(tmpStandardDimItemImportDTOLinkedMap) && !CollectionUtils.isEmpty((Map)((Map)cell.getValue()))) {
                    tmpStandardDimItemImportDTOLinkedMap = (Map)cell.getValue();
                }
                StringJoiner errFields = new StringJoiner(MultiLangHelper.getMultiLangCommaDelimiter());
                if (firstRegisterTypeId == 0L && registerTypeId != 0L || firstRegisterTypeId != 0L && registerTypeId == 0L) {
                    errFields.add(SocInsuranceErrInfoEnum.CENSUS_REGISTER_TYPE.getErrInfo());
                }
                if (firstCategoryId == 0L && categoryId != 0L || firstCategoryId != 0L && categoryId == 0L) {
                    errFields.add(SocInsuranceErrInfoEnum.HOUSEHOLD_TYPE.getErrInfo());
                }
                if (errFields.length() > 0) {
                    log.info("SInsuranceStandardBatchImportPlugin.checkSubEntityTableInfoValidAndBuildDataInfo: stdDimItemImportDTOTable is {},", (Object)stdDimItemImportDTOTable.toString());
                    errInfoList.add(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_MAKE_SURE_DIM.getErrInfo(new Object[]{entityRowNum, insurTypeDetailName, errFields.toString()}));
                    isInvalid = true;
                    continue;
                }
            }
            if (!CollectionUtils.isEmpty((Map)(standardDimItemImportDTOLinkedMap = (LinkedHashMap<Long, StandardDimItemImportDTO>)stdDimItemImportDTOTable.get((Object)registerTypeId, (Object)categoryId)))) {
                errInfoList.add(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_INSUR_DIM_REPEATED.getErrInfo(new Object[]{entityRowNum, insurTypeDetailName}));
                log.info("SInsuranceStandardBatchImportPlugin.checkSubEntityTableInfoValidAndBuildDataInfo: registerTypeId = {}, categoryId = {} ", (Object)registerTypeId, (Object)categoryId);
                isInvalid = true;
                continue;
            }
            standardDimItemImportDTOLinkedMap = new LinkedHashMap<Long, StandardDimItemImportDTO>(16);
            stdDimItemImportDTOTable.put((Object)registerTypeId, (Object)categoryId, standardDimItemImportDTOLinkedMap);
            Map<Long, InsurTypeAttrEntity> insurancePropIdAndEntityMap = this.insurTypeAttrFieldKeyAndEntityMap.values().stream().collect(Collectors.toMap(InsurTypeAttrEntity::getId, val -> val, (oldVal, newVal) -> oldVal));
            LinkedHashMap<SocInsuranceErrInfoEnum, StringJoiner> errFieldMap = new LinkedHashMap<SocInsuranceErrInfoEnum, StringJoiner>(16);
            for (Map.Entry entry : cfgInfoLinkedMap.entrySet()) {
                Long insurAttrId = (Long)entry.getKey();
                InsurTypeAttrEntity insurTypeAttrEntity = insurancePropIdAndEntityMap.get(insurAttrId);
                if (insurTypeAttrEntity == null || HRStringUtils.isEmpty((String)insurTypeAttrEntity.getFieldKey())) {
                    log.error("SInsuranceStandardBatchImportPlugin.checkSubEntityTableInfoValidAndBuildDataInfo: insurTypeAttrEntity is {}.", (Object)JSON.toJSONString((Object)insurTypeAttrEntity));
                    isInvalid = true;
                    errFieldMap.computeIfAbsent(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_EXPORT_CFG_TPL_ERROR, key -> new StringJoiner(MultiLangHelper.getMultiLangCommaDelimiter())).add(String.valueOf(insurAttrId));
                    continue;
                }
                String fieldKey = insurTypeAttrEntity.getFieldKey();
                Long insurItemId = (Long)this.insurTypeAndAttrAndItemTable.get((Object)insurTypeId, (Object)insurAttrId);
                if (insurItemId == null) {
                    log.error("SInsuranceStandardBatchImportPlugin.checkSubEntityTableInfoValidAndBuildDataInfo: insurTypeAttrEntity is {}, insurItemId is {}", (Object)JSON.toJSONString((Object)insurTypeAttrEntity), (Object)insurItemId);
                    isInvalid = true;
                    this.recordErrField(errFieldMap, SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_INSUR_ITEM_EMPTY, fieldKey);
                    continue;
                }
                String insurItemVal = currJson.getString(insurTypeAttrEntity.getFieldKey());
                if (HRStringUtils.isEmpty((String)insurItemVal)) {
                    isInvalid = true;
                    this.recordErrField(errFieldMap, SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_INSUR_ITEM_EMPTY, fieldKey);
                    continue;
                }
                StandardDimItemImportDTO standardDimItemImportDTO = standardDimItemImportDTOLinkedMap.computeIfAbsent(insurAttrId, key -> new StandardDimItemImportDTO());
                standardDimItemImportDTO.setInsurItem(insurItemId);
                standardDimItemImportDTO.setCategory(registerTypeId);
                standardDimItemImportDTO.setCategory(categoryId);
                if ("0".equals(entry.getValue())) {
                    boolean isTmplInvalid = this.isInvalidNumerical(insurItemVal, fieldKey, errFieldMap);
                    boolean bl = isInvalid = isTmplInvalid || isInvalid;
                    if (isTmplInvalid) continue;
                    LinkedHashMap<String, Object> attrMap = this.insurItemIdAndAttrInfoMap.get(String.valueOf(insurItemId));
                    int precision = (Integer)attrMap.getOrDefault("dataprecision.scale", 0);
                    BigDecimal insurItemBigVal = new BigDecimal(insurItemVal).setScale(precision, 1);
                    standardDimItemImportDTO.setItemValue(String.valueOf(insurItemBigVal));
                    standardDimItemImportDTO.setRoundType(null);
                    continue;
                }
                StandardDimItemImportDTO lastStandardDimItemImportDTO = (StandardDimItemImportDTO)tmpStandardDimItemImportDTOLinkedMap.get(insurAttrId);
                String lastRoundType = lastStandardDimItemImportDTO == null ? null : lastStandardDimItemImportDTO.getRoundType();
                standardDimItemImportDTO.setRoundType(lastRoundType);
                boolean isTmplInvalid = this.isInvalidRoundTypeAndRecord(insurItemVal, fieldKey, standardDimItemImportDTO, errFieldMap);
                if (isTmplInvalid) {
                    isInvalid = true;
                    continue;
                }
                tmpStandardDimItemImportDTOLinkedMap.put(insurAttrId, standardDimItemImportDTO);
            }
            StringJoiner lineErr = new StringJoiner("");
            boolean bl = this.checkBaseTopAndDownInValid(cfgInfoLinkedMap, standardDimItemImportDTOLinkedMap, lineErr);
            isInvalid = isInvalid || bl;
            log.info("SInsuranceStandardBatchImportPlugin.checkSubEntityTableInfoValidAndBuildDataInfo: errFieldMap is {}, insurTypeId is {}, rowNum is {}", new Object[]{((Object)errFieldMap).toString(), insurTypeId, entityRowNum});
            if (isInvalid) {
                for (Map.Entry entry : errFieldMap.entrySet()) {
                    SocInsuranceErrInfoEnum socInsuranceErrInfoEnum = (SocInsuranceErrInfoEnum)entry.getKey();
                    if (SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_EXPORT_CFG_TPL_ERROR == socInsuranceErrInfoEnum) {
                        lineErr.add(socInsuranceErrInfoEnum.getErrInfo());
                        continue;
                    }
                    StringJoiner value = (StringJoiner)entry.getValue();
                    if (value.length() <= 0) continue;
                    lineErr.add(socInsuranceErrInfoEnum.getErrInfo(new Object[]{value.toString()}));
                    log.info("SInsuranceStandardBatchImportPlugin.checkSubEntityTableInfoValidAndBuildDataInfo: errFieldMap detail msg is {}.", (Object)socInsuranceErrInfoEnum.getErrInfo(new Object[]{value.toString()}));
                }
                if (lineErr.length() > 0) {
                    errInfoList.add(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_LINE_ERR.getErrInfo(new Object[]{entityRowNum, insurTypeDetailName, lineErr}));
                    log.info("SInsuranceStandardBatchImportPlugin.checkSubEntityTableInfoValidAndBuildDataInfo: {}", (Object)SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_LINE_ERR.getErrInfo(new Object[]{entityRowNum, insurTypeDetailName, lineErr}));
                }
            }
            ++entityRowNum;
        }
        return !isInvalid;
    }

    private boolean checkDimInvalidAndGetVal(JSONObject currJson, List<String> errInfoList, int entityRowNum, Map<String, Long> dimKeyVal) {
        boolean isInvalid = false;
        StringJoiner errFieldSj = new StringJoiner(MultiLangHelper.getMultiLangCommaDelimiter());
        for (String dimField : DIM_FIELDS) {
            SocInsuranceErrInfoEnum socInsuranceErrInfoEnum = dimField.equals("registertype") ? SocInsuranceErrInfoEnum.CENSUS_REGISTER_TYPE : SocInsuranceErrInfoEnum.HOUSEHOLD_TYPE;
            String basePropValInExcel = this.getBaseValFrom(currJson, dimField);
            Long baseId = 0L;
            if (basePropValInExcel != null && ((baseId = this.baseFieldAndPropAndIdMap.get(dimField).get(basePropValInExcel)) == null || baseId == 0L)) {
                String baseTypeDetailName = this.getBaseTypeDetailName(dimField, socInsuranceErrInfoEnum, basePropValInExcel);
                errFieldSj.add(baseTypeDetailName);
                isInvalid = true;
                baseId = 0L;
            }
            dimKeyVal.put(dimField, baseId);
        }
        if (errFieldSj.length() > 0) {
            errInfoList.add(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_INSUR_DIM_VAL_ERROR.getErrInfo(new Object[]{entityRowNum, errFieldSj.toString()}));
        }
        return isInvalid;
    }

    private Long checkBaseInvalid(JSONObject jsonData, String baseFieldKey, List<String> errInfoList, StringJoiner emptySj, StringJoiner notExistInDbSj) {
        Long basePropId;
        JSONObject baseInfoJson = jsonData.getJSONObject(baseFieldKey);
        SocInsuranceErrInfoEnum socInsuranceErrInfoEnum = (SocInsuranceErrInfoEnum)BASED_FIELD_KEY_AND_SOC_ENUM_MAP.get((Object)baseFieldKey);
        if (baseInfoJson == null) {
            emptySj.add(socInsuranceErrInfoEnum.getErrInfo());
            return null;
        }
        String importProp = baseInfoJson.getString("importprop");
        String baseValInExcel = baseInfoJson.getString(importProp);
        String basedPropDes = this.getBasedPropDes(socInsuranceErrInfoEnum, importProp);
        if (baseValInExcel == null) {
            emptySj.add(basedPropDes);
            return null;
        }
        if ("id".equals(importProp)) {
            try {
                Long.parseLong(baseValInExcel);
            }
            catch (Exception e) {
                errInfoList.add(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_IS_NOT_LONG.getErrInfo(new Object[]{basedPropDes}));
                return null;
            }
        }
        if ((basePropId = this.baseFieldAndPropAndIdMap.get(baseFieldKey).get(baseValInExcel)) == null) {
            if (notExistInDbSj != null) {
                notExistInDbSj.add(basedPropDes);
            }
            return null;
        }
        if (this.hasPermOrgs != null && !this.hasPermOrgs.contains(basePropId) && "createorg".equals(baseFieldKey)) {
            String createOrgDetailName = this.getBaseTypeDetailName("createorg", SocInsuranceErrInfoEnum.COMMON_FIELD_CREATE_ORG, baseValInExcel);
            errInfoList.add(SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_WITHOUT_CREATE_ORG_PERMISSION.getErrInfo(new Object[]{createOrgDetailName}));
            return null;
        }
        if (this.permCountryIdSet != null && !this.permCountryIdSet.contains(countryChinaDy.getLong("id")) && "country".equals(baseFieldKey)) {
            errInfoList.add(SocInsuranceErrInfoEnum.PERIOD_TYPE_WITHOUT_COUNTRY_PERMISSION.getErrInfo(new Object[]{SocInsuranceErrInfoEnum.COMMON_COUNTRY_CHINA.getErrInfo()}));
            return null;
        }
        return basePropId;
    }

    private String checkBaseInvalid(JSONObject baseInfoJson, SocInsuranceErrInfoEnum socInsuranceErrInfoEnum) {
        if (baseInfoJson == null) {
            return SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_IS_NULL.getErrInfo(new Object[]{socInsuranceErrInfoEnum.getErrInfo()});
        }
        String importProp = baseInfoJson.getString("importprop");
        Object baseProp = baseInfoJson.get((Object)importProp);
        if (baseProp == null) {
            return SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_IS_NULL.getErrInfo(new Object[]{this.getBasedPropDes(socInsuranceErrInfoEnum, importProp)});
        }
        if ("id".equals(importProp)) {
            try {
                Long.parseLong(String.valueOf(baseProp));
            }
            catch (Exception e) {
                return SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_IS_NOT_LONG.getErrInfo(new Object[]{this.getBasedPropDes(socInsuranceErrInfoEnum, importProp)});
            }
        }
        return null;
    }

    private String getBasedPropDes(SocInsuranceErrInfoEnum socInsuranceErrInfoEnum, String baseProp) {
        if ("number".equals(baseProp)) {
            return socInsuranceErrInfoEnum.getErrInfo() + "." + SocInsuranceErrInfoEnum.COMMON_FIELD_NUMBER.getErrInfo();
        }
        if ("name".equals(baseProp)) {
            return socInsuranceErrInfoEnum.getErrInfo() + "." + SocInsuranceErrInfoEnum.COMMON_FIELD_NAME.getErrInfo();
        }
        return socInsuranceErrInfoEnum.getErrInfo() + "." + SocInsuranceErrInfoEnum.COMMON_FIELD_MASTER.getErrInfo();
    }

    private void getBaseInfo(JSONObject jsonData, Map<String, Object> rowMap, String baseFieldKey) {
        Object resultPropVal = this.recordImportPropAndValue(baseFieldKey, jsonData);
        if (resultPropVal != null) {
            rowMap.put(baseFieldKey, resultPropVal);
        }
    }

    private Object recordImportPropAndValue(String baseFieldKey, JSONObject jsonData) {
        SocInsuranceErrInfoEnum socInsuranceErrInfoEnum;
        if (baseFieldKey != null && (socInsuranceErrInfoEnum = (SocInsuranceErrInfoEnum)BASED_FIELD_KEY_AND_SOC_ENUM_MAP.get((Object)baseFieldKey)) != null) {
            JSONObject baseInfoJson = jsonData.getJSONObject(baseFieldKey);
            return this.recordImportPropAndValue(socInsuranceErrInfoEnum, baseInfoJson);
        }
        return null;
    }

    private Object recordImportPropAndValue(SocInsuranceErrInfoEnum socInsuranceErrInfoEnum, JSONObject baseInfoJson) {
        String importPropVal;
        String importProp;
        if (baseInfoJson == null || (importProp = baseInfoJson.getString("importprop")) == null || (importPropVal = baseInfoJson.getString(importProp)) == null) {
            return null;
        }
        Object resultPropVal = importPropVal;
        if ("id".equals(importProp)) {
            try {
                resultPropVal = Long.parseLong(importPropVal);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (SocInsuranceErrInfoEnum.COMMON_FIELD_CREATE_ORG == socInsuranceErrInfoEnum) {
            if (this.standardImportBasePropDTO.getCreateOrgProp() == null) {
                this.standardImportBasePropDTO.setCreateOrgProp(importProp);
            }
            this.baseFieldAndPropAndIdMap.get("createorg").put(importPropVal, null);
        } else if (SocInsuranceErrInfoEnum.COMMON_FIELD_COUNTRY == socInsuranceErrInfoEnum) {
            if (this.standardImportBasePropDTO.getCountryProp() == null) {
                this.standardImportBasePropDTO.setCountryProp(importProp);
            }
            this.baseFieldAndPropAndIdMap.get("country").put(importPropVal, null);
        } else if (SocInsuranceErrInfoEnum.COMMON_FIELD_INSURANCE_AREA == socInsuranceErrInfoEnum) {
            if (this.standardImportBasePropDTO.getInsurAreaProp() == null) {
                this.standardImportBasePropDTO.setInsurAreaProp(importProp);
            }
            this.baseFieldAndPropAndIdMap.get("insurarea").put(importPropVal, null);
        } else if (SocInsuranceErrInfoEnum.COMMON_FIELD_INSURANCE_TYPE == socInsuranceErrInfoEnum) {
            if (this.standardImportBasePropDTO.getInsurtypeProp() == null) {
                this.standardImportBasePropDTO.setInsurTypeProp(importProp);
            }
            this.baseFieldAndPropAndIdMap.get("insurtype").put(importPropVal, null);
        } else if (SocInsuranceErrInfoEnum.CENSUS_REGISTER_TYPE == socInsuranceErrInfoEnum) {
            if (this.standardImportBasePropDTO.getRegisterTypeProp() == null) {
                this.standardImportBasePropDTO.setRegisterTypeProp(importProp);
            }
            this.baseFieldAndPropAndIdMap.get("registertype").put(importPropVal, null);
        } else if (SocInsuranceErrInfoEnum.HOUSEHOLD_TYPE == socInsuranceErrInfoEnum) {
            if (this.standardImportBasePropDTO.getCategoryProp() == null) {
                this.standardImportBasePropDTO.setCategoryProp(importProp);
            }
            this.baseFieldAndPropAndIdMap.get("category").put(importPropVal, null);
        }
        return resultPropVal;
    }

    private void getInsurTypeEntityInfo(JSONObject jsonData) {
        JSONArray stdEntryEntity = jsonData.getJSONArray("stdentryentity");
        if (!CollectionUtils.isEmpty((Collection)stdEntryEntity)) {
            for (int i = 0; i < stdEntryEntity.size(); ++i) {
                JSONObject currJsonData = stdEntryEntity.getJSONObject(i);
                this.recordImportPropAndValue("insurtype", currJsonData);
                JSONArray subEntryEntity = currJsonData.getJSONArray("subentryentity");
                for (int j = 0; j < subEntryEntity.size(); ++j) {
                    JSONObject currJson = subEntryEntity.getJSONObject(j);
                    this.recordImportPropAndValue("registertype", currJson);
                    this.recordImportPropAndValue("category", currJson);
                }
            }
        }
    }

    private void filterDataToUpdate(String updateType) {
        log.info("SInsuranceStandardBatchImportPlugin.filterDataToUpdate: begin to filter data.");
        this.updateQFilter.and("iscurrentversion", "=", (Object)"1");
        List stdDys = SocInsuranceStandardHelper.queryInfoByEntityName((String)"sitbs_sinsurstd", (QFilter)this.updateQFilter);
        HashSet<String> existsFieldKeySet = new HashSet<String>(stdDys.size());
        HashSet<Long> auditInsurStdBoIdSet = new HashSet<Long>(stdDys.size());
        for (DynamicObject stdDyInDB : stdDys) {
            String fieldValKey = this.getFieldValKey(stdDyInDB);
            if (!existsFieldKeySet.add(fieldValKey)) {
                this.updateKeysValAndStdDyInDbMap.put(fieldValKey, 0);
                continue;
            }
            this.updateKeysValAndStdDyInDbMap.put(fieldValKey, stdDyInDB);
            String status = stdDyInDB.getString("status");
            String enable = stdDyInDB.getString("enable");
            if (!"C".equals(status) || !"1".equals(enable)) continue;
            auditInsurStdBoIdSet.add(stdDyInDB.getLong("boid"));
        }
        if ("0".equals(updateType)) {
            this.featureBoIdSet = SocInsuranceStandardHelper.queryFeatureBoId(auditInsurStdBoIdSet);
        }
        HashMap<Integer, String> tmpRowNumAndFieldValueMap = new HashMap<Integer, String>(this.rowNumAndFieldValueMap);
        tmpRowNumAndFieldValueMap.values().removeAll(this.updateKeysValAndStdDyInDbMap.keySet());
        this.rowNumAndStandardNumMap.keySet().retainAll(tmpRowNumAndFieldValueMap.keySet());
    }

    private void filterDataToAddNew() {
        if (this.rowNumAndStandardNumMap.isEmpty()) {
            return;
        }
        log.info("SInsuranceStandardBatchImportPlugin.filterDataToAddNew: begin to filter data.");
        QFilter filter = new QFilter("number", "in", new HashSet<String>(this.rowNumAndStandardNumMap.values()));
        List stdDys = SocInsuranceStandardHelper.queryInfoByEntityName((String)"sitbs_sinsurstd", (QFilter)filter);
        stdDys.forEach(stdDy -> this.existsStandardNumAndDyForAddNewMap.put(stdDy.getString("number"), (DynamicObject)stdDy));
    }

    private void getAllBaseInfo() {
        for (String baseField : ALL_BASE_FIELDS) {
            this.buildBasedInfo(baseField);
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_registertype");
        QFilter filter = SInsuranceCommonService.getAuditAndEnableQFilter();
        this.registerTypeMaxCountInDb = helper.count("sitbs_registertype", filter.toArray());
        this.categoryMaxCountInDb = helper.count("hbss_category", filter.toArray());
    }

    private void buildBasedInfo(String baseField) {
        QFilter filter;
        if (HRStringUtils.isEmpty((String)baseField)) {
            return;
        }
        String entityName = null;
        String baseProp = this.standardImportBasePropDTO.getBasePropBy(baseField);
        QFilter countryFilter = null;
        QFilter createOrgFilter = null;
        switch (baseField) {
            case "createorg": {
                entityName = "bos_org";
                createOrgFilter = new QFilter("fishrsi", "=", (Object)"1");
                break;
            }
            case "country": {
                entityName = "bd_country";
                countryFilter = new QFilter("id", "=", (Object)SInsuranceConstants.COUNTRY_ID_CHINA);
                break;
            }
            case "insurarea": {
                entityName = "sitbs_placeofwelfare";
                countryFilter = new QFilter("country", "=", (Object)SInsuranceConstants.COUNTRY_ID_CHINA);
                break;
            }
            case "insurtype": {
                entityName = "sitbs_welfaretype";
                countryFilter = new QFilter("country", "=", (Object)SInsuranceConstants.COUNTRY_ID_CHINA);
                break;
            }
            case "registertype": {
                entityName = "sitbs_registertype";
                break;
            }
            case "category": {
                entityName = "hbss_category";
                break;
            }
        }
        Map<String, Long> basePropAndDyMap = this.baseFieldAndPropAndIdMap.get(baseField);
        if (entityName == null || CollectionUtils.isEmpty(basePropAndDyMap) || HRStringUtils.isEmpty((String)baseProp)) {
            return;
        }
        if ("registertype".equals(baseField) || "category".equals(baseField)) {
            filter = SInsuranceCommonService.getAuditAndEnableQFilter();
        } else {
            filter = new QFilter(baseProp, "in", basePropAndDyMap.keySet());
            filter.and(SInsuranceCommonService.getAuditAndEnableQFilter());
            filter.and(countryFilter);
            filter.and(createOrgFilter);
        }
        List baseInfoDys = SocInsuranceStandardHelper.queryInfoByEntityName((String)entityName, (QFilter)filter);
        for (DynamicObject baseInfoDy : baseInfoDys) {
            String propValInDb = baseInfoDy.getString(baseProp);
            long pkId = baseInfoDy.getLong("id");
            if (propValInDb == null || pkId == 0L) continue;
            basePropAndDyMap.put(propValInDb, pkId);
            this.basedPkTable.put((Object)baseField, (Object)pkId, (Object)baseInfoDy);
        }
    }

    private void setInsuranceInfo() {
        HashSet<Long> insurTypeIdSet = new HashSet<Long>(this.baseFieldAndPropAndIdMap.get("insurtype").values());
        if (CollectionUtils.isEmpty(insurTypeIdSet)) {
            return;
        }
        HashSet allInsurItemIdSet = new HashSet(16);
        HashMap tmpInsurTypeIdAndCfgIdLinkedMap = new HashMap(16);
        this.insurTypeIdAndCfgInfoLinkedMap = SocInsuranceStandardService.getSInsurStdCfgMap(insurTypeIdSet, allInsurItemIdSet, (boolean)false, tmpInsurTypeIdAndCfgIdLinkedMap, this.insurTypeAndAttrAndItemTable);
        this.insurTypeIdAndCfgIdLinkedMap.putAll(tmpInsurTypeIdAndCfgIdLinkedMap);
        this.insurItemIdAndAttrInfoMap = SocInsuranceStandardService.getFieldKeyAttrLinkedMap(allInsurItemIdSet, insurTypeIdSet, (boolean)false);
    }

    private void setFieldValueStringAndQFilter(int rowNum, Map<String, Object> rowMap) {
        ArrayList<Object> fieldValues = new ArrayList<Object>(10);
        QFilter filter = new QFilter("1", "=", (Object)1);
        for (String updateField : ALL_UPDATE_FIELDS) {
            Object propVal;
            if (!this.updateFieldSet.contains(updateField) || (propVal = rowMap.get(updateField)) == null) continue;
            String sqlField = updateField;
            if ("createorg".equals(updateField) || "insurarea".equals(updateField)) {
                String baseProp = "createorg".equals(updateField) ? this.standardImportBasePropDTO.getCreateOrgProp() : this.standardImportBasePropDTO.getInsurAreaProp();
                sqlField = updateField + "." + baseProp;
            }
            this.getUpdateQFilter(filter, sqlField, propVal);
            fieldValues.add(propVal);
        }
        if (fieldValues.size() == this.updateFieldSet.size()) {
            StringJoiner sj = new StringJoiner(",");
            fieldValues.forEach(fieldValue -> sj.add(String.valueOf(fieldValue)));
            this.rowNumAndFieldValueMap.put(rowNum, sj.toString());
            if (this.updateFieldSet.size() > 1) {
                this.updateQFilter = filter.or(this.updateQFilter);
            }
        }
    }

    private void getUpdateQFilter(QFilter filter, String fieldKey, Object fieldVal) {
        if (this.updateFieldSet.size() == 1) {
            if (this.updateQFilter == null) {
                HashSet valSet = new HashSet(16);
                this.updateQFilter = new QFilter(fieldKey, "in", valSet);
            }
            Set sumValSet = (Set)this.updateQFilter.getValue();
            sumValSet.add(fieldVal);
        } else {
            filter.and(fieldKey, "=", fieldVal);
        }
    }

    private String getFieldValKey(DynamicObject stdDy) {
        ArrayList<String> fieldValues = new ArrayList<String>(10);
        for (String updateField : ALL_UPDATE_FIELDS) {
            if (!this.updateFieldSet.contains(updateField)) continue;
            if ("number".equals(updateField) || "name".equals(updateField)) {
                String updateFieldVal = stdDy.getString(updateField);
                fieldValues.add(updateFieldVal);
                continue;
            }
            String baseProp = "createorg".equals(updateField) ? this.standardImportBasePropDTO.getCreateOrgProp() : this.standardImportBasePropDTO.getInsurAreaProp();
            fieldValues.add(stdDy.getString(updateField + "." + baseProp));
        }
        StringJoiner sj = new StringJoiner(",");
        fieldValues.forEach(sj::add);
        return sj.toString();
    }

    private String getBaseValFrom(JSONObject jsonData, String fieldKey) {
        JSONObject fieldJson = jsonData.getJSONObject(fieldKey);
        return this.getDetailBaseValFrom(fieldJson, fieldKey);
    }

    private String getDetailBaseValFrom(JSONObject baseJson, String fieldKey) {
        String baseProp;
        if (baseJson != null && (baseProp = this.standardImportBasePropDTO.getBasePropBy(fieldKey)) != null) {
            return baseJson.getString(baseProp);
        }
        return null;
    }

    private void buildStandardDimImportDTO(StandardDimImportDTO standardDimImportDTO, Long registerTypeId, Long categoryId) {
        int maxLine = standardDimImportDTO.getMaxDimEntityLength();
        if (maxLine == 0) {
            int maxRegisterTypeCount = 1;
            boolean enableDim = false;
            if (registerTypeId > 0L) {
                maxRegisterTypeCount = this.registerTypeMaxCountInDb;
                standardDimImportDTO.setRegisterType("0");
                enableDim = true;
            }
            int maxCategoryCount = 1;
            if (categoryId > 0L) {
                maxCategoryCount = this.categoryMaxCountInDb;
                standardDimImportDTO.setCategory("1");
                enableDim = true;
            }
            maxLine = maxRegisterTypeCount * maxCategoryCount;
            standardDimImportDTO.setMaxDimEntityLength(maxLine);
            standardDimImportDTO.setEnableDim(enableDim);
        }
    }

    public boolean isInvalidNumerical(String insurItemVal, String insurTypeAttrFieldKey, Map<SocInsuranceErrInfoEnum, StringJoiner> errFieldMap) {
        if (insurItemVal == null || !NUMBER_PATTERN.matcher(insurItemVal).matches()) {
            this.recordErrField(errFieldMap, SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_DATA_IS_NOT_NUMERICAL, insurTypeAttrFieldKey);
            return true;
        }
        String[] split = insurItemVal.split("\\.");
        String firstPart = split[0];
        if ((firstPart = firstPart.replaceFirst("^0*", "")).isEmpty()) {
            firstPart = "0";
        }
        if ("payproportionofemployee".equals(insurTypeAttrFieldKey) || "payproportionofcompany".equals(insurTypeAttrFieldKey)) {
            if (!"100".equals(firstPart) && firstPart.length() >= 3) {
                this.recordErrField(errFieldMap, SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_PAY_PROPORTION_OUT_OF_RANGE, insurTypeAttrFieldKey);
                return true;
            }
        } else if (firstPart.length() > 13) {
            this.recordErrField(errFieldMap, SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_DATA_OUT_OF_RANGE, insurTypeAttrFieldKey);
            return true;
        }
        if (split.length == 2 && split[1].length() > 10) {
            this.recordErrField(errFieldMap, SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_DATA_OUT_OF_RANGE, insurTypeAttrFieldKey);
            return true;
        }
        return false;
    }

    private boolean isInvalidRoundTypeAndRecord(String roundTypeValInExcel, String insurTypeAttrFieldKey, StandardDimItemImportDTO standardDimItemImportDTO, Map<SocInsuranceErrInfoEnum, StringJoiner> errFieldMap) {
        if (roundTypeValInExcel == null || !ROUND_TYPE_ENUM_SET.contains(roundTypeValInExcel)) {
            this.recordErrField(errFieldMap, SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_ROUND_TYPE_ERR, insurTypeAttrFieldKey);
            return true;
        }
        if (standardDimItemImportDTO != null) {
            if (standardDimItemImportDTO.getRoundType() != null && !standardDimItemImportDTO.getRoundType().equals(roundTypeValInExcel)) {
                this.recordErrField(errFieldMap, SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_ROUND_TYPE_NOT_SAME, insurTypeAttrFieldKey);
                return true;
            }
            standardDimItemImportDTO.setRoundType(roundTypeValInExcel);
        }
        return false;
    }

    private void recordErrField(Map<SocInsuranceErrInfoEnum, StringJoiner> errFieldMap, SocInsuranceErrInfoEnum errInfoEnum, String fieldKey) {
        InsurTypeAttrEntity insurTypeAttrEntity = (InsurTypeAttrEntity)this.insurTypeAttrFieldKeyAndEntityMap.get((Object)fieldKey);
        String fieldName = insurTypeAttrEntity != null ? insurTypeAttrEntity.getName() : "";
        errFieldMap.computeIfAbsent(errInfoEnum, key -> new StringJoiner(MultiLangHelper.getMultiLangCommaDelimiter())).add(fieldName);
    }

    private void setStdInfo(String status, String stdNumInExcel, StandardMainImportDTO stdMainImportDTO, Map<Long, StandardDimImportDTO> stdDimImportDTOLinkedMap, Map<Long, HashBasedTable<Long, Long, Map<Long, StandardDimItemImportDTO>>> stdDimItemImportDTOLinkedMap) {
        this.stdNumberAndStdMainInfoLinkedMap.put(stdNumInExcel, stdMainImportDTO);
        stdDimImportDTOLinkedMap.forEach((key, value) -> {
            StandardDimImportDTO cfr_ignored_0 = (StandardDimImportDTO)this.stdNumberInsurTypeAndStdDimTable.put((Object)stdNumInExcel, key, value);
        });
        HashBasedTable<String, Long, HashBasedTable<Long, Long, Map<Long, StandardDimItemImportDTO>>> subEntryTable = "new".equals(status) ? this.stdDimItemImportAddDTOTable : ("A".equals(status) ? this.stdDimItemImportSaveDTOTable : this.stdDimItemImportAuditDTOTable);
        stdDimItemImportDTOLinkedMap.forEach((key, value) -> {
            HashBasedTable cfr_ignored_0 = (HashBasedTable)subEntryTable.put((Object)stdNumInExcel, key, value);
        });
    }

    private void checkNameAndNumberRepeated(String valInExcel, String valInDb, StringJoiner repeatedNumAndNameJS, SocInsuranceErrInfoEnum socInsuranceErrInfoEnum) {
        if (SocInsuranceErrInfoEnum.COMMON_FIELD_NAME == socInsuranceErrInfoEnum) {
            if (!HRStringUtils.isEmpty((String)valInDb) && valInDb.equals(valInExcel)) {
                return;
            }
            if (this.standardNameInDbSet.contains(valInExcel) || this.usedStandardNameSet.contains(valInExcel)) {
                repeatedNumAndNameJS.add(socInsuranceErrInfoEnum.getErrInfo());
            }
        } else if (SocInsuranceErrInfoEnum.COMMON_FIELD_NUMBER == socInsuranceErrInfoEnum && valInDb == null && (this.existsStandardNumAndDyForAddNewMap.containsKey(valInExcel) || this.usedStandardNumberSet.contains(valInExcel))) {
            repeatedNumAndNameJS.add(socInsuranceErrInfoEnum.getErrInfo());
        }
    }

    private void updateNumberNameRepeatCheckSet(JSONObject jsonData, String fieldKey, String valInDb) {
        String valInExcel = null;
        if (jsonData != null) {
            JSONObject nameJson;
            if ("name".equals(fieldKey) && (nameJson = jsonData.getJSONObject("name")) != null) {
                valInExcel = nameJson.getString(RequestContext.get().getLang().name());
            } else if ("number".equals(fieldKey)) {
                valInExcel = jsonData.getString(fieldKey);
            }
        }
        if (valInExcel != null && !valInExcel.equals(valInDb)) {
            if ("name".equals(fieldKey) && valInDb != null) {
                this.standardNameInDbSet.remove(valInDb);
            }
            Set<String> currSet = "number".equals(fieldKey) ? this.usedStandardNumberSet : this.usedStandardNameSet;
            currSet.add(valInExcel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveInsuranceStandardInfo() {
        Date modifyTime = new Date();
        try (TXHandle txHandle = TX.required();){
            List<DynamicObject> newStdDys = this.getStandardDys("new", modifyTime);
            this.updateDynamicObject("new", newStdDys);
            List<DynamicObject> saveStdDys = this.getStandardDys("A", modifyTime);
            this.updateDynamicObject("A", saveStdDys);
            List<DynamicObject> auditStdDys = this.getStandardDys("C", modifyTime);
            this.updateDynamicObject("C", auditStdDys);
            txHandle.commit();
        }
    }

    private List<DynamicObject> getStandardDys(String status, Date modifyTime) {
        Map rowMap;
        long[] pkIdArr = new long[]{};
        String currStatus = status;
        if ("new".equals(currStatus)) {
            rowMap = this.stdDimItemImportAddDTOTable.rowMap();
            pkIdArr = DB.genLongIds((String)"sitbs_sinsurstd", (int)rowMap.size());
            currStatus = "A";
        } else if ("A".equals(currStatus)) {
            rowMap = this.stdDimItemImportSaveDTOTable.rowMap();
        } else {
            rowMap = this.stdDimItemImportAuditDTOTable.rowMap();
            pkIdArr = DB.genLongIds((String)"sitbs_sinsurstd", (int)rowMap.size());
        }
        if (rowMap.isEmpty()) {
            return new ArrayList<DynamicObject>(0);
        }
        this.pkIdAndRowNumMap.clear();
        ArrayList<DynamicObject> importStdDys = new ArrayList<DynamicObject>(this.stdDimItemImportAuditDTOTable.size());
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"sitbs_sinsurstd");
        int index = 0;
        for (Map.Entry mapEntry : rowMap.entrySet()) {
            DynamicObject stdDy;
            String stdNumber = (String)mapEntry.getKey();
            StandardMainImportDTO standardMainImportDTO = this.stdNumberAndStdMainInfoLinkedMap.get(stdNumber);
            Map stdDimImportDTOLinkedMap = this.stdNumberInsurTypeAndStdDimTable.row((Object)stdNumber);
            Map stdDimItemImportDTOLinkedMap = (Map)mapEntry.getValue();
            if (standardMainImportDTO == null || CollectionUtils.isEmpty((Map)stdDimImportDTOLinkedMap) || CollectionUtils.isEmpty((Map)stdDimItemImportDTOLinkedMap)) continue;
            if ("A".equals(status)) {
                String updateFieldKeyVal = this.rowNumAndFieldValueMap.get(standardMainImportDTO.getRowNum());
                stdDy = (DynamicObject)this.updateKeysValAndStdDyInDbMap.get(updateFieldKeyVal);
                if (stdDy == null) {
                    log.error("SInsuranceStandardBatchImportPlugin.getStandardDys: the value of key '{}' is null. ", (Object)updateFieldKeyVal);
                    continue;
                }
            } else {
                stdDy = (DynamicObject)type.createInstance();
            }
            importStdDys.add(stdDy);
            Long pkId = pkIdArr.length > 0 ? Long.valueOf(pkIdArr[index]) : standardMainImportDTO.getBoId();
            Long boId = standardMainImportDTO.getBoId() != null ? standardMainImportDTO.getBoId() : pkIdArr[index];
            stdDy.set("id", (Object)pkId);
            if ("new".equals(status)) {
                standardMainImportDTO.setCreator(Long.valueOf(RequestContext.get().getCurrUserId()));
                standardMainImportDTO.setCreatetime(modifyTime);
                standardMainImportDTO.setEnable("1");
            }
            stdDy.set("boid", (Object)boId);
            stdDy.set("modifytime", (Object)modifyTime);
            this.pkIdAndRowNumMap.put(pkId, standardMainImportDTO.getRowNum());
            this.setStandardMainInfo(currStatus, standardMainImportDTO, stdDy);
            this.setStandardEntityInfo(stdDy, stdDimImportDTOLinkedMap, stdDimItemImportDTOLinkedMap);
            ++index;
        }
        log.info("SInsuranceStandardBatchImportPlugin.getStandardDys: end to create data, and the data size is {}.", (Object)importStdDys.size());
        return importStdDys;
    }

    private void setStandardMainInfo(String status, StandardMainImportDTO standardMainImportDTO, DynamicObject stdDy) {
        stdDy.set("createorg", this.basedPkTable.get((Object)"createorg", (Object)standardMainImportDTO.getCreateOrg()));
        stdDy.set("number", (Object)standardMainImportDTO.getNumber());
        stdDy.set("name", (Object)standardMainImportDTO.getName());
        stdDy.set("simplename", (Object)"");
        stdDy.set("generalenname", (Object)standardMainImportDTO.getGeneralenName());
        stdDy.set("country", (Object)countryChinaDy);
        stdDy.set("insurarea", this.basedPkTable.get((Object)"insurarea", (Object)standardMainImportDTO.getInsurArea()));
        stdDy.set("bsed", (Object)standardMainImportDTO.getBsed());
        if ("C".equals(status)) {
            stdDy.set("bsled", (Object)standardMainImportDTO.getBsled());
            stdDy.set("changedescription", null);
        } else {
            stdDy.set("iscurrentversion", (Object)"1");
        }
        stdDy.set("ctrlstrategy", (Object)standardMainImportDTO.getCtrlStrategy());
        stdDy.set("description", (Object)standardMainImportDTO.getDescription());
        stdDy.set("status", (Object)status);
        stdDy.set("enable", (Object)standardMainImportDTO.getEnable());
        stdDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
        stdDy.set("creator", (Object)standardMainImportDTO.getCreator());
        stdDy.set("createtime", (Object)standardMainImportDTO.getCreatetime());
    }

    private void setStandardEntityInfo(DynamicObject stdDy, Map<Long, StandardDimImportDTO> stdDimImportDTOLinkedMap, Map<Long, HashBasedTable<Long, Long, Map<Long, StandardDimItemImportDTO>>> stdDimItemImportDTOLinkedMap) {
        long[] entityIds = DB.genLongIds((String)"t_sitbs_sinsurstdent", (int)stdDimImportDTOLinkedMap.size());
        DynamicObjectCollection stdEntryEntity = stdDy.getDynamicObjectCollection("stdentryentity");
        stdEntryEntity.clear();
        int index = 0;
        for (Map.Entry<Long, StandardDimImportDTO> stdDimImportDTOEntry : stdDimImportDTOLinkedMap.entrySet()) {
            Long insurTypeId = stdDimImportDTOEntry.getKey();
            StandardDimImportDTO stdDimImportDTO = stdDimImportDTOEntry.getValue();
            DynamicObject entryEntityDy = stdEntryEntity.addNew();
            entryEntityDy.set("entryboid", (Object)entityIds[index]);
            entryEntityDy.set("insurtype", this.basedPkTable.get((Object)"insurtype", (Object)insurTypeId));
            String stdDim = HRStringUtils.isNotEmpty((String)stdDimImportDTO.getRegisterType()) && HRStringUtils.isNotEmpty((String)stdDimImportDTO.getCategory()) ? stdDimImportDTO.getRegisterType() + "," + stdDimImportDTO.getCategory() : stdDimImportDTO.getRegisterType() + stdDimImportDTO.getCategory();
            entryEntityDy.set("stddim", (Object)(stdDim.length() > 0 ? stdDim : null));
            String isStdDim = stdDimImportDTO.isEnableDim() ? "1" : "0";
            entryEntityDy.set("isstddim", (Object)isStdDim);
            entryEntityDy.set("seq", (Object)(++index));
            DynamicObjectCollection subEntryEntity = entryEntityDy.getDynamicObjectCollection("subentryentity");
            subEntryEntity.clear();
            this.setStandardSubEntityInfo(subEntryEntity, stdDimItemImportDTOLinkedMap.get(insurTypeId));
        }
    }

    private void setStandardSubEntityInfo(DynamicObjectCollection subEntryEntity, HashBasedTable<Long, Long, Map<Long, StandardDimItemImportDTO>> stdDimItemImportDTOTable) {
        int totalSize = stdDimItemImportDTOTable.values().stream().mapToInt(Map::size).sum();
        long[] entityIds = DB.genLongIds((String)"t_sitbs_sinsurstdrent", (int)totalSize);
        int index = 0;
        for (Table.Cell stdDimItemImportDTOCell : stdDimItemImportDTOTable.cellSet()) {
            Map insurItemMap = (Map)stdDimItemImportDTOCell.getValue();
            if (CollectionUtils.isEmpty((Map)insurItemMap)) continue;
            DynamicObject registerTypeDy = (DynamicObject)this.basedPkTable.get((Object)"registertype", stdDimItemImportDTOCell.getRowKey());
            DynamicObject categoryDy = (DynamicObject)this.basedPkTable.get((Object)"category", stdDimItemImportDTOCell.getColumnKey());
            for (StandardDimItemImportDTO standardDimItemImportDTO : insurItemMap.values()) {
                DynamicObject subEntryEntityDy = subEntryEntity.addNew();
                subEntryEntityDy.set("entryboidsinsurstdrent", (Object)entityIds[index]);
                subEntryEntityDy.set("registertype", (Object)registerTypeDy);
                subEntryEntityDy.set("category", (Object)categoryDy);
                subEntryEntityDy.set("insuritem", (Object)standardDimItemImportDTO.getInsurItem());
                subEntryEntityDy.set("itemvalue", (Object)standardDimItemImportDTO.getItemValue());
                subEntryEntityDy.set("roundtype", (Object)standardDimItemImportDTO.getRoundType());
                subEntryEntityDy.set("seq", (Object)(++index));
            }
        }
    }

    private void updateDynamicObject(String status, List<DynamicObject> newStdDys) {
        if (CollectionUtils.isEmpty(newStdDys)) {
            return;
        }
        OperationResult operationResult = SInsuranceCommonService.saveDynamicObject(newStdDys, (String)status);
        if (operationResult == null) {
            return;
        }
        log.info("SInsuranceStandardBatchImportPlugin.updateDynamicObject: status is {}, and operationResult is {}", (Object)status, (Object)operationResult.getAllErrorOrValidateInfo().toString());
        ImportOperationResultHelper.dealOperationResult((OperationResult)operationResult, this.pkIdAndRowNumMap, this.rowNumAndErrInfoMap);
    }

    private String getBaseTypeDetailName(String fieldKey, SocInsuranceErrInfoEnum socInsuranceErrInfoEnum, Object baseValInExcel) {
        String propName = this.standardImportBasePropDTO.getBasePropBy(fieldKey);
        propName = propName == null ? "" : propName;
        String basedPropDes = this.getBasedPropDes(socInsuranceErrInfoEnum, propName);
        return SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_DETAIL_BASE_TYPE.getErrInfo(new Object[]{basedPropDes, baseValInExcel});
    }

    private ApiResult loggerForResult(List<ImportBillData> rowDatas, ImportLogger logger) {
        ArrayList<Integer> errRowNums = new ArrayList<Integer>(this.rowNumAndErrInfoMap.keySet());
        errRowNums.sort(Comparator.naturalOrder());
        ApiResult apiResult = new ApiResult();
        ArrayList billResults = new ArrayList(rowDatas.size());
        apiResult.setData(billResults);
        for (int i = 0; i < rowDatas.size(); ++i) {
            HashMap<String, Constable> billResult = new HashMap<String, Constable>(4);
            billResult.put("dindex", Integer.valueOf(i));
            JSONObject jsonData = rowDatas.get(i).getData();
            if (jsonData == null || jsonData.isEmpty()) continue;
            int rowNum = jsonData.getIntValue(IMPORT_ROW_NUMBER);
            if (errRowNums.contains(rowNum) && !CollectionUtils.isEmpty((Collection)this.rowNumAndErrInfoMap.get(rowNum))) {
                List<String> errInfoList = this.rowNumAndErrInfoMap.get(rowNum);
                StringJoiner errMsgSj = new StringJoiner("");
                errInfoList.forEach(errMsgSj::add);
                logger.log(Integer.valueOf(rowNum), errMsgSj.toString()).fail();
                continue;
            }
            billResult.put("success", Boolean.TRUE);
            billResult.put("id", Integer.valueOf(i));
            billResults.add(billResult);
        }
        return apiResult;
    }

    private void clearMemoryCache() {
        this.standardNameInDbSet.clear();
        this.featureBoIdSet.clear();
        this.stdNumberAndStdMainInfoLinkedMap.clear();
        this.rowNumAndStandardNumMap.clear();
        this.existsStandardNumAndDyForAddNewMap.clear();
        this.usedStandardNumberSet.clear();
        this.usedStandardNameSet.clear();
        this.insurTypeIdAndCfgInfoLinkedMap.clear();
        this.insurTypeIdAndCfgIdLinkedMap.clear();
        this.insurTypeAndAttrAndItemTable.clear();
        this.insurItemIdAndAttrInfoMap.clear();
        this.rowNumAndErrInfoMap.clear();
        this.pkIdAndRowNumMap.clear();
        this.baseFieldAndPropAndIdMap.clear();
        this.rowNumAndFieldValueMap.clear();
        this.updateKeysValAndStdDyInDbMap.clear();
        this.stdNumberInsurTypeAndStdDimTable.clear();
        this.stdDimItemImportAddDTOTable.clear();
        this.stdDimItemImportSaveDTOTable.clear();
        this.stdDimItemImportAuditDTOTable.clear();
    }

    private boolean checkBaseTopAndDownInValid(Map<Long, String> cfgInfoLinkedMap, Map<Long, StandardDimItemImportDTO> standardDimItemImportDTOLinkedMap, StringJoiner lineErr) {
        boolean isInvalid = false;
        for (List<Enum<Enum<?>>> payBaseTopAndBottom : PAY_BASE_TOP_AND_BOTTOMS) {
            BigDecimal bigDecBottom;
            BigDecimal bigDecTop;
            if (payBaseTopAndBottom == null || payBaseTopAndBottom.size() != 3 || !(payBaseTopAndBottom.get(0) instanceof InsurTypeAttrEnum) || !(payBaseTopAndBottom.get(1) instanceof InsurTypeAttrEnum) || !(payBaseTopAndBottom.get(2) instanceof SocInsuranceErrInfoEnum)) continue;
            InsurTypeAttrEnum payBaseTopEnum = (InsurTypeAttrEnum)payBaseTopAndBottom.get(0);
            InsurTypeAttrEnum payBaseBottomEnum = (InsurTypeAttrEnum)payBaseTopAndBottom.get(1);
            SocInsuranceErrInfoEnum baseTopSocInsuranceErrInfoEnum = (SocInsuranceErrInfoEnum)payBaseTopAndBottom.get(2);
            if (!cfgInfoLinkedMap.containsKey(payBaseTopEnum.getId()) || !cfgInfoLinkedMap.containsKey(payBaseBottomEnum.getId()) || baseTopSocInsuranceErrInfoEnum == null) continue;
            StandardDimItemImportDTO payBaseTop = standardDimItemImportDTOLinkedMap.get(payBaseTopEnum.getId());
            StandardDimItemImportDTO payBaseBottom = standardDimItemImportDTOLinkedMap.get(payBaseBottomEnum.getId());
            if (payBaseTop == null || payBaseBottom == null || payBaseTop.getItemValue() == null || payBaseBottom.getItemValue() == null || (bigDecTop = new BigDecimal(payBaseTop.getItemValue()).setScale(10, 1)).compareTo(bigDecBottom = new BigDecimal(payBaseBottom.getItemValue()).setScale(10, 1)) >= 0) continue;
            lineErr.add(baseTopSocInsuranceErrInfoEnum.getErrInfo());
            isInvalid = true;
        }
        return isInvalid;
    }

    private void filterNameInDb() {
        if (!this.standardNameInDbSet.isEmpty()) {
            QFilter filter = new QFilter("name", "in", this.standardNameInDbSet);
            List stdDys = SocInsuranceStandardHelper.queryInfoByEntityName((String)"sitbs_sinsurstd", (QFilter)filter);
            this.standardNameInDbSet.clear();
            stdDys.forEach(stdDy -> this.standardNameInDbSet.add(stdDy.getString("name")));
        }
    }

    static {
        ALL_BASE_FIELDS = Arrays.asList("createorg", "country", "insurarea", "insurtype", "registertype", "category");
        ALL_UPDATE_FIELDS = Arrays.asList("number", "name", "createorg", "insurarea");
        DIM_FIELDS = Arrays.asList("registertype", "category");
        CTRL_STRATEGY_SET = ImmutableSet.of((Object)"1", (Object)"2", (Object)"5", (Object)"6", (Object)"7");
        HashBiMap tmpBasedFieldKeyAndSocEnumMap = HashBiMap.create();
        tmpBasedFieldKeyAndSocEnumMap.put((Object)"createorg", (Object)SocInsuranceErrInfoEnum.COMMON_FIELD_CREATE_ORG);
        tmpBasedFieldKeyAndSocEnumMap.put((Object)"country", (Object)SocInsuranceErrInfoEnum.COMMON_FIELD_COUNTRY);
        tmpBasedFieldKeyAndSocEnumMap.put((Object)"insurarea", (Object)SocInsuranceErrInfoEnum.COMMON_FIELD_INSURANCE_AREA);
        tmpBasedFieldKeyAndSocEnumMap.put((Object)"insurtype", (Object)SocInsuranceErrInfoEnum.COMMON_FIELD_INSURANCE_TYPE);
        tmpBasedFieldKeyAndSocEnumMap.put((Object)"registertype", (Object)SocInsuranceErrInfoEnum.CENSUS_REGISTER_TYPE);
        tmpBasedFieldKeyAndSocEnumMap.put((Object)"category", (Object)SocInsuranceErrInfoEnum.HOUSEHOLD_TYPE);
        BASED_FIELD_KEY_AND_SOC_ENUM_MAP = ImmutableBiMap.copyOf((Map)tmpBasedFieldKeyAndSocEnumMap);
        HashSet<String> tmpRoundTypeEnumSet = new HashSet<String>(16);
        List itemList = SocInsuranceStandardService.getRoundTypeItemList();
        for (ValueMapItem item : itemList) {
            tmpRoundTypeEnumSet.add(item.getValue());
        }
        ROUND_TYPE_ENUM_SET = ImmutableSet.copyOf(tmpRoundTypeEnumSet);
        List<Enum> employees = Arrays.asList(InsurTypeAttrEnum.PAY_BASE_TOP_OF_EMPLOYEE, InsurTypeAttrEnum.PAY_BASE_BOTTOM_OF_EMPLOYEE, SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_PAY_BASE_TOP_OF_EMPLOYEE_MUST_GREATER_THAN_DOWN);
        List<Enum> companies = Arrays.asList(InsurTypeAttrEnum.PAY_BASE_TOP_OF_COMPANY, InsurTypeAttrEnum.PAY_BASE_BOTTOM_OF_COMPANY, SocInsuranceErrInfoEnum.SOC_INSURANCE_STD_IMPORT_PAY_BASE_TOP_OF_COMPANY_MUST_GREATER_THAN_DOWN);
        PAY_BASE_TOP_AND_BOTTOMS = Arrays.asList(employees, companies);
    }
}

