/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.sinsurstandardcfg;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sdk.kingscript.util.Tuple;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbp.common.util.SITGridUtils;
import kd.sit.sitbs.business.socinsurance.errinfo.SocInsuranceErrInfoEnum;
import kd.sit.sitbs.business.socinsurance.service.SInsuranceCommonService;
import kd.sit.sitbs.business.socinsurance.standardcfg.helper.SocInsuranceStandardCfgHelper;
import kd.sit.sitbs.business.socinsurance.standardcfg.service.SocInsuranceStandardCfgService;

public class SInsuranceStandardCfgEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
EntryGridBindDataListener {
    private static final String ADD_SOC_INSURE_ITEM = "addsinsuritem";
    private static final String DEL_SOC_INSURE_ITEM = "delsinsuritem";
    private static final String ADD_STD_DIM = "addstddim";
    private static final String DEL_STD_DIM_BTN = "delstddim";
    private static final String MOVE_ENTRY_UP = "moveentryup";
    private static final String MOVE_ENTRY_DOWN = "moveentrydown";
    private static final String PAY_IN_MULTIPLE_AREA_FLEX = "payinmultipleareatipsflex";
    private static final Set<String> NEED_LOCK_ENTRY_ENTITY_SET = new HashSet<String>(Arrays.asList("dentryentity", "rentryentity"));
    private static final Set<String> NEED_LOCK_ENTTITY_FIELD = new HashSet<String>(Arrays.asList("basetype", "datasrc"));

    public void registerListener(EventObject event) {
        super.registerListener(event);
        SInsuranceCommonService.createInstance().multiSetBeforeF7SelectListener((Object)this, new String[]{"country", "insurtype"});
        this.addClickListeners(new String[]{ADD_SOC_INSURE_ITEM, DEL_SOC_INSURE_ITEM, ADD_STD_DIM, MOVE_ENTRY_UP, MOVE_ENTRY_DOWN});
        for (String lockEntryEntity : NEED_LOCK_ENTRY_ENTITY_SET) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(lockEntryEntity);
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void afterCreateNewData(EventObject event) {
        super.afterCreateNewData(event);
        this.updateDimEntryEntity();
        this.setPayInMultipleFlexVisible(false);
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        if (!Long.valueOf(0L).equals(this.getModel().getDataEntity().getPkValue())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"insurtype"});
        }
        this.lockCellIfNeeded(null);
        this.switchDimEntryEntity(Boolean.FALSE);
        String firstKey = "firstKey";
        if (!Boolean.TRUE.toString().equals(this.getPageCache().get(firstKey))) {
            this.setPayInMultipleFlexVisible(false);
            this.getPageCache().put(firstKey, Boolean.TRUE.toString());
        }
    }

    public void setView(IFormView formView) {
        super.setView(formView);
        if (formView != null && BaseDataHisHelper.isHisPage((IFormView)formView)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number", "insurtype"});
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent ex) {
        this.updateDimEntryEntity();
        this.lockCellIfNeeded(null);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        Object[] changeSets = args.getChangeSet();
        if (HRArrayUtils.isEmpty((Object[])changeSets)) {
            return;
        }
        switch (args.getProperty().getName()) {
            case "insurtype": {
                if (this.checkInsurTypeForSameCountry((ChangeData)changeSets[0]) || this.checkDataUnChanged((ChangeData[])changeSets) || CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity("rentryentity"))) break;
                String insurTypeId = changeSets[0].getOldValue() == null ? "" : ((DynamicObject)changeSets[0].getOldValue()).getString("id");
                this.getView().showConfirm(SocInsuranceErrInfoEnum.INSUR_TYPE_CHANGED.getErrInfo(), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("insurance_type_changed"), null, insurTypeId);
                break;
            }
            case "paramtype": {
                this.updateMultiDimEntryViewList((ChangeData)changeSets[0]);
                break;
            }
            case "ispayinmultiplearea": {
                Object changeSet = changeSets[0];
                boolean visible = Boolean.TRUE.equals(changeSet.getOldValue()) && Boolean.FALSE.equals(changeSet.getNewValue());
                this.setPayInMultipleFlexVisible(visible);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name;
        switch (name = beforeF7SelectEvent.getProperty().getName()) {
            case "insurtype": {
                QFilter filter = SocInsuranceStandardCfgService.createInstance().getCommonQFilter(this.getModel().getDataEntity(), "sitbs_welfaretype");
                beforeF7SelectEvent.addCustomQFilter(filter);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (formOperate.getOperateKey()) {
            case "addsinsuritem": {
                if (this.checkFieldInValid(Collections.singletonList("insurtype"))) {
                    args.setCancel(true);
                    break;
                }
                this.openSocInsuranceItemBaseView();
                break;
            }
            case "changesave": 
            case "save": 
            case "submit": 
            case "audit": 
            case "auditconfirmchange": 
            case "confirmchange": {
                OperateOption option = formOperate.getOption();
                option.setVariableValue("is_detail_view", Boolean.TRUE.toString());
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (MOVE_ENTRY_UP.equals(operateKey) || MOVE_ENTRY_DOWN.equals(operateKey) || DEL_SOC_INSURE_ITEM.equals(operateKey)) {
            DynamicObjectCollection resultEntryEntity = this.getModel().getEntryEntity("rentryentity");
            for (int i = 0; i < resultEntryEntity.size(); ++i) {
                DynamicObject resultEntity = (DynamicObject)resultEntryEntity.get(0);
                if ("C".equals(resultEntity.getString("datasrc"))) {
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{"datasrc"});
                    continue;
                }
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"datasrc"});
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("insurance_type_changed".equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getModel().deleteEntryData("rentryentity");
                this.getView().updateView("rentryentity");
            } else {
                String insurTypeId = messageBoxClosedEvent.getCustomVaule();
                if (insurTypeId != null && insurTypeId.length() > 0) {
                    this.getModel().beginInit();
                    try {
                        this.getModel().setValue("insurtype", (Object)Long.parseLong(insurTypeId));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.getModel().endInit();
                    this.getView().updateView("insurtype");
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (closedCallBackEvent.getActionId()) {
            case "sitbs_insuranceitem": {
                this.updateEntryEntity(returnData);
                break;
            }
        }
    }

    private boolean checkFieldInValid(List<String> fields) {
        if (CollectionUtils.isEmpty(fields)) {
            return true;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        for (String field : fields) {
            Object dyObj = dataEntity.get(field);
            if (dyObj != null && (!(dyObj instanceof DynamicObject) || ((DynamicObject)dyObj).getLong("id") != 0L)) continue;
            this.showMustInputInfoForPointKey(field);
            return true;
        }
        return false;
    }

    private void showMustInputInfoForPointKey(String fieldKey) {
        String errMsg;
        if (HRStringUtils.isNotEmpty((String)fieldKey) && (errMsg = (String)SocInsuranceErrInfoEnum.getSocInsuranceErrInfoMap().get(fieldKey)) != null) {
            this.getView().showTipNotification(errMsg);
        }
    }

    private boolean checkDataUnChanged(ChangeData[] changeSets) {
        DynamicObject oldDyObj = (DynamicObject)changeSets[0].getOldValue();
        DynamicObject newDyObj = (DynamicObject)changeSets[0].getNewValue();
        return oldDyObj != null && newDyObj != null && oldDyObj.getLong("id") == newDyObj.getLong("id");
    }

    private void openSocInsuranceItemBaseView() {
        int currRowIndex = ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).getEntryState("rentryentity").getFocusRow();
        this.getModel().setEntryCurrentRowIndex("rentryentity", currRowIndex);
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"sitbs_insuranceitem", (boolean)true);
        showParameter.setFormId("sitbp_allowreturnnullf7");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "sitbs_insuranceitem"));
        QFilter filter = SocInsuranceStandardCfgService.createInstance().getCommonQFilter(this.getModel().getDataEntity(), "sitbs_insuranceitem");
        showParameter.setListFilterParameter(new ListFilterParameter(Arrays.asList(filter.toArray()), null));
        Object[] selectedInsuranceItemArr = this.getSelectedInsuranceItemArr();
        if (!HRArrayUtils.isEmpty((Object[])selectedInsuranceItemArr)) {
            showParameter.setSelectedRows(selectedInsuranceItemArr);
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private Object[] getSelectedInsuranceItemArr() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("rentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return new Object[0];
        }
        List insuranceItemIds = entryEntity.stream().map(dyObj -> dyObj.getLong("insuritem.id")).collect(Collectors.toList());
        QFilter filter = SocInsuranceStandardCfgService.createInstance().getCommonQFilter(this.getModel().getDataEntity(), "sitbs_insuranceitem");
        filter.and("id", "in", insuranceItemIds);
        return SocInsuranceStandardCfgHelper.getValidInsuranceItemIdArr((QFilter)filter);
    }

    private void updateEntryEntity(Object returnData) {
        ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)returnData;
        Set newInsuranceItemIds = listSelectedRowCollection.stream().map(obj -> (Long)obj.getPrimaryKeyValue()).collect(Collectors.toCollection(LinkedHashSet::new));
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("rentryentity");
        Iterator iterator = entryEntity.iterator();
        while (iterator.hasNext()) {
            DynamicObject entryDyObj = (DynamicObject)iterator.next();
            long insuranceItemId = entryDyObj.getLong("insuritem.id");
            if (!newInsuranceItemIds.contains(insuranceItemId)) {
                iterator.remove();
                continue;
            }
            newInsuranceItemIds.remove(insuranceItemId);
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int index = 0;
        for (DynamicObject lastInsuranceItemDyObj : entryEntity) {
            long insurItemId = lastInsuranceItemDyObj.getLong("insuritem.id");
            vs.set("insuritem", (Object)insurItemId, index);
            vs.set("isuseroundtype", (Object)lastInsuranceItemDyObj.getString("isuseroundtype"), index);
            vs.set("datasrc", (Object)lastInsuranceItemDyObj.getString("datasrc"), index);
            vs.set("calrule", (Object)lastInsuranceItemDyObj.getString("calrule"), index);
            ++index;
        }
        Map itemAndRefAttrMap = SocInsuranceStandardCfgHelper.queryInsuranceItemAttr((Set)newInsuranceItemIds);
        for (Long insurItemId : newInsuranceItemIds) {
            Tuple attrInfo = (Tuple)itemAndRefAttrMap.get(insurItemId);
            if (attrInfo == null) continue;
            vs.set("insuritem", (Object)insurItemId, index);
            vs.set("isuseroundtype", attrInfo.getKey(), index);
            vs.set("datasrc", attrInfo.getValue(), index);
            vs.set("calrule", null, index);
            ++index;
        }
        model.deleteEntryData("rentryentity");
        model.batchCreateNewEntryRow("rentryentity", vs);
        model.endInit();
        this.getView().updateView("rentryentity");
        this.lockCellIfNeeded("datasrc");
    }

    private void lockCellIfNeeded(String fieldName) {
        if (fieldName == null) {
            for (String locKField : NEED_LOCK_ENTTITY_FIELD) {
                this.lockCell(locKField);
            }
        } else if (NEED_LOCK_ENTTITY_FIELD.contains(fieldName)) {
            this.lockCell(fieldName);
        }
    }

    private void lockCell(String locKField) {
        String entryEntity = "basetype".equals(locKField) ? "dentryentity" : "rentryentity";
        int[] seqArr = this.needLockRows(entryEntity);
        if (seqArr == null || seqArr.length == 0) {
            return;
        }
        HashMap<String, int[]> cellMap = new HashMap<String, int[]>(16);
        String currLockField = "basetype".equals(locKField) ? "basetype" : "calrule";
        cellMap.put(currLockField, seqArr);
        SITGridUtils.lockCell((IClientViewProxy)((IClientViewProxy)this.getView().getService(IClientViewProxy.class)), (String)entryEntity, cellMap, (boolean)true);
    }

    private int[] needLockRows(String entryEntityName) {
        DynamicObjectCollection entryEntity;
        this.getModel().getEntryEntity(entryEntityName);
        if (!NEED_LOCK_ENTRY_ENTITY_SET.contains(entryEntityName) || (entryEntity = this.getModel().getEntryEntity(entryEntityName)) == null || entryEntity.isEmpty()) {
            return new int[0];
        }
        switch (entryEntityName) {
            case "dentryentity": {
                return entryEntity.stream().filter(dyObj -> !"B".equals(dyObj.getString("paramtype"))).mapToInt(dyObj -> dyObj.getInt("seq") - 1).toArray();
            }
            case "rentryentity": {
                return entryEntity.stream().filter(entry -> !"C".equals(entry.getString("datasrc"))).mapToInt(dyObj -> dyObj.getInt("seq") - 1).toArray();
            }
        }
        return new int[0];
    }

    private void updateDimEntryEntity() {
        if ("1000001".equals(this.getModel().getDataEntity().getString("country.id"))) {
            this.createDefaultDimEntryEntity();
        } else {
            this.switchDimEntryEntity(Boolean.TRUE);
            this.lockCellIfNeeded("basetype");
        }
    }

    private void createDefaultDimEntryEntity() {
        if (!CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity("dentryentity"))) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if ("1000001".equals(dataEntity.getString("country.id"))) {
            int i;
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.deleteEntryData("dentryentity");
            TableValueSetter vs = new TableValueSetter(new String[0]);
            String[][] defaultEntityValues = this.getDefaultDimEntityPro();
            for (i = 0; i < defaultEntityValues[0].length; ++i) {
                vs.addField(defaultEntityValues[0][i], new Object[0]);
            }
            for (i = 1; i < 3; ++i) {
                vs.addRow((Object[])defaultEntityValues[i]);
            }
            model.batchCreateNewEntryRow("dentryentity", vs);
            model.endInit();
        }
        this.switchDimEntryEntity(Boolean.FALSE);
    }

    private void switchDimEntryEntity(Boolean isNeedOpen) {
        IFormView iFormView = this.getView();
        iFormView.setVisible(isNeedOpen, new String[]{ADD_STD_DIM, DEL_STD_DIM_BTN});
        iFormView.setEnable(isNeedOpen, new String[]{"dentryentity"});
        iFormView.updateView("dentryentity");
    }

    private String[][] getDefaultDimEntityPro() {
        return new String[][]{{"paramtype", "basetype", "paramname", "dataprecision", "paramsrc"}, {"B", "0", SocInsuranceErrInfoEnum.CENSUS_REGISTER_TYPE.getErrInfo(), null, "0"}, {"B", "1", SocInsuranceErrInfoEnum.HOUSEHOLD_TYPE.getErrInfo(), null, "1"}};
    }

    private void updateMultiDimEntryViewList(ChangeData changeData) {
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("dentryentity").get(changeData.getRowIndex());
        if (!"B".equals(changeData.getNewValue())) {
            dynamicObject.set("basetype", null);
        }
        this.getView().updateView("dentryentity", changeData.getRowIndex());
        this.lockCellIfNeeded("basetype");
    }

    private boolean checkInsurTypeForSameCountry(ChangeData changeSet) {
        DynamicObject insurTypeDy = (DynamicObject)changeSet.getNewValue();
        if (insurTypeDy == null || Long.valueOf(0L).equals(insurTypeDy.getPkValue())) {
            return false;
        }
        IDataModel iDataModel = this.getModel();
        DynamicObject dataEntity = iDataModel.getDataEntity();
        String insurTypeCfgName = SocInsuranceStandardCfgHelper.queryInsurTypeCfgInfo((Long)insurTypeDy.getLong("id"), (Long)dataEntity.getLong("country.id"), (Long)dataEntity.getLong("boid"));
        if (!HRStringUtils.isEmpty((String)insurTypeCfgName)) {
            String errInfo = MessageFormat.format(SocInsuranceErrInfoEnum.INSUR_TYPE_EXISTS_FOR_SAME_COUNTRY_AND_STD_CFG.getErrInfo(), insurTypeDy.getString("name"), insurTypeCfgName);
            this.getView().showTipNotification(errInfo);
            iDataModel.beginInit();
            iDataModel.setValue("insurtype", null);
            iDataModel.endInit();
            return true;
        }
        return false;
    }

    private void setPayInMultipleFlexVisible(boolean visible) {
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{PAY_IN_MULTIPLE_AREA_FLEX});
    }
}

