/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.sumitem;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IBaseDataService;
import kd.sit.sitbp.common.enums.CalDataTypeEnum;
import kd.sit.sitbp.common.util.SITStringUtils;

public class SumItemEdit
extends AbstractBasePlugIn {
    private static final String ADVCONTOOLBARAP = "advcontoolbarap";
    private static final String FIELD_AREATYPE_ASSIGN = "2";
    private static final String FIELD_AREATYPE_GENERAL = "1";
    private static final String KEY_ITEM_ENTRY = "entryentity";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{ADVCONTOOLBARAP});
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "additem": {
                this.openInsuranceItemF7();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        FormOperate operate = (FormOperate)args.getSource();
        switch (opKey = operate.getOperateKey()) {
            case "save": 
            case "submit": 
            case "auditconfirmchange": 
            case "changesave": {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryEntity");
                if (entryEntity != null && entryEntity.size() != 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u201c\u5408\u8ba1\u6210\u5458\u201d\u3002", (String)"SumItemEdit_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String callStr = event.getActionId();
        Object returnData = event.getReturnData();
        switch (callStr) {
            case "sitbs_insuranceitem": {
                ListSelectedRowCollection dataColl = (ListSelectedRowCollection)returnData;
                this.addItemsToEntity(dataColl);
                break;
            }
        }
    }

    private void addItemsToEntity(ListSelectedRowCollection dataColl) {
        if (dataColl == null || dataColl.size() == 0) {
            return;
        }
        IDataModel dataModel = this.getModel();
        ArrayList<Long> billIds = new ArrayList<Long>(dataColl.size());
        for (ListSelectedRow listSelectedRow : dataColl) {
            billIds.add(Long.valueOf(listSelectedRow.getPrimaryKeyValue().toString()));
        }
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("insuranceitem", new Object[0]);
        for (Long itemId : billIds) {
            vs.addRow(new Object[]{itemId});
        }
        model.batchCreateNewEntryRow(KEY_ITEM_ENTRY, vs);
        model.endInit();
        this.getView().updateView(KEY_ITEM_ENTRY);
    }

    private void openInsuranceItemF7() {
        if (!this.checkAreaAndCountry()) {
            return;
        }
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"sitbs_insuranceitem", (boolean)true);
        showParameter.setHasRight(true);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "sitbs_insuranceitem"));
        showParameter.setListFilterParameter(new ListFilterParameter(this.getInsuranceItemFilter(), null));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private List<QFilter> getInsuranceItemFilter() {
        List<Long> billIds;
        DynamicObject mainOrgObj;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(5);
        MainEntityType billEntityType = this.getModel().getDataEntityType();
        String mainOrgProp = billEntityType.getMainOrg();
        if (StringUtils.isNotBlank((CharSequence)mainOrgProp) && (mainOrgObj = (DynamicObject)this.getModel().getValue(mainOrgProp)) != null && mainOrgObj.getPkValue() != null) {
            long orgID = (Long)mainOrgObj.getPkValue();
            IBaseDataService baseDataService = (IBaseDataService)this.getModel().getService(IBaseDataService.class);
            QFilter qFilter = baseDataService.getBaseDataFilter("sitbs_insuranceitem", Long.valueOf(orgID));
            qFilters.add(qFilter);
        }
        if ((billIds = this.getEntryItemIds()).size() > 0) {
            qFilters.add(new QFilter("id", "not in", billIds));
        }
        qFilters.add(new QFilter("enable", "=", (Object)FIELD_AREATYPE_GENERAL));
        qFilters.add(new QFilter("status", "=", (Object)"C"));
        qFilters.add(new QFilter("datatype.id", "=", (Object)CalDataTypeEnum.AMOUNT.getId()));
        long countryId = this.getModel().getDataEntity().getLong("country.id");
        QFilter areaFilter = this.addAreaFilter(countryId, FIELD_AREATYPE_ASSIGN);
        if (null != areaFilter) {
            qFilters.add(areaFilter);
        }
        return qFilters;
    }

    private QFilter addAreaFilter(long countryId, String areaType) {
        if (SITStringUtils.isEmpty((String)areaType)) {
            return null;
        }
        if (areaType.equals(FIELD_AREATYPE_GENERAL)) {
            return new QFilter("areatype", "=", (Object)FIELD_AREATYPE_GENERAL);
        }
        HashSet<Long> set = new HashSet<Long>(2);
        set.add(countryId);
        set.add(0L);
        return new QFilter("country.id", "in", set);
    }

    private List<Long> getEntryItemIds() {
        DynamicObjectCollection coll = this.getModel().getEntryEntity(KEY_ITEM_ENTRY);
        ArrayList<Long> billIds = new ArrayList<Long>();
        for (DynamicObject dynamicObject : coll) {
            long itemId;
            DynamicObject itemObj = (DynamicObject)dynamicObject.get("insuranceitem");
            if (itemObj == null || billIds.contains(itemId = itemObj.getLong("id"))) continue;
            billIds.add(itemId);
        }
        return billIds;
    }

    private boolean checkAreaAndCountry() {
        if (!this.checkArea(this.getModel().getDataEntity())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u56fd\u5bb6/\u5730\u533a\u540e\uff0c\u518d\u9009\u62e9\u201c\u85aa\u916c\u9879\u76ee\u6784\u6210\u53ca\u8ba1\u7b97\u516c\u5f0f\u201d\u548c\u201c\u603b\u85aa\u8d44\u4e0e\u51c0\u85aa\u8d44\u201d\u3002", (String)"CalRuleEdit_26", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkArea(DynamicObject dataEntity) {
        String arealtype = dataEntity.getString("areatype");
        long countryId = dataEntity.getLong("country.id");
        return !SITStringUtils.isEmpty((String)arealtype) && (!SITStringUtils.equals((String)FIELD_AREATYPE_ASSIGN, (String)arealtype) || 0L != countryId);
    }
}

