/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.taxitemlibrary;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;

public class TaxItemBatchImportPlugin
extends BatchImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(TaxItemBatchImportPlugin.class);
    private static final int BATCH_IMPORT_SIZE = 500;
    private static final String COUNTRYTYPE_GENERAL = "0";
    private static final String COUNTRYTYPE_ASSIGN = "1";
    private Set<String> countryNums = null;
    private final String countryMsg = ResManager.loadKDString((String)"\u4e2d\u56fd\u4e2a\u7a0e\u4e0b\u53ea\u80fd\u5bfc\u5165\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\u4e3a\u6307\u5b9a\uff0c\u4e14\u56fd\u5bb6/\u5730\u533a\u4e3a\u4e2d\u56fd\u7684\u6570\u636e\u3002", (String)"TaxItemBatchImportPlugin_7", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
    private final String checkCountryRightMsg = ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u56fd\u5bb6/\u5730\u533a\u4e1a\u52a1\u6570\u636e\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxItemBatchImportPlugin_18", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);

    private String getAppId() {
        String appNumber = this.ctx.getCheckRightAppId();
        if (HRStringUtils.isEmpty((String)appNumber)) {
            return null;
        }
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
        return appInfo != null ? appInfo.getId() : null;
    }

    protected boolean isForceBatch() {
        return true;
    }

    protected int getBatchImportSize() {
        return 500;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        try {
            Iterator<ImportBillData> it = billdatas.iterator();
            while (it.hasNext()) {
                ImportBillData bill = it.next();
                if (!bill.isEmpty() && !this.validateAppAndCountry(logger, it, bill) && !this.validateCountryRight(logger, it, bill)) continue;
            }
        }
        catch (Exception throwable) {
            LOGGER.error((Throwable)throwable);
            if (SystemParamServiceHelper.isShowStackTrace()) {
                logger.log(Integer.valueOf(billdatas.get(0).getStartIndex()), (Throwable)throwable);
            } else {
                logger.log(Integer.valueOf(billdatas.get(0).getStartIndex()), ResManager.loadKDString((String)"\u6570\u636e\u5305\u6821\u9a8c\u51fa\u73b0\u5f02\u5e38,\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"TaxItemBatchImportPlugin_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            }
            billdatas.clear();
        }
    }

    private boolean validateCountryRight(ImportLogger logger, Iterator<ImportBillData> it, ImportBillData bill) {
        JSONObject country;
        if (COUNTRYTYPE_ASSIGN.equals(this.getCountryType(bill)) && Objects.nonNull(country = this.getCountry(bill))) {
            String countryNum = country.getString("number");
            if (Objects.isNull(this.countryNums)) {
                Set countryIds = SITPermissionServiceHelper.getCountrySetByPermItem((String)this.getAppId(), (String)"sitbs_taxitem", (String)"47150e89000000ac");
                if (CollectionUtils.isEmpty((Collection)countryIds)) {
                    this.countryNums = Sets.newHashSetWithExpectedSize((int)0);
                } else {
                    HRBaseServiceHelper countryService = new HRBaseServiceHelper("bd_country");
                    DynamicObject[] countryDys = countryService.query("id,number", new QFilter[]{new QFilter("id", "in", (Object)countryIds)});
                    this.countryNums = Arrays.stream(countryDys).map(dy -> dy.getString("number")).collect(Collectors.toSet());
                }
            }
            if (!CollectionUtils.isEmpty(this.countryNums) && !this.countryNums.contains(countryNum)) {
                it.remove();
                this.log(bill.getStartIndex(), this.checkCountryRightMsg, logger);
                return true;
            }
        }
        return false;
    }

    private boolean validateAppAndCountry(ImportLogger logger, Iterator<ImportBillData> it, ImportBillData bill) {
        if (COUNTRYTYPE_GENERAL.equals(this.getCountryType(bill)) && !HRStringUtils.equals((String)"sitbs", (String)this.ctx.getCheckRightAppId())) {
            it.remove();
            this.log(bill.getStartIndex(), this.countryMsg, logger);
            return true;
        }
        return false;
    }

    private JSONObject getCountry(ImportBillData bill) {
        return bill.getData().getJSONObject("country");
    }

    private String getCountryType(ImportBillData bill) {
        return bill.getData().getString("countrytype");
    }

    private void log(int rowIndex, String errorMsg, ImportLogger logger) {
        Map logCache = logger.getLogCache();
        if (logCache.get(rowIndex) != null) {
            ((List)logCache.get(rowIndex)).add(new ImportLogger.ImportLog(errorMsg));
            logger.setLogCache(logCache);
        } else {
            logger.log(Integer.valueOf(rowIndex), errorMsg).fail();
        }
    }
}

