/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.taxitemlibrary;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.tree.TreeFilterParameter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hbp.formplugin.web.util.perm.HRPermUtil;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.enums.DataPrecisionEnum;
import kd.sit.sitbp.common.enums.DataRoundEnum;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbs.business.multiview.GetAppInfoService;
import kd.sit.sitbs.business.taxitemlibrary.TaxItemHelper;
import kd.sit.sitbs.business.taxitemlibrary.TaxLibraryHelper;
import kd.sit.sitbs.common.enums.TaxItemTypeEnums;
import kd.sit.sitbs.common.taxitemlibrary.TaxItemLibraryConstants;

public class TaxItemEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(TaxItemEdit.class);
    private static final String FIELD_DATATYPE = "datatype";
    private static final String FIELD_DATALENGTH = "datalength";
    private static final String FIELD_DATAPRECISION = "dataprecision";
    private static final String FIELD_DATAROUND = "dataround";
    private static final String FIELD_COUNTRY = "country";
    private static final String FIELD_COUNTRYTYPE = "countrytype";
    private static final String FIELD_COUNTRYTYPE_GENERAL = "0";
    private static final String FIELD_COUNTRYTYPE_ASSIGN = "1";
    private static final String FIELD_TAXITEMTYPE = "taxitemtype";
    private static final String FIELD_TAXCATEGORIES = "taxcategories";

    public void registerListener(EventObject ex) {
        super.registerListener(ex);
        BasedataEdit taxItemTypeBE = (BasedataEdit)this.getControl(FIELD_TAXITEMTYPE);
        BasedataEdit countryBE = (BasedataEdit)this.getControl(FIELD_COUNTRY);
        BasedataEdit taxcategoriesBE = (BasedataEdit)this.getControl(FIELD_TAXCATEGORIES);
        BasedataEdit datatypeBE = (BasedataEdit)this.getControl(FIELD_DATATYPE);
        taxItemTypeBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        countryBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        taxcategoriesBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        datatypeBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject ex) {
        String useorg;
        String createOrg;
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            createOrg = pageCache.get("createOrg");
            useorg = pageCache.get("useOrg");
        } else {
            useorg = createOrg = Long.toString(RequestContext.getOrCreate().getOrgId());
        }
        String entityName = this.getModel().getDataEntity().getDataEntityType().toString();
        if (useorg != null) {
            this.getModel().setValue("useOrg", (Object)useorg);
        }
        if (createOrg != null && createOrg.length() > 0) {
            long createOrgId = Long.parseLong(createOrg);
            this.getModel().setValue("createOrg", (Object)createOrgId);
            List bctrlStragy = BaseDataServiceHelper.getBdCtrlOrgs((String)entityName);
            if (!CollectionUtils.isEmpty((Collection)bctrlStragy)) {
                long org = OrgServiceHelper.getCuByOrgId((long)createOrgId);
                if (org != 0L) {
                    this.getModel().setValue("org", (Object)org);
                }
            } else {
                this.getModel().setValue("org", (Object)createOrgId);
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"org"});
            String ctrlStrgy = BaseDataServiceHelper.getBdCtrlStrgy((String)entityName, (String)String.valueOf(createOrgId));
            if (ctrlStrgy != null && ctrlStrgy.length() > 0) {
                this.getModel().setValue("ctrlstrategy", (Object)ctrlStrgy);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        BasedataEdit basedataEdit = (BasedataEdit)evt.getSource();
        switch (key = basedataEdit.getKey()) {
            case "taxitemtype": {
                this.showTaxItemTypeF7(evt);
                break;
            }
            case "country": {
                this.showCountryF7(evt);
                break;
            }
            case "taxcategories": {
                this.showTaxCategoryF7(evt);
                break;
            }
            case "datatype": {
                this.showDataTypeF7(evt);
                break;
            }
        }
    }

    private void showDataTypeF7(BeforeF7SelectEvent evt) {
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        QFilter qFilter = new QFilter("id", "!=", (Object)SitDataTypeEnum.INTEGER.getId());
        qFilter.and("id", "!=", (Object)SitDataTypeEnum.BOOLEAN.getId());
        listShowParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void showTaxCategoryF7(BeforeF7SelectEvent evt) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String countryType = model.getDataEntity().getString(FIELD_COUNTRYTYPE);
        DynamicObject country = model.getDataEntity().getDynamicObject(FIELD_COUNTRY);
        if (null == country && FIELD_COUNTRYTYPE_ASSIGN.equals(countryType)) {
            evt.setCancel(true);
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6307\u5b9a\u56fd\u5bb6/\u5730\u533a\u3002", (String)"TaxItemEdit_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = new QFilter("enable", "=", (Object)FIELD_COUNTRYTYPE_ASSIGN);
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        if (FIELD_COUNTRYTYPE_GENERAL.equals(countryType)) {
            qFilter.and(new QFilter(FIELD_COUNTRYTYPE, "=", (Object)FIELD_COUNTRYTYPE_GENERAL));
        }
        if (null != country && FIELD_COUNTRYTYPE_ASSIGN.equals(countryType)) {
            Long countryId = country.getLong("id");
            qFilter.and(new QFilter(FIELD_COUNTRY, "=", (Object)countryId));
        }
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        listShowParameter.getListFilterParameter().setFilter(qFilter);
        TreeFilterParameter treeFilterParameter = listShowParameter.getTreeFilterParameter();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(qFilter);
        treeFilterParameter.setQFilters(qFilters);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            if (this.getModel().getDataChanged() && this.validateTaxTaskSnapShot(args)) {
                return;
            }
            this.validateTaxCategoryAndIncomeitem(args);
            this.validateTaxCategoryAndDeductionitem(args);
        }
    }

    private boolean validateTaxTaskSnapShot(BeforeDoOperationEventArgs args) {
        long id;
        long countryId = this.getModel().getDataEntity().getLong("country.id");
        if (countryId == 0L) {
            return false;
        }
        DynamicObject appInfo = GetAppInfoService.getInstance().queryAppInfoByCountryId(Long.valueOf(countryId));
        if (appInfo == null) {
            return false;
        }
        String appId = appInfo.getString("app.number");
        Set taxItemIdsInSnapShot = TaxItemHelper.getAllTaxItemsReferredInTaxTaskSnapShot((String)appId);
        if (taxItemIdsInSnapShot.contains(id = this.getModel().getDataEntity().getLong("id"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6b64\u4e2a\u7a0e\u9879\u76ee\u5df2\u5728\u4ee5\u5f80\u7684\u4e2a\u7a0e\u4efb\u52a1\u4e2d\u4f7f\u7528\uff0c\u65e0\u6cd5\u66f4\u6539\u3002", (String)"TaxItemEdit_6", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return true;
        }
        return false;
    }

    private void validateTaxCategoryAndDeductionitem(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection taxCategories;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject taxItemType = dataEntity.getDynamicObject(FIELD_TAXITEMTYPE);
        long taxItemTypeId = taxItemType.getLong("id");
        if (TaxItemTypeEnums.SPECIAL_ADDITIONAL_DEDUCTION.getId() == taxItemTypeId && !TaxLibraryHelper.validateTaxCategory((DynamicObjectCollection)(taxCategories = dataEntity.getDynamicObjectCollection(FIELD_TAXCATEGORIES)))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e13\u9879\u9644\u52a0\u6263\u9664\u9879\u76ee\u7684\u4e2a\u7a0e\u79cd\u7c7b\u53ea\u80fd\u662f\u201c\u6b63\u5e38\u5de5\u8d44\u85aa\u91d1\u6240\u5f97\u201d\u3002", (String)"TaxItemEdit_7", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            this.getView().showFieldTip(new FieldTip(FieldTip.FieldTipsLevel.Error, FieldTip.FieldTipsTypes.scope, FIELD_TAXCATEGORIES, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u6b63\u5e38\u5de5\u8d44\u85aa\u91d1\u6240\u5f97\u201d\u3002", (String)"TaxItemEdit_8", (String)"sit-sitbs-formplugin", (Object[])new Object[0])));
            args.setCancel(true);
        }
    }

    private void validateTaxCategoryAndIncomeitem(BeforeDoOperationEventArgs args) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String incomeItem = dataEntity.getString("incomeitem");
        if (YesOrNoEnum.isYes((String)incomeItem)) {
            DynamicObjectCollection taxCategories = dataEntity.getDynamicObjectCollection(FIELD_TAXCATEGORIES);
            if (taxCategories.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6bcf\u4e2a\u6240\u5f97\u9879\u76ee\u53ea\u80fd\u5bf9\u5e94\u4e00\u4e2a\u4e2a\u7a0e\u79cd\u7c7b\u3002", (String)"TaxItemEdit_3", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
                this.getView().showFieldTip(new FieldTip(FieldTip.FieldTipsLevel.Error, FieldTip.FieldTipsTypes.scope, FIELD_TAXCATEGORIES, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u4e2a\u7a0e\u79cd\u7c7b\u3002", (String)"TaxItemEdit_5", (String)"sit-sitbs-formplugin", (Object[])new Object[0])));
                args.setCancel(true);
                return;
            }
            if (taxCategories.size() == 1) {
                Long taxCategoryId = ((DynamicObject)taxCategories.get(0)).getLong("fbasedataid_id");
                HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxitem");
                QFilter qFilter = new QFilter("taxcategories.fbasedataid_id", "=", (Object)taxCategoryId);
                qFilter.and(new QFilter("incomeitem", "=", (Object)YesOrNoEnum.YES.getCode())).and(new QFilter("id", "!=", (Object)dataEntity.getLong("id")));
                DynamicObject[] taxItemDys = helper.query("id,number", new QFilter[]{qFilter});
                if (taxItemDys.length > 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6bcf\u4e2a\u4e2a\u7a0e\u79cd\u7c7b\u53ea\u80fd\u6709\u4e00\u4e2a\u6240\u5f97\u9879\u76ee\u3002", (String)"TaxItemEdit_4", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
        }
    }

    private void validateFields(BeforeDoOperationEventArgs args) {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity();
        Date bred = dataEntity.getDate("bred");
        Date brled = dataEntity.getDate("brled");
        if (null != bred && null != brled && bred.compareTo(brled) >= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u5931\u6548\u65e5\u671f\u3002", (String)"TaxItemEdit_1", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if (null == brled) {
            try {
                brled = HRDateTimeUtils.parseDate((String)"2999-12-31");
            }
            catch (ParseException e) {
                LOGGER.error("\u65f6\u95f4\u8f6c\u6362\u6210\u65e5\u671f\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
            this.getModel().setValue("brled", (Object)brled);
        }
    }

    private void showCountryF7(BeforeF7SelectEvent evt) {
        Map allCountryData = TaxItemHelper.getAllCountryData(null);
        QFilter countryFilter = new QFilter("id", "in", allCountryData.keySet());
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        listShowParameter.getListFilterParameter().setFilter(countryFilter);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String appId = HRPermUtil.getAppIdFromShowParam((FormShowParameter)formShowParameter);
        Set countryIds = SITPermissionServiceHelper.getCountrySetByPermItem((String)appId, (String)"sitbs_taxitem", (String)"47150e89000000ac");
        if (!CollectionUtils.isEmpty((Collection)countryIds)) {
            listShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)countryIds));
            LOGGER.info("taxitem countryIds after F7 is {}", (Object)countryIds.toString());
        }
    }

    private void showTaxItemTypeF7(BeforeF7SelectEvent evt) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String countryType = model.getDataEntity().getString(FIELD_COUNTRYTYPE);
        DynamicObject country = model.getDataEntity().getDynamicObject(FIELD_COUNTRY);
        if (null == country && FIELD_COUNTRYTYPE_ASSIGN.equals(countryType)) {
            evt.setCancel(true);
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6307\u5b9a\u56fd\u5bb6/\u5730\u533a\u3002", (String)"TaxItemEdit_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = new QFilter("enable", "=", (Object)FIELD_COUNTRYTYPE_ASSIGN);
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        if (FIELD_COUNTRYTYPE_GENERAL.equals(countryType)) {
            qFilter.and(new QFilter(FIELD_COUNTRYTYPE, "=", (Object)FIELD_COUNTRYTYPE_GENERAL));
        }
        if (null != country && FIELD_COUNTRYTYPE_ASSIGN.equals(countryType)) {
            Long countryId = country.getLong("id");
            qFilter.and(new QFilter(FIELD_COUNTRY, "=", (Object)countryId));
        }
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        listShowParameter.getListFilterParameter().setFilter(qFilter);
    }

    public void afterBindData(EventObject ex) {
        boolean isSysPreSet;
        OperationStatus viewStatus;
        DynamicObject dataObj = this.getModel().getDataEntity().getDynamicObject(FIELD_DATATYPE);
        if (null != dataObj) {
            long dataTypeId = dataObj.getLong("id");
            this.setDataTypeCtlState(dataTypeId, false);
        }
        if (OperationStatus.ADDNEW.equals((Object)(viewStatus = this.getView().getFormShowParameter().getStatus())) || OperationStatus.EDIT.equals((Object)viewStatus)) {
            this.setCountryVisible();
        }
        if (isSysPreSet = this.getModel().getDataEntity().getBoolean("issyspreset")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify"});
        }
    }

    private void setCountryVisible() {
        String countryType = this.getModel().getDataEntity().getString(FIELD_COUNTRYTYPE);
        String country = this.getModel().getDataEntity().getString(FIELD_COUNTRY);
        if (FIELD_COUNTRYTYPE_GENERAL.equals(countryType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_COUNTRY});
        }
        if (FIELD_COUNTRYTYPE_ASSIGN.equals(countryType) && HRStringUtils.isNotEmpty((String)country)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FIELD_COUNTRY});
            BasedataEdit control = (BasedataEdit)this.getView().getControl(FIELD_COUNTRY);
            control.setMustInput(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs ex) {
        String propertyName = ex.getProperty().getName();
        ChangeData[] changeData = ex.getChangeSet();
        this.setTaxCategoriesAndOtherFields();
        switch (propertyName) {
            case "datatype": {
                this.setDataTypeAndOtherFields(changeData);
                break;
            }
            case "countrytype": {
                this.setCountryTypeAndOtherFields(changeData);
                break;
            }
            case "country": {
                this.setCountryAndOtherFields(changeData);
                break;
            }
            case "taxcategories": {
                this.setTaxCategoriesAndOtherFields();
                break;
            }
        }
    }

    private void setTaxCategoriesAndOtherFields() {
        IFormView view = this.getView();
        FieldTip tip = new FieldTip();
        tip.setFieldKey(FIELD_TAXCATEGORIES);
        tip.setSuccess(true);
        view.showFieldTip(tip);
    }

    private void setCountryAndOtherFields(ChangeData[] changeData) {
        IFormView view = this.getView();
        IDataModel dataModel = this.getModel();
        dataModel.setValue(FIELD_TAXITEMTYPE, null);
        dataModel.setValue(FIELD_TAXCATEGORIES, null);
        DynamicObject dataObj = (DynamicObject)changeData[0].getNewValue();
        if (null != dataObj) {
            String countryId = dataObj.getString("id");
            String currencyId = TaxLibraryHelper.queryCurrencyByCountryId((String)countryId);
            dataModel.setValue("currency", (Object)currencyId);
            long dataTypeId = dataModel.getDataEntity().getLong("datatype.id");
            TaxLibraryHelper.ctrlFieldVisible((IFormView)view, (Long)dataTypeId, (String)currencyId);
            if ("1000001".equals(countryId)) {
                view.setVisible(Boolean.TRUE, new String[]{"caltaxtype"});
                dataModel.setValue("caltaxtype", null);
                BasedataEdit control = (BasedataEdit)this.getView().getControl("caltaxtype");
                control.setMustInput(true);
                view.setVisible(Boolean.TRUE, new String[]{"splitalgo"});
                dataModel.setValue("splitalgo", (Object)TaxItemLibraryConstants.NONESPLIT_ID);
                BasedataEdit splitAlgoCtl = (BasedataEdit)this.getView().getControl("splitalgo");
                splitAlgoCtl.setMustInput(true);
            } else {
                view.setVisible(Boolean.FALSE, new String[]{"caltaxtype"});
                view.setVisible(Boolean.FALSE, new String[]{"incomeitem"});
                view.setVisible(Boolean.FALSE, new String[]{"splitalgo"});
                dataModel.setValue("caltaxtype", null);
                dataModel.setValue("incomeitem", null);
                dataModel.setValue("splitalgo", null);
            }
        }
    }

    private void setCountryTypeAndOtherFields(ChangeData[] changeData) {
        IFormView view = this.getView();
        IDataModel dataModel = this.getModel();
        TaxLibraryHelper.setCountryVisible((IFormView)this.getView());
        dataModel.setValue(FIELD_TAXITEMTYPE, null);
        dataModel.setValue(FIELD_TAXCATEGORIES, null);
        String newValue = (String)changeData[0].getNewValue();
        if (FIELD_COUNTRYTYPE_GENERAL.equals(newValue)) {
            view.setVisible(Boolean.FALSE, new String[]{"currency"});
            view.setVisible(Boolean.FALSE, new String[]{"caltaxtype"});
            view.setVisible(Boolean.FALSE, new String[]{"incomeitem"});
            view.setVisible(Boolean.FALSE, new String[]{"splitalgo"});
            dataModel.setValue("currency", null);
            dataModel.setValue("caltaxtype", null);
            dataModel.setValue("incomeitem", null);
            dataModel.setValue("splitalgo", null);
        }
    }

    private void setDataTypeAndOtherFields(ChangeData[] changeData) {
        DynamicObject dataObj = (DynamicObject)changeData[0].getNewValue();
        long dataTypeId = 0L;
        if (!HRObjectUtils.isEmpty((Object)dataObj)) {
            dataTypeId = dataObj.getLong("id");
        }
        this.setDataTypeCtlState(dataTypeId, true);
        TaxLibraryHelper.setCurrency((IFormView)this.getView(), (Long)dataTypeId);
    }

    private void setDataTypeCtlState(long dataTypeId, boolean setDefaultData) {
        if (SitDataTypeEnum.NUMBER.getId() == dataTypeId) {
            this.setDataTypeCtlNum(setDefaultData);
        } else if (SitDataTypeEnum.AMOUNT.getId() == dataTypeId) {
            this.setDataTypeCtlAmount(setDefaultData);
        } else if (SitDataTypeEnum.TEXT.getId() == dataTypeId) {
            this.setDataTypeCtlText(setDefaultData);
        } else if (SitDataTypeEnum.INTEGER.getId() == dataTypeId) {
            this.setDataTypeCtlInt(setDefaultData);
        } else if (SitDataTypeEnum.DATE.getId() == dataTypeId) {
            this.setDataTypeCtlOther(setDefaultData);
        } else if (SitDataTypeEnum.BOOLEAN.getId() == dataTypeId) {
            this.setDataTypeCtlOther(setDefaultData);
        } else {
            this.setDataTypeCtlNull(setDefaultData);
        }
    }

    private void setDataTypeCtlNull(boolean setDefaultData) {
        this.setDataTypeCtlDefaultState(true, true, true);
        if (setDefaultData) {
            this.getView().getModel().setValue(FIELD_DATALENGTH, null);
            this.getView().getModel().setValue(FIELD_DATAPRECISION, null);
            this.getView().getModel().setValue(FIELD_DATAROUND, null);
        }
    }

    private void setDataTypeCtlOther(boolean setDefaultData) {
        this.setDataTypeCtlDefaultState(false, false, false);
        if (setDefaultData) {
            this.getView().getModel().setValue(FIELD_DATALENGTH, null);
            this.getView().getModel().setValue(FIELD_DATAPRECISION, null);
            this.getView().getModel().setValue(FIELD_DATAROUND, null);
        }
    }

    private void setDataTypeCtlText(boolean setDefaultData) {
        this.setDataTypeCtlDefaultState(true, false, false);
        this.getView().setEnable(Boolean.TRUE, new String[]{FIELD_DATALENGTH});
        if (setDefaultData) {
            this.getView().getModel().setValue(FIELD_DATALENGTH, (Object)200);
            this.getView().getModel().setValue(FIELD_DATAPRECISION, null);
            this.getView().getModel().setValue(FIELD_DATAROUND, null);
        }
    }

    private void setDataTypeCtlInt(boolean setDefaultData) {
        this.setDataTypeCtlDefaultState(false, false, false);
        this.getView().setEnable(Boolean.FALSE, new String[]{FIELD_DATALENGTH});
        if (setDefaultData) {
            this.getView().getModel().setValue(FIELD_DATALENGTH, (Object)13);
            this.getView().getModel().setValue(FIELD_DATAPRECISION, null);
            this.getView().getModel().setValue(FIELD_DATAROUND, null);
        }
    }

    private void setDataTypeCtlAmount(boolean setDefaultData) {
        this.setDataTypeCtlDefaultState(false, false, true);
        if (setDefaultData) {
            this.getView().getModel().setValue(FIELD_DATALENGTH, null);
            this.getView().getModel().setValue(FIELD_DATAPRECISION, null);
            if (this.getView().getModel().getValue(FIELD_DATAROUND) == null) {
                this.getView().getModel().setValue(FIELD_DATAROUND, (Object)DataRoundEnum.ROUNDING.getId());
            }
        }
    }

    private void setDataTypeCtlNum(boolean setDefaultData) {
        this.setDataTypeCtlDefaultState(false, true, true);
        this.getView().setEnable(Boolean.FALSE, new String[]{FIELD_DATALENGTH});
        if (setDefaultData) {
            this.getView().getModel().setValue(FIELD_DATALENGTH, null);
            if (this.getView().getModel().getValue(FIELD_DATAPRECISION) == null) {
                this.getView().getModel().setValue(FIELD_DATAPRECISION, (Object)DataPrecisionEnum.SAVE_TWO_PRECISION.getId());
            }
            if (this.getView().getModel().getValue(FIELD_DATAROUND) == null) {
                this.getView().getModel().setValue(FIELD_DATAROUND, (Object)DataRoundEnum.ROUNDING.getId());
            }
        }
    }

    private void setDataTypeCtlDefaultState(boolean datalengthCtlState, boolean dataprecisionCtlState, boolean dataroundCtlState) {
        DecimalEdit datalengthCtl = (DecimalEdit)this.getView().getControl(FIELD_DATALENGTH);
        BasedataEdit dataprecisionCtl = (BasedataEdit)this.getView().getControl(FIELD_DATAPRECISION);
        BasedataEdit dataroundCtl = (BasedataEdit)this.getView().getControl(FIELD_DATAROUND);
        datalengthCtl.setMustInput(datalengthCtlState);
        datalengthCtl.setVisible("", datalengthCtlState);
        dataprecisionCtl.setMustInput(dataprecisionCtlState);
        dataprecisionCtl.setVisible("", dataprecisionCtlState);
        dataroundCtl.setMustInput(dataroundCtlState);
        dataroundCtl.setVisible("", dataroundCtlState);
    }
}

