/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.taxitemlibrary;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbs.common.utils.TreeUtils;

public class TaxItemTreeListF7Plugin
extends StandardTreeListPlugin
implements SearchEnterListener,
TreeNodeClickListener {
    private static final int CHILDREN_LEVEL = 10;

    public void initializeTree(EventObject ex) {
        TreeNode root = this.initRootNode();
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.addNode(root);
        this.loadChildNode();
        treeView.focusNode(root);
    }

    public void afterBindData(EventObject ex) {
        super.afterBindData(ex);
        SplitContainer splitc = (SplitContainer)this.getControl("splitcontainerap");
        splitc.hidePanel(SplitDirection.left, true);
    }

    private TreeNode initRootNode() {
        TreeNode root = new TreeNode();
        root.setId("100000");
        root.setText(ResManager.loadKDString((String)"\u4e2a\u7a0e\u79cd\u7c7b", (String)"TaxItemTreeListF7Plugin_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
        root.setData((Object)"");
        root.setParentid("");
        root.setIsOpened(true);
        return root;
    }

    private void loadChildNode() {
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        ITreeModel treeModel = this.getTreeModel();
        TreeMap<String, String> allTaxCategoryData = this.getAllTaxCategoryData();
        for (Map.Entry<String, String> entry : allTaxCategoryData.entrySet()) {
            TreeNode node = new TreeNode("100000", entry.getKey(), entry.getValue());
            String parentId = "100000";
            treeModel.addNode((Object)parentId, node);
            treeView.addNode(node);
        }
    }

    private TreeMap<String, String> getAllTaxCategoryData() {
        DynamicObject[] dynamicObjects;
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxitem");
        TreeMap<String, String> taxCategoriesTreeMap = new TreeMap<String, String>();
        String selectFields = "id,number,taxcategories";
        QFilter[] filters = new QFilter[]{};
        String orderBys = "number asc";
        for (DynamicObject dynamicObject : dynamicObjects = helper.query(selectFields, filters, orderBys)) {
            DynamicObjectCollection taxCategoriesColl = dynamicObject.getDynamicObjectCollection("taxcategories");
            for (DynamicObject object : taxCategoriesColl) {
                String id = object.getString("fbasedataid_id");
                String name = object.getString("fbasedataid.name");
                taxCategoriesTreeMap.put(id, name);
            }
        }
        return taxCategoriesTreeMap;
    }

    public void refreshNode(RefreshNodeEvent ex) {
        super.refreshNode(ex);
        TreeNode root = this.getTreeModel().getRoot();
        String nodeId = (String)ex.getNodeId();
        TreeNode currNode = root.getTreeNode(nodeId, 10);
        ex.setChildNodes(currNode.getChildren());
    }

    public void registerListener(EventObject ex) {
        super.registerListener(ex);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void beforeBindData(EventObject ex) {
        super.beforeBindData(ex);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.expand("100000");
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent ex) {
        TreeNode root = this.getTreeModel().getRoot();
        String currNodeId = (String)ex.getNodeId();
        TreeNode currNode = root.getTreeNode(currNodeId, 10);
        List childIds = TreeUtils.getSubNodes((TreeNode)currNode);
        QFilter filter = new QFilter("taxcategories.fbasedataid_id", "in", (Object)childIds);
        ex.addQFilter(filter);
        ex.setCancel(true);
    }
}

