/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.formplugin.web.taxitemlibrary;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.business.servicehelper.MutexServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbs.business.taxitemlibrary.TaxItemHelper;
import kd.sit.sitbs.business.taxitemlibrary.TaxLibraryHelper;
import kd.sit.sitbs.common.utils.TreeUtils;

public class TaxItemTreeListPlugin
extends StandardTreeListPlugin {
    private static final int CHILDREN_LEVEL = 10;
    private static final String ISCONTINUEDEL = "isContinueDel";
    private static final HashMap<String, String> PERMISSIONMAP = new HashMap(3);
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_MODIFY = "btnedit";
    private static final String BTN_DEL = "btndel";

    public void initializeTree(EventObject ex) {
        this.initTree();
    }

    private void initTree() {
        TreeNode root = this.initTreeNode();
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.getTreeModel().setRootVisable(false);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.addNode(root);
        this.loadChildNode();
    }

    private void loadChildNode() {
        this.buildFirstLevelTreeNodes();
        this.buildSecondLevelTreeNodes();
    }

    private void buildSecondLevelTreeNodes() {
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        ITreeModel treeModel = this.getTreeModel();
        String appId = this.getView().getFormShowParameter().getCheckRightAppId();
        QFilter filter = null;
        if (!("ricc".equals(appId) || "hrdt".equals(appId) || HRStringUtils.equals((String)"sitbs", (String)appId))) {
            String currentAppRelCountryId = TaxLibraryHelper.getDataByPageCache((IFormView)this.getView(), (String)"countryid");
            filter = !Strings.isNullOrEmpty((String)currentAppRelCountryId) ? new QFilter("country.id", "in", Arrays.asList(Long.parseLong(currentAppRelCountryId), 0)) : new QFilter("1", "=", (Object)2);
        }
        List secondLevelDatas = TaxItemHelper.getAllTaxItemTypes(filter);
        for (DynamicObject secondLevelData : secondLevelDatas) {
            TreeNode treeNode;
            String parentId = secondLevelData.getString("parent.id");
            if (null != parentId) {
                TreeNode treeNode2 = new TreeNode(parentId, secondLevelData.getString("id"), secondLevelData.getString("name"));
                treeModel.addNode((Object)parentId, treeNode2);
                treeView.addNode(treeNode2);
                continue;
            }
            String countryId = secondLevelData.getString("country.id");
            if (null == countryId) {
                treeNode = new TreeNode("999", secondLevelData.getString("id"), secondLevelData.getString("name"));
                treeModel.addNode((Object)"999", treeNode);
                treeView.addNode(treeNode);
                continue;
            }
            treeNode = new TreeNode(countryId, secondLevelData.getString("id"), secondLevelData.getString("name"));
            treeModel.addNode((Object)countryId, treeNode);
            treeView.addNode(treeNode);
        }
    }

    private void buildFirstLevelTreeNodes() {
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        ITreeModel treeModel = this.getTreeModel();
        String appId = this.getView().getFormShowParameter().getCheckRightAppId();
        QFilter filter = null;
        if (!("ricc".equals(appId) || "hrdt".equals(appId) || HRStringUtils.equals((String)"sitbs", (String)appId))) {
            filter = new QFilter("app.number", "in", Arrays.asList(appId, "sitbs"));
        }
        Map firstLevelDatas = TaxItemHelper.getAllCountryData(filter);
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(firstLevelDatas.size());
        String countryName = ResManager.loadKDString((String)"\u901a\u7528", (String)"TaxItemTreeListPlugin_1", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
        TreeNode generalNode = new TreeNode("100000", "999", countryName);
        treeModel.addNode((Object)"100000", generalNode);
        treeView.addNode(generalNode);
        for (Map.Entry entry : firstLevelDatas.entrySet()) {
            TreeNode treeNode = new TreeNode("100000", String.valueOf(entry.getKey()), (String)entry.getValue());
            treeNodes.add(treeNode);
        }
        treeModel.addNodes((Object)treeModel.getRoot().getId(), treeNodes);
        treeView.addNodes(treeNodes);
    }

    private TreeNode initTreeNode() {
        TreeNode root = new TreeNode();
        root.setId("100000");
        root.setText(ResManager.loadKDString((String)"\u4e2a\u7a0e\u9879\u76ee\u6839\u8282\u70b9", (String)"TaxItemTreeListPlugin_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
        root.setData((Object)"");
        root.setParentid("");
        root.setIsOpened(true);
        return root;
    }

    public void refreshNode(RefreshNodeEvent ex) {
        super.refreshNode(ex);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.deleteAllNodes();
        this.initTree();
        TreeNode root = this.getTreeModel().getRoot();
        String currNodeId = (String)ex.getNodeId();
        TreeNode currNode = root.getTreeNode(currNodeId, 10);
        if (currNode != null && currNode.getChildren() != null && !currNode.getChildren().isEmpty()) {
            ex.setChildNodes(currNode.getChildren());
        }
        treeView.setRootVisible(false);
        this.getTreeModel().setCurrentNodeId(ex.getNodeId());
        treeView.focusNode(currNode);
        if (Objects.nonNull(currNode)) {
            treeView.treeNodeClick(currNode.getParentid(), currNodeId);
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent ex) {
        TreeNode root = this.getTreeModel().getRoot();
        String currNodeId = (String)ex.getNodeId();
        TreeNode currNode = root.getTreeNode(currNodeId, 10);
        List childIds = TreeUtils.getSubNodes((TreeNode)currNode);
        QFilter qFilter = new QFilter("taxitemtype.id", "in", (Object)childIds);
        ex.addQFilter(qFilter);
        ex.setCancel(true);
    }

    public void treeToolbarClick(EventObject ex) {
        String opKey;
        ITreeModel treeModel = this.getTreeModel();
        String currentNodeId = (String)treeModel.getCurrentNodeId();
        if (Strings.isNullOrEmpty((String)currentNodeId)) {
            return;
        }
        if ("100000".equals(currentNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u8282\u70b9\u3002", (String)"TaxItemTreeListPlugin_16", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        Control ctl = (Control)ex.getSource();
        switch (opKey = ctl.getKey()) {
            case "btnnew": {
                String msg = ResManager.loadKDString((String)"\u65e0\u65b0\u589e\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxItemTreeListPlugin_13", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
                this.checkPermAndDoAction(ex, opKey, msg, currentNodeId);
                break;
            }
            case "btnedit": {
                String msg = ResManager.loadKDString((String)"\u65e0\u4fee\u6539\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxItemTreeListPlugin_14", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
                this.checkPermAndDoAction(ex, opKey, msg, currentNodeId);
                break;
            }
            case "btndel": {
                String msg = ResManager.loadKDString((String)"\u65e0\u5220\u9664\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxItemTreeListPlugin_15", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
                this.checkPermAndDoAction(ex, opKey, msg, currentNodeId);
                break;
            }
        }
    }

    private void checkPermAndDoAction(EventObject ex, String opKey, String msg, String currentNodeId) {
        String appId;
        String permItemId = PERMISSIONMAP.get(opKey);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        boolean permFlag = SITPermissionServiceHelper.hasPerm((long)userId, (String)(appId = this.getView().getFormShowParameter().getCheckRightAppId()), (String)"sitbs_taxitem", (String)permItemId);
        if (!permFlag) {
            this.getView().showErrorNotification(msg);
            ((BeforeClickEvent)ex).setCancel(true);
        } else if (this.validateNode(currentNodeId)) {
            switch (opKey) {
                case "btnnew": {
                    this.addGroupNode(currentNodeId);
                    break;
                }
                case "btnedit": {
                    this.editAction(currentNodeId);
                    break;
                }
                case "btndel": {
                    this.delAction(currentNodeId);
                    break;
                }
            }
        }
    }

    private boolean validateNode(String currentNodeId) {
        boolean flag = true;
        String appId = this.getView().getFormShowParameter().getCheckRightAppId();
        if (!("ricc".equals(appId) || "hrdt".equals(appId) || HRStringUtils.equals((String)"sitbs", (String)appId))) {
            DynamicObject taxItemTypeDy = TaxItemHelper.getTaxItemTypeDy((String)currentNodeId);
            String countryId = null == taxItemTypeDy ? currentNodeId : taxItemTypeDy.getString("country.id");
            String currentAppRelCountryId = TaxLibraryHelper.getDataByPageCache((IFormView)this.getView(), (String)"countryid");
            if (!HRStringUtils.equals((String)currentAppRelCountryId, (String)countryId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u65b0\u589e\u3001\u7f16\u8f91\u6216\u5220\u9664\u901a\u7528\u7684\u4e2a\u7a0e\u9879\u76ee\u7c7b\u522b\u3002", (String)"TaxItemTreeListPlugin_11", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
                flag = false;
            }
        }
        return flag;
    }

    private void delAction(String currentNodeId) {
        if (StringUtils.isBlank((CharSequence)currentNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u8282\u70b9\u3002", (String)"TaxItemTreeListPlugin_3", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.isSysPreSetNode(currentNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u65e0\u6cd5\u5220\u9664\u3002", (String)"TaxItemTreeListPlugin_9", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.isFirstLvelNode(currentNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u4e00\u7ea7\u8282\u70b9\u3002", (String)"TaxItemTreeListPlugin_4", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.checkHasDatas(currentNodeId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u7c7b\u522b\u4e0b\u5b58\u5728\u4e2a\u7a0e\u9879\u76ee\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"TaxItemTreeListPlugin_7", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode currNode = root.getTreeNode(currentNodeId, 10);
        List childIds = TreeUtils.getSubNodes((TreeNode)currNode);
        ArrayList getLockNodes = Lists.newArrayListWithExpectedSize((int)childIds.size());
        for (Long childId : childIds) {
            BaseResult require = MutexServiceHelper.require((String)"sitbs_taxitemtype", (String)String.valueOf(childId), (String)"modify");
            if (!require.isSuccess()) {
                TreeNode currentNode = this.getTreeModel().getRoot().getTreeNode(String.valueOf(childId), 10);
                String text = currentNode.getText();
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5176\u4ed6\u7528\u6237\u6b63\u5728\u7f16\u8f91{0}\u9879\u76ee\u7c7b\u522b\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"TaxItemTreeListPlugin_18", (String)"sit-sitbs-formplugin", (Object[])new Object[]{text}));
                for (Long getLockNode : getLockNodes) {
                    MutexServiceHelper.release((String)"sitbs_taxitemtype", (String)String.valueOf(getLockNode), (String)"modify");
                }
                return;
            }
            getLockNodes.add(childId);
        }
        if (childIds.size() > 1) {
            String msg = ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u7c7b\u522b\u4e0b\u6709\u5b50\u9879\u76ee\u7c7b\u522b\uff0c\u662f\u5426\u5c06\u5b50\u9879\u76ee\u7c7b\u522b\u4e00\u5e76\u5220\u9664\uff1f", (String)"TaxItemTreeListPlugin_8", (String)"sit-sitbs-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(ISCONTINUEDEL));
        } else {
            String text = currNode.getText();
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("group_bar_del", (IFormPlugin)this);
            String strs = MessageFormat.format(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u60a8\u786e\u8ba4\u5220\u9664\u4e2a\u7a0e\u9879\u76ee\u7c7b\u522b{0}\uff1f", (String)"TaxItemTreeListPlugin_5", (String)"sit-sitbs-formplugin", (Object[])new Object[0]), text);
            this.getView().showConfirm(strs, MessageBoxOptions.YesNo, confirmCallBacks);
        }
    }

    private void editAction(String currentNodeId) {
        if (StringUtils.isBlank((CharSequence)currentNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u8282\u70b9\u3002", (String)"TaxItemTreeListPlugin_3", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.isSysPreSetNode(currentNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u65e0\u6cd5\u7f16\u8f91\u3002", (String)"TaxItemTreeListPlugin_10", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.isFirstLvelNode(currentNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7f16\u8f91\u4e00\u7ea7\u8282\u70b9\u3002", (String)"TaxItemTreeListPlugin_2", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return;
        }
        this.editGroupNode(currentNodeId);
    }

    private void editGroupNode(String currentNodeId) {
        DynamicObject taxItemTypeDy = TaxItemHelper.getTaxItemTypeDy((String)currentNodeId);
        String countryId = null == taxItemTypeDy ? currentNodeId : taxItemTypeDy.getString("country.id");
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("sitbs_taxitemtype");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "group_bar_edit");
        formShowParameter.setCloseCallBack(callBack);
        formShowParameter.setCustomParam("id", (Object)currentNodeId);
        formShowParameter.setCustomParam("countryId", (Object)countryId);
        formShowParameter.setPkId(this.getTreeModel().getCurrentNodeId());
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setBillStatus(BillOperationStatus.SUBMIT);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private boolean isSysPreSetNode(String currentNodeId) {
        DynamicObject taxItemTypeDy = TaxItemHelper.getTaxItemTypeDy((String)currentNodeId);
        if (null != taxItemTypeDy) {
            return taxItemTypeDy.getBoolean("issyspreset");
        }
        return false;
    }

    private boolean isFirstLvelNode(String currentNodeId) {
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode currNode = root.getTreeNode(currentNodeId, 10);
        return "100000".equals(currNode.getParentid());
    }

    private void addGroupNode(String currentNodeId) {
        String countryId;
        DynamicObject taxItemTypeDy = TaxItemHelper.getTaxItemTypeDy((String)currentNodeId);
        if (null == taxItemTypeDy) {
            countryId = currentNodeId;
        } else {
            countryId = taxItemTypeDy.getString("country.id");
            if (HRStringUtils.equals((String)"1000001", (String)countryId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5728\u4e2d\u56fd\u4e2a\u7a0e\u9879\u76ee\u7c7b\u522b\u4e0b\u521b\u5efa\u5b50\u7c7b\u522b\u3002", (String)"TaxItemTreeListPlugin_19", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("sitbs_taxitemtype");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "group_bar_add");
        formShowParameter.setCloseCallBack(callBack);
        formShowParameter.setCustomParam("id", (Object)currentNodeId);
        formShowParameter.setCustomParam("operate", (Object)"addnew");
        formShowParameter.setCustomParam("countryId", (Object)countryId);
        if (!currentNodeId.equals(this.getTreeModel().getRoot().getId())) {
            this.getParentNode("sitbs_taxitemtype", currentNodeId, formShowParameter);
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void getParentNode(String entityId, String currentNodeId, BillShowParameter formShowParameter) {
        BasedataEntityType basedataEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)entityId);
        if (basedataEntityType != null) {
            HashMap<String, String> parentInfo = new HashMap<String, String>(16);
            for (IDataEntityProperty pro : basedataEntityType.getProperties()) {
                if (!(pro instanceof ParentBasedataProp)) continue;
                parentInfo.put("key", pro.getName());
                parentInfo.put("value", currentNodeId);
                formShowParameter.setCustomParam("tree_parent_id", parentInfo);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "group_bar_add": 
            case "group_bar_edit": {
                Object map = closedCallBackEvent.getReturnData();
                if (!(map instanceof HashMap)) {
                    return;
                }
                this.refreshTree();
                HashMap returnData = (HashMap)map;
                this.focusNodeBySearchName((String)returnData.get("name"));
                break;
            }
        }
    }

    private void focusNodeBySearchName(String name) {
        SearchEnterEvent searchEnterEvent = new SearchEnterEvent((Object)this, name + "#s#");
        this.search(searchEnterEvent);
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        if (!searchText.endsWith("#s#")) {
            super.search(evt);
        } else {
            searchText = searchText.substring(0, searchText.length() - 3);
            TreeNode rootNode = this.getTreeModel().getRoot();
            List treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, node -> this.loadChildNodes((TreeNode)node), 16);
            TreeNode targetNode = this.initTreeNode();
            for (TreeNode treeNode : treeNodes) {
                if (!searchText.equals(treeNode.getText())) continue;
                targetNode = treeNode;
            }
            if (targetNode.getId().equals("100000")) {
                return;
            }
            TreeView treeView = this.getTreeListView().getTreeView();
            this.focusNode(treeView, rootNode, targetNode);
        }
    }

    private void focusNode(TreeView treeView, TreeNode rootNode, TreeNode treeNode) {
        this.expandParents(treeView, rootNode, treeNode);
        treeView.showNode(treeNode.getParentid());
        treeView.focusNode(treeNode);
        treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
    }

    private void expandParents(TreeView treeView, TreeNode rootNode, TreeNode node) {
        String parentid = node.getParentid();
        if (StringUtils.isNotBlank((CharSequence)parentid)) {
            TreeNode pnode = rootNode.getTreeNode(parentid, 20);
            if (pnode != null) {
                this.expandParents(treeView, rootNode, pnode);
                treeView.expand(parentid);
                if (pnode == rootNode) {
                    treeView.updateNode(node);
                }
            } else {
                treeView.updateNode(node);
            }
        } else {
            treeView.updateNode(node);
        }
    }

    private void refreshTree() {
        ITreeListView treeListView = ((IListView)this.getView()).getTreeListView();
        String rootId = treeListView.getTreeModel().getRoot().getId();
        treeListView.getTreeModel().refreshNode((Object)rootId);
        treeListView.refreshTreeNode(rootId);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        switch (event.getCallBackId()) {
            case "group_bar_del": 
            case "isContinueDel": {
                if (MessageBoxResult.Yes.equals((Object)event.getResult())) {
                    this.doDel();
                    break;
                }
                ITreeModel treeModel = this.getTreeModel();
                String currentNodeId = (String)treeModel.getCurrentNodeId();
                TreeNode currNode = treeModel.getRoot().getTreeNode(currentNodeId, 10);
                List childIds = TreeUtils.getSubNodes((TreeNode)currNode);
                for (Long childId : childIds) {
                    MutexServiceHelper.release((String)"sitbs_taxitemtype", (String)String.valueOf(childId), (String)"modify");
                }
                break;
            }
        }
    }

    private void doDel() {
        ITreeModel treeModel = this.getTreeModel();
        String currentNodeId = (String)treeModel.getCurrentNodeId();
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode currNode = root.getTreeNode(currentNodeId, 10);
        List childIds = TreeUtils.getSubNodes((TreeNode)currNode);
        TaxItemHelper.deleteTaxItemTypesByTypeIds((List)childIds);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"TaxItemTreeListPlugin_6", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
        this.refreshTree();
        String parentid = currNode.getParentid();
        DynamicObject taxItemTypeDy = TaxItemHelper.getTaxItemTypeDy((String)String.valueOf(parentid));
        if (taxItemTypeDy == null) {
            return;
        }
        this.focusNodeBySearchName(taxItemTypeDy.getString("name"));
    }

    private boolean checkHasDatas(String currentNodeId) {
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode currNode = root.getTreeNode(currentNodeId, 10);
        List childIds = TreeUtils.getSubNodes((TreeNode)currNode);
        return TaxItemHelper.checkHasDatas((List)childIds);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "refresh": {
                args.setCancel(true);
                String nodeId = (String)this.getTreeModel().getCurrentNodeId();
                if (Strings.isNullOrEmpty((String)nodeId)) {
                    TreeView treeView = (TreeView)this.getView().getControl("treeview");
                    treeView.deleteAllNodes();
                    return;
                }
                this.refreshNode(new RefreshNodeEvent((Object)this, (Object)nodeId));
                break;
            }
        }
    }

    static {
        PERMISSIONMAP.put(BTN_NEW, "47156aff000000ac");
        PERMISSIONMAP.put(BTN_MODIFY, "4715a0df000000ac");
        PERMISSIONMAP.put(BTN_DEL, "4715e1f1000000ac");
    }
}

